set(vtk_features)

if (TARGET VTK::WebPython)
  list(APPEND vtk_features "web")
endif ()

if (TARGET VTK::mpi)
  list(APPEND vtk_features "mpi")
endif ()

if (TARGET VTK::RenderingCore)
  list(APPEND vtk_features "rendering")
endif ()

if (TARGET VTK::RenderingOpenVR)
  list(APPEND vtk_features "openvr")
endif ()

if (TARGET VTK::RenderingOpenXR)
  list(APPEND vtk_features "openxr")
endif ()

if (TARGET VTK::RenderingOpenGL2)
  set(has_onscreen OFF)
  set(has_offscreen ON)
  list(APPEND vtk_features "rendering-offscreen-osmesa")
  if (VTK_USE_X)
    list(APPEND vtk_features "rendering-onscreen-x11")
    set(has_onscreen ON)
  endif ()
  if (VTK_USE_COCOA)
    list(APPEND vtk_features "rendering-onscreen-cocoa")
    set(has_onscreen ON)
  endif ()
  if (WIN32)
    list(APPEND vtk_features "rendering-onscreen-windows")
    set(has_onscreen ON)
  endif ()

  if (has_onscreen)
    list(APPEND vtk_features "rendering-onscreen")
  endif ()
  if (has_offscreen)
    list(APPEND vtk_features "rendering-offscreen")
  endif ()

  if (VTK_OPENGL_USE_GLES)
    list(APPEND vtk_features "rendering-backend-gles")
  else ()
    list(APPEND vtk_features "rendering-backend-gl")
  endif ()
  if (VTK_OPENGL_HAS_EGL)
    list(APPEND vtk_features "rendering-backend-egl")
  endif ()
endif ()

set(vtk_feature_entries "")
foreach (vtk_feature IN LISTS vtk_features)
  string(APPEND vtk_feature_entries
    "    '${vtk_feature}': [],\n")
endforeach ()
file(WRITE "${CMAKE_BINARY_DIR}/vtk_features.py"
  "FEATURES = {\n${vtk_feature_entries}}\n")
