// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_ASSEMBLER_COND_RD_RN_OPERAND_RM_UXTAH_A32_H_
#define VIXL_ASSEMBLER_COND_RD_RN_OPERAND_RM_UXTAH_A32_H_

const byte kInstruction_uxtah_le_r4_r5_r14[] = {
  0x7e, 0x40, 0xf5, 0xd6 // uxtah le r4 r5 r14
};
const byte kInstruction_uxtah_ge_r5_r11_r10[] = {
  0x7a, 0x50, 0xfb, 0xa6 // uxtah ge r5 r11 r10
};
const byte kInstruction_uxtah_ls_r0_r9_r9[] = {
  0x79, 0x00, 0xf9, 0x96 // uxtah ls r0 r9 r9
};
const byte kInstruction_uxtah_le_r8_r7_r2[] = {
  0x72, 0x80, 0xf7, 0xd6 // uxtah le r8 r7 r2
};
const byte kInstruction_uxtah_eq_r1_r10_r13[] = {
  0x7d, 0x10, 0xfa, 0x06 // uxtah eq r1 r10 r13
};
const byte kInstruction_uxtah_le_r9_r12_r2[] = {
  0x72, 0x90, 0xfc, 0xd6 // uxtah le r9 r12 r2
};
const byte kInstruction_uxtah_pl_r6_r1_r5[] = {
  0x75, 0x60, 0xf1, 0x56 // uxtah pl r6 r1 r5
};
const byte kInstruction_uxtah_ge_r1_r12_r6[] = {
  0x76, 0x10, 0xfc, 0xa6 // uxtah ge r1 r12 r6
};
const byte kInstruction_uxtah_cc_r13_r12_r3[] = {
  0x73, 0xd0, 0xfc, 0x36 // uxtah cc r13 r12 r3
};
const byte kInstruction_uxtah_gt_r2_r4_r9[] = {
  0x79, 0x20, 0xf4, 0xc6 // uxtah gt r2 r4 r9
};
const byte kInstruction_uxtah_le_r3_r9_r10[] = {
  0x7a, 0x30, 0xf9, 0xd6 // uxtah le r3 r9 r10
};
const byte kInstruction_uxtah_gt_r11_r1_r9[] = {
  0x79, 0xb0, 0xf1, 0xc6 // uxtah gt r11 r1 r9
};
const byte kInstruction_uxtah_cc_r8_r6_r11[] = {
  0x7b, 0x80, 0xf6, 0x36 // uxtah cc r8 r6 r11
};
const byte kInstruction_uxtah_cs_r12_r9_r3[] = {
  0x73, 0xc0, 0xf9, 0x26 // uxtah cs r12 r9 r3
};
const byte kInstruction_uxtah_eq_r9_r14_r10[] = {
  0x7a, 0x90, 0xfe, 0x06 // uxtah eq r9 r14 r10
};
const byte kInstruction_uxtah_gt_r9_r0_r1[] = {
  0x71, 0x90, 0xf0, 0xc6 // uxtah gt r9 r0 r1
};
const byte kInstruction_uxtah_pl_r11_r8_r2[] = {
  0x72, 0xb0, 0xf8, 0x56 // uxtah pl r11 r8 r2
};
const byte kInstruction_uxtah_mi_r7_r1_r2[] = {
  0x72, 0x70, 0xf1, 0x46 // uxtah mi r7 r1 r2
};
const byte kInstruction_uxtah_vs_r8_r6_r7[] = {
  0x77, 0x80, 0xf6, 0x66 // uxtah vs r8 r6 r7
};
const byte kInstruction_uxtah_ne_r14_r2_r13[] = {
  0x7d, 0xe0, 0xf2, 0x16 // uxtah ne r14 r2 r13
};
const byte kInstruction_uxtah_hi_r3_r3_r8[] = {
  0x78, 0x30, 0xf3, 0x86 // uxtah hi r3 r3 r8
};
const byte kInstruction_uxtah_vc_r10_r8_r14[] = {
  0x7e, 0xa0, 0xf8, 0x76 // uxtah vc r10 r8 r14
};
const byte kInstruction_uxtah_ls_r2_r11_r0[] = {
  0x70, 0x20, 0xfb, 0x96 // uxtah ls r2 r11 r0
};
const byte kInstruction_uxtah_ge_r8_r10_r0[] = {
  0x70, 0x80, 0xfa, 0xa6 // uxtah ge r8 r10 r0
};
const byte kInstruction_uxtah_mi_r8_r10_r5[] = {
  0x75, 0x80, 0xfa, 0x46 // uxtah mi r8 r10 r5
};
const byte kInstruction_uxtah_pl_r1_r0_r9[] = {
  0x79, 0x10, 0xf0, 0x56 // uxtah pl r1 r0 r9
};
const byte kInstruction_uxtah_gt_r6_r7_r3[] = {
  0x73, 0x60, 0xf7, 0xc6 // uxtah gt r6 r7 r3
};
const byte kInstruction_uxtah_vs_r7_r9_r9[] = {
  0x79, 0x70, 0xf9, 0x66 // uxtah vs r7 r9 r9
};
const byte kInstruction_uxtah_al_r9_r4_r2[] = {
  0x72, 0x90, 0xf4, 0xe6 // uxtah al r9 r4 r2
};
const byte kInstruction_uxtah_le_r3_r1_r2[] = {
  0x72, 0x30, 0xf1, 0xd6 // uxtah le r3 r1 r2
};
const byte kInstruction_uxtah_mi_r6_r14_r0[] = {
  0x70, 0x60, 0xfe, 0x46 // uxtah mi r6 r14 r0
};
const byte kInstruction_uxtah_vc_r7_r10_r11[] = {
  0x7b, 0x70, 0xfa, 0x76 // uxtah vc r7 r10 r11
};
const byte kInstruction_uxtah_hi_r13_r2_r10[] = {
  0x7a, 0xd0, 0xf2, 0x86 // uxtah hi r13 r2 r10
};
const byte kInstruction_uxtah_cs_r5_r4_r12[] = {
  0x7c, 0x50, 0xf4, 0x26 // uxtah cs r5 r4 r12
};
const byte kInstruction_uxtah_ls_r13_r9_r11[] = {
  0x7b, 0xd0, 0xf9, 0x96 // uxtah ls r13 r9 r11
};
const byte kInstruction_uxtah_ne_r2_r10_r12[] = {
  0x7c, 0x20, 0xfa, 0x16 // uxtah ne r2 r10 r12
};
const byte kInstruction_uxtah_vc_r4_r6_r8[] = {
  0x78, 0x40, 0xf6, 0x76 // uxtah vc r4 r6 r8
};
const byte kInstruction_uxtah_lt_r13_r0_r13[] = {
  0x7d, 0xd0, 0xf0, 0xb6 // uxtah lt r13 r0 r13
};
const byte kInstruction_uxtah_pl_r11_r14_r5[] = {
  0x75, 0xb0, 0xfe, 0x56 // uxtah pl r11 r14 r5
};
const byte kInstruction_uxtah_cs_r8_r11_r3[] = {
  0x73, 0x80, 0xfb, 0x26 // uxtah cs r8 r11 r3
};
const byte kInstruction_uxtah_cs_r4_r1_r7[] = {
  0x77, 0x40, 0xf1, 0x26 // uxtah cs r4 r1 r7
};
const byte kInstruction_uxtah_al_r0_r12_r13[] = {
  0x7d, 0x00, 0xfc, 0xe6 // uxtah al r0 r12 r13
};
const byte kInstruction_uxtah_gt_r3_r6_r0[] = {
  0x70, 0x30, 0xf6, 0xc6 // uxtah gt r3 r6 r0
};
const byte kInstruction_uxtah_vc_r6_r9_r0[] = {
  0x70, 0x60, 0xf9, 0x76 // uxtah vc r6 r9 r0
};
const byte kInstruction_uxtah_cc_r2_r2_r12[] = {
  0x7c, 0x20, 0xf2, 0x36 // uxtah cc r2 r2 r12
};
const byte kInstruction_uxtah_cs_r4_r13_r1[] = {
  0x71, 0x40, 0xfd, 0x26 // uxtah cs r4 r13 r1
};
const byte kInstruction_uxtah_mi_r12_r12_r10[] = {
  0x7a, 0xc0, 0xfc, 0x46 // uxtah mi r12 r12 r10
};
const byte kInstruction_uxtah_hi_r8_r9_r14[] = {
  0x7e, 0x80, 0xf9, 0x86 // uxtah hi r8 r9 r14
};
const byte kInstruction_uxtah_hi_r4_r3_r7[] = {
  0x77, 0x40, 0xf3, 0x86 // uxtah hi r4 r3 r7
};
const byte kInstruction_uxtah_ne_r11_r10_r1[] = {
  0x71, 0xb0, 0xfa, 0x16 // uxtah ne r11 r10 r1
};
const byte kInstruction_uxtah_cc_r2_r6_r3[] = {
  0x73, 0x20, 0xf6, 0x36 // uxtah cc r2 r6 r3
};
const byte kInstruction_uxtah_cs_r6_r6_r0[] = {
  0x70, 0x60, 0xf6, 0x26 // uxtah cs r6 r6 r0
};
const byte kInstruction_uxtah_vc_r13_r2_r9[] = {
  0x79, 0xd0, 0xf2, 0x76 // uxtah vc r13 r2 r9
};
const byte kInstruction_uxtah_vc_r7_r13_r14[] = {
  0x7e, 0x70, 0xfd, 0x76 // uxtah vc r7 r13 r14
};
const byte kInstruction_uxtah_pl_r11_r14_r4[] = {
  0x74, 0xb0, 0xfe, 0x56 // uxtah pl r11 r14 r4
};
const byte kInstruction_uxtah_lt_r12_r14_r8[] = {
  0x78, 0xc0, 0xfe, 0xb6 // uxtah lt r12 r14 r8
};
const byte kInstruction_uxtah_cs_r2_r11_r14[] = {
  0x7e, 0x20, 0xfb, 0x26 // uxtah cs r2 r11 r14
};
const byte kInstruction_uxtah_le_r12_r13_r2[] = {
  0x72, 0xc0, 0xfd, 0xd6 // uxtah le r12 r13 r2
};
const byte kInstruction_uxtah_le_r5_r6_r14[] = {
  0x7e, 0x50, 0xf6, 0xd6 // uxtah le r5 r6 r14
};
const byte kInstruction_uxtah_vc_r3_r14_r8[] = {
  0x78, 0x30, 0xfe, 0x76 // uxtah vc r3 r14 r8
};
const byte kInstruction_uxtah_lt_r7_r6_r14[] = {
  0x7e, 0x70, 0xf6, 0xb6 // uxtah lt r7 r6 r14
};
const byte kInstruction_uxtah_ls_r0_r13_r12[] = {
  0x7c, 0x00, 0xfd, 0x96 // uxtah ls r0 r13 r12
};
const byte kInstruction_uxtah_ge_r10_r9_r14[] = {
  0x7e, 0xa0, 0xf9, 0xa6 // uxtah ge r10 r9 r14
};
const byte kInstruction_uxtah_le_r11_r12_r1[] = {
  0x71, 0xb0, 0xfc, 0xd6 // uxtah le r11 r12 r1
};
const byte kInstruction_uxtah_al_r2_r12_r14[] = {
  0x7e, 0x20, 0xfc, 0xe6 // uxtah al r2 r12 r14
};
const byte kInstruction_uxtah_cs_r6_r4_r0[] = {
  0x70, 0x60, 0xf4, 0x26 // uxtah cs r6 r4 r0
};
const byte kInstruction_uxtah_vs_r5_r0_r3[] = {
  0x73, 0x50, 0xf0, 0x66 // uxtah vs r5 r0 r3
};
const byte kInstruction_uxtah_le_r8_r8_r0[] = {
  0x70, 0x80, 0xf8, 0xd6 // uxtah le r8 r8 r0
};
const byte kInstruction_uxtah_gt_r1_r5_r4[] = {
  0x74, 0x10, 0xf5, 0xc6 // uxtah gt r1 r5 r4
};
const byte kInstruction_uxtah_le_r4_r3_r4[] = {
  0x74, 0x40, 0xf3, 0xd6 // uxtah le r4 r3 r4
};
const byte kInstruction_uxtah_pl_r9_r7_r10[] = {
  0x7a, 0x90, 0xf7, 0x56 // uxtah pl r9 r7 r10
};
const byte kInstruction_uxtah_ls_r8_r7_r14[] = {
  0x7e, 0x80, 0xf7, 0x96 // uxtah ls r8 r7 r14
};
const byte kInstruction_uxtah_vc_r9_r10_r6[] = {
  0x76, 0x90, 0xfa, 0x76 // uxtah vc r9 r10 r6
};
const byte kInstruction_uxtah_hi_r2_r4_r9[] = {
  0x79, 0x20, 0xf4, 0x86 // uxtah hi r2 r4 r9
};
const byte kInstruction_uxtah_cs_r0_r2_r13[] = {
  0x7d, 0x00, 0xf2, 0x26 // uxtah cs r0 r2 r13
};
const byte kInstruction_uxtah_vs_r3_r6_r12[] = {
  0x7c, 0x30, 0xf6, 0x66 // uxtah vs r3 r6 r12
};
const byte kInstruction_uxtah_cc_r14_r14_r7[] = {
  0x77, 0xe0, 0xfe, 0x36 // uxtah cc r14 r14 r7
};
const byte kInstruction_uxtah_vc_r10_r6_r4[] = {
  0x74, 0xa0, 0xf6, 0x76 // uxtah vc r10 r6 r4
};
const byte kInstruction_uxtah_cc_r1_r6_r10[] = {
  0x7a, 0x10, 0xf6, 0x36 // uxtah cc r1 r6 r10
};
const byte kInstruction_uxtah_vs_r13_r10_r11[] = {
  0x7b, 0xd0, 0xfa, 0x66 // uxtah vs r13 r10 r11
};
const byte kInstruction_uxtah_ls_r5_r7_r12[] = {
  0x7c, 0x50, 0xf7, 0x96 // uxtah ls r5 r7 r12
};
const byte kInstruction_uxtah_eq_r6_r4_r3[] = {
  0x73, 0x60, 0xf4, 0x06 // uxtah eq r6 r4 r3
};
const byte kInstruction_uxtah_mi_r5_r9_r2[] = {
  0x72, 0x50, 0xf9, 0x46 // uxtah mi r5 r9 r2
};
const byte kInstruction_uxtah_lt_r7_r1_r9[] = {
  0x79, 0x70, 0xf1, 0xb6 // uxtah lt r7 r1 r9
};
const byte kInstruction_uxtah_ne_r12_r7_r0[] = {
  0x70, 0xc0, 0xf7, 0x16 // uxtah ne r12 r7 r0
};
const byte kInstruction_uxtah_eq_r0_r6_r7[] = {
  0x77, 0x00, 0xf6, 0x06 // uxtah eq r0 r6 r7
};
const byte kInstruction_uxtah_pl_r7_r3_r9[] = {
  0x79, 0x70, 0xf3, 0x56 // uxtah pl r7 r3 r9
};
const byte kInstruction_uxtah_pl_r11_r11_r13[] = {
  0x7d, 0xb0, 0xfb, 0x56 // uxtah pl r11 r11 r13
};
const byte kInstruction_uxtah_gt_r0_r10_r5[] = {
  0x75, 0x00, 0xfa, 0xc6 // uxtah gt r0 r10 r5
};
const byte kInstruction_uxtah_mi_r14_r1_r10[] = {
  0x7a, 0xe0, 0xf1, 0x46 // uxtah mi r14 r1 r10
};
const byte kInstruction_uxtah_mi_r5_r14_r0[] = {
  0x70, 0x50, 0xfe, 0x46 // uxtah mi r5 r14 r0
};
const byte kInstruction_uxtah_ne_r12_r9_r13[] = {
  0x7d, 0xc0, 0xf9, 0x16 // uxtah ne r12 r9 r13
};
const byte kInstruction_uxtah_hi_r8_r5_r11[] = {
  0x7b, 0x80, 0xf5, 0x86 // uxtah hi r8 r5 r11
};
const byte kInstruction_uxtah_ls_r7_r0_r5[] = {
  0x75, 0x70, 0xf0, 0x96 // uxtah ls r7 r0 r5
};
const byte kInstruction_uxtah_lt_r5_r1_r7[] = {
  0x77, 0x50, 0xf1, 0xb6 // uxtah lt r5 r1 r7
};
const byte kInstruction_uxtah_cc_r2_r8_r4[] = {
  0x74, 0x20, 0xf8, 0x36 // uxtah cc r2 r8 r4
};
const byte kInstruction_uxtah_lt_r3_r0_r5[] = {
  0x75, 0x30, 0xf0, 0xb6 // uxtah lt r3 r0 r5
};
const byte kInstruction_uxtah_pl_r4_r9_r7[] = {
  0x77, 0x40, 0xf9, 0x56 // uxtah pl r4 r9 r7
};
const byte kInstruction_uxtah_eq_r13_r8_r10[] = {
  0x7a, 0xd0, 0xf8, 0x06 // uxtah eq r13 r8 r10
};
const byte kInstruction_uxtah_ge_r6_r10_r10[] = {
  0x7a, 0x60, 0xfa, 0xa6 // uxtah ge r6 r10 r10
};
const byte kInstruction_uxtah_lt_r5_r5_r7[] = {
  0x77, 0x50, 0xf5, 0xb6 // uxtah lt r5 r5 r7
};
const byte kInstruction_uxtah_hi_r6_r3_r9[] = {
  0x79, 0x60, 0xf3, 0x86 // uxtah hi r6 r3 r9
};
const byte kInstruction_uxtah_hi_r14_r12_r10[] = {
  0x7a, 0xe0, 0xfc, 0x86 // uxtah hi r14 r12 r10
};
const byte kInstruction_uxtah_lt_r9_r13_r14[] = {
  0x7e, 0x90, 0xfd, 0xb6 // uxtah lt r9 r13 r14
};
const byte kInstruction_uxtah_al_r0_r12_r7[] = {
  0x77, 0x00, 0xfc, 0xe6 // uxtah al r0 r12 r7
};
const byte kInstruction_uxtah_eq_r14_r8_r11[] = {
  0x7b, 0xe0, 0xf8, 0x06 // uxtah eq r14 r8 r11
};
const byte kInstruction_uxtah_ne_r9_r11_r1[] = {
  0x71, 0x90, 0xfb, 0x16 // uxtah ne r9 r11 r1
};
const byte kInstruction_uxtah_ge_r5_r0_r3[] = {
  0x73, 0x50, 0xf0, 0xa6 // uxtah ge r5 r0 r3
};
const byte kInstruction_uxtah_pl_r12_r0_r1[] = {
  0x71, 0xc0, 0xf0, 0x56 // uxtah pl r12 r0 r1
};
const byte kInstruction_uxtah_lt_r13_r7_r11[] = {
  0x7b, 0xd0, 0xf7, 0xb6 // uxtah lt r13 r7 r11
};
const byte kInstruction_uxtah_eq_r4_r6_r6[] = {
  0x76, 0x40, 0xf6, 0x06 // uxtah eq r4 r6 r6
};
const byte kInstruction_uxtah_cs_r1_r14_r0[] = {
  0x70, 0x10, 0xfe, 0x26 // uxtah cs r1 r14 r0
};
const byte kInstruction_uxtah_hi_r7_r7_r6[] = {
  0x76, 0x70, 0xf7, 0x86 // uxtah hi r7 r7 r6
};
const byte kInstruction_uxtah_hi_r1_r0_r3[] = {
  0x73, 0x10, 0xf0, 0x86 // uxtah hi r1 r0 r3
};
const byte kInstruction_uxtah_pl_r12_r2_r0[] = {
  0x70, 0xc0, 0xf2, 0x56 // uxtah pl r12 r2 r0
};
const byte kInstruction_uxtah_mi_r3_r0_r3[] = {
  0x73, 0x30, 0xf0, 0x46 // uxtah mi r3 r0 r3
};
const byte kInstruction_uxtah_al_r14_r4_r3[] = {
  0x73, 0xe0, 0xf4, 0xe6 // uxtah al r14 r4 r3
};
const byte kInstruction_uxtah_vs_r4_r2_r9[] = {
  0x79, 0x40, 0xf2, 0x66 // uxtah vs r4 r2 r9
};
const byte kInstruction_uxtah_vs_r1_r9_r12[] = {
  0x7c, 0x10, 0xf9, 0x66 // uxtah vs r1 r9 r12
};
const byte kInstruction_uxtah_vs_r3_r6_r9[] = {
  0x79, 0x30, 0xf6, 0x66 // uxtah vs r3 r6 r9
};
const byte kInstruction_uxtah_cc_r4_r1_r8[] = {
  0x78, 0x40, 0xf1, 0x36 // uxtah cc r4 r1 r8
};
const byte kInstruction_uxtah_ls_r10_r11_r14[] = {
  0x7e, 0xa0, 0xfb, 0x96 // uxtah ls r10 r11 r14
};
const byte kInstruction_uxtah_le_r11_r7_r2[] = {
  0x72, 0xb0, 0xf7, 0xd6 // uxtah le r11 r7 r2
};
const byte kInstruction_uxtah_le_r6_r9_r14[] = {
  0x7e, 0x60, 0xf9, 0xd6 // uxtah le r6 r9 r14
};
const byte kInstruction_uxtah_al_r1_r3_r11[] = {
  0x7b, 0x10, 0xf3, 0xe6 // uxtah al r1 r3 r11
};
const byte kInstruction_uxtah_lt_r0_r2_r2[] = {
  0x72, 0x00, 0xf2, 0xb6 // uxtah lt r0 r2 r2
};
const byte kInstruction_uxtah_eq_r11_r6_r8[] = {
  0x78, 0xb0, 0xf6, 0x06 // uxtah eq r11 r6 r8
};
const byte kInstruction_uxtah_ls_r7_r12_r5[] = {
  0x75, 0x70, 0xfc, 0x96 // uxtah ls r7 r12 r5
};
const byte kInstruction_uxtah_vc_r4_r11_r0[] = {
  0x70, 0x40, 0xfb, 0x76 // uxtah vc r4 r11 r0
};
const byte kInstruction_uxtah_ls_r7_r14_r2[] = {
  0x72, 0x70, 0xfe, 0x96 // uxtah ls r7 r14 r2
};
const byte kInstruction_uxtah_le_r7_r12_r1[] = {
  0x71, 0x70, 0xfc, 0xd6 // uxtah le r7 r12 r1
};
const byte kInstruction_uxtah_le_r1_r14_r13[] = {
  0x7d, 0x10, 0xfe, 0xd6 // uxtah le r1 r14 r13
};
const byte kInstruction_uxtah_le_r11_r3_r9[] = {
  0x79, 0xb0, 0xf3, 0xd6 // uxtah le r11 r3 r9
};
const byte kInstruction_uxtah_ne_r14_r13_r1[] = {
  0x71, 0xe0, 0xfd, 0x16 // uxtah ne r14 r13 r1
};
const byte kInstruction_uxtah_ne_r5_r1_r10[] = {
  0x7a, 0x50, 0xf1, 0x16 // uxtah ne r5 r1 r10
};
const byte kInstruction_uxtah_cc_r7_r4_r3[] = {
  0x73, 0x70, 0xf4, 0x36 // uxtah cc r7 r4 r3
};
const byte kInstruction_uxtah_lt_r8_r1_r1[] = {
  0x71, 0x80, 0xf1, 0xb6 // uxtah lt r8 r1 r1
};
const byte kInstruction_uxtah_al_r5_r0_r1[] = {
  0x71, 0x50, 0xf0, 0xe6 // uxtah al r5 r0 r1
};
const byte kInstruction_uxtah_ge_r11_r13_r9[] = {
  0x79, 0xb0, 0xfd, 0xa6 // uxtah ge r11 r13 r9
};
const byte kInstruction_uxtah_gt_r5_r9_r5[] = {
  0x75, 0x50, 0xf9, 0xc6 // uxtah gt r5 r9 r5
};
const byte kInstruction_uxtah_cc_r2_r8_r3[] = {
  0x73, 0x20, 0xf8, 0x36 // uxtah cc r2 r8 r3
};
const byte kInstruction_uxtah_eq_r6_r6_r12[] = {
  0x7c, 0x60, 0xf6, 0x06 // uxtah eq r6 r6 r12
};
const byte kInstruction_uxtah_vc_r3_r10_r13[] = {
  0x7d, 0x30, 0xfa, 0x76 // uxtah vc r3 r10 r13
};
const byte kInstruction_uxtah_vc_r9_r13_r1[] = {
  0x71, 0x90, 0xfd, 0x76 // uxtah vc r9 r13 r1
};
const byte kInstruction_uxtah_lt_r7_r0_r0[] = {
  0x70, 0x70, 0xf0, 0xb6 // uxtah lt r7 r0 r0
};
const byte kInstruction_uxtah_cc_r6_r6_r1[] = {
  0x71, 0x60, 0xf6, 0x36 // uxtah cc r6 r6 r1
};
const byte kInstruction_uxtah_mi_r8_r1_r9[] = {
  0x79, 0x80, 0xf1, 0x46 // uxtah mi r8 r1 r9
};
const byte kInstruction_uxtah_ls_r14_r10_r10[] = {
  0x7a, 0xe0, 0xfa, 0x96 // uxtah ls r14 r10 r10
};
const byte kInstruction_uxtah_ge_r7_r13_r1[] = {
  0x71, 0x70, 0xfd, 0xa6 // uxtah ge r7 r13 r1
};
const byte kInstruction_uxtah_le_r0_r4_r3[] = {
  0x73, 0x00, 0xf4, 0xd6 // uxtah le r0 r4 r3
};
const byte kInstruction_uxtah_cc_r12_r10_r10[] = {
  0x7a, 0xc0, 0xfa, 0x36 // uxtah cc r12 r10 r10
};
const byte kInstruction_uxtah_ge_r5_r0_r10[] = {
  0x7a, 0x50, 0xf0, 0xa6 // uxtah ge r5 r0 r10
};
const byte kInstruction_uxtah_vs_r8_r3_r10[] = {
  0x7a, 0x80, 0xf3, 0x66 // uxtah vs r8 r3 r10
};
const byte kInstruction_uxtah_ge_r11_r12_r2[] = {
  0x72, 0xb0, 0xfc, 0xa6 // uxtah ge r11 r12 r2
};
const byte kInstruction_uxtah_ne_r14_r4_r8[] = {
  0x78, 0xe0, 0xf4, 0x16 // uxtah ne r14 r4 r8
};
const byte kInstruction_uxtah_mi_r3_r0_r4[] = {
  0x74, 0x30, 0xf0, 0x46 // uxtah mi r3 r0 r4
};
const byte kInstruction_uxtah_gt_r13_r9_r6[] = {
  0x76, 0xd0, 0xf9, 0xc6 // uxtah gt r13 r9 r6
};
const byte kInstruction_uxtah_ls_r1_r14_r2[] = {
  0x72, 0x10, 0xfe, 0x96 // uxtah ls r1 r14 r2
};
const byte kInstruction_uxtah_eq_r11_r3_r12[] = {
  0x7c, 0xb0, 0xf3, 0x06 // uxtah eq r11 r3 r12
};
const byte kInstruction_uxtah_ge_r4_r13_r4[] = {
  0x74, 0x40, 0xfd, 0xa6 // uxtah ge r4 r13 r4
};
const byte kInstruction_uxtah_al_r5_r9_r7[] = {
  0x77, 0x50, 0xf9, 0xe6 // uxtah al r5 r9 r7
};
const byte kInstruction_uxtah_le_r11_r9_r0[] = {
  0x70, 0xb0, 0xf9, 0xd6 // uxtah le r11 r9 r0
};
const byte kInstruction_uxtah_mi_r13_r10_r12[] = {
  0x7c, 0xd0, 0xfa, 0x46 // uxtah mi r13 r10 r12
};
const byte kInstruction_uxtah_hi_r5_r5_r10[] = {
  0x7a, 0x50, 0xf5, 0x86 // uxtah hi r5 r5 r10
};
const byte kInstruction_uxtah_ge_r4_r6_r14[] = {
  0x7e, 0x40, 0xf6, 0xa6 // uxtah ge r4 r6 r14
};
const byte kInstruction_uxtah_le_r5_r5_r7[] = {
  0x77, 0x50, 0xf5, 0xd6 // uxtah le r5 r5 r7
};
const byte kInstruction_uxtah_pl_r12_r2_r8[] = {
  0x78, 0xc0, 0xf2, 0x56 // uxtah pl r12 r2 r8
};
const byte kInstruction_uxtah_al_r7_r8_r10[] = {
  0x7a, 0x70, 0xf8, 0xe6 // uxtah al r7 r8 r10
};
const byte kInstruction_uxtah_vc_r8_r11_r13[] = {
  0x7d, 0x80, 0xfb, 0x76 // uxtah vc r8 r11 r13
};
const byte kInstruction_uxtah_ne_r14_r2_r12[] = {
  0x7c, 0xe0, 0xf2, 0x16 // uxtah ne r14 r2 r12
};
const byte kInstruction_uxtah_eq_r10_r4_r2[] = {
  0x72, 0xa0, 0xf4, 0x06 // uxtah eq r10 r4 r2
};
const byte kInstruction_uxtah_al_r6_r2_r5[] = {
  0x75, 0x60, 0xf2, 0xe6 // uxtah al r6 r2 r5
};
const byte kInstruction_uxtah_al_r1_r6_r2[] = {
  0x72, 0x10, 0xf6, 0xe6 // uxtah al r1 r6 r2
};
const byte kInstruction_uxtah_vs_r0_r7_r14[] = {
  0x7e, 0x00, 0xf7, 0x66 // uxtah vs r0 r7 r14
};
const byte kInstruction_uxtah_hi_r9_r7_r0[] = {
  0x70, 0x90, 0xf7, 0x86 // uxtah hi r9 r7 r0
};
const byte kInstruction_uxtah_ne_r8_r11_r13[] = {
  0x7d, 0x80, 0xfb, 0x16 // uxtah ne r8 r11 r13
};
const byte kInstruction_uxtah_ne_r9_r8_r12[] = {
  0x7c, 0x90, 0xf8, 0x16 // uxtah ne r9 r8 r12
};
const byte kInstruction_uxtah_al_r14_r8_r6[] = {
  0x76, 0xe0, 0xf8, 0xe6 // uxtah al r14 r8 r6
};
const byte kInstruction_uxtah_vc_r8_r0_r3[] = {
  0x73, 0x80, 0xf0, 0x76 // uxtah vc r8 r0 r3
};
const byte kInstruction_uxtah_pl_r11_r9_r0[] = {
  0x70, 0xb0, 0xf9, 0x56 // uxtah pl r11 r9 r0
};
const byte kInstruction_uxtah_al_r7_r9_r9[] = {
  0x79, 0x70, 0xf9, 0xe6 // uxtah al r7 r9 r9
};
const byte kInstruction_uxtah_ls_r0_r8_r3[] = {
  0x73, 0x00, 0xf8, 0x96 // uxtah ls r0 r8 r3
};
const byte kInstruction_uxtah_lt_r5_r13_r6[] = {
  0x76, 0x50, 0xfd, 0xb6 // uxtah lt r5 r13 r6
};
const byte kInstruction_uxtah_ge_r6_r5_r13[] = {
  0x7d, 0x60, 0xf5, 0xa6 // uxtah ge r6 r5 r13
};
const byte kInstruction_uxtah_cs_r11_r7_r3[] = {
  0x73, 0xb0, 0xf7, 0x26 // uxtah cs r11 r7 r3
};
const byte kInstruction_uxtah_vs_r8_r0_r6[] = {
  0x76, 0x80, 0xf0, 0x66 // uxtah vs r8 r0 r6
};
const byte kInstruction_uxtah_hi_r0_r12_r6[] = {
  0x76, 0x00, 0xfc, 0x86 // uxtah hi r0 r12 r6
};
const byte kInstruction_uxtah_eq_r14_r5_r12[] = {
  0x7c, 0xe0, 0xf5, 0x06 // uxtah eq r14 r5 r12
};
const byte kInstruction_uxtah_lt_r1_r4_r13[] = {
  0x7d, 0x10, 0xf4, 0xb6 // uxtah lt r1 r4 r13
};
const byte kInstruction_uxtah_hi_r6_r4_r2[] = {
  0x72, 0x60, 0xf4, 0x86 // uxtah hi r6 r4 r2
};
const byte kInstruction_uxtah_lt_r10_r10_r9[] = {
  0x79, 0xa0, 0xfa, 0xb6 // uxtah lt r10 r10 r9
};
const byte kInstruction_uxtah_pl_r14_r7_r4[] = {
  0x74, 0xe0, 0xf7, 0x56 // uxtah pl r14 r7 r4
};
const byte kInstruction_uxtah_ge_r8_r3_r4[] = {
  0x74, 0x80, 0xf3, 0xa6 // uxtah ge r8 r3 r4
};
const byte kInstruction_uxtah_al_r11_r1_r14[] = {
  0x7e, 0xb0, 0xf1, 0xe6 // uxtah al r11 r1 r14
};
const byte kInstruction_uxtah_ge_r7_r8_r9[] = {
  0x79, 0x70, 0xf8, 0xa6 // uxtah ge r7 r8 r9
};
const byte kInstruction_uxtah_le_r10_r10_r8[] = {
  0x78, 0xa0, 0xfa, 0xd6 // uxtah le r10 r10 r8
};
const byte kInstruction_uxtah_hi_r3_r3_r7[] = {
  0x77, 0x30, 0xf3, 0x86 // uxtah hi r3 r3 r7
};
const byte kInstruction_uxtah_cc_r3_r0_r14[] = {
  0x7e, 0x30, 0xf0, 0x36 // uxtah cc r3 r0 r14
};
const byte kInstruction_uxtah_al_r8_r9_r1[] = {
  0x71, 0x80, 0xf9, 0xe6 // uxtah al r8 r9 r1
};
const byte kInstruction_uxtah_gt_r6_r13_r7[] = {
  0x77, 0x60, 0xfd, 0xc6 // uxtah gt r6 r13 r7
};
const byte kInstruction_uxtah_ls_r11_r3_r1[] = {
  0x71, 0xb0, 0xf3, 0x96 // uxtah ls r11 r3 r1
};
const byte kInstruction_uxtah_cc_r14_r0_r13[] = {
  0x7d, 0xe0, 0xf0, 0x36 // uxtah cc r14 r0 r13
};
const byte kInstruction_uxtah_gt_r4_r4_r4[] = {
  0x74, 0x40, 0xf4, 0xc6 // uxtah gt r4 r4 r4
};
const byte kInstruction_uxtah_al_r8_r13_r1[] = {
  0x71, 0x80, 0xfd, 0xe6 // uxtah al r8 r13 r1
};
const byte kInstruction_uxtah_mi_r8_r4_r6[] = {
  0x76, 0x80, 0xf4, 0x46 // uxtah mi r8 r4 r6
};
const byte kInstruction_uxtah_vc_r12_r7_r11[] = {
  0x7b, 0xc0, 0xf7, 0x76 // uxtah vc r12 r7 r11
};
const byte kInstruction_uxtah_cs_r0_r1_r0[] = {
  0x70, 0x00, 0xf1, 0x26 // uxtah cs r0 r1 r0
};
const byte kInstruction_uxtah_cc_r13_r14_r0[] = {
  0x70, 0xd0, 0xfe, 0x36 // uxtah cc r13 r14 r0
};
const byte kInstruction_uxtah_eq_r4_r7_r11[] = {
  0x7b, 0x40, 0xf7, 0x06 // uxtah eq r4 r7 r11
};
const byte kInstruction_uxtah_ls_r11_r2_r0[] = {
  0x70, 0xb0, 0xf2, 0x96 // uxtah ls r11 r2 r0
};
const byte kInstruction_uxtah_gt_r10_r2_r3[] = {
  0x73, 0xa0, 0xf2, 0xc6 // uxtah gt r10 r2 r3
};
const byte kInstruction_uxtah_al_r6_r1_r7[] = {
  0x77, 0x60, 0xf1, 0xe6 // uxtah al r6 r1 r7
};
const byte kInstruction_uxtah_cs_r10_r13_r0[] = {
  0x70, 0xa0, 0xfd, 0x26 // uxtah cs r10 r13 r0
};
const byte kInstruction_uxtah_lt_r11_r2_r6[] = {
  0x76, 0xb0, 0xf2, 0xb6 // uxtah lt r11 r2 r6
};
const byte kInstruction_uxtah_pl_r4_r13_r6[] = {
  0x76, 0x40, 0xfd, 0x56 // uxtah pl r4 r13 r6
};
const byte kInstruction_uxtah_cs_r3_r0_r9[] = {
  0x79, 0x30, 0xf0, 0x26 // uxtah cs r3 r0 r9
};
const byte kInstruction_uxtah_gt_r4_r6_r14[] = {
  0x7e, 0x40, 0xf6, 0xc6 // uxtah gt r4 r6 r14
};
const byte kInstruction_uxtah_eq_r6_r8_r0[] = {
  0x70, 0x60, 0xf8, 0x06 // uxtah eq r6 r8 r0
};
const byte kInstruction_uxtah_cc_r5_r5_r2[] = {
  0x72, 0x50, 0xf5, 0x36 // uxtah cc r5 r5 r2
};
const byte kInstruction_uxtah_al_r9_r3_r7[] = {
  0x77, 0x90, 0xf3, 0xe6 // uxtah al r9 r3 r7
};
const byte kInstruction_uxtah_cc_r12_r0_r8[] = {
  0x78, 0xc0, 0xf0, 0x36 // uxtah cc r12 r0 r8
};
const byte kInstruction_uxtah_le_r4_r1_r7[] = {
  0x77, 0x40, 0xf1, 0xd6 // uxtah le r4 r1 r7
};
const byte kInstruction_uxtah_gt_r3_r12_r7[] = {
  0x77, 0x30, 0xfc, 0xc6 // uxtah gt r3 r12 r7
};
const byte kInstruction_uxtah_vc_r4_r3_r14[] = {
  0x7e, 0x40, 0xf3, 0x76 // uxtah vc r4 r3 r14
};
const byte kInstruction_uxtah_le_r0_r7_r10[] = {
  0x7a, 0x00, 0xf7, 0xd6 // uxtah le r0 r7 r10
};
const byte kInstruction_uxtah_vs_r14_r8_r13[] = {
  0x7d, 0xe0, 0xf8, 0x66 // uxtah vs r14 r8 r13
};
const byte kInstruction_uxtah_hi_r9_r0_r11[] = {
  0x7b, 0x90, 0xf0, 0x86 // uxtah hi r9 r0 r11
};
const byte kInstruction_uxtah_eq_r8_r13_r0[] = {
  0x70, 0x80, 0xfd, 0x06 // uxtah eq r8 r13 r0
};
const byte kInstruction_uxtah_vc_r10_r9_r2[] = {
  0x72, 0xa0, 0xf9, 0x76 // uxtah vc r10 r9 r2
};
const byte kInstruction_uxtah_al_r0_r13_r10[] = {
  0x7a, 0x00, 0xfd, 0xe6 // uxtah al r0 r13 r10
};
const byte kInstruction_uxtah_ne_r5_r4_r6[] = {
  0x76, 0x50, 0xf4, 0x16 // uxtah ne r5 r4 r6
};
const byte kInstruction_uxtah_cc_r7_r13_r1[] = {
  0x71, 0x70, 0xfd, 0x36 // uxtah cc r7 r13 r1
};
const byte kInstruction_uxtah_lt_r1_r14_r11[] = {
  0x7b, 0x10, 0xfe, 0xb6 // uxtah lt r1 r14 r11
};
const byte kInstruction_uxtah_vc_r13_r10_r14[] = {
  0x7e, 0xd0, 0xfa, 0x76 // uxtah vc r13 r10 r14
};
const byte kInstruction_uxtah_le_r3_r0_r4[] = {
  0x74, 0x30, 0xf0, 0xd6 // uxtah le r3 r0 r4
};
const byte kInstruction_uxtah_al_r11_r4_r5[] = {
  0x75, 0xb0, 0xf4, 0xe6 // uxtah al r11 r4 r5
};
const byte kInstruction_uxtah_lt_r0_r8_r8[] = {
  0x78, 0x00, 0xf8, 0xb6 // uxtah lt r0 r8 r8
};
const byte kInstruction_uxtah_al_r13_r12_r7[] = {
  0x77, 0xd0, 0xfc, 0xe6 // uxtah al r13 r12 r7
};
const byte kInstruction_uxtah_ls_r12_r13_r13[] = {
  0x7d, 0xc0, 0xfd, 0x96 // uxtah ls r12 r13 r13
};
const byte kInstruction_uxtah_vc_r8_r2_r9[] = {
  0x79, 0x80, 0xf2, 0x76 // uxtah vc r8 r2 r9
};
const byte kInstruction_uxtah_ne_r14_r9_r3[] = {
  0x73, 0xe0, 0xf9, 0x16 // uxtah ne r14 r9 r3
};
const byte kInstruction_uxtah_pl_r12_r11_r6[] = {
  0x76, 0xc0, 0xfb, 0x56 // uxtah pl r12 r11 r6
};
const byte kInstruction_uxtah_eq_r0_r3_r5[] = {
  0x75, 0x00, 0xf3, 0x06 // uxtah eq r0 r3 r5
};
const byte kInstruction_uxtah_hi_r11_r3_r14[] = {
  0x7e, 0xb0, 0xf3, 0x86 // uxtah hi r11 r3 r14
};
const byte kInstruction_uxtah_le_r3_r7_r4[] = {
  0x74, 0x30, 0xf7, 0xd6 // uxtah le r3 r7 r4
};
const byte kInstruction_uxtah_ne_r6_r9_r8[] = {
  0x78, 0x60, 0xf9, 0x16 // uxtah ne r6 r9 r8
};
const byte kInstruction_uxtah_vc_r11_r11_r11[] = {
  0x7b, 0xb0, 0xfb, 0x76 // uxtah vc r11 r11 r11
};
const byte kInstruction_uxtah_ge_r3_r1_r10[] = {
  0x7a, 0x30, 0xf1, 0xa6 // uxtah ge r3 r1 r10
};
const byte kInstruction_uxtah_gt_r5_r14_r13[] = {
  0x7d, 0x50, 0xfe, 0xc6 // uxtah gt r5 r14 r13
};
const byte kInstruction_uxtah_le_r7_r0_r13[] = {
  0x7d, 0x70, 0xf0, 0xd6 // uxtah le r7 r0 r13
};
const byte kInstruction_uxtah_lt_r8_r5_r1[] = {
  0x71, 0x80, 0xf5, 0xb6 // uxtah lt r8 r5 r1
};
const byte kInstruction_uxtah_le_r3_r4_r8[] = {
  0x78, 0x30, 0xf4, 0xd6 // uxtah le r3 r4 r8
};
const byte kInstruction_uxtah_ne_r5_r11_r13[] = {
  0x7d, 0x50, 0xfb, 0x16 // uxtah ne r5 r11 r13
};
const byte kInstruction_uxtah_ge_r9_r8_r2[] = {
  0x72, 0x90, 0xf8, 0xa6 // uxtah ge r9 r8 r2
};
const byte kInstruction_uxtah_gt_r9_r5_r12[] = {
  0x7c, 0x90, 0xf5, 0xc6 // uxtah gt r9 r5 r12
};
const byte kInstruction_uxtah_pl_r9_r8_r1[] = {
  0x71, 0x90, 0xf8, 0x56 // uxtah pl r9 r8 r1
};
const byte kInstruction_uxtah_le_r3_r12_r4[] = {
  0x74, 0x30, 0xfc, 0xd6 // uxtah le r3 r12 r4
};
const byte kInstruction_uxtah_eq_r5_r6_r9[] = {
  0x79, 0x50, 0xf6, 0x06 // uxtah eq r5 r6 r9
};
const byte kInstruction_uxtah_ne_r14_r4_r13[] = {
  0x7d, 0xe0, 0xf4, 0x16 // uxtah ne r14 r4 r13
};
const byte kInstruction_uxtah_ge_r3_r9_r2[] = {
  0x72, 0x30, 0xf9, 0xa6 // uxtah ge r3 r9 r2
};
const byte kInstruction_uxtah_ls_r13_r0_r10[] = {
  0x7a, 0xd0, 0xf0, 0x96 // uxtah ls r13 r0 r10
};
const byte kInstruction_uxtah_mi_r14_r0_r2[] = {
  0x72, 0xe0, 0xf0, 0x46 // uxtah mi r14 r0 r2
};
const byte kInstruction_uxtah_cs_r11_r1_r3[] = {
  0x73, 0xb0, 0xf1, 0x26 // uxtah cs r11 r1 r3
};
const byte kInstruction_uxtah_ne_r8_r9_r10[] = {
  0x7a, 0x80, 0xf9, 0x16 // uxtah ne r8 r9 r10
};
const byte kInstruction_uxtah_gt_r9_r10_r4[] = {
  0x74, 0x90, 0xfa, 0xc6 // uxtah gt r9 r10 r4
};
const byte kInstruction_uxtah_le_r2_r8_r4[] = {
  0x74, 0x20, 0xf8, 0xd6 // uxtah le r2 r8 r4
};
const byte kInstruction_uxtah_al_r6_r14_r11[] = {
  0x7b, 0x60, 0xfe, 0xe6 // uxtah al r6 r14 r11
};
const byte kInstruction_uxtah_eq_r3_r14_r14[] = {
  0x7e, 0x30, 0xfe, 0x06 // uxtah eq r3 r14 r14
};
const byte kInstruction_uxtah_pl_r9_r9_r3[] = {
  0x73, 0x90, 0xf9, 0x56 // uxtah pl r9 r9 r3
};
const byte kInstruction_uxtah_ge_r5_r13_r12[] = {
  0x7c, 0x50, 0xfd, 0xa6 // uxtah ge r5 r13 r12
};
const byte kInstruction_uxtah_mi_r10_r6_r5[] = {
  0x75, 0xa0, 0xf6, 0x46 // uxtah mi r10 r6 r5
};
const byte kInstruction_uxtah_ls_r14_r13_r12[] = {
  0x7c, 0xe0, 0xfd, 0x96 // uxtah ls r14 r13 r12
};
const byte kInstruction_uxtah_lt_r10_r9_r10[] = {
  0x7a, 0xa0, 0xf9, 0xb6 // uxtah lt r10 r9 r10
};
const byte kInstruction_uxtah_ls_r7_r4_r9[] = {
  0x79, 0x70, 0xf4, 0x96 // uxtah ls r7 r4 r9
};
const byte kInstruction_uxtah_cs_r9_r10_r7[] = {
  0x77, 0x90, 0xfa, 0x26 // uxtah cs r9 r10 r7
};
const byte kInstruction_uxtah_eq_r4_r2_r2[] = {
  0x72, 0x40, 0xf2, 0x06 // uxtah eq r4 r2 r2
};
const byte kInstruction_uxtah_lt_r14_r13_r4[] = {
  0x74, 0xe0, 0xfd, 0xb6 // uxtah lt r14 r13 r4
};
const byte kInstruction_uxtah_al_r0_r3_r5[] = {
  0x75, 0x00, 0xf3, 0xe6 // uxtah al r0 r3 r5
};
const byte kInstruction_uxtah_vs_r9_r6_r7[] = {
  0x77, 0x90, 0xf6, 0x66 // uxtah vs r9 r6 r7
};
const byte kInstruction_uxtah_ls_r0_r6_r4[] = {
  0x74, 0x00, 0xf6, 0x96 // uxtah ls r0 r6 r4
};
const byte kInstruction_uxtah_ne_r7_r10_r14[] = {
  0x7e, 0x70, 0xfa, 0x16 // uxtah ne r7 r10 r14
};
const byte kInstruction_uxtah_le_r2_r12_r1[] = {
  0x71, 0x20, 0xfc, 0xd6 // uxtah le r2 r12 r1
};
const byte kInstruction_uxtah_cs_r1_r5_r0[] = {
  0x70, 0x10, 0xf5, 0x26 // uxtah cs r1 r5 r0
};
const byte kInstruction_uxtah_pl_r0_r9_r1[] = {
  0x71, 0x00, 0xf9, 0x56 // uxtah pl r0 r9 r1
};
const byte kInstruction_uxtah_mi_r2_r2_r5[] = {
  0x75, 0x20, 0xf2, 0x46 // uxtah mi r2 r2 r5
};
const byte kInstruction_uxtah_hi_r5_r1_r12[] = {
  0x7c, 0x50, 0xf1, 0x86 // uxtah hi r5 r1 r12
};
const byte kInstruction_uxtah_ls_r13_r14_r7[] = {
  0x77, 0xd0, 0xfe, 0x96 // uxtah ls r13 r14 r7
};
const byte kInstruction_uxtah_lt_r0_r4_r3[] = {
  0x73, 0x00, 0xf4, 0xb6 // uxtah lt r0 r4 r3
};
const byte kInstruction_uxtah_cc_r8_r13_r2[] = {
  0x72, 0x80, 0xfd, 0x36 // uxtah cc r8 r13 r2
};
const byte kInstruction_uxtah_ls_r7_r8_r14[] = {
  0x7e, 0x70, 0xf8, 0x96 // uxtah ls r7 r8 r14
};
const byte kInstruction_uxtah_hi_r13_r11_r13[] = {
  0x7d, 0xd0, 0xfb, 0x86 // uxtah hi r13 r11 r13
};
const byte kInstruction_uxtah_ge_r13_r7_r6[] = {
  0x76, 0xd0, 0xf7, 0xa6 // uxtah ge r13 r7 r6
};
const byte kInstruction_uxtah_mi_r3_r2_r0[] = {
  0x70, 0x30, 0xf2, 0x46 // uxtah mi r3 r2 r0
};
const byte kInstruction_uxtah_cs_r12_r0_r10[] = {
  0x7a, 0xc0, 0xf0, 0x26 // uxtah cs r12 r0 r10
};
const byte kInstruction_uxtah_vs_r9_r10_r8[] = {
  0x78, 0x90, 0xfa, 0x66 // uxtah vs r9 r10 r8
};
const byte kInstruction_uxtah_ls_r2_r8_r8[] = {
  0x78, 0x20, 0xf8, 0x96 // uxtah ls r2 r8 r8
};
const byte kInstruction_uxtah_ge_r1_r11_r3[] = {
  0x73, 0x10, 0xfb, 0xa6 // uxtah ge r1 r11 r3
};
const byte kInstruction_uxtah_ge_r12_r3_r3[] = {
  0x73, 0xc0, 0xf3, 0xa6 // uxtah ge r12 r3 r3
};
const byte kInstruction_uxtah_gt_r3_r8_r6[] = {
  0x76, 0x30, 0xf8, 0xc6 // uxtah gt r3 r8 r6
};
const byte kInstruction_uxtah_ne_r13_r2_r9[] = {
  0x79, 0xd0, 0xf2, 0x16 // uxtah ne r13 r2 r9
};
const byte kInstruction_uxtah_ls_r14_r9_r1[] = {
  0x71, 0xe0, 0xf9, 0x96 // uxtah ls r14 r9 r1
};
const byte kInstruction_uxtah_cc_r2_r10_r2[] = {
  0x72, 0x20, 0xfa, 0x36 // uxtah cc r2 r10 r2
};
const byte kInstruction_uxtah_le_r9_r12_r1[] = {
  0x71, 0x90, 0xfc, 0xd6 // uxtah le r9 r12 r1
};
const byte kInstruction_uxtah_cs_r11_r10_r0[] = {
  0x70, 0xb0, 0xfa, 0x26 // uxtah cs r11 r10 r0
};
const byte kInstruction_uxtah_eq_r7_r0_r5[] = {
  0x75, 0x70, 0xf0, 0x06 // uxtah eq r7 r0 r5
};
const byte kInstruction_uxtah_ne_r10_r4_r4[] = {
  0x74, 0xa0, 0xf4, 0x16 // uxtah ne r10 r4 r4
};
const byte kInstruction_uxtah_pl_r13_r9_r6[] = {
  0x76, 0xd0, 0xf9, 0x56 // uxtah pl r13 r9 r6
};
const byte kInstruction_uxtah_vc_r11_r3_r3[] = {
  0x73, 0xb0, 0xf3, 0x76 // uxtah vc r11 r3 r3
};
const byte kInstruction_uxtah_al_r1_r13_r9[] = {
  0x79, 0x10, 0xfd, 0xe6 // uxtah al r1 r13 r9
};
const byte kInstruction_uxtah_cc_r13_r9_r14[] = {
  0x7e, 0xd0, 0xf9, 0x36 // uxtah cc r13 r9 r14
};
const byte kInstruction_uxtah_vc_r5_r2_r3[] = {
  0x73, 0x50, 0xf2, 0x76 // uxtah vc r5 r2 r3
};
const byte kInstruction_uxtah_ne_r12_r8_r10[] = {
  0x7a, 0xc0, 0xf8, 0x16 // uxtah ne r12 r8 r10
};
const byte kInstruction_uxtah_cs_r11_r13_r6[] = {
  0x76, 0xb0, 0xfd, 0x26 // uxtah cs r11 r13 r6
};
const byte kInstruction_uxtah_al_r1_r11_r10[] = {
  0x7a, 0x10, 0xfb, 0xe6 // uxtah al r1 r11 r10
};
const byte kInstruction_uxtah_ne_r14_r6_r11[] = {
  0x7b, 0xe0, 0xf6, 0x16 // uxtah ne r14 r6 r11
};
const byte kInstruction_uxtah_cs_r1_r14_r5[] = {
  0x75, 0x10, 0xfe, 0x26 // uxtah cs r1 r14 r5
};
const byte kInstruction_uxtah_al_r11_r11_r6[] = {
  0x76, 0xb0, 0xfb, 0xe6 // uxtah al r11 r11 r6
};
const byte kInstruction_uxtah_pl_r3_r6_r2[] = {
  0x72, 0x30, 0xf6, 0x56 // uxtah pl r3 r6 r2
};
const byte kInstruction_uxtah_ne_r3_r9_r4[] = {
  0x74, 0x30, 0xf9, 0x16 // uxtah ne r3 r9 r4
};
const byte kInstruction_uxtah_mi_r11_r4_r9[] = {
  0x79, 0xb0, 0xf4, 0x46 // uxtah mi r11 r4 r9
};
const byte kInstruction_uxtah_al_r10_r1_r3[] = {
  0x73, 0xa0, 0xf1, 0xe6 // uxtah al r10 r1 r3
};
const byte kInstruction_uxtah_vc_r2_r14_r11[] = {
  0x7b, 0x20, 0xfe, 0x76 // uxtah vc r2 r14 r11
};
const byte kInstruction_uxtah_mi_r9_r3_r0[] = {
  0x70, 0x90, 0xf3, 0x46 // uxtah mi r9 r3 r0
};
const byte kInstruction_uxtah_vs_r9_r8_r1[] = {
  0x71, 0x90, 0xf8, 0x66 // uxtah vs r9 r8 r1
};
const byte kInstruction_uxtah_lt_r2_r12_r5[] = {
  0x75, 0x20, 0xfc, 0xb6 // uxtah lt r2 r12 r5
};
const byte kInstruction_uxtah_al_r9_r8_r12[] = {
  0x7c, 0x90, 0xf8, 0xe6 // uxtah al r9 r8 r12
};
const byte kInstruction_uxtah_vc_r3_r8_r0[] = {
  0x70, 0x30, 0xf8, 0x76 // uxtah vc r3 r8 r0
};
const byte kInstruction_uxtah_mi_r10_r5_r1[] = {
  0x71, 0xa0, 0xf5, 0x46 // uxtah mi r10 r5 r1
};
const byte kInstruction_uxtah_vc_r7_r14_r2[] = {
  0x72, 0x70, 0xfe, 0x76 // uxtah vc r7 r14 r2
};
const byte kInstruction_uxtah_ls_r0_r9_r7[] = {
  0x77, 0x00, 0xf9, 0x96 // uxtah ls r0 r9 r7
};
const byte kInstruction_uxtah_cs_r3_r0_r10[] = {
  0x7a, 0x30, 0xf0, 0x26 // uxtah cs r3 r0 r10
};
const byte kInstruction_uxtah_cc_r10_r8_r10[] = {
  0x7a, 0xa0, 0xf8, 0x36 // uxtah cc r10 r8 r10
};
const byte kInstruction_uxtah_eq_r5_r4_r1[] = {
  0x71, 0x50, 0xf4, 0x06 // uxtah eq r5 r4 r1
};
const byte kInstruction_uxtah_vc_r11_r13_r1[] = {
  0x71, 0xb0, 0xfd, 0x76 // uxtah vc r11 r13 r1
};
const byte kInstruction_uxtah_hi_r6_r5_r8[] = {
  0x78, 0x60, 0xf5, 0x86 // uxtah hi r6 r5 r8
};
const byte kInstruction_uxtah_ne_r10_r5_r6[] = {
  0x76, 0xa0, 0xf5, 0x16 // uxtah ne r10 r5 r6
};
const byte kInstruction_uxtah_al_r10_r12_r9[] = {
  0x79, 0xa0, 0xfc, 0xe6 // uxtah al r10 r12 r9
};
const byte kInstruction_uxtah_eq_r5_r1_r12[] = {
  0x7c, 0x50, 0xf1, 0x06 // uxtah eq r5 r1 r12
};
const byte kInstruction_uxtah_le_r0_r14_r10[] = {
  0x7a, 0x00, 0xfe, 0xd6 // uxtah le r0 r14 r10
};
const byte kInstruction_uxtah_eq_r4_r2_r5[] = {
  0x75, 0x40, 0xf2, 0x06 // uxtah eq r4 r2 r5
};
const byte kInstruction_uxtah_pl_r5_r8_r2[] = {
  0x72, 0x50, 0xf8, 0x56 // uxtah pl r5 r8 r2
};
const byte kInstruction_uxtah_hi_r5_r14_r4[] = {
  0x74, 0x50, 0xfe, 0x86 // uxtah hi r5 r14 r4
};
const byte kInstruction_uxtah_le_r2_r7_r9[] = {
  0x79, 0x20, 0xf7, 0xd6 // uxtah le r2 r7 r9
};
const byte kInstruction_uxtah_pl_r5_r12_r6[] = {
  0x76, 0x50, 0xfc, 0x56 // uxtah pl r5 r12 r6
};
const byte kInstruction_uxtah_vs_r11_r4_r14[] = {
  0x7e, 0xb0, 0xf4, 0x66 // uxtah vs r11 r4 r14
};
const byte kInstruction_uxtah_eq_r0_r7_r14[] = {
  0x7e, 0x00, 0xf7, 0x06 // uxtah eq r0 r7 r14
};
const byte kInstruction_uxtah_pl_r5_r2_r5[] = {
  0x75, 0x50, 0xf2, 0x56 // uxtah pl r5 r2 r5
};
const byte kInstruction_uxtah_ne_r5_r11_r7[] = {
  0x77, 0x50, 0xfb, 0x16 // uxtah ne r5 r11 r7
};
const byte kInstruction_uxtah_pl_r7_r9_r10[] = {
  0x7a, 0x70, 0xf9, 0x56 // uxtah pl r7 r9 r10
};
const byte kInstruction_uxtah_hi_r4_r2_r2[] = {
  0x72, 0x40, 0xf2, 0x86 // uxtah hi r4 r2 r2
};
const byte kInstruction_uxtah_pl_r14_r9_r2[] = {
  0x72, 0xe0, 0xf9, 0x56 // uxtah pl r14 r9 r2
};
const byte kInstruction_uxtah_le_r4_r11_r13[] = {
  0x7d, 0x40, 0xfb, 0xd6 // uxtah le r4 r11 r13
};
const byte kInstruction_uxtah_pl_r8_r8_r8[] = {
  0x78, 0x80, 0xf8, 0x56 // uxtah pl r8 r8 r8
};
const byte kInstruction_uxtah_ge_r0_r6_r10[] = {
  0x7a, 0x00, 0xf6, 0xa6 // uxtah ge r0 r6 r10
};
const byte kInstruction_uxtah_vc_r4_r4_r10[] = {
  0x7a, 0x40, 0xf4, 0x76 // uxtah vc r4 r4 r10
};
const byte kInstruction_uxtah_cc_r11_r9_r12[] = {
  0x7c, 0xb0, 0xf9, 0x36 // uxtah cc r11 r9 r12
};
const byte kInstruction_uxtah_pl_r14_r4_r12[] = {
  0x7c, 0xe0, 0xf4, 0x56 // uxtah pl r14 r4 r12
};
const byte kInstruction_uxtah_vs_r8_r8_r8[] = {
  0x78, 0x80, 0xf8, 0x66 // uxtah vs r8 r8 r8
};
const byte kInstruction_uxtah_ge_r14_r2_r12[] = {
  0x7c, 0xe0, 0xf2, 0xa6 // uxtah ge r14 r2 r12
};
const byte kInstruction_uxtah_ge_r8_r2_r13[] = {
  0x7d, 0x80, 0xf2, 0xa6 // uxtah ge r8 r2 r13
};
const byte kInstruction_uxtah_vs_r10_r0_r11[] = {
  0x7b, 0xa0, 0xf0, 0x66 // uxtah vs r10 r0 r11
};
const byte kInstruction_uxtah_eq_r5_r1_r2[] = {
  0x72, 0x50, 0xf1, 0x06 // uxtah eq r5 r1 r2
};
const byte kInstruction_uxtah_vs_r10_r11_r3[] = {
  0x73, 0xa0, 0xfb, 0x66 // uxtah vs r10 r11 r3
};
const byte kInstruction_uxtah_lt_r13_r13_r7[] = {
  0x77, 0xd0, 0xfd, 0xb6 // uxtah lt r13 r13 r7
};
const byte kInstruction_uxtah_le_r12_r7_r6[] = {
  0x76, 0xc0, 0xf7, 0xd6 // uxtah le r12 r7 r6
};
const byte kInstruction_uxtah_eq_r4_r3_r3[] = {
  0x73, 0x40, 0xf3, 0x06 // uxtah eq r4 r3 r3
};
const byte kInstruction_uxtah_pl_r0_r5_r8[] = {
  0x78, 0x00, 0xf5, 0x56 // uxtah pl r0 r5 r8
};
const byte kInstruction_uxtah_vs_r10_r5_r3[] = {
  0x73, 0xa0, 0xf5, 0x66 // uxtah vs r10 r5 r3
};
const byte kInstruction_uxtah_gt_r0_r11_r9[] = {
  0x79, 0x00, 0xfb, 0xc6 // uxtah gt r0 r11 r9
};
const byte kInstruction_uxtah_cc_r8_r5_r9[] = {
  0x79, 0x80, 0xf5, 0x36 // uxtah cc r8 r5 r9
};
const byte kInstruction_uxtah_cs_r9_r12_r11[] = {
  0x7b, 0x90, 0xfc, 0x26 // uxtah cs r9 r12 r11
};
const byte kInstruction_uxtah_gt_r3_r4_r8[] = {
  0x78, 0x30, 0xf4, 0xc6 // uxtah gt r3 r4 r8
};
const byte kInstruction_uxtah_ls_r8_r3_r10[] = {
  0x7a, 0x80, 0xf3, 0x96 // uxtah ls r8 r3 r10
};
const byte kInstruction_uxtah_eq_r8_r14_r12[] = {
  0x7c, 0x80, 0xfe, 0x06 // uxtah eq r8 r14 r12
};
const byte kInstruction_uxtah_gt_r7_r1_r3[] = {
  0x73, 0x70, 0xf1, 0xc6 // uxtah gt r7 r1 r3
};
const byte kInstruction_uxtah_al_r4_r4_r8[] = {
  0x78, 0x40, 0xf4, 0xe6 // uxtah al r4 r4 r8
};
const byte kInstruction_uxtah_gt_r9_r14_r10[] = {
  0x7a, 0x90, 0xfe, 0xc6 // uxtah gt r9 r14 r10
};
const byte kInstruction_uxtah_lt_r3_r13_r2[] = {
  0x72, 0x30, 0xfd, 0xb6 // uxtah lt r3 r13 r2
};
const byte kInstruction_uxtah_le_r4_r11_r14[] = {
  0x7e, 0x40, 0xfb, 0xd6 // uxtah le r4 r11 r14
};
const byte kInstruction_uxtah_ge_r2_r14_r0[] = {
  0x70, 0x20, 0xfe, 0xa6 // uxtah ge r2 r14 r0
};
const byte kInstruction_uxtah_pl_r1_r8_r8[] = {
  0x78, 0x10, 0xf8, 0x56 // uxtah pl r1 r8 r8
};
const byte kInstruction_uxtah_pl_r9_r2_r5[] = {
  0x75, 0x90, 0xf2, 0x56 // uxtah pl r9 r2 r5
};
const byte kInstruction_uxtah_vs_r13_r13_r1[] = {
  0x71, 0xd0, 0xfd, 0x66 // uxtah vs r13 r13 r1
};
const byte kInstruction_uxtah_ge_r12_r14_r3[] = {
  0x73, 0xc0, 0xfe, 0xa6 // uxtah ge r12 r14 r3
};
const byte kInstruction_uxtah_vc_r0_r11_r4[] = {
  0x74, 0x00, 0xfb, 0x76 // uxtah vc r0 r11 r4
};
const byte kInstruction_uxtah_ge_r0_r2_r9[] = {
  0x79, 0x00, 0xf2, 0xa6 // uxtah ge r0 r2 r9
};
const byte kInstruction_uxtah_vc_r12_r1_r6[] = {
  0x76, 0xc0, 0xf1, 0x76 // uxtah vc r12 r1 r6
};
const byte kInstruction_uxtah_ne_r1_r3_r7[] = {
  0x77, 0x10, 0xf3, 0x16 // uxtah ne r1 r3 r7
};
const byte kInstruction_uxtah_vs_r10_r3_r9[] = {
  0x79, 0xa0, 0xf3, 0x66 // uxtah vs r10 r3 r9
};
const byte kInstruction_uxtah_cc_r14_r4_r1[] = {
  0x71, 0xe0, 0xf4, 0x36 // uxtah cc r14 r4 r1
};
const byte kInstruction_uxtah_le_r9_r3_r7[] = {
  0x77, 0x90, 0xf3, 0xd6 // uxtah le r9 r3 r7
};
const byte kInstruction_uxtah_le_r1_r0_r14[] = {
  0x7e, 0x10, 0xf0, 0xd6 // uxtah le r1 r0 r14
};
const byte kInstruction_uxtah_le_r0_r14_r4[] = {
  0x74, 0x00, 0xfe, 0xd6 // uxtah le r0 r14 r4
};
const byte kInstruction_uxtah_hi_r13_r8_r11[] = {
  0x7b, 0xd0, 0xf8, 0x86 // uxtah hi r13 r8 r11
};
const byte kInstruction_uxtah_cc_r10_r6_r11[] = {
  0x7b, 0xa0, 0xf6, 0x36 // uxtah cc r10 r6 r11
};
const byte kInstruction_uxtah_cc_r0_r10_r14[] = {
  0x7e, 0x00, 0xfa, 0x36 // uxtah cc r0 r10 r14
};
const byte kInstruction_uxtah_le_r4_r4_r0[] = {
  0x70, 0x40, 0xf4, 0xd6 // uxtah le r4 r4 r0
};
const byte kInstruction_uxtah_pl_r8_r14_r12[] = {
  0x7c, 0x80, 0xfe, 0x56 // uxtah pl r8 r14 r12
};
const byte kInstruction_uxtah_ge_r13_r12_r2[] = {
  0x72, 0xd0, 0xfc, 0xa6 // uxtah ge r13 r12 r2
};
const byte kInstruction_uxtah_al_r11_r11_r7[] = {
  0x77, 0xb0, 0xfb, 0xe6 // uxtah al r11 r11 r7
};
const byte kInstruction_uxtah_ls_r11_r12_r1[] = {
  0x71, 0xb0, 0xfc, 0x96 // uxtah ls r11 r12 r1
};
const byte kInstruction_uxtah_vs_r10_r14_r14[] = {
  0x7e, 0xa0, 0xfe, 0x66 // uxtah vs r10 r14 r14
};
const byte kInstruction_uxtah_pl_r2_r8_r12[] = {
  0x7c, 0x20, 0xf8, 0x56 // uxtah pl r2 r8 r12
};
const byte kInstruction_uxtah_pl_r12_r7_r11[] = {
  0x7b, 0xc0, 0xf7, 0x56 // uxtah pl r12 r7 r11
};
const byte kInstruction_uxtah_eq_r5_r8_r13[] = {
  0x7d, 0x50, 0xf8, 0x06 // uxtah eq r5 r8 r13
};
const byte kInstruction_uxtah_vc_r6_r6_r6[] = {
  0x76, 0x60, 0xf6, 0x76 // uxtah vc r6 r6 r6
};
const byte kInstruction_uxtah_vs_r0_r12_r1[] = {
  0x71, 0x00, 0xfc, 0x66 // uxtah vs r0 r12 r1
};
const byte kInstruction_uxtah_cs_r6_r0_r8[] = {
  0x78, 0x60, 0xf0, 0x26 // uxtah cs r6 r0 r8
};
const byte kInstruction_uxtah_cc_r3_r4_r1[] = {
  0x71, 0x30, 0xf4, 0x36 // uxtah cc r3 r4 r1
};
const byte kInstruction_uxtah_lt_r1_r10_r14[] = {
  0x7e, 0x10, 0xfa, 0xb6 // uxtah lt r1 r10 r14
};
const byte kInstruction_uxtah_le_r1_r3_r5[] = {
  0x75, 0x10, 0xf3, 0xd6 // uxtah le r1 r3 r5
};
const byte kInstruction_uxtah_cc_r11_r1_r1[] = {
  0x71, 0xb0, 0xf1, 0x36 // uxtah cc r11 r1 r1
};
const byte kInstruction_uxtah_vc_r1_r8_r7[] = {
  0x77, 0x10, 0xf8, 0x76 // uxtah vc r1 r8 r7
};
const byte kInstruction_uxtah_eq_r3_r10_r13[] = {
  0x7d, 0x30, 0xfa, 0x06 // uxtah eq r3 r10 r13
};
const byte kInstruction_uxtah_hi_r14_r12_r12[] = {
  0x7c, 0xe0, 0xfc, 0x86 // uxtah hi r14 r12 r12
};
const byte kInstruction_uxtah_eq_r10_r1_r14[] = {
  0x7e, 0xa0, 0xf1, 0x06 // uxtah eq r10 r1 r14
};
const byte kInstruction_uxtah_lt_r3_r1_r6[] = {
  0x76, 0x30, 0xf1, 0xb6 // uxtah lt r3 r1 r6
};
const byte kInstruction_uxtah_cc_r9_r12_r10[] = {
  0x7a, 0x90, 0xfc, 0x36 // uxtah cc r9 r12 r10
};
const byte kInstruction_uxtah_lt_r13_r14_r14[] = {
  0x7e, 0xd0, 0xfe, 0xb6 // uxtah lt r13 r14 r14
};
const byte kInstruction_uxtah_ge_r2_r6_r9[] = {
  0x79, 0x20, 0xf6, 0xa6 // uxtah ge r2 r6 r9
};
const byte kInstruction_uxtah_vs_r3_r9_r1[] = {
  0x71, 0x30, 0xf9, 0x66 // uxtah vs r3 r9 r1
};
const byte kInstruction_uxtah_cc_r1_r9_r12[] = {
  0x7c, 0x10, 0xf9, 0x36 // uxtah cc r1 r9 r12
};
const byte kInstruction_uxtah_ls_r5_r0_r6[] = {
  0x76, 0x50, 0xf0, 0x96 // uxtah ls r5 r0 r6
};
const byte kInstruction_uxtah_hi_r6_r14_r10[] = {
  0x7a, 0x60, 0xfe, 0x86 // uxtah hi r6 r14 r10
};
const byte kInstruction_uxtah_al_r11_r10_r3[] = {
  0x73, 0xb0, 0xfa, 0xe6 // uxtah al r11 r10 r3
};
const byte kInstruction_uxtah_ne_r13_r4_r1[] = {
  0x71, 0xd0, 0xf4, 0x16 // uxtah ne r13 r4 r1
};
const byte kInstruction_uxtah_hi_r13_r5_r14[] = {
  0x7e, 0xd0, 0xf5, 0x86 // uxtah hi r13 r5 r14
};
const byte kInstruction_uxtah_ne_r8_r9_r11[] = {
  0x7b, 0x80, 0xf9, 0x16 // uxtah ne r8 r9 r11
};
const byte kInstruction_uxtah_eq_r0_r13_r13[] = {
  0x7d, 0x00, 0xfd, 0x06 // uxtah eq r0 r13 r13
};
const byte kInstruction_uxtah_ne_r14_r11_r0[] = {
  0x70, 0xe0, 0xfb, 0x16 // uxtah ne r14 r11 r0
};
const byte kInstruction_uxtah_mi_r6_r8_r7[] = {
  0x77, 0x60, 0xf8, 0x46 // uxtah mi r6 r8 r7
};
const byte kInstruction_uxtah_eq_r1_r7_r5[] = {
  0x75, 0x10, 0xf7, 0x06 // uxtah eq r1 r7 r5
};
const byte kInstruction_uxtah_pl_r12_r9_r12[] = {
  0x7c, 0xc0, 0xf9, 0x56 // uxtah pl r12 r9 r12
};
const byte kInstruction_uxtah_al_r4_r5_r14[] = {
  0x7e, 0x40, 0xf5, 0xe6 // uxtah al r4 r5 r14
};
const byte kInstruction_uxtah_pl_r7_r0_r12[] = {
  0x7c, 0x70, 0xf0, 0x56 // uxtah pl r7 r0 r12
};
const byte kInstruction_uxtah_mi_r5_r0_r13[] = {
  0x7d, 0x50, 0xf0, 0x46 // uxtah mi r5 r0 r13
};
const byte kInstruction_uxtah_al_r10_r7_r11[] = {
  0x7b, 0xa0, 0xf7, 0xe6 // uxtah al r10 r7 r11
};
const byte kInstruction_uxtah_gt_r2_r10_r0[] = {
  0x70, 0x20, 0xfa, 0xc6 // uxtah gt r2 r10 r0
};
const byte kInstruction_uxtah_ge_r11_r11_r8[] = {
  0x78, 0xb0, 0xfb, 0xa6 // uxtah ge r11 r11 r8
};
const byte kInstruction_uxtah_eq_r14_r7_r3[] = {
  0x73, 0xe0, 0xf7, 0x06 // uxtah eq r14 r7 r3
};
const byte kInstruction_uxtah_ls_r0_r12_r4[] = {
  0x74, 0x00, 0xfc, 0x96 // uxtah ls r0 r12 r4
};
const byte kInstruction_uxtah_ne_r10_r1_r7[] = {
  0x77, 0xa0, 0xf1, 0x16 // uxtah ne r10 r1 r7
};
const byte kInstruction_uxtah_hi_r14_r3_r13[] = {
  0x7d, 0xe0, 0xf3, 0x86 // uxtah hi r14 r3 r13
};
const byte kInstruction_uxtah_le_r1_r5_r12[] = {
  0x7c, 0x10, 0xf5, 0xd6 // uxtah le r1 r5 r12
};
const byte kInstruction_uxtah_ne_r8_r5_r11[] = {
  0x7b, 0x80, 0xf5, 0x16 // uxtah ne r8 r5 r11
};
const byte kInstruction_uxtah_le_r5_r13_r0[] = {
  0x70, 0x50, 0xfd, 0xd6 // uxtah le r5 r13 r0
};
const byte kInstruction_uxtah_gt_r8_r12_r7[] = {
  0x77, 0x80, 0xfc, 0xc6 // uxtah gt r8 r12 r7
};
const byte kInstruction_uxtah_eq_r9_r14_r3[] = {
  0x73, 0x90, 0xfe, 0x06 // uxtah eq r9 r14 r3
};
const byte kInstruction_uxtah_cs_r10_r9_r9[] = {
  0x79, 0xa0, 0xf9, 0x26 // uxtah cs r10 r9 r9
};
const byte kInstruction_uxtah_vc_r5_r13_r8[] = {
  0x78, 0x50, 0xfd, 0x76 // uxtah vc r5 r13 r8
};
const byte kInstruction_uxtah_eq_r4_r1_r8[] = {
  0x78, 0x40, 0xf1, 0x06 // uxtah eq r4 r1 r8
};
const byte kInstruction_uxtah_lt_r12_r14_r9[] = {
  0x79, 0xc0, 0xfe, 0xb6 // uxtah lt r12 r14 r9
};
const byte kInstruction_uxtah_cc_r8_r8_r0[] = {
  0x70, 0x80, 0xf8, 0x36 // uxtah cc r8 r8 r0
};
const byte kInstruction_uxtah_hi_r0_r14_r12[] = {
  0x7c, 0x00, 0xfe, 0x86 // uxtah hi r0 r14 r12
};
const byte kInstruction_uxtah_hi_r4_r1_r10[] = {
  0x7a, 0x40, 0xf1, 0x86 // uxtah hi r4 r1 r10
};
const byte kInstruction_uxtah_gt_r2_r14_r12[] = {
  0x7c, 0x20, 0xfe, 0xc6 // uxtah gt r2 r14 r12
};
const byte kInstruction_uxtah_vs_r1_r8_r14[] = {
  0x7e, 0x10, 0xf8, 0x66 // uxtah vs r1 r8 r14
};
const byte kInstruction_uxtah_cs_r4_r1_r6[] = {
  0x76, 0x40, 0xf1, 0x26 // uxtah cs r4 r1 r6
};
const byte kInstruction_uxtah_hi_r7_r8_r7[] = {
  0x77, 0x70, 0xf8, 0x86 // uxtah hi r7 r8 r7
};
const byte kInstruction_uxtah_hi_r3_r11_r8[] = {
  0x78, 0x30, 0xfb, 0x86 // uxtah hi r3 r11 r8
};
const byte kInstruction_uxtah_lt_r1_r12_r9[] = {
  0x79, 0x10, 0xfc, 0xb6 // uxtah lt r1 r12 r9
};
const byte kInstruction_uxtah_cs_r13_r4_r12[] = {
  0x7c, 0xd0, 0xf4, 0x26 // uxtah cs r13 r4 r12
};
const byte kInstruction_uxtah_eq_r10_r10_r5[] = {
  0x75, 0xa0, 0xfa, 0x06 // uxtah eq r10 r10 r5
};
const byte kInstruction_uxtah_ge_r10_r14_r0[] = {
  0x70, 0xa0, 0xfe, 0xa6 // uxtah ge r10 r14 r0
};
const byte kInstruction_uxtah_lt_r3_r3_r2[] = {
  0x72, 0x30, 0xf3, 0xb6 // uxtah lt r3 r3 r2
};
const byte kInstruction_uxtah_vs_r2_r13_r2[] = {
  0x72, 0x20, 0xfd, 0x66 // uxtah vs r2 r13 r2
};
const byte kInstruction_uxtah_ls_r6_r2_r12[] = {
  0x7c, 0x60, 0xf2, 0x96 // uxtah ls r6 r2 r12
};
const byte kInstruction_uxtah_gt_r5_r11_r12[] = {
  0x7c, 0x50, 0xfb, 0xc6 // uxtah gt r5 r11 r12
};
const byte kInstruction_uxtah_al_r11_r10_r6[] = {
  0x76, 0xb0, 0xfa, 0xe6 // uxtah al r11 r10 r6
};
const byte kInstruction_uxtah_hi_r12_r14_r14[] = {
  0x7e, 0xc0, 0xfe, 0x86 // uxtah hi r12 r14 r14
};
const byte kInstruction_uxtah_ge_r12_r10_r6[] = {
  0x76, 0xc0, 0xfa, 0xa6 // uxtah ge r12 r10 r6
};
const byte kInstruction_uxtah_eq_r8_r3_r9[] = {
  0x79, 0x80, 0xf3, 0x06 // uxtah eq r8 r3 r9
};
const byte kInstruction_uxtah_cc_r7_r5_r1[] = {
  0x71, 0x70, 0xf5, 0x36 // uxtah cc r7 r5 r1
};
const byte kInstruction_uxtah_lt_r3_r0_r6[] = {
  0x76, 0x30, 0xf0, 0xb6 // uxtah lt r3 r0 r6
};
const byte kInstruction_uxtah_le_r14_r4_r12[] = {
  0x7c, 0xe0, 0xf4, 0xd6 // uxtah le r14 r4 r12
};
const byte kInstruction_uxtah_le_r9_r6_r4[] = {
  0x74, 0x90, 0xf6, 0xd6 // uxtah le r9 r6 r4
};
const byte kInstruction_uxtah_hi_r6_r11_r0[] = {
  0x70, 0x60, 0xfb, 0x86 // uxtah hi r6 r11 r0
};
const byte kInstruction_uxtah_al_r3_r7_r6[] = {
  0x76, 0x30, 0xf7, 0xe6 // uxtah al r3 r7 r6
};
const byte kInstruction_uxtah_lt_r10_r9_r12[] = {
  0x7c, 0xa0, 0xf9, 0xb6 // uxtah lt r10 r9 r12
};
const byte kInstruction_uxtah_al_r14_r8_r4[] = {
  0x74, 0xe0, 0xf8, 0xe6 // uxtah al r14 r8 r4
};
const byte kInstruction_uxtah_le_r14_r11_r14[] = {
  0x7e, 0xe0, 0xfb, 0xd6 // uxtah le r14 r11 r14
};
const byte kInstruction_uxtah_al_r14_r13_r8[] = {
  0x78, 0xe0, 0xfd, 0xe6 // uxtah al r14 r13 r8
};
const byte kInstruction_uxtah_ge_r5_r9_r10[] = {
  0x7a, 0x50, 0xf9, 0xa6 // uxtah ge r5 r9 r10
};
const byte kInstruction_uxtah_eq_r1_r9_r4[] = {
  0x74, 0x10, 0xf9, 0x06 // uxtah eq r1 r9 r4
};
const byte kInstruction_uxtah_cc_r5_r13_r8[] = {
  0x78, 0x50, 0xfd, 0x36 // uxtah cc r5 r13 r8
};
const byte kInstruction_uxtah_ne_r10_r0_r14[] = {
  0x7e, 0xa0, 0xf0, 0x16 // uxtah ne r10 r0 r14
};
const byte kInstruction_uxtah_al_r2_r0_r10[] = {
  0x7a, 0x20, 0xf0, 0xe6 // uxtah al r2 r0 r10
};
const byte kInstruction_uxtah_pl_r4_r0_r11[] = {
  0x7b, 0x40, 0xf0, 0x56 // uxtah pl r4 r0 r11
};
const byte kInstruction_uxtah_gt_r13_r5_r12[] = {
  0x7c, 0xd0, 0xf5, 0xc6 // uxtah gt r13 r5 r12
};
const byte kInstruction_uxtah_al_r2_r13_r8[] = {
  0x78, 0x20, 0xfd, 0xe6 // uxtah al r2 r13 r8
};
const byte kInstruction_uxtah_mi_r11_r3_r4[] = {
  0x74, 0xb0, 0xf3, 0x46 // uxtah mi r11 r3 r4
};
const byte kInstruction_uxtah_le_r11_r8_r1[] = {
  0x71, 0xb0, 0xf8, 0xd6 // uxtah le r11 r8 r1
};
const byte kInstruction_uxtah_hi_r12_r11_r1[] = {
  0x71, 0xc0, 0xfb, 0x86 // uxtah hi r12 r11 r1
};
const byte kInstruction_uxtah_ls_r6_r7_r2[] = {
  0x72, 0x60, 0xf7, 0x96 // uxtah ls r6 r7 r2
};
const byte kInstruction_uxtah_cs_r7_r11_r2[] = {
  0x72, 0x70, 0xfb, 0x26 // uxtah cs r7 r11 r2
};
const byte kInstruction_uxtah_vc_r11_r13_r7[] = {
  0x77, 0xb0, 0xfd, 0x76 // uxtah vc r11 r13 r7
};
const byte kInstruction_uxtah_cs_r13_r0_r1[] = {
  0x71, 0xd0, 0xf0, 0x26 // uxtah cs r13 r0 r1
};
const byte kInstruction_uxtah_cc_r5_r4_r6[] = {
  0x76, 0x50, 0xf4, 0x36 // uxtah cc r5 r4 r6
};
const byte kInstruction_uxtah_gt_r4_r4_r13[] = {
  0x7d, 0x40, 0xf4, 0xc6 // uxtah gt r4 r4 r13
};
const byte kInstruction_uxtah_al_r14_r8_r2[] = {
  0x72, 0xe0, 0xf8, 0xe6 // uxtah al r14 r8 r2
};
const TestResult kReferenceuxtah[] = {
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r4_r5_r14),
    kInstruction_uxtah_le_r4_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r5_r11_r10),
    kInstruction_uxtah_ge_r5_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r0_r9_r9),
    kInstruction_uxtah_ls_r0_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r8_r7_r2),
    kInstruction_uxtah_le_r8_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r1_r10_r13),
    kInstruction_uxtah_eq_r1_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r9_r12_r2),
    kInstruction_uxtah_le_r9_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r6_r1_r5),
    kInstruction_uxtah_pl_r6_r1_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r1_r12_r6),
    kInstruction_uxtah_ge_r1_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r13_r12_r3),
    kInstruction_uxtah_cc_r13_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r2_r4_r9),
    kInstruction_uxtah_gt_r2_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r3_r9_r10),
    kInstruction_uxtah_le_r3_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r11_r1_r9),
    kInstruction_uxtah_gt_r11_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r8_r6_r11),
    kInstruction_uxtah_cc_r8_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r12_r9_r3),
    kInstruction_uxtah_cs_r12_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r9_r14_r10),
    kInstruction_uxtah_eq_r9_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r9_r0_r1),
    kInstruction_uxtah_gt_r9_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r11_r8_r2),
    kInstruction_uxtah_pl_r11_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r7_r1_r2),
    kInstruction_uxtah_mi_r7_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r8_r6_r7),
    kInstruction_uxtah_vs_r8_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r14_r2_r13),
    kInstruction_uxtah_ne_r14_r2_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r3_r3_r8),
    kInstruction_uxtah_hi_r3_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r10_r8_r14),
    kInstruction_uxtah_vc_r10_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r2_r11_r0),
    kInstruction_uxtah_ls_r2_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r8_r10_r0),
    kInstruction_uxtah_ge_r8_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r8_r10_r5),
    kInstruction_uxtah_mi_r8_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r1_r0_r9),
    kInstruction_uxtah_pl_r1_r0_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r6_r7_r3),
    kInstruction_uxtah_gt_r6_r7_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r7_r9_r9),
    kInstruction_uxtah_vs_r7_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r9_r4_r2),
    kInstruction_uxtah_al_r9_r4_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r3_r1_r2),
    kInstruction_uxtah_le_r3_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r6_r14_r0),
    kInstruction_uxtah_mi_r6_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r7_r10_r11),
    kInstruction_uxtah_vc_r7_r10_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r13_r2_r10),
    kInstruction_uxtah_hi_r13_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r5_r4_r12),
    kInstruction_uxtah_cs_r5_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r13_r9_r11),
    kInstruction_uxtah_ls_r13_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r2_r10_r12),
    kInstruction_uxtah_ne_r2_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r4_r6_r8),
    kInstruction_uxtah_vc_r4_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r13_r0_r13),
    kInstruction_uxtah_lt_r13_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r11_r14_r5),
    kInstruction_uxtah_pl_r11_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r8_r11_r3),
    kInstruction_uxtah_cs_r8_r11_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r4_r1_r7),
    kInstruction_uxtah_cs_r4_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r0_r12_r13),
    kInstruction_uxtah_al_r0_r12_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r3_r6_r0),
    kInstruction_uxtah_gt_r3_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r6_r9_r0),
    kInstruction_uxtah_vc_r6_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r2_r2_r12),
    kInstruction_uxtah_cc_r2_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r4_r13_r1),
    kInstruction_uxtah_cs_r4_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r12_r12_r10),
    kInstruction_uxtah_mi_r12_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r8_r9_r14),
    kInstruction_uxtah_hi_r8_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r4_r3_r7),
    kInstruction_uxtah_hi_r4_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r11_r10_r1),
    kInstruction_uxtah_ne_r11_r10_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r2_r6_r3),
    kInstruction_uxtah_cc_r2_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r6_r6_r0),
    kInstruction_uxtah_cs_r6_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r13_r2_r9),
    kInstruction_uxtah_vc_r13_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r7_r13_r14),
    kInstruction_uxtah_vc_r7_r13_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r11_r14_r4),
    kInstruction_uxtah_pl_r11_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r12_r14_r8),
    kInstruction_uxtah_lt_r12_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r2_r11_r14),
    kInstruction_uxtah_cs_r2_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r12_r13_r2),
    kInstruction_uxtah_le_r12_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r5_r6_r14),
    kInstruction_uxtah_le_r5_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r3_r14_r8),
    kInstruction_uxtah_vc_r3_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r7_r6_r14),
    kInstruction_uxtah_lt_r7_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r0_r13_r12),
    kInstruction_uxtah_ls_r0_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r10_r9_r14),
    kInstruction_uxtah_ge_r10_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r11_r12_r1),
    kInstruction_uxtah_le_r11_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r2_r12_r14),
    kInstruction_uxtah_al_r2_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r6_r4_r0),
    kInstruction_uxtah_cs_r6_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r5_r0_r3),
    kInstruction_uxtah_vs_r5_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r8_r8_r0),
    kInstruction_uxtah_le_r8_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r1_r5_r4),
    kInstruction_uxtah_gt_r1_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r4_r3_r4),
    kInstruction_uxtah_le_r4_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r9_r7_r10),
    kInstruction_uxtah_pl_r9_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r8_r7_r14),
    kInstruction_uxtah_ls_r8_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r9_r10_r6),
    kInstruction_uxtah_vc_r9_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r2_r4_r9),
    kInstruction_uxtah_hi_r2_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r0_r2_r13),
    kInstruction_uxtah_cs_r0_r2_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r3_r6_r12),
    kInstruction_uxtah_vs_r3_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r14_r14_r7),
    kInstruction_uxtah_cc_r14_r14_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r10_r6_r4),
    kInstruction_uxtah_vc_r10_r6_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r1_r6_r10),
    kInstruction_uxtah_cc_r1_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r13_r10_r11),
    kInstruction_uxtah_vs_r13_r10_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r5_r7_r12),
    kInstruction_uxtah_ls_r5_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r6_r4_r3),
    kInstruction_uxtah_eq_r6_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r5_r9_r2),
    kInstruction_uxtah_mi_r5_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r7_r1_r9),
    kInstruction_uxtah_lt_r7_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r12_r7_r0),
    kInstruction_uxtah_ne_r12_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r0_r6_r7),
    kInstruction_uxtah_eq_r0_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r7_r3_r9),
    kInstruction_uxtah_pl_r7_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r11_r11_r13),
    kInstruction_uxtah_pl_r11_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r0_r10_r5),
    kInstruction_uxtah_gt_r0_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r14_r1_r10),
    kInstruction_uxtah_mi_r14_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r5_r14_r0),
    kInstruction_uxtah_mi_r5_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r12_r9_r13),
    kInstruction_uxtah_ne_r12_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r8_r5_r11),
    kInstruction_uxtah_hi_r8_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r7_r0_r5),
    kInstruction_uxtah_ls_r7_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r5_r1_r7),
    kInstruction_uxtah_lt_r5_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r2_r8_r4),
    kInstruction_uxtah_cc_r2_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r3_r0_r5),
    kInstruction_uxtah_lt_r3_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r4_r9_r7),
    kInstruction_uxtah_pl_r4_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r13_r8_r10),
    kInstruction_uxtah_eq_r13_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r6_r10_r10),
    kInstruction_uxtah_ge_r6_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r5_r5_r7),
    kInstruction_uxtah_lt_r5_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r6_r3_r9),
    kInstruction_uxtah_hi_r6_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r14_r12_r10),
    kInstruction_uxtah_hi_r14_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r9_r13_r14),
    kInstruction_uxtah_lt_r9_r13_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r0_r12_r7),
    kInstruction_uxtah_al_r0_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r14_r8_r11),
    kInstruction_uxtah_eq_r14_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r9_r11_r1),
    kInstruction_uxtah_ne_r9_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r5_r0_r3),
    kInstruction_uxtah_ge_r5_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r12_r0_r1),
    kInstruction_uxtah_pl_r12_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r13_r7_r11),
    kInstruction_uxtah_lt_r13_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r4_r6_r6),
    kInstruction_uxtah_eq_r4_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r1_r14_r0),
    kInstruction_uxtah_cs_r1_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r7_r7_r6),
    kInstruction_uxtah_hi_r7_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r1_r0_r3),
    kInstruction_uxtah_hi_r1_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r12_r2_r0),
    kInstruction_uxtah_pl_r12_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r3_r0_r3),
    kInstruction_uxtah_mi_r3_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r14_r4_r3),
    kInstruction_uxtah_al_r14_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r4_r2_r9),
    kInstruction_uxtah_vs_r4_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r1_r9_r12),
    kInstruction_uxtah_vs_r1_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r3_r6_r9),
    kInstruction_uxtah_vs_r3_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r4_r1_r8),
    kInstruction_uxtah_cc_r4_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r10_r11_r14),
    kInstruction_uxtah_ls_r10_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r11_r7_r2),
    kInstruction_uxtah_le_r11_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r6_r9_r14),
    kInstruction_uxtah_le_r6_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r1_r3_r11),
    kInstruction_uxtah_al_r1_r3_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r0_r2_r2),
    kInstruction_uxtah_lt_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r11_r6_r8),
    kInstruction_uxtah_eq_r11_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r7_r12_r5),
    kInstruction_uxtah_ls_r7_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r4_r11_r0),
    kInstruction_uxtah_vc_r4_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r7_r14_r2),
    kInstruction_uxtah_ls_r7_r14_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r7_r12_r1),
    kInstruction_uxtah_le_r7_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r1_r14_r13),
    kInstruction_uxtah_le_r1_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r11_r3_r9),
    kInstruction_uxtah_le_r11_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r14_r13_r1),
    kInstruction_uxtah_ne_r14_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r5_r1_r10),
    kInstruction_uxtah_ne_r5_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r7_r4_r3),
    kInstruction_uxtah_cc_r7_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r8_r1_r1),
    kInstruction_uxtah_lt_r8_r1_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r5_r0_r1),
    kInstruction_uxtah_al_r5_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r11_r13_r9),
    kInstruction_uxtah_ge_r11_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r5_r9_r5),
    kInstruction_uxtah_gt_r5_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r2_r8_r3),
    kInstruction_uxtah_cc_r2_r8_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r6_r6_r12),
    kInstruction_uxtah_eq_r6_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r3_r10_r13),
    kInstruction_uxtah_vc_r3_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r9_r13_r1),
    kInstruction_uxtah_vc_r9_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r7_r0_r0),
    kInstruction_uxtah_lt_r7_r0_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r6_r6_r1),
    kInstruction_uxtah_cc_r6_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r8_r1_r9),
    kInstruction_uxtah_mi_r8_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r14_r10_r10),
    kInstruction_uxtah_ls_r14_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r7_r13_r1),
    kInstruction_uxtah_ge_r7_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r0_r4_r3),
    kInstruction_uxtah_le_r0_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r12_r10_r10),
    kInstruction_uxtah_cc_r12_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r5_r0_r10),
    kInstruction_uxtah_ge_r5_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r8_r3_r10),
    kInstruction_uxtah_vs_r8_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r11_r12_r2),
    kInstruction_uxtah_ge_r11_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r14_r4_r8),
    kInstruction_uxtah_ne_r14_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r3_r0_r4),
    kInstruction_uxtah_mi_r3_r0_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r13_r9_r6),
    kInstruction_uxtah_gt_r13_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r1_r14_r2),
    kInstruction_uxtah_ls_r1_r14_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r11_r3_r12),
    kInstruction_uxtah_eq_r11_r3_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r4_r13_r4),
    kInstruction_uxtah_ge_r4_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r5_r9_r7),
    kInstruction_uxtah_al_r5_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r11_r9_r0),
    kInstruction_uxtah_le_r11_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r13_r10_r12),
    kInstruction_uxtah_mi_r13_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r5_r5_r10),
    kInstruction_uxtah_hi_r5_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r4_r6_r14),
    kInstruction_uxtah_ge_r4_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r5_r5_r7),
    kInstruction_uxtah_le_r5_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r12_r2_r8),
    kInstruction_uxtah_pl_r12_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r7_r8_r10),
    kInstruction_uxtah_al_r7_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r8_r11_r13),
    kInstruction_uxtah_vc_r8_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r14_r2_r12),
    kInstruction_uxtah_ne_r14_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r10_r4_r2),
    kInstruction_uxtah_eq_r10_r4_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r6_r2_r5),
    kInstruction_uxtah_al_r6_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r1_r6_r2),
    kInstruction_uxtah_al_r1_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r0_r7_r14),
    kInstruction_uxtah_vs_r0_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r9_r7_r0),
    kInstruction_uxtah_hi_r9_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r8_r11_r13),
    kInstruction_uxtah_ne_r8_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r9_r8_r12),
    kInstruction_uxtah_ne_r9_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r14_r8_r6),
    kInstruction_uxtah_al_r14_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r8_r0_r3),
    kInstruction_uxtah_vc_r8_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r11_r9_r0),
    kInstruction_uxtah_pl_r11_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r7_r9_r9),
    kInstruction_uxtah_al_r7_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r0_r8_r3),
    kInstruction_uxtah_ls_r0_r8_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r5_r13_r6),
    kInstruction_uxtah_lt_r5_r13_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r6_r5_r13),
    kInstruction_uxtah_ge_r6_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r11_r7_r3),
    kInstruction_uxtah_cs_r11_r7_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r8_r0_r6),
    kInstruction_uxtah_vs_r8_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r0_r12_r6),
    kInstruction_uxtah_hi_r0_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r14_r5_r12),
    kInstruction_uxtah_eq_r14_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r1_r4_r13),
    kInstruction_uxtah_lt_r1_r4_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r6_r4_r2),
    kInstruction_uxtah_hi_r6_r4_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r10_r10_r9),
    kInstruction_uxtah_lt_r10_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r14_r7_r4),
    kInstruction_uxtah_pl_r14_r7_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r8_r3_r4),
    kInstruction_uxtah_ge_r8_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r11_r1_r14),
    kInstruction_uxtah_al_r11_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r7_r8_r9),
    kInstruction_uxtah_ge_r7_r8_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r10_r10_r8),
    kInstruction_uxtah_le_r10_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r3_r3_r7),
    kInstruction_uxtah_hi_r3_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r3_r0_r14),
    kInstruction_uxtah_cc_r3_r0_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r8_r9_r1),
    kInstruction_uxtah_al_r8_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r6_r13_r7),
    kInstruction_uxtah_gt_r6_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r11_r3_r1),
    kInstruction_uxtah_ls_r11_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r14_r0_r13),
    kInstruction_uxtah_cc_r14_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r4_r4_r4),
    kInstruction_uxtah_gt_r4_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r8_r13_r1),
    kInstruction_uxtah_al_r8_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r8_r4_r6),
    kInstruction_uxtah_mi_r8_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r12_r7_r11),
    kInstruction_uxtah_vc_r12_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r0_r1_r0),
    kInstruction_uxtah_cs_r0_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r13_r14_r0),
    kInstruction_uxtah_cc_r13_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r4_r7_r11),
    kInstruction_uxtah_eq_r4_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r11_r2_r0),
    kInstruction_uxtah_ls_r11_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r10_r2_r3),
    kInstruction_uxtah_gt_r10_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r6_r1_r7),
    kInstruction_uxtah_al_r6_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r10_r13_r0),
    kInstruction_uxtah_cs_r10_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r11_r2_r6),
    kInstruction_uxtah_lt_r11_r2_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r4_r13_r6),
    kInstruction_uxtah_pl_r4_r13_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r3_r0_r9),
    kInstruction_uxtah_cs_r3_r0_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r4_r6_r14),
    kInstruction_uxtah_gt_r4_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r6_r8_r0),
    kInstruction_uxtah_eq_r6_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r5_r5_r2),
    kInstruction_uxtah_cc_r5_r5_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r9_r3_r7),
    kInstruction_uxtah_al_r9_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r12_r0_r8),
    kInstruction_uxtah_cc_r12_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r4_r1_r7),
    kInstruction_uxtah_le_r4_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r3_r12_r7),
    kInstruction_uxtah_gt_r3_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r4_r3_r14),
    kInstruction_uxtah_vc_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r0_r7_r10),
    kInstruction_uxtah_le_r0_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r14_r8_r13),
    kInstruction_uxtah_vs_r14_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r9_r0_r11),
    kInstruction_uxtah_hi_r9_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r8_r13_r0),
    kInstruction_uxtah_eq_r8_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r10_r9_r2),
    kInstruction_uxtah_vc_r10_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r0_r13_r10),
    kInstruction_uxtah_al_r0_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r5_r4_r6),
    kInstruction_uxtah_ne_r5_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r7_r13_r1),
    kInstruction_uxtah_cc_r7_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r1_r14_r11),
    kInstruction_uxtah_lt_r1_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r13_r10_r14),
    kInstruction_uxtah_vc_r13_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r3_r0_r4),
    kInstruction_uxtah_le_r3_r0_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r11_r4_r5),
    kInstruction_uxtah_al_r11_r4_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r0_r8_r8),
    kInstruction_uxtah_lt_r0_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r13_r12_r7),
    kInstruction_uxtah_al_r13_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r12_r13_r13),
    kInstruction_uxtah_ls_r12_r13_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r8_r2_r9),
    kInstruction_uxtah_vc_r8_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r14_r9_r3),
    kInstruction_uxtah_ne_r14_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r12_r11_r6),
    kInstruction_uxtah_pl_r12_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r0_r3_r5),
    kInstruction_uxtah_eq_r0_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r11_r3_r14),
    kInstruction_uxtah_hi_r11_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r3_r7_r4),
    kInstruction_uxtah_le_r3_r7_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r6_r9_r8),
    kInstruction_uxtah_ne_r6_r9_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r11_r11_r11),
    kInstruction_uxtah_vc_r11_r11_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r3_r1_r10),
    kInstruction_uxtah_ge_r3_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r5_r14_r13),
    kInstruction_uxtah_gt_r5_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r7_r0_r13),
    kInstruction_uxtah_le_r7_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r8_r5_r1),
    kInstruction_uxtah_lt_r8_r5_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r3_r4_r8),
    kInstruction_uxtah_le_r3_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r5_r11_r13),
    kInstruction_uxtah_ne_r5_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r9_r8_r2),
    kInstruction_uxtah_ge_r9_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r9_r5_r12),
    kInstruction_uxtah_gt_r9_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r9_r8_r1),
    kInstruction_uxtah_pl_r9_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r3_r12_r4),
    kInstruction_uxtah_le_r3_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r5_r6_r9),
    kInstruction_uxtah_eq_r5_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r14_r4_r13),
    kInstruction_uxtah_ne_r14_r4_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r3_r9_r2),
    kInstruction_uxtah_ge_r3_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r13_r0_r10),
    kInstruction_uxtah_ls_r13_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r14_r0_r2),
    kInstruction_uxtah_mi_r14_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r11_r1_r3),
    kInstruction_uxtah_cs_r11_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r8_r9_r10),
    kInstruction_uxtah_ne_r8_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r9_r10_r4),
    kInstruction_uxtah_gt_r9_r10_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r2_r8_r4),
    kInstruction_uxtah_le_r2_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r6_r14_r11),
    kInstruction_uxtah_al_r6_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r3_r14_r14),
    kInstruction_uxtah_eq_r3_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r9_r9_r3),
    kInstruction_uxtah_pl_r9_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r5_r13_r12),
    kInstruction_uxtah_ge_r5_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r10_r6_r5),
    kInstruction_uxtah_mi_r10_r6_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r14_r13_r12),
    kInstruction_uxtah_ls_r14_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r10_r9_r10),
    kInstruction_uxtah_lt_r10_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r7_r4_r9),
    kInstruction_uxtah_ls_r7_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r9_r10_r7),
    kInstruction_uxtah_cs_r9_r10_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r4_r2_r2),
    kInstruction_uxtah_eq_r4_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r14_r13_r4),
    kInstruction_uxtah_lt_r14_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r0_r3_r5),
    kInstruction_uxtah_al_r0_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r9_r6_r7),
    kInstruction_uxtah_vs_r9_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r0_r6_r4),
    kInstruction_uxtah_ls_r0_r6_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r7_r10_r14),
    kInstruction_uxtah_ne_r7_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r2_r12_r1),
    kInstruction_uxtah_le_r2_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r1_r5_r0),
    kInstruction_uxtah_cs_r1_r5_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r0_r9_r1),
    kInstruction_uxtah_pl_r0_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r2_r2_r5),
    kInstruction_uxtah_mi_r2_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r5_r1_r12),
    kInstruction_uxtah_hi_r5_r1_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r13_r14_r7),
    kInstruction_uxtah_ls_r13_r14_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r0_r4_r3),
    kInstruction_uxtah_lt_r0_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r8_r13_r2),
    kInstruction_uxtah_cc_r8_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r7_r8_r14),
    kInstruction_uxtah_ls_r7_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r13_r11_r13),
    kInstruction_uxtah_hi_r13_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r13_r7_r6),
    kInstruction_uxtah_ge_r13_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r3_r2_r0),
    kInstruction_uxtah_mi_r3_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r12_r0_r10),
    kInstruction_uxtah_cs_r12_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r9_r10_r8),
    kInstruction_uxtah_vs_r9_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r2_r8_r8),
    kInstruction_uxtah_ls_r2_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r1_r11_r3),
    kInstruction_uxtah_ge_r1_r11_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r12_r3_r3),
    kInstruction_uxtah_ge_r12_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r3_r8_r6),
    kInstruction_uxtah_gt_r3_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r13_r2_r9),
    kInstruction_uxtah_ne_r13_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r14_r9_r1),
    kInstruction_uxtah_ls_r14_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r2_r10_r2),
    kInstruction_uxtah_cc_r2_r10_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r9_r12_r1),
    kInstruction_uxtah_le_r9_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r11_r10_r0),
    kInstruction_uxtah_cs_r11_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r7_r0_r5),
    kInstruction_uxtah_eq_r7_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r10_r4_r4),
    kInstruction_uxtah_ne_r10_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r13_r9_r6),
    kInstruction_uxtah_pl_r13_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r11_r3_r3),
    kInstruction_uxtah_vc_r11_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r1_r13_r9),
    kInstruction_uxtah_al_r1_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r13_r9_r14),
    kInstruction_uxtah_cc_r13_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r5_r2_r3),
    kInstruction_uxtah_vc_r5_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r12_r8_r10),
    kInstruction_uxtah_ne_r12_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r11_r13_r6),
    kInstruction_uxtah_cs_r11_r13_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r1_r11_r10),
    kInstruction_uxtah_al_r1_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r14_r6_r11),
    kInstruction_uxtah_ne_r14_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r1_r14_r5),
    kInstruction_uxtah_cs_r1_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r11_r11_r6),
    kInstruction_uxtah_al_r11_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r3_r6_r2),
    kInstruction_uxtah_pl_r3_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r3_r9_r4),
    kInstruction_uxtah_ne_r3_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r11_r4_r9),
    kInstruction_uxtah_mi_r11_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r10_r1_r3),
    kInstruction_uxtah_al_r10_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r2_r14_r11),
    kInstruction_uxtah_vc_r2_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r9_r3_r0),
    kInstruction_uxtah_mi_r9_r3_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r9_r8_r1),
    kInstruction_uxtah_vs_r9_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r2_r12_r5),
    kInstruction_uxtah_lt_r2_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r9_r8_r12),
    kInstruction_uxtah_al_r9_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r3_r8_r0),
    kInstruction_uxtah_vc_r3_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r10_r5_r1),
    kInstruction_uxtah_mi_r10_r5_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r7_r14_r2),
    kInstruction_uxtah_vc_r7_r14_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r0_r9_r7),
    kInstruction_uxtah_ls_r0_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r3_r0_r10),
    kInstruction_uxtah_cs_r3_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r10_r8_r10),
    kInstruction_uxtah_cc_r10_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r5_r4_r1),
    kInstruction_uxtah_eq_r5_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r11_r13_r1),
    kInstruction_uxtah_vc_r11_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r6_r5_r8),
    kInstruction_uxtah_hi_r6_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r10_r5_r6),
    kInstruction_uxtah_ne_r10_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r10_r12_r9),
    kInstruction_uxtah_al_r10_r12_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r5_r1_r12),
    kInstruction_uxtah_eq_r5_r1_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r0_r14_r10),
    kInstruction_uxtah_le_r0_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r4_r2_r5),
    kInstruction_uxtah_eq_r4_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r5_r8_r2),
    kInstruction_uxtah_pl_r5_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r5_r14_r4),
    kInstruction_uxtah_hi_r5_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r2_r7_r9),
    kInstruction_uxtah_le_r2_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r5_r12_r6),
    kInstruction_uxtah_pl_r5_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r11_r4_r14),
    kInstruction_uxtah_vs_r11_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r0_r7_r14),
    kInstruction_uxtah_eq_r0_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r5_r2_r5),
    kInstruction_uxtah_pl_r5_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r5_r11_r7),
    kInstruction_uxtah_ne_r5_r11_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r7_r9_r10),
    kInstruction_uxtah_pl_r7_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r4_r2_r2),
    kInstruction_uxtah_hi_r4_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r14_r9_r2),
    kInstruction_uxtah_pl_r14_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r4_r11_r13),
    kInstruction_uxtah_le_r4_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r8_r8_r8),
    kInstruction_uxtah_pl_r8_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r0_r6_r10),
    kInstruction_uxtah_ge_r0_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r4_r4_r10),
    kInstruction_uxtah_vc_r4_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r11_r9_r12),
    kInstruction_uxtah_cc_r11_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r14_r4_r12),
    kInstruction_uxtah_pl_r14_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r8_r8_r8),
    kInstruction_uxtah_vs_r8_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r14_r2_r12),
    kInstruction_uxtah_ge_r14_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r8_r2_r13),
    kInstruction_uxtah_ge_r8_r2_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r10_r0_r11),
    kInstruction_uxtah_vs_r10_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r5_r1_r2),
    kInstruction_uxtah_eq_r5_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r10_r11_r3),
    kInstruction_uxtah_vs_r10_r11_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r13_r13_r7),
    kInstruction_uxtah_lt_r13_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r12_r7_r6),
    kInstruction_uxtah_le_r12_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r4_r3_r3),
    kInstruction_uxtah_eq_r4_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r0_r5_r8),
    kInstruction_uxtah_pl_r0_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r10_r5_r3),
    kInstruction_uxtah_vs_r10_r5_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r0_r11_r9),
    kInstruction_uxtah_gt_r0_r11_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r8_r5_r9),
    kInstruction_uxtah_cc_r8_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r9_r12_r11),
    kInstruction_uxtah_cs_r9_r12_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r3_r4_r8),
    kInstruction_uxtah_gt_r3_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r8_r3_r10),
    kInstruction_uxtah_ls_r8_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r8_r14_r12),
    kInstruction_uxtah_eq_r8_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r7_r1_r3),
    kInstruction_uxtah_gt_r7_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r4_r4_r8),
    kInstruction_uxtah_al_r4_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r9_r14_r10),
    kInstruction_uxtah_gt_r9_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r3_r13_r2),
    kInstruction_uxtah_lt_r3_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r4_r11_r14),
    kInstruction_uxtah_le_r4_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r2_r14_r0),
    kInstruction_uxtah_ge_r2_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r1_r8_r8),
    kInstruction_uxtah_pl_r1_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r9_r2_r5),
    kInstruction_uxtah_pl_r9_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r13_r13_r1),
    kInstruction_uxtah_vs_r13_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r12_r14_r3),
    kInstruction_uxtah_ge_r12_r14_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r0_r11_r4),
    kInstruction_uxtah_vc_r0_r11_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r0_r2_r9),
    kInstruction_uxtah_ge_r0_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r12_r1_r6),
    kInstruction_uxtah_vc_r12_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r1_r3_r7),
    kInstruction_uxtah_ne_r1_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r10_r3_r9),
    kInstruction_uxtah_vs_r10_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r14_r4_r1),
    kInstruction_uxtah_cc_r14_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r9_r3_r7),
    kInstruction_uxtah_le_r9_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r1_r0_r14),
    kInstruction_uxtah_le_r1_r0_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r0_r14_r4),
    kInstruction_uxtah_le_r0_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r13_r8_r11),
    kInstruction_uxtah_hi_r13_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r10_r6_r11),
    kInstruction_uxtah_cc_r10_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r0_r10_r14),
    kInstruction_uxtah_cc_r0_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r4_r4_r0),
    kInstruction_uxtah_le_r4_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r8_r14_r12),
    kInstruction_uxtah_pl_r8_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r13_r12_r2),
    kInstruction_uxtah_ge_r13_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r11_r11_r7),
    kInstruction_uxtah_al_r11_r11_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r11_r12_r1),
    kInstruction_uxtah_ls_r11_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r10_r14_r14),
    kInstruction_uxtah_vs_r10_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r2_r8_r12),
    kInstruction_uxtah_pl_r2_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r12_r7_r11),
    kInstruction_uxtah_pl_r12_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r5_r8_r13),
    kInstruction_uxtah_eq_r5_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r6_r6_r6),
    kInstruction_uxtah_vc_r6_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r0_r12_r1),
    kInstruction_uxtah_vs_r0_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r6_r0_r8),
    kInstruction_uxtah_cs_r6_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r3_r4_r1),
    kInstruction_uxtah_cc_r3_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r1_r10_r14),
    kInstruction_uxtah_lt_r1_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r1_r3_r5),
    kInstruction_uxtah_le_r1_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r11_r1_r1),
    kInstruction_uxtah_cc_r11_r1_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r1_r8_r7),
    kInstruction_uxtah_vc_r1_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r3_r10_r13),
    kInstruction_uxtah_eq_r3_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r14_r12_r12),
    kInstruction_uxtah_hi_r14_r12_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r10_r1_r14),
    kInstruction_uxtah_eq_r10_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r3_r1_r6),
    kInstruction_uxtah_lt_r3_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r9_r12_r10),
    kInstruction_uxtah_cc_r9_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r13_r14_r14),
    kInstruction_uxtah_lt_r13_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r2_r6_r9),
    kInstruction_uxtah_ge_r2_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r3_r9_r1),
    kInstruction_uxtah_vs_r3_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r1_r9_r12),
    kInstruction_uxtah_cc_r1_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r5_r0_r6),
    kInstruction_uxtah_ls_r5_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r6_r14_r10),
    kInstruction_uxtah_hi_r6_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r11_r10_r3),
    kInstruction_uxtah_al_r11_r10_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r13_r4_r1),
    kInstruction_uxtah_ne_r13_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r13_r5_r14),
    kInstruction_uxtah_hi_r13_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r8_r9_r11),
    kInstruction_uxtah_ne_r8_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r0_r13_r13),
    kInstruction_uxtah_eq_r0_r13_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r14_r11_r0),
    kInstruction_uxtah_ne_r14_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r6_r8_r7),
    kInstruction_uxtah_mi_r6_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r1_r7_r5),
    kInstruction_uxtah_eq_r1_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r12_r9_r12),
    kInstruction_uxtah_pl_r12_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r4_r5_r14),
    kInstruction_uxtah_al_r4_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r7_r0_r12),
    kInstruction_uxtah_pl_r7_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r5_r0_r13),
    kInstruction_uxtah_mi_r5_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r10_r7_r11),
    kInstruction_uxtah_al_r10_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r2_r10_r0),
    kInstruction_uxtah_gt_r2_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r11_r11_r8),
    kInstruction_uxtah_ge_r11_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r14_r7_r3),
    kInstruction_uxtah_eq_r14_r7_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r0_r12_r4),
    kInstruction_uxtah_ls_r0_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r10_r1_r7),
    kInstruction_uxtah_ne_r10_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r14_r3_r13),
    kInstruction_uxtah_hi_r14_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r1_r5_r12),
    kInstruction_uxtah_le_r1_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r8_r5_r11),
    kInstruction_uxtah_ne_r8_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r5_r13_r0),
    kInstruction_uxtah_le_r5_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r8_r12_r7),
    kInstruction_uxtah_gt_r8_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r9_r14_r3),
    kInstruction_uxtah_eq_r9_r14_r3,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r10_r9_r9),
    kInstruction_uxtah_cs_r10_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r5_r13_r8),
    kInstruction_uxtah_vc_r5_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r4_r1_r8),
    kInstruction_uxtah_eq_r4_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r12_r14_r9),
    kInstruction_uxtah_lt_r12_r14_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r8_r8_r0),
    kInstruction_uxtah_cc_r8_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r0_r14_r12),
    kInstruction_uxtah_hi_r0_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r4_r1_r10),
    kInstruction_uxtah_hi_r4_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r2_r14_r12),
    kInstruction_uxtah_gt_r2_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r1_r8_r14),
    kInstruction_uxtah_vs_r1_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r4_r1_r6),
    kInstruction_uxtah_cs_r4_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r7_r8_r7),
    kInstruction_uxtah_hi_r7_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r3_r11_r8),
    kInstruction_uxtah_hi_r3_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r1_r12_r9),
    kInstruction_uxtah_lt_r1_r12_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r13_r4_r12),
    kInstruction_uxtah_cs_r13_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r10_r10_r5),
    kInstruction_uxtah_eq_r10_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r10_r14_r0),
    kInstruction_uxtah_ge_r10_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r3_r3_r2),
    kInstruction_uxtah_lt_r3_r3_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vs_r2_r13_r2),
    kInstruction_uxtah_vs_r2_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r6_r2_r12),
    kInstruction_uxtah_ls_r6_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r5_r11_r12),
    kInstruction_uxtah_gt_r5_r11_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r11_r10_r6),
    kInstruction_uxtah_al_r11_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r12_r14_r14),
    kInstruction_uxtah_hi_r12_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r12_r10_r6),
    kInstruction_uxtah_ge_r12_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r8_r3_r9),
    kInstruction_uxtah_eq_r8_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r7_r5_r1),
    kInstruction_uxtah_cc_r7_r5_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r3_r0_r6),
    kInstruction_uxtah_lt_r3_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r14_r4_r12),
    kInstruction_uxtah_le_r14_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r9_r6_r4),
    kInstruction_uxtah_le_r9_r6_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r6_r11_r0),
    kInstruction_uxtah_hi_r6_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r3_r7_r6),
    kInstruction_uxtah_al_r3_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_lt_r10_r9_r12),
    kInstruction_uxtah_lt_r10_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r14_r8_r4),
    kInstruction_uxtah_al_r14_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r14_r11_r14),
    kInstruction_uxtah_le_r14_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r14_r13_r8),
    kInstruction_uxtah_al_r14_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ge_r5_r9_r10),
    kInstruction_uxtah_ge_r5_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_eq_r1_r9_r4),
    kInstruction_uxtah_eq_r1_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r5_r13_r8),
    kInstruction_uxtah_cc_r5_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ne_r10_r0_r14),
    kInstruction_uxtah_ne_r10_r0_r14,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r2_r0_r10),
    kInstruction_uxtah_al_r2_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_pl_r4_r0_r11),
    kInstruction_uxtah_pl_r4_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r13_r5_r12),
    kInstruction_uxtah_gt_r13_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r2_r13_r8),
    kInstruction_uxtah_al_r2_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_mi_r11_r3_r4),
    kInstruction_uxtah_mi_r11_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_le_r11_r8_r1),
    kInstruction_uxtah_le_r11_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_hi_r12_r11_r1),
    kInstruction_uxtah_hi_r12_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_ls_r6_r7_r2),
    kInstruction_uxtah_ls_r6_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r7_r11_r2),
    kInstruction_uxtah_cs_r7_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_vc_r11_r13_r7),
    kInstruction_uxtah_vc_r11_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cs_r13_r0_r1),
    kInstruction_uxtah_cs_r13_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_cc_r5_r4_r6),
    kInstruction_uxtah_cc_r5_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_gt_r4_r4_r13),
    kInstruction_uxtah_gt_r4_r4_r13,
  },
  {
    ARRAY_SIZE(kInstruction_uxtah_al_r14_r8_r2),
    kInstruction_uxtah_al_r14_r8_r2,
  },
};

#endif  // VIXL_ASSEMBLER_COND_RD_RN_OPERAND_RM_UXTAH_A32_H_
