# Announce: Rakudo compiler, Release #164 (2023.09)

On behalf of the Rakudo development team, I’m very happy to announce the
September 2023 release of Rakudo #164. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2023.09:

+ Improvements:
    * Work on 6.e PseudoStash clarification [6f6951c0][5d1198e7][4b9679a9]
      [7d1e8b8b][1b9a434a][f3d97602][9e298840]
    + Make .combinations about 32% faster [f09fa022][695b9dc4]
    + Make .permutations about 20% faster [e41e823c]

+ Additions:
    + Introduce Operator class, subclass of Sub [fc8bf7c0][73d02cc0][70944f73]
    + Introduce X::QuoteWords::Missing::Closer class [b245dcbb][1eb3db77]

+ Fixes:
    + Fix setting operator properties on some operators («>» and «<» and
      friends) [7f6f2512]
    + Provide a workaround for macOS Security Integrity Protection [402bcb8e]
    + Fix JVM build [1227b407]

+ Removals:
    + Remove Test.is_approx [e958040c]

+ Internal:
    + Use new stat syscalls [e258c2cf][64eb3e17][79784420][56294538][57e658c4]
      [4597e20d][a7f368c8]
    + Remove superfluous "is equiv" [92758cc5]
    + Remove "is equiv", it isn't necessary with OperatorProperties [50a4f690]
    + Move operator related trait_mods to much later in the setting [3937c862]
    + Handle operator traits with string better [16595e84]
    + Make sure OperatorProperties are set on new 6.e operators [c9eb5953]
    + Remove unused attribute in Iterator [ec207675]
    + Rename all .pm6 files to .rakumod [81d2aa6f]
    + Make X::Worry::P5::LeadingZero exception more readable [a369b57f]
    + Streamline Routine.gist [5ed482e0]

+ RakuAST Development:
    + A lot of work was done on RakuAST development (over 230 commits), raising
      the number of passing spectest files from 938 to 953 (out of 1358).

      [8be7bfe2][e6bc6878][81446212][4a4be8de][76308eb5][c509e758][ce29ccda]
      [042e1e4d][be6428ba][eec42c77][5aeeb39d][e0b7e831][1380fa3b][ba9f4050]
      [e6fdb853][168a67ff][cefa085c][ad4c580d][66414c04][b248ae12][e7df63a4]
      [4b2c4072][48838af4][ea40e4c6][def3a4ad][d3b53807][fc9debac][c4674f70]
      [c21f4b6b][ceb3d407][978e2d78][61097bd1][74cd925b][3777e2db][4c3d0ede]
      [c08ebbee][960a40dd][abc13a3c][f723f72c][d86cc550][6574c0e4][cc19095e]
      [1c47bb26][056bf03f][3ed02c34][1a33df17][646d548e][a0936a7e][37283cd6]
      [4db885c4][491b8469][b1560d3a][5b8f98b9][bda2be54][bc9a7123][e0975a5a]
      [743c4252][6605c0a8][238fa003][066d1d95][a6cbf201][b5e9f6fe][57b92f07]
      [f3da4c1f][89912801][66506c79][0395c7bb][29f3826a][c82791b0][1d785551]
      [5d43ff5b][8797bf95][fac51f9a][cb0f4ec2][ab613324][008b73de][f3215d05]
      [d33af758][c0667de0][ea12dec9][98312dcb][2a331f1f][c38af03b][24c05ee0]
      [4fd34508][eb3f30f4][48ae9919][562926fc][137ff2b9][32cddc56][abbbdd01]
      [f5e3bc94][e08eadf6][8dc2e53e][2b36f85f][c7338f96][e8076ae4][c035db23]
      [95dbd6cd][310e40da][51b0afc4][5fe1bd82][ee170b9f][5841afb2][1626cbfb]
      [76ad99d4][6da14def][e337c823][e026c1b0][65789659][6fa642c6][c19e7a1c]
      [4b09c649][c821ffeb][5e10f295][b60812ea][68070835][84419efb][c978bf21]
      [8ec9ae8b][e0864b19][5667eaa7][700e5248][8ed9f681][ec4d75ca][628c71bd]
      [44ba0636][5881f0b9][577498bc][8631e3ab][3a70184a][be944af2][94eb0c34]
      [3a0b05d6][9fe819e7][fc5d02ad][d192c18c][6817b10b][7779b565][c5d36f2f]
      [6b331d9c][ca05e9fb][fe9ff1c6][73737c5b][f4c9f606][5ad51ca5][3e652d5f]
      [8938e551][b5fcda9f][daec7797][9311a720][cacefa6a][e41ffda4][4f13da10]
      [8832f11c][c4cd9af1][f4c228dc][f67797db][eb8fea81][9d711ea5][863373a6]
      [3a91b495][636c8789][42c2f5a7][50c2f86e][8d82622a][7004c563][2671792a]
      [ebd4c00e][a39765a6][1504fc2f][04ec9234][cfcf9fb3][f950ca13][97fac492]
      [66b6f788][bc16a7ac][cd32d6a3][381cf921][ae833884][7ebd9bb3][42a92611]
      [5d784a9c][1b6f5791][4c0ffe67][f05f7746][770ac47b][866e4310][ded9b37c]
      [6f73a9c2][0079b03b][6d3904d0][60ec27c6][40a94e23][97683f98][ef0aa2b6]
      [3e81831a][8c2062c2][cbfdaeec][f9de8160][b7a59287][d08c2f98][4d1ff732]
      [d6b2a465][cdc7c1d5][714f2f6d][783c7900][bc3cc07a][c716de92][e3f23896]
      [9da6db8f][1e797d64][cdcd9c58][c776e55a][19bd3089][35bdbbc6][44659105]
      [f4fc256b][d6fd0f60][65cc4b66][150488c1][65d84a4d][1702a8e2][b70ca769]
      [a1a658ab][c4511e4c][ebe8322a][6771c4ae][e46425c5][8e375870][f1c6261c]
      [9866e7a1][dba3b448]

The following people contributed to this release:

Elizabeth Mattijsen, Daniel Green, ab5tract, Justin DeVuyst, Will Coleda,
Tom Browder, Christian Bartolomäus, Márton Polgár, Nick Logan, Vadim Belman,
Jake Boeckerman, John Benediktsson, Leon Timmermans, Stefan Seifert,
habere-et-dispertire

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2023 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on Libera.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#165), is tentatively scheduled for 2023-10-19.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
