/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.TimeProjected;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;

public abstract class Player
implements TimeProjected {
    protected final ISkinParam skinParam;
    protected final TimingRuler ruler;
    private final boolean compact;
    private final Display title;
    protected int suggestedHeight;

    public Player(String title, ISkinParam skinParam, TimingRuler ruler, boolean compact) {
        this.skinParam = skinParam;
        this.compact = compact;
        this.ruler = ruler;
        this.title = Display.getWithNewlines(title);
    }

    public boolean isCompact() {
        return this.compact;
    }

    protected final FontConfiguration getFontConfiguration() {
        return new FontConfiguration(this.skinParam, FontParam.TIMING, null);
    }

    protected final TextBlock getTitle() {
        return this.title.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    public abstract void addNote(TimeTick var1, Display var2, Position var3);

    public abstract void defineState(String var1, String var2);

    public abstract void setState(TimeTick var1, String var2, Colors var3, String ... var4);

    public abstract void createConstraint(TimeTick var1, TimeTick var2, String var3);

    public abstract TextBlock getPart1(double var1, double var3);

    public abstract UDrawable getPart2();

    public abstract double getFullHeight(StringBounder var1);

    public final void setHeight(int height) {
        this.suggestedHeight = height;
    }
}

