// Reconcile DEP-5 debian/copyright to licensecheck
//
// Copyright : 2023-2025 P Blackman
// License   : BSD-2-clause
//

program lrc;
{$mode delphi}
{$linklib c}

Uses cmem, SysUtils, rstrings, gettext, exclude, dep5,
    options, loadsourcefiles, licensechecking, compare;


begin
    TranslateResourcestrings('/usr/share/lrc/i18n/%s.mo');
    GetOptions;

    if Option_Help then
        ShowHelp
    else
    if Option_Version then
        ShowVersions
    else
    if not FileExists ('debian/copyright') then
    begin
        Writeln (rsCff + '; debian/copyright');
        Writeln;
        ShowHelp;
        Halt (1);
    end
    else
    begin
        if not Option_Format then
            ShowVersions;

        LoadSource;

        if CopyRightFile then // Parse debian/copyright
        begin
            LoadExcludes;     // Load exclusions from usr/share & debian/
            LicenseCheck;     // Get licenses from licensecheck
            CompareLicenses;  // Do the check
        end
        else
            Halt (1);
    end;
end.
