use super::*;

pub fn get_scenarios() -> Vec<Scenario> {
    vec![
        Scenario::new("no-sources", 1, 0, vec![], vec![]),
        Scenario::new("no-resources", 1, 0, vec![vec![true]], vec![]),
        Scenario::new("no-keys", 0, 1, vec![], vec![]),
        Scenario::new(
            "one-res-two-sources",
            1,
            2,
            vec![vec![true, true]],
            vec![vec![0], vec![1]],
        ),
        Scenario::new(
            "two-res-two-sources",
            2,
            2,
            vec![vec![false, true], vec![true, false]],
            vec![vec![1, 0]],
        ),
        Scenario::new(
            "small",
            3,
            2,
            vec![vec![true, true], vec![true, true], vec![true, true]],
            vec![
                vec![0, 0, 0],
                vec![0, 0, 1],
                vec![0, 1, 0],
                vec![0, 1, 1],
                vec![1, 0, 0],
                vec![1, 0, 1],
                vec![1, 1, 0],
                vec![1, 1, 1],
            ],
        ),
        Scenario::new(
            "incomplete",
            3,
            2,
            vec![vec![true, false], vec![false, true], vec![true, true]],
            vec![vec![0, 1, 0], vec![0, 1, 1]],
        ),
        Scenario::new(
            "preferences",
            19,
            2,
            vec![
                vec![true, false],
                vec![true, false],
                vec![true, false],
                vec![true, false],
                vec![true, false],
                vec![true, false],
                vec![true, false],
                vec![true, false],
                vec![true, false],
                vec![true, false],
                vec![true, false],
                vec![true, false],
                vec![true, false],
                vec![true, false],
                vec![true, false],
                vec![true, false],
                vec![false, true],
                vec![false, true],
                vec![false, true],
            ],
            vec![vec![
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
            ]],
        ),
        Scenario::new(
            "langpack",
            3,
            4,
            vec![
                vec![true, true, true, true],
                vec![true, true, true, true],
                vec![true, true, true, true],
            ],
            vec![
                vec![0, 0, 0],
                vec![0, 0, 1],
                vec![0, 0, 2],
                vec![0, 0, 3],
                vec![0, 1, 0],
                vec![0, 1, 1],
                vec![0, 1, 2],
                vec![0, 1, 3],
                vec![0, 2, 0],
                vec![0, 2, 1],
                vec![0, 2, 2],
                vec![0, 2, 3],
                vec![0, 3, 0],
                vec![0, 3, 1],
                vec![0, 3, 2],
                vec![0, 3, 3],
                vec![1, 0, 0],
                vec![1, 0, 1],
                vec![1, 0, 2],
                vec![1, 0, 3],
                vec![1, 1, 0],
                vec![1, 1, 1],
                vec![1, 1, 2],
                vec![1, 1, 3],
                vec![1, 2, 0],
                vec![1, 2, 1],
                vec![1, 2, 2],
                vec![1, 2, 3],
                vec![1, 3, 0],
                vec![1, 3, 1],
                vec![1, 3, 2],
                vec![1, 3, 3],
                vec![2, 0, 0],
                vec![2, 0, 1],
                vec![2, 0, 2],
                vec![2, 0, 3],
                vec![2, 1, 0],
                vec![2, 1, 1],
                vec![2, 1, 2],
                vec![2, 1, 3],
                vec![2, 2, 0],
                vec![2, 2, 1],
                vec![2, 2, 2],
                vec![2, 2, 3],
                vec![2, 3, 0],
                vec![2, 3, 1],
                vec![2, 3, 2],
                vec![2, 3, 3],
                vec![3, 0, 0],
                vec![3, 0, 1],
                vec![3, 0, 2],
                vec![3, 0, 3],
                vec![3, 1, 0],
                vec![3, 1, 1],
                vec![3, 1, 2],
                vec![3, 1, 3],
                vec![3, 2, 0],
                vec![3, 2, 1],
                vec![3, 2, 2],
                vec![3, 2, 3],
                vec![3, 3, 0],
                vec![3, 3, 1],
                vec![3, 3, 2],
                vec![3, 3, 3],
            ],
        ),
    ]
}
