// Copyright (C) 2001 Nils Bokermann <Nils.Bokermann@mediaWays.net>
//
// PURPOSE OF THIS FILE: Implement the ldap_delete functions
//
// - Automatic Version Information via RCS:
//   $Id: delete.cxx,v 1.1 2001/12/17 16:36:17 nilsb Exp $
//   $Source: /cvsroot/openh323gk/openh323gk/ldap/src/delete.cxx,v $
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "ldapapi.h"
#include <ldap-int.h>

#ifndef lint
// mark object with version info
static const char vcid[] = "@(#) $Id: delete.cxx,v 1.1 2001/12/17 16:36:17 nilsb Exp $";
static const char vcHid[] = __LDAP_OPENH323_H;
#endif

int ldap_delete_ext (LDAP *ld, LDAP_CONST char *dn, LDAPControl **serverctrls,
		     LDAPControl **clientctrls, int *msgidp) {
  
  LDAP_LDAPMessage msg;
  *msgidp=++(ld->msg_id);
  msg.m_messageID=*msgidp;
  msg.m_protocolOp=LDAP_LDAPMessage_protocolOp(LDAP_LDAPMessage_protocolOp::e_delRequest);
  LDAP_DelRequest &del=msg.m_protocolOp;
  del=dn;

  PBER_Stream encoding_stream;
  msg.Encode(encoding_stream);
  if(encoding_stream.Write(*(ld->socket))) {
    return LDAP_SUCCESS;
  }
  ld->ld_errno=LDAP_UNAVAILABLE;
  return ld->ld_errno;
}

  


int ldap_delete_ext_s (LDAP *ld, LDAP_CONST char *dn, LDAPControl **serverctrls,
		       LDAPControl **clientctrls) {
  int msgid;
  int rv;
  LDAPMessage *result;
  if(LDAP_SUCCESS!=(rv=ldap_delete_ext(ld, dn, serverctrls, clientctrls, &msgid))) {
    ld->ld_errno=rv;
    return rv;
  }

  if (-1==ldap_result(ld, msgid, 1, NULL, &result)) {
    return(ld->ld_errno);
  }
    
  rv = ldap_result2error(ld, result, 0);
  ldap_msgfree(result);
  return rv;
}

		    

int ldap_delete (LDAP *ld, LDAP_CONST char *dn) {
  int msgid;
  int rv;
  if(LDAP_SUCCESS!=(rv=ldap_delete_ext(ld, dn, NULL, NULL, &msgid))) {
    ld->ld_errno=rv;
    return -1;
  }
  
  return msgid;
}

int ldap_delete_s (LDAP *ld, LDAP_CONST char *dn ) {
  int msgid;
  LDAPMessage *result;
  if(-1==(msgid=ldap_delete(ld,dn)))
    return ld->ld_errno;

  if (-1==ldap_result(ld, msgid, 1, NULL, &result)) {
    return(ld->ld_errno);
  }
    
  msgid = ldap_result2error(ld, result, 0);
  ldap_msgfree(result);
  return msgid;
}
  
//
// End of delete.cxx
//
