#
# bitmap widget demo (called by 'widget')
#

# bitmapRow --
# Create a row of bitmap items in a window.
#
# Arguments:
# w -           The parent window that is to contain the row.
# args -        The names of one or more bitmaps, which will be displayed
#               in a new row across the bottom of w along with their
#               names.

def bitmapRow(w,*args)
  TkFrame.new(w){|row|
    pack('side'=>'top', 'fill'=>'both')
    for bitmap in args 
      TkFrame.new(row){|base|
        pack('side'=>'left', 'fill'=>'both', 'pady'=>'.25c', 'padx'=>'.25c')
        TkLabel.new(base, 'text'=>bitmap, 'width'=>9).pack('side'=>'bottom')
        TkLabel.new(base, 'bitmap'=>bitmap).pack('side'=>'bottom')
      }
    end
  }
end

# toplevel widget ¸ߤк
if defined?($bitmap_demo) && $bitmap_demo
  $bitmap_demo.destroy 
  $bitmap_demo = nil
end

# demo Ѥ toplevel widget 
$bitmap_demo = TkToplevel.new {|w|
  title("Bitmap Demonstration")
  iconname("bitmap")
  positionWindow(w)
}

# label 
TkLabel.new($bitmap_demo,'font'=>$font,'wraplength'=>'4i','justify'=>'left', 
            'text'=>"ΥɥˤϡTk Ȥ߹ޤ줿٤ƤΥӥåȥޥåפ̾ȶɽƤޤTcl ΥץǤϡ줾̾ѤƻȤޤ"){
  pack('side'=>'top')
}

# frame 
$bitmap_buttons = TkFrame.new($bitmap_demo) {|frame|
  TkButton.new(frame) {
    #text 'λ'
    text 'Ĥ'
    command proc{
      tmppath = $bitmap_demo
      $bitmap_demo = nil
      tmppath.destroy
    }
  }.pack('side'=>'left', 'expand'=>'yes')

  TkButton.new(frame) {
    text 'ɻ'
    command proc{showCode 'bitmap'}
  }.pack('side'=>'left', 'expand'=>'yes')
}
$bitmap_buttons.pack('side'=>'bottom', 'fill'=>'x', 'pady'=>'2m')

# frame 
TkFrame.new($bitmap_demo){|f|
  bitmapRow(f,'error','gray25','gray50','hourglass')
  bitmapRow(f,'info','question','questhead','warning')
  pack('side'=>'top', 'expand'=>'yes', 'fill'=>'both')
}

