/* 
 * vfldrvs.c - print a list of installed font drivers
 * by Hirotsugu Kakugawa
 *
 *  22 Jul 1998   
 *
 */
/*
 * Copyright (C) 1998 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

/*
 * Usage:  vfldrvs
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#if defined(HAVE_STRING_H) || defined(STDC_HEADERS)
#  include  <string.h>
#else
#  include  <strings.h>
#endif
#include "VFlib-3_6.h"


int
main(int argc, char **argv)
{
  int     i;
  char    *vfcap, **drv_list;

  vfcap = NULL;
  --argc; argv++;
  while (argc > 0){
    if ((argc >= 2) && (strcmp(argv[0], "-v") == 0)){
      --argc; argv++;
      vfcap = argv[0];
      --argc; argv++;
    } else {
      break;
    }
  }

  if ((VF_Init(vfcap, NULL) < 0) 
      || ((drv_list = VF_FontDriverList()) == NULL))
    exit(1);

  for (i = 0; drv_list[i] != NULL; i++)
    printf("%s\n", drv_list[i]);

  return 0;
}
