/* ==================================================== ======== ======= *
 *
 *  uucursor.cpp
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//#pragma ident	"@(#)uucursor.cc	ubit:03.04.00"
#include <ubrick.hpp>
#include <ucall.hpp>
#include <ubox.hpp>
#include <ucolor.hpp>
#include <uview.hpp>
#include <uevent.hpp>
#include <ucontext.hpp>
#include <ugraph.hpp>
#include <ucursor.hpp>
#include <uappli.hpp>
#include <X11/cursorfont.h>


UCursor UCursor::arrow(XC_arrow, UMode::UCONST);
UCursor UCursor::xcross(XC_X_cursor, UMode::UCONST);
UCursor UCursor::crosshair(XC_crosshair, UMode::UCONST);
UCursor UCursor::text(XC_xterm, UMode::UCONST);
UCursor UCursor::hand(XC_hand2, UMode::UCONST);

UCursor UCursor::wait(XC_watch, UMode::UCONST);
UCursor UCursor::question(XC_question_arrow, UMode::UCONST);
UCursor UCursor::kill(XC_pirate, UMode::UCONST);
UCursor UCursor::sizing(XC_sizing, UMode::UCONST);
UCursor UCursor::drag(XC_gumby, UMode::UCONST);
UCursor UCursor::add(XC_plus, UMode::UCONST);

/*
UCursor UCursor::pencil("pencil", XC_pencil, UMode::UCONST);
UCursor UCursor::spray("spray", XC_spraycan, UMode::UCONST);
UCursor UCursor::spider("spider", XC_spider, UMode::UCONST);
UCursor UCursor::finger("finger", XC_hand1, UMode::UCONST);
UCursor UCursor::umbrella("umbrella", XC_umbrella, UMode::UCONST);
UCursor UCursor::heart("heart", XC_heart, UMode::UCONST);
*/
/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UCursor::UCursor(int curshape, u_modes m): UProp(m){
  //name = curname;
  shape = curshape;
}

//!! ATT aux delete: plusieurs objets peuvent pointer sur le meme NatCursor
//!! dans le UDisp
UCursor::UCursor(const UCursor &c) {
  //name = c.name;
  shape = c.shape;
}

void UCursor::set(const UCursor &new_value) {
  if (shape == new_value.shape) return;
  //name  = new_value.name;
  shape = new_value.shape;
  changed(true);
}

bool UCursor::equals(const UCursor &c) const {
  return (shape == c.shape);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UCursor::addingTo(ULink *selflink, UGroup *parent) {
  UProp::addingTo(selflink, parent);

  if (parent->isDef(0, UMode::HAS_CURSOR)) {
    UError::error("warning@UCursor::addingTo", 
		  "multiple UCursor bricks in object:", parent->cname());
  }
  // Rendre parent sensitif aux events ad hoc
  parent->setCmodes(UMode::HAS_CURSOR, true);
}

void UCursor::removingFrom(ULink *selflink, UGroup *parent) {
  // tant pis s'il y a plusieurs Cursors: de tt facon c'est une erreur
  parent->setCmodes(UMode::HAS_CURSOR, false);
  UProp::removingFrom(selflink, parent);
}

void UCursor::update() {}

void UCursor::putProp(UContext *props, UCtrl *state) {
  props->cursor = this;
}

bool UCursor::realize(UDisp *d) {
  return d->realizeCursor(*this);
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
