/* ==================================================== ======== ======= *
 *
 *  ubrickImpl.hpp [internal implementation]
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _ubrickImpl_hpp_
#define	_ubrickImpl_hpp_
//pragma ident	"@(#)ubrickImpl.hpp	ubit:03.04.05"

// ====[internal implementation]===========================

class UGenLink {
protected:
  friend class UGenChain;
  UGenLink *nextlink;
  UGenLink() {nextlink = null;}
  UGenLink* getNext() const {return nextlink;}
};

/* ==================================================== ======== ======= */

class ULink : public UGenLink {
public:
  ULink(class UBrick* _child);

  class UBrick* getChild() const  {return b;}
  class UBox* getBoxChild() const;    ///< null if child is not an UBox
  class UWin* getWinChild() const;    ///< null if child is not an UWin
  
  class UGroup* getParent() const {return par;}
  void setParent(class UGroup* _parent)  {par = _parent;}

  class ULink* getNext() const {return (ULink*)nextlink;}
  
  const class UCond* getCond() const  {return cond;}
  void setCond(const class UCond& c)  {cond = &c;}
  void setCond(const class ULink* l)  {cond = l->cond;}

  bool verifies(const class UContext *ctx, const class UCtrl *ctrl) const;
  
  /// NB: null cond means do nothing
  bool match(const class UCond& _cond) const {   //a etendre pour UOn copies!!!
    return (cond != null && cond == &_cond);
  }

protected:
  class UBrick *b;
  class UGroup *par;
  const class UCond *cond;
};

/* ==================================================== ======== ======= */

class ULinkLink : public UGenLink {
  friend class ULLChain;
  ULink *lk;
public:
  ULinkLink(ULink *l) : UGenLink() {lk = l;}

  class UGroup* getParent() const {return lk->getParent();}
  
  ULink* getLink() const {return lk;}
  ULink* link() const {return lk;}
  
  ULinkLink* getNext() const {return (ULinkLink*)nextlink;}
};

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

class UGenChain {
public:
  UGenChain() {firstlink = null, lastlink = null;};

  /// adds link at the end of the chain
  void add(UGenLink *link);
 
  /// removes and returns link (null if not found)
  void remove(UGenLink *link);

  /// merge 'this' chain with the chain given as an argument
  void append(UGenChain*);

  /** inserts 'link' after 'poslink' in the chain.
   * special case: if 'poslink=null' => add 'link' at the BEGINNING of the list
   */
  void insertAfter(UGenLink *link, UGenLink *poslink);

  /** removes and returns the link that FOLLOWS 'poslink'.
   * (but does not remove 'poslink' itself!)
   * - returns null and do nothing if no link follows 'poslink'
   * special case:
   * - if 'poslink=null' => removes and returns the FIRST link in the list
   */
  class UGenLink* removeAfter(UGenLink *poslink);

  /** resets the Chain so that it points to null.
   * - returns the first link that was previously pointed by the Chain
   * - this fct. does not destroy the links and does not free anything
   */
  class UGenLink *reset();

protected:
    UGenLink *firstlink, *lastlink;
};

/* ==================================================== ======== ======= */

class UChain : public UGenChain {
public:
  ULink *first() const {return (ULink*)firstlink;}
  ULink *last()  const {return (ULink*)lastlink;}

  ULink* removeAfter(ULink *poslink) 
  {return (ULink*)UGenChain::removeAfter(poslink);}

  /** search first occurence of 'brick' in the list.
   * - returns the 'brick' link if found and  null otherwise
   * - searches from 'fromlink' if not null and from the beginning otherwise
   */
  ULink* search(const UBrick *brick, const ULink *fromlink = null);
};

/* ==================================================== ======== ======= */

class ULLChain : public UGenChain {
public:
  ULinkLink *first() const {return (ULinkLink*)firstlink;}
  ULinkLink *last()  const {return (ULinkLink*)lastlink;}

  ULinkLink* removeAfter(ULinkLink *poslink) 
  {return (ULinkLink*)UGenChain::removeAfter(poslink);}

  /// removes the first ULinkLink that is pointing to this ULink
  ULinkLink* removePointingTo(ULink *pointed);

  void fireParents(class UEvent&, const UOn&) const;
  void updateParents(const class UUpdate&) const;
  void setModesOfParents(u_modes bmodes, u_modes cmodes, bool onoff) const;
  void setModesOfParentViews(int vmodes, bool on_off) const;
};

/* ==================================================== ======== ======= */

class UArgsChain : public UChain {
  friend class UArgs;
  friend class UArgsImpl;
  int refcount;
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
