/* ==================================================== ======== ======= *
 *
 *  uborder.hpp
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _uborder_hpp_
#define	_uborder_hpp_
//pragma ident	"@(#)uborder.hpp		ubit:03.05.00"
#include <ubit/uprop.hpp>

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
/** Box margins.
 */
struct UMargins {
  short top, right, bottom, left;

  UMargins() {}
  UMargins(short _top_bottom, short _left_right);
  UMargins(short _top, short _right, short _bottom, short _left);

  void set(short _top_bottom, short _left_right);
  void set(short _top, short _right, short _bottom, short _left);
  void incr(const UMargins&);
};

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
/** Border decoration Property
 */
class UBorder : public UProp {
public:
  enum {NONE=0, FLAT, SHADOW, ETCHED};
  ///< predefined decorations.

  static UBorder
    none, empty, flat, shadowIn, shadowOut, etchedIn, etchedOut;
  ///< predefined borders.

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  UBorder(int decoration = -ETCHED);
  UBorder(int decoration, class UColor& color, class UColor& bgcolor,
	  int top_bottom_margin = 1, int left_right_margin = 1, u_modes = 0);
  /**< creates a new Border with custom properties.
   * arguments:
   * - 'decoration' is one of NONE, +/-SHADOW, +/-ETCHED, +/-FLAT (a negative 
   *    value sets an INwards shadow, a positive value an OUTwards shadow)
   * - 'color' and 'bgcolor' are the colors of the shadows. They can be
   *   set to UColor::inherit to inherit colors from their parents (ie. the
   *   boxes that contains them). They can't be destroyed by 'delete' 
   *   (automatical deletion when the UBorder is destroyed and these objects
   *   are not pointed by any uptr)
   */

  UBorder(const UBorder&);
  ///< creates a new Border that is a copy of another Border.

  UBorder(bool overlaid, const UArgs&);
  ///< creates an active border (used to create scrollpanes, etc).

  virtual ~UBorder();

  UBorder& operator=(const UBorder&);

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  bool isOverlaid() const {return overlaid;}

  UColor& bgcolor() {return *pbgcolor;}
  UColor& color() {return *pcolor;}
  /**<
    * returns internal fields.
    * these objects can be shared by other objects and their value can
    * be changed by clients. They are automatically deleted when the
    * UBorder is deleted if they dont have other parents and are not
    * pointed by any uptr<>
    */
  
  const UColor& getBgcolor() const {return *pbgcolor;}
  const UColor& getColor() const {return *pcolor;}
  
  int getDecoration() const;
  void setDecoration(int decoration);
  
  const UMargins& getMargins() const;
  void setMargins(const class UMargins&);

  virtual class UGroup* getSubGroup() {return psubgroup;}
  ///< returns the children of an active UBorder.

  virtual void update();

#ifndef NO_DOC
  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // implementation

  virtual void putProp(class UContext*, class UCtrl*);
  virtual void getSize(const UContext&, class UMargins&) const;
  virtual void paint(class UWinGraph&, const UContext&, const URegion &r) const;

protected:
  int  decoration;
  bool overlaid;
  UMargins margins;
  uptr<class UColor> pcolor, pbgcolor;
  uptr<class UGroup> psubgroup;

  virtual void constructs(int decoration, UColor& _color, UColor& _bgcolor);
#endif
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
