/* ==================================================== ======== ======= *
 *
 *  dtree.cc  [demo]
 *  Ubit Project [Elc::2000]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:99] ======= *
 * ==================================================== ======== ======= */

#include <ubit/ubit.hpp>
#include "dmisc.hh"
#include "dtree.hh"

/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */

TreeEntry::TreeEntry(const char *filename, bool isdir, UMenu *menu) {
  file_menu = menu;
  const char *fileattr = " rw- ";
  dir_init = false;

  UHbox &fident = uhbox
    (
     fileattr
     + ubox(uedit() + filename)	 // uedit() makes text editable
     + ubox(USymbol::down + file_menu)
     );
  
  if (!isdir) {	     // entry is a regular file
    addlist
      (
       UValign::top
       + UPix::doc
       + UPix::ellipsis
       + fident
       );
  }
  else { 		// entry is a directory
    addlist
      (
       utop() + uleft()

       // 'folder' pixmap
       + UPix::folder

       // +/- checkbox
       + ubox( uvmargin(0) + uhmargin(0) 

	       // actual visible pixmap will depend on checkbox state
	       + UOn::select / UPix::minus
	       + UOn::unselect / UPix::plus

	       // call the 'readFiles' method when checkbox becomes selected
	       + UOn::select / ucall(this, &TreeEntry::unfold)
	       + UOn::unselect / ucall(this, &TreeEntry::fold)
	       )

       // dirname + handle for adding chilren (the file names in the dir)
       + uvbox( uvmargin(0) + uhmargin(0) 
		+ fident 
		+ (child_handle = &uvbox())) 
       );
  }
}


void TreeEntry::fold(UEvent&) {
  child_handle->show(false);
}

void TreeEntry::unfold(UEvent&) {
  if (!dir_init) {
    dir_init = true;
    // search files
    // for (each file) 
    //      fchildren->add(new TreeEntry(file ,false, view_menu));
    child_handle->add(new TreeEntry("demo", false, file_menu));
    child_handle->add(new TreeEntry("src" ,true, file_menu));
    child_handle->add(new TreeEntry("zsh", false, file_menu));
  }  
  child_handle->show(true);
};



/***
#include <sys/types.h>
#include <dirent.h>
{
     struct dirent *readdir(DIR *dirp);

     struct dirent *readdir_r(DIR *dirp, struct dirent *entry);

 dirp = opendir(".");
     while ((dp = readdir(dirp)) != NULL)
             if (strcmp(dp->d_name, name) == 0) {
                     closedir(dirp);
                     return FOUND;
             }
     closedir(dirp);
     return NOT_FOUND;
}
****/

/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */
// Makes the TreeDialog

MyTreeDialog::MyTreeDialog(UMenu* menu, UArgs a) : UDialog(a) {
  // add children to this 
  addlist
    (
     utitle("Tree Dialog")
     + UBgcolor::white
     + uscrollpane(uwidth(300) + uheight(300)
		   + new TreeEntry("ubit-dir", true, menu)
		   )
     + ubottom()
     + uhbox( UHalign::center
	      // closes the dialog box when OK or Cancel are clicked
	      + ubutton( UPix::ray + "OK" + ucloseWin())
	      + ubutton("Cancel" + ucloseWin())
	      + ubutton( UPix::question + "Help")
	      )
     );
}


/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:00] ======= */
