//
//	tardy - a tar post-processor
//	Copyright (C) 1998, 1999, 2001-2003 Peter Miller;
//	All rights reserved.
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
//
// MANIFEST: functions to manipulate file outputs
//

#include <ac/errno.h>
#include <ac/stdarg.h>
#include <ac/stdio.h>

#include <error.h>
#include <file/output.h>


file_output::~file_output()
{
    // nothing to do
}


file_output::file_output()
{
    // nothing to do
}


void
file_output::fatal(const char *fmt, ...)
    const
{
    va_list ap;
    va_start(ap, fmt);
    char buffer[2000];
    vsnprintf(buffer, sizeof(buffer), fmt, ap);
    va_end(ap);
    const char *s = filename();
    ::fatal("%s: %s",s, buffer);
}


void
file_output::nfatal(const char *fmt, ...)
    const
{
    int err = errno;
    va_list ap;
    va_start(ap, fmt);
    char buffer[2000];
    vsnprintf(buffer, sizeof(buffer), fmt, ap);
    va_end(ap);
    const char *s = filename();
    errno = err;
    ::nfatal("%s: %s", s, buffer);
}
