#!/usr/local/bin/perl

use SPDB;
use SPCGI;

use Templates::Search;

use strict;

sub main{
  # --- create a SPDB object
  my $spdb = SPDB->new();
  
  my $spcgi = SPCGI->new($spdb);
  $spcgi->set_state_for_client();

  # --- load the lang module
  $spcgi->{STATE}->{langptr} = SmallPig::get_lang_ptr($spcgi->{STATE}->{lang}, 
						      "search");

  # --- create a template object
  my $template = Templates::Search->new($spcgi, $spdb);
  # --- print the http header
  $template->print_http_header();
  $template->print_template();
}

main();
