package Templates::User;

use SmallPigVars qw($config);
use Templates::Default;

use strict;
use vars qw(@ISA $template);

@ISA = qw(Templates::Default);

my $lang;

sub new{
  my ($class, $spcgi, $spdb, $pagetype) = @_;
  $pagetype ||= "default";
  
  $template = Templates::Default->new($spcgi, $spdb, $pagetype);

  $template->{'spcgi'} = $spcgi;
  $template->{'STATE'} = $spcgi->{'STATE'};
  $template->{'spdb'} = $spdb || SPDB->new;
  
  bless $template, $class;

  $template->initialize();
  
  return $template;
}

#########################################################################
# --- Sun Dec 19 23:06:10 PST 1999
# ---
sub initialize{
  my ($template) = @_;
  
  my $pagefiles = {};
  $pagefiles->{'default'} = "default.temp";
  $pagefiles->{'login'} = "login.temp";
  $pagefiles->{'register'} = "register.temp";
  $pagefiles->{'forgetpasswd'} = "forgetpasswd.temp";

  $template->{'pagefiles'} = $pagefiles;

  my $pagesubs = {};
  $pagesubs->{'default'} = \&userinfo;
  $pagesubs->{'edituser'} = \&edituser;
  $pagesubs->{'preferences'} = \&editpref;
  $pagesubs->{'whosonline'} =\&whosonline;
  
  $template->{'pagesubs'} = $pagesubs;

  $lang = $template->{'lang'};
}

sub whosonline{
    my $theme = $template->{'theme'};
    $template->print_standard_index();
    $template->print_msg("header2", 1, "", "$lang->{'whosonline1'}:",
			 $theme->{'inbgcolor'}, $theme->{'inbgcolor'});

    $template->SUPER::print_block_start();

    print qq|<tr bgcolor=$theme->{'dhdrcolor'}><td  class=bheader2>$lang->{'loginusername'}</td><td  class=bheader2>$lang->{'status'}</td><td  class=bheader2>$lang->{'lastresp'}</td></tr>|;

    my $spdb = $template->spdb;
    my ($users, $cnt) = $spdb->db_select_many_new(1, "uid, username, nickname, date_format(lastresp, \"$config->{date_format}\")", "Users", "UNIX_TIMESTAMP(NOW())-UNIX_TIMESTAMP(lastresp)<=600 AND uid>0");

    if($users){
	
	while (my ($uid, $username, $nickname, $lastresp) = $users->fetchrow_array){
	    my $userstatus = $template->_check_user_status($username);
	    my $status = ($userstatus eq "admin")?$lang->{'admin'}:
		($userstatus =~ "mod")?$lang->{'moderator'}:$lang->{'ruser'};
	    
	    print qq|<tr><td><a href=\"$config->{'cgidir'}/user.cgi?op=userinfo&uid=$uid&page=1&postsper=10\">$nickname</A></td><td>$status</td><td>$lastresp</td></tr>|;
	}

	$spdb->db_handler_done($users);

    }

    if($cnt==0){
	print "<tr><td colspan=3>$lang->{'no_active_user'}!</td></tr>";
    }
    
    $template->SUPER::print_block_end();
    
    $template->print_adjust_font();
}

sub userinfo{
    my $uid = $template->STATE->{'uid'};
    my $spcgi = $template->{'spcgi'};
    my $spdb = $template->{'spdb'};
    my $STATE = $template->{STATE};
    my $DBH = $spdb->{'dbh'};

    my $tmp = $template;
    if($template->STATE->{'op'} eq "userinfo"){
	$template->print_standard_index();
    }
    else{
	$template->print_user_index();    
    }
    
    $template->print_user_profile();
    
    if($template->STATE->{'op'} eq "userinfo"){
	$template->print_space();
	$template->print_user_posts();
	my ($uid, $postsper) = map{ $template->STATE->{$_} } qw(uid postsper);
	$template->print_page_index($template->{'totalnums'}, 
				    "&uid=$uid&postsper=$postsper");
    }
    $template->print_adjust_font();
}

sub edituser{
  my $theme = $template->{'theme'};
  print qq|<form method="post" action="$config->{'cgidir'}/user.cgi"|;
  $template->print_user_index();
  $template->print_msg("header1", 1, "", $lang->{'edit_profile'},
		       $theme->{'inbgcolor'}, $theme->{'inbgcolor'});
  $template->print_msg("header2", 1, "", $lang->{'bold_info'},
		       $theme->{'inbgcolor'}, $theme->{'inbgcolor'});
  $template->print_edituser_form();
  $template->print_bottom_bar();
  if($template->STATE->{'op'} eq $lang->{'ModifyProfile'}){
      print qq|<input type="hidden" name="prev_op" value="modifyuser">|;
  }
  print "</form>";
}

sub editpref{
  print qq|<form method="post" action="$config->{'cgidir'}/user.cgi"|;
  $template->print_user_index();
  $template->print_editpref_form();
  $template->print_bottom_bar();
  if($template->STATE->{'op'} eq $lang->{'ModifyPreferences'}){
      print qq|<input type="hidden" name="prev_op" value="modifyuser">|;
  }
  print "</form>";
}

#############################################################################
# --- private functions
# ---
#############################################################################
sub print_user_posts{
    my ($template) = @_;
    my ($STATE, $spdb) = map{ $template->{$_} } qw(STATE spdb);
    my $DBH = $spdb->{'dbh'};
    my $theme = $template->{'theme'};
    
    $template->SUPER::print_block_start();

    my ($op, $uid, $postsper, $page, $sort) = map{ $STATE->{$_} } 
    qw(op uid postsper page sort);
    my $select = "DISTINCT cid, pid, B.sid, subject, 
                date_format(P.date, \"$config->{date_format}\"),
                title";
    
    my $from = "Posts AS P, Boards AS B";
    my $where = "P.uid=$uid AND B.sid=P.sid ";
    $where .= "ORDER BY P.sid ";
    my $where1 = $where;
    my $tmplimit = $postsper;
    if($page == 1){
	$where .= "LIMIT $tmplimit";
    }
    else{ 
	my $tmpstart;
	$tmpstart = ($page-1)*$tmplimit; 
	$where .= "LIMIT $tmpstart, $tmplimit";
    }
    
    my ($posts, $rows) = $spdb->db_select_many_new(1, $select, 
						   $from, $where);
    
    my ($ret, $pageindex); 
    
    print qq!
	<TR BGCOLOR=$theme->{'dhdrcolor'} CELLPADDING=2>
	    <TD WIDTH=75% CLASS=bheader2>Subject</TD>
		<TD WIDTH=25% CLASS=bheader2>Date</TD>
		    </TR>
			!;
    
    if($posts){
	my $curr_sid = "";
	while ( my ($cid, $pid, $sid, $subject, $date, $title) = $posts->fetchrow_array){
	    $date =~ s/(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/$lang->{$1}/ig;
	    
      if($curr_sid ne $sid){
	  print "<TR BGCOLOR=$theme->{'lhdrcolor'}>
<TD CLASS=lbheader2 COLSPAN=2 ALIGN=center><B>$title</B></TD></TR>";
	  $curr_sid = $sid;
      }
      # --- encode sid
	    $sid = $template->url_encode($sid);
	    print qq!
		<TR><TD>
		    <A HREF=$config->{'cgidir'}/comments.cgi?op=threadlist&sid=$sid&cid=$cid&pid=$pid&display=$STATE->{'display'}>
			$subject</A></TD><TD WIDTH=25%>$date</TD></TR>
			    !;
	}

	$spdb->db_handler_done($posts);

    }
    else{
	print "<TR><TD COLSPAN=2>$lang->{'no_posts'}\!</TD></TR>";
    }
    
    $template->{'totalnums'} = $spdb->db_count($from, $where1);

    $template->SUPER::print_block_end();
}

sub print_bottom_bar{
  my ($self) = @_;
  my $op = $self->{'STATE'}->{'op'};
  my ($buttons, $ret);

  if($op eq "edituser" || $op eq $lang->{'ModifyProfile'}){
      $buttons = qq|<INPUT TYPE="submit" name="op" value="$lang->{'saveuser'}">|;
  }
  else{
      $buttons = qq|<INPUT TYPE="submit" name="op" value="$lang->{'SavePreferences'}">|;
  }

  $template->SUPER::print_block_start();  
  print qq|<tr width="100%"><td><font size="1">$buttons</font></td></tr>|;
  $template->SUPER::print_block_end();
}

sub print_editpref_form{
  my ($self) = @_;
  my $STATE = $self->{'STATE'};
  my $spdb = $self->{'spdb'};
  my $DBH = $spdb->{'dbh'};
  
  my ($username, $uid, $op) = map{ $STATE->{$_} } qw(username uid op);

  if($op eq $lang->{'ModifyPreferences'}){
      $uid = $STATE->{'selecteduid'};
    
      ($username) = $spdb->db_select_cols("username", "Users",
                                          "uid=$uid") if $uid;
  }

  my $select = "sort, display, view, postsper, sig, theme, lang";
  
  my ($sort, $display, $view, $postsper, $sig, $theme, $tlang) = 
      $spdb->db_select_cols($select, "BoardPrefs", 
			    "uid=$uid") if $username;

  my ($cookieexpire) = $spdb->db_select_cols("cookieexpire", "Users", "uid=$uid") if $username;

  my $postsperp = qq|<input type="text" name="mypostsper" size="5" value="$postsper">|;
  my $displayp = $template->select_option({("$lang->{'ThreadedFlat'}"=>'nested',
					    "$lang->{'Threaded'}"=>'threaded',
					    "$lang->{'Flat'}"=>'flat',
					    "$lang->{'Combined'}"=>'combined')},
                                         'mydisplay', $display);
  my $viewp = $template->select_option({("$lang->{'Collapsed'}"=>'collapsed',
                                        "$lang->{'Expanded'}"=>'expanded')},
                                      'myview', $view);
  my $sortp =
    $template->select_option({("$lang->{'date'} $lang->{'Ascending'}"=>'date asc',
                              "$lang->{'date'} $lang->{'Descending'}"=>'date desc',
                              "$lang->{'subject'} $lang->{'Ascending'}"=>'subject asc',
                              "$lang->{'subject'} $lang->{'Descending'}"=>'subject desc',
                              "$lang->{'name'} $lang->{'Ascending'}"=>'name asc',
                              "$lang->{'name'} $lang->{'Descending'}"=>'name desc')},
                            'mysort', $sort);

  my (%themes, $themep);
  opendir(DIR, $config->{'themesdir'});
  while(my $theme = readdir(DIR)){ 
      next if($theme =~ /^(\.\.|\.)$/);
      $themes{$theme} = $theme; 
  }
  $themep = $template->select_option(\%themes, 'mytheme', $theme);

  my (%langs, $langp);
  opendir(DIR, $config->{'langsdir'});
  while(my $tlang = readdir(DIR)){ 
      next if($tlang =~ /^(\.\.|\.)$/);
      $langs{$tlang} = $tlang; 
  }
  $langp = $template->select_option(\%langs, 'mylang', $tlang);

  my $cookieexpirep = 
    $template->select_option({($lang->{'after1h'}=>'+1h',
			       $lang->{'after12hs'}=>'+12h',
			       $lang->{'after1d'}=>'+1d',
			       $lang->{'after1w'}=>'+7d',
			       $lang->{'after1m'}=>'+1M',
			       $lang->{'never'}=>'+10y')}, 
			     'cookieexpire', 
			     $cookieexpire);
  my $sigp = qq|<textarea name="mysig" rows=2 columns=50 value=$sig size=127 wrap="soft">$sig</textarea>|;

  $template->print_block_start("", "", "$lang->{'user_profile'} $STATE->{'realuser'}");  
  print qq!
    <TR><TD>
    <TABLE BORDER=0 CELLPADDING=2><TR><TD>
      <TR><TD COLSPAN=2><P CLASS=caution>$lang->{'login_set'}</P></TD></TR>
      <TR><TD><B>$lang->{'cookie_expire1'}:</B><BR>$lang->{'cookie_expire2'}<BR>
       <font size="1">$cookieexpirep</font></TD></TR>
      <TR><TD COLSPAN=2><BR><P CLASS=caution>$lang->{'board_set'}</P></TD></TR>
      <TR><TD>
      <B>$lang->{'theme'}:</B><BR><font size="1">$themep</font><BR><BR>
      <B>$lang->{'language'}:</B><BR><font size="1">$langp</font><BR><BR>
      <B>$lang->{'display_mode'}:</B><BR><font size="1">$displayp</font><BR><BR>
      <B>$lang->{'view'}:</B><BR><font size="1">$viewp<BR><BR>
      <B>$lang->{'sort'}:</B><BR><font size="1">$sortp<BR><BR>
      <B>$lang->{'limit1'}:</B> $lang->{'limit2'}
      <BR><font size="1">$postsperp</font><BR></TD></TR>
         !;
  print qq!<INPUT TYPE="HIDDEN" NAME="myuid" VALUE="$uid">! if $uid;
  print qq!<INPUT TYPE="HIDDEN" NAME="myusername" VALUE="$username">! if $username;
  print qq!
      <TR><TD COLSPAN=2><BR><P CLASS=caution>$lang->{'post_set'}</P></TD></TR>
      <TR><TD COLSPAN=2><B>$lang->{'post_sig'}</b><BR>$lang->{'create_sig'}<BR><font size="1">$sigp</font><BR></TD></TR>
    </TD></TR></TABLE>
    </TD></TR>
        !;
  $template->print_block_end();
}

sub print_edituser_form{
  my ($self) = @_;
  my $spdb = $self->{'spdb'};
  my $STATE = $self->{'STATE'};
  my $uid = $STATE->{'uid'};

  if($STATE->{'op'} eq $lang->{'ModifyProfile'}){
      $uid = $STATE->{'selecteduid'};
  }

  my $select = "username, passwd, nickname, realname, 
realemail, fakeemail, homepage, bio, icq,
location, photourl, privlev";
  my ($username, $passwd, $nickname, $realname, $realemail, 
      $fakeemail, $homepage, $bio, $icq,  
      $location, $photourl, $privlev) =
	  $spdb->db_select_cols($select, "Users", "uid=$uid") if $uid;
      
  my $realnamep = qq|<input type="text" name="realname" size=35 value="$realname">|;
  my $nicknamep = ($config->{'one_hdlr'} eq "yes")?$nickname:
  qq|<input type="text" name="mynickname" size=35 value="$nickname">|;
  my $realemailp = qq|<input type="text" name="realemail" size=35 value="$realemail">|;
  my $fakeemailp = qq|<input type="text" name="myfakeemail" size=35 value="$fakeemail">|;
  my $homepagep =  qq|<input type="text" name="homepage" size=50 value=|.($homepage||"http://").">";
  my $biop = qq|<textarea name="mybio" rows=3 columns=50 size=255 wrap="soft">$bio</textarea>|;
  my $icqp = qq|<input type="text" name="myicq" size=35 value="$icq">|;
  my $photop = qq|<input type="text" name="myphoto" size=35 value="$photourl">|;
  my $locationp = qq|<input type="text" name="mylocation" size=35 value="$location">|;
  my $usernamep = qq|<input type="text" name="username" size=35>| if !$username;
  $usernamep ||= $username;

  my ($check1, $check2) = ("","");
  if($privlev == 0){ $check1 = "checked"; }
  else{ $check2 = "checked"; }
  my $privlevp1 = "<input type=radio name=myprivlev value=0 $check1>";
  my $privlevp2 = "<input type=radio name=myprivlev value=1 $check2>";

  $template->print_block_start("", "", "$lang->{'user_profile'} $STATE->{'realuser'}");  

  print qq!
    <TR><TD>
    <TABLE BORDER=0 CELLPADDING=2>
       <TR><TD COLSPAN=2><P CLASS=caution>$lang->{'per_info'}</P></TD></TR>
       <TR><TD WIDTH=10%>$lang->{'real_name'}:</TD><TD><font size="1">$realnamep</font></TD></TR>
       <TR><TD WIDTH=10%>$lang->{'location'}:</TD><TD><font size="1">$locationp</font></TD></TR>
           
       <TR><TD COLSPAN=2><BR><P CLASS=caution>$lang->{'online_info'}</P></TD></TR>
       <TR><TD WIDTH=10%><B>$lang->{'posting_name'}:</B></TD><TD><font size="1">$nicknamep</font></TD></TR>
       <TR><TD WIDTH=10%>$lang->{'posting_email'}:</TD><TD><font size="1">$fakeemailp</font></TD></TR>
       <TR><TD WIDTH=10%>$lang->{'homepage'}:</TD><TD><font size="1">$homepagep</font></TD></TR>
       <TR><TD WIDTH=10%>$lang->{'icq'}:</TD><TD><font size="1"><font size="1">$icqp</font></TD></TR>

       <TR><TD COLSPAN=2><BR><P CLASS=caution>$lang->{'reg_info'}</P></TD></TR>
       <TR><TD WIDTH=10%><B>$lang->{'loginusername'}:</B></TD><TD><B><font size="1">$usernamep</font></b></TD></TR>
       <TR><TD WIDTH=10%><B>$lang->{'loginemail'}:</B></TD><TD><font size="1">$realemailp</font></TD></TR>
       <TR><TD COLSPAN=2><B>$lang->{'passwd1'}:</B> ($lang->{'passwd2'})<br>
       <font size="1"><INPUT TYPE="password" NAME="passwd" SIZE="15"></font>
       <font size="1"><INPUT TYPE="password" NAME="vpasswd" SIZE="15"></font><BR>      
           !;
  print qq!<INPUT TYPE="HIDDEN" NAME="myuid" VALUE="$uid">! if $uid;
  print qq!<INPUT TYPE="HIDDEN" NAME="myusername" VALUE="$username">! if $username;
  print qq!
       </TD></TR>
       <TR><TD COLSPAN=2><BR><P CLASS=caution>$lang->{'photo1'}</P></TD></TR>
       <TR><TD COLSPAN=2>$lang->{'photo2'}<BR><font size="1">$photop</font><BR>$lang->{'photo3'}</TD></TR>
       <TR><TD COLSPAN=2><BR><P CLASS=caution>$lang->{'bio1'}</P></TD></TR>
       <TR><TD COLSPAN=2>$lang->{'bio2'}<BR><font size="1">$biop</font></TD></TR>
       <TR><TD COLSPAN=2><BR><P CLASS=caution>$lang->{'privlev1'}</P></TD></TR>
       <TR><TD COLSPAN=2>$lang->{'privlev2'}</TD></TR>
       <TR><TD WIDTH=1%><font size="1">$privlevp1</font></TD><TD><B>$lang->{'public'}</b> - $lang->{'privlev3'}</TD></TR>
       <TR><TD WIDTH=1%><font size="1">$privlevp2</font></TD><TD><B>$lang->{'private'}</B> - $lang->{'privlev4'}</TD></TR>
   </TABLE>
       </TD></TR>
	   !;

  $template->print_block_end();
}

sub print_user_profile{
  my ($template) = @_;
  my $spdb = $template->{'spdb'};
  my $STATE = $template->{'STATE'};
  my $theme = $template->{'theme'};

  my ($uid, $op, $ruserstatus) = map{ $STATE->{$_} } qw(uid op userstatus);
  my $select = "uid, nickname, fakeemail, homepage, bio, username,
                icq, date_format(registered, \"$config->{date_format}\"),
                     date_format(lastlogon, \"$config->{date_format}\"),
                location, photourl, privlev";
  my ($tuid, $nickname, $fakeemail, $homepage, $bio, $username, 
      $icq, $registered, $lastlogon, $location, $photourl, $privlev) =
	  $spdb->db_select_cols($select,"Users","uid=$uid AND active=1"); 

  $registered =~ s/(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/$lang->{$1}/ig;
  $lastlogon =~ s/(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/$lang->{$1}/ig;

  my $userstatus = $template->_check_user_status($username);

  unless($tuid){
      print $lang->{'user_deleted'};
  }
  else{
    $lastlogon = $lang->{'first_logon'} unless $lastlogon;
    my $status = ($userstatus eq "admin")?$lang->{'admin'}:
        ($userstatus =~ "mod")?$lang->{'moderator'}:$lang->{'ruser'};

    $icq = qq|$icq <img src="http://online.mirabilis.com/scripts/online.dll?icq=$icq&img=9" border=0 width=55 height=14>| if $icq;

    my $posts;
    $posts = $spdb->db_count("Posts", "uid=$tuid") if $tuid;
  my $photo = qq!<TD VALIGN=top>
<BR>
<IMG SRC="$photourl" BORDER=0 HEIGHT=85 WIDTH=70>
    </TD>! if $photourl;

    my ($makeprivmsg, $mconfig);
    if($template->STATE->{'op'} eq "userinfo"){

	# --- if spmail client is available
        $mconfig = $template->{'mconfig'};#_get_mconfig();
    
    }

    if($ruserstatus ne "anon" && $mconfig){
	$makeprivmsg = qq~<a class=small href="$mconfig->{'cgidir'}/spmail.cgi?op=newmsg&mto=$username"><img alt="$lang->{'make_priv_msg'} $nickname" border=0 src="$theme->{'imagesdir'}/$theme->{'priv_msg_image'}"></a>~;
	$fakeemail = qq~<a href="$mconfig->{'cgidir'}/spmail.cgi?op=newmsg&mto=$fakeemail">$fakeemail</a>~;
    }
    else{
	$fakeemail = qq~<a href="mailto:$fakeemail">$fakeemail</a>~;
    }

    $template->print_block_start("","",$lang->{'user_profile'},"",3);

    print qq!
<tr bgcolor=$theme->{'lhdrcolor'}>
<td width=1% valign=bottom>$makeprivmsg&nbsp;</td>
<td class=lbheader1 width=30%>$nickname<br>$fakeemail</td>
<td class=lbheader2 align=right valign=top><b>$lang->{'status'}:</b> $status</td>
</tr>

<tr><td colspan=3>
    <table border=0 cellpadding=1 cellspacing=0 width=100%>
	<tr><td>
	    <table border=0 cellpadding=1 cellspacing=0 width=100%>
		<tr><td colspan=2><p class=caution><br>$lang->{'per_info'}</p></td></tr>
		<tr><td width=40%>$lang->{nick_name1}\:</td><td>$nickname</td></tr>
		<tr><td>$lang->{'location'}:</td><td>$location</td></tr>
		<tr><td colspan=2><br><p class=caution>$lang->{'bio1'}</p></td></tr>
		<tr><td colspan=2>$bio</td></tr>

   	        <tr><td colspan=2><br><p class=caution>$lang->{'online_info'}</p></td></tr>
		<tr><td>$lang->{'email'}:</td><td>$fakeemail</a></td></tr>
		<tr><td>$lang->{'homepage'}:</td><td><a href=$homepage>$homepage</a></td></tr>
		<tr><td>$lang->{'icq'}:</td><td>$icq</td></tr>
		<tr><td>$lang->{'registered_on'}:</td><td>$registered</td></tr>
		<tr><td>$lang->{'last_logon'}:</td><td>$lastlogon</td></tr>
	    </table>
	  </td>
	  <td>
	      $photo
	  </td>
       </tr>
   </table>
</td></tr>
  !;
  }

  $template->print_block_end();

  if($op eq "userinfo"){
      $spdb->db_update("Users",{('peek'=>'peek+1')},"uid=$uid"); 
  }

}

sub print_user_index{
  my ($template) = @_;
  my $STATE = $template->{'STATE'};
  my $theme = $template->{'theme'};

  my ($op, $postsper) = map{$STATE->{$_}} qw(op postsper);
  my $cgidir = $config->{'cgidir'};

  $template->print_block_start($theme->{'inbgcolor'}, $theme->{'inbgcolor'});
  
  print "<TR><TD ALIGN=center valign=middle>";
  my $user_status = $STATE->{'userstatus'};
  if($user_status eq "admin"){
      print qq^<a href="$cgidir/admin.cgi">$lang->{'admin1'}</a> | ^;
  }
  elsif($user_status =~ /mod/){
      print qq! <a href="$cgidir/admin.cgi">$lang->{'mod1'}</a> | !;
  }

  # --- <time> Wed Sep  1 15:45:00 PDT 1999
  print qq!<a href="$cgidir/index.cgi">$lang->{'forum_index'}</a> | !;

  my ($profile, $editprofile, $subscribe, $posthist, $preferences);
  ($profile, $editprofile, $subscribe, $posthist, $preferences) =
      (qq|<a href="$cgidir/user.cgi">$lang->{'profile'}</a>|,
       qq|<a href="$cgidir/user.cgi?op=edituser">$lang->{'edit_profile'}</a>|,
       qq|<a href="$cgidir/user.cgi?op=subscription">$lang->{'subscribe2'}</a>|,
       qq|<a href="$cgidir/user.cgi?op=posthist&page=1&postsper=$postsper">$lang->{'posthist1'}</a>|,
       qq|<a href="$cgidir/user.cgi?op=preferences">$lang->{'preferences'}</a>|);
  
  if($op eq "subscription"){
      $subscribe = $lang->{'subscribe2'};
  }
  elsif($op eq "posthist"){
      $posthist =  $lang->{'posthist1'};
  }
  elsif($op eq "edituser"){
      $editprofile = $lang->{'edit_profile'};
  }
  elsif($op eq "subscribe" || $op eq "editsub"){}
  elsif($op eq "preferences"){
      $preferences = $lang->{'preferences'};
  }
  else{ 
      $profile = $lang->{'profile'};
  }
  print "<B>$profile | $editprofile | $preferences | $subscribe | $posthist | </B>";
  print "<A HREF=$cgidir/user.cgi?op=logout>$lang->{'logout'}</A></TD></TR>";

  $template->print_block_end();
}

# return "anon"  - anonymous
#        "ruser  - registered user
#        "mod"   - moderator
#        "admin" - administration
#        "gmem"  - group member
sub _check_user_status{
  my ($self, $tusername) = @_;
  my ($spdb, $STATE) = map{ $self->{$_} } qw(spdb STATE);
  my $DBH = $spdb->{'dbh'};

  my $username = $tusername;
  return "anon" if($username eq "anon");

  my $usernameq = $DBH->quote($username);

  my $where = "username=$usernameq";
  
  # --- if user is admin?
  my ($isadmin, $uid) = $spdb->db_select_cols("isadmin, uid", "Users", 
					      $where);

  return "admin" if $isadmin;

  my $userstatus;
  my $where = "uid=$uid ";
  # --- if user is mod?
  if($spdb->db_count("Moderators", $where) > 0){
      $userstatus = "mod";
  }
  
  $userstatus ||= "ruser";
  return $userstatus;
}


return 1;





