package Templates::AttachFile;

use SmallPigVars qw($config);
use Templates::CommentsNC;

use strict;
use vars qw(@ISA $template);

@ISA = qw(Templates::CommentsNC);

my $lang;

sub new{
  my ($class, $spcgi, $spdb) = @_;

  $template = Templates::CommentsNC->new($spcgi, $spdb);

  $template->{'spcgi'} = $spcgi;
  $template->{'STATE'} = $spcgi->{'STATE'};
  $template->{'spdb'} = $spdb;
  
  $template->{'title'} = "";
  $template->{'refresh'} = "";

  bless $template, $class;

  $template->initialize();
  
  return $template;
}

#########################################################################
# --- Sun Dec 19 23:06:10 PST 1999
# ---
sub initialize{
  my ($template) = @_;

  my $pagefiles = {};
  $pagefiles->{'default'} = "default.temp";
  
  $template->{'pagefiles'} = $pagefiles;

  my $pagesubs = {};
  $pagesubs->{'default'} = \&whole;
  
  $template->{'pagesubs'} = $pagesubs;
  
  $lang = $template->{'lang'};
}

#########################################################################
# --- pagesubs
# ---
sub whole{
  my ($STATE, $spdb) = map{ $template->{$_} } qw(STATE spdb);
  my ($prev_op, $poster, $posteremail, $subject, $body, $fids, $sid, $cid) = 
      map{ $STATE->{$_} } 
  qw(prev_op poster posteremail subject body fids sid cid);

  $template->_set_files_info($fids);

  print qq|<FORM METHOD="post" ACTION="$config->{'cgidir'}/comments.cgi" ENCTYPE="multipart/form-data">|;
  
  $template->print_standard_index();
  $template->print_attach_file();
  $template->print_file_att();
  $template->print_bottom_bar();

  #-----------------------------------
  $poster = $template->filter_html($poster);
  $posteremail = $template->filter_html($posteremail);
  $subject = $template->filter_html($subject);
  $body = $template->filter_html($body);
  #-----------------------------------

  $prev_op .= "#" if $prev_op;
  print qq|<INPUT type="hidden" name="prev_op"  value=$prev_op|."attachfile>";
  print qq|<INPUT type="hidden" name="poster" value="$poster">|;
  print qq|<INPUT type="hidden" name="posteremail" value="$posteremail">|;
  print qq|<INPUT type="hidden" name="subject" value="$subject">|;
  print qq|<INPUT type="hidden" name="body" value="$body">|;
  print qq|<INPUT type="hidden" name="fids" value="$fids">|;
  print qq|<INPUT type="hidden" name="sid" value="$sid">|;
  print qq|<INPUT type="hidden" name="cid" value="$cid">|;
  
  print "</form>";
}

sub print_attach_file{
  my ($template, $STATE) = @_;
  my ($fid) = map{ $template->{$_} } qw(fid);
  my ($sid, $prev_op, $html, $body, $fids) = 
    map{ $STATE->{$_} } qw(sid prev_op html body fids);
  
  my $ret;

  my $file_namef = qq|<INPUT TYPE="file" name="file_hdl" size=30 maxlength=80>|;
  my $file_descf = qq|<TEXTAREA name="file_desc" rows=3 cols=30 size=255 wrap="virtual"></TEXTAREA>|;
  
  $template->SUPER::print_block_start("","",$lang->{'attachments'});  
  print qq|
<TR><TD>
  <TABLE BORDER=0 CELLPADDING=10>
    <TR><TD>
      <B>$lang->{'file_desc'}:</B><BR>
	  <font size=1>$file_descf</FONT><BR>
      <B>$lang->{'select_file'}:</B><BR>
	  <font size=1>$file_namef</font><BR><BR>
      </TD></TR>
   </TABLE>
</TD></TR>
  |;
  $template->SUPER::print_block_end();
}

sub print_bottom_bar{
  my ($template) = @_;
  my ($buttons, $ret);

  $buttons = qq|<INPUT TYPE="submit" name="op" value="$lang->{'AttachFile'}">|;

  $template->SUPER::print_block_start();  
  print qq|<tr width="100%"><td><FONT SIZE=1>$buttons</FONT></td></tr>|;
  $template->SUPER::print_block_end();
}

return 1;



