package Templates::Admin::UsersList;

use SmallPigVars qw($config);
use Templates::Admin::SmallPig;
use SPDB;
use strict;
use vars qw(@ISA $lang);

@ISA = qw(Templates::Admin::OptBlock);

my %CACHE;

my $lang;

sub new{
  my ($class, $STATE, $spdb) = @_;
  my $theme = $STATE->{'theme'};

  $lang = $STATE->{'langptr'};

  my $self = Templates::Admin::OptBlock->new({}, $theme);
  $self->{'spdb'} = $spdb || SPDB->new;
  my $id = join '', sort values %$self, "userslist";
  
#  return $CACHE{$id} if $CACHE{$id};
  return $CACHE{$id} = bless $self, $class;
}

sub DESTROY{
    my $self = shift;
    my $spdb = $self->{'spdb'};
    $spdb->db_disconnect($spdb->{'dbh'});
}

sub get_grouplist{
  my ($self, $STATE) = @_;
  my $spdb = $self->{'spdb'};
  my $DBH = $spdb->{'dbh'};
  my $theme = $STATE->{'theme'};  

  $lang = $STATE->{'langptr'};

  my $ret;
  my ($uid, $tboards, $tusers, $user_status, $postsper, $allowpost) = 
    map { $STATE->{$_} } qw(uid boards users userstatus postsper allowwrite);
  $allowpost = (!$allowpost)?"no":"yes";

  my (@tboards, @tusers);
  my ($sidh, $uidh) = ({},{});
  if($tboards && $tusers) {
    @tboards = split("#", $tboards); 
    @tusers = split("#", $tusers);

    my $where;
    foreach (@tusers){ $where .= "uid=$_ OR "; } 
    $where =~ s/(.*) OR $/$1/g;
    $where = "($where) AND active=1 ";
    my ($tusers_name) = $spdb->db_select_many(1,
					      "uid, username", 
					      "Users",
					      $where);
    foreach (@$tusers_name){
	my ($uid, $username) = @$_;
	$uidh->{$uid} = $username;
    }
  }
  
  my $from  = "Boards AS B";
  my $where .= "(level=32) ";

  if($user_status =~ /mod/){
    $from    .= ", Moderators AS M" if $user_status;
    $where    .= "AND B.sid=M.sid AND M.uid=$uid";
  }
  
  my ($boards) =
    $spdb->db_select_many(1, 
			 "B.sid, title, level", 
			 $from, $where);

  $ret .= qq!
<TR BGCOLOR=$theme->{'dhdrcolor'} CELLPADDING=2>
<TD CLASS=bheader2>$lang->{'members'}</TD>
<TD WIDTH=25% CLASS=bheader2>$lang->{'allowtopost'}</TD>
<TD WIDTH=25% CLASS=bheader2>$lang->{'assigned_on'}</TD>
</TR>
  !;
  foreach (@$boards){
    my ($sid, $title, $level) = @$_;
    my $sidq = $DBH->quote($sid);
    my $bstatus = Templates::Admin::SmallPig::get_board_status($level);

    $ret .= "<TR BGCOLOR=$theme->{'lhdrcolor'}>
<TD CLASS=lbheader2 COLSPAN=3 ALIGN=center><B>$title ($bstatus)</B>
</TD></TR>";
    
    # --- find the moderator of this board
    my ($mods) = $spdb->db_select_many(1,
				    "uid","Moderators", "sid=$sidq");

    my ($mems) = 
      $spdb->db_select_many(1,
			   "GM.sid, assigned, username, GM.uid, GM.allowwrite", 
			   "GroupMems AS GM, Users AS U", 
			   "GM.sid=$sidq AND GM.uid=U.uid AND U.active=1 ");
    my $time = $spdb->db_date($config->{'date_format'});

    if($mems){
      my %tmp = ();

      if($STATE->{'prev_op'} !~ /revokegroup/){
	  foreach (@$mems){
	      my ($sid, $assigned, $username, $uid, $allowwrite) = @$_;
	      $tmp{$uid}{'username'} = $username;
	      $tmp{$uid}{'allowwrite'} = (($allowwrite)?"yes":"no");
	  }
	  foreach (@tusers){
	      my ($uid, $username) = ($_, $uidh->{$_});
	      # --- make sure user is not a moderator of this board
	      my $flag = 1;
	      foreach (@$mods){
		  my ($tuid) = @$_;
		  if($tuid == $uid){ $flag = 0; }
	      }
	      foreach (@tboards){
		  $tmp{$uid}{'username'} = $username if($sid eq $_ && $flag);
		  $tmp{$uid}{'allowwrite'} = $allowpost if($sid eq $_ && $flag);
	      }
	  }
      }
      else{
	foreach (@$mems){
	  my $flag = 1;
	  my ($sid, $assigned, $username, $uid) = @$_;
	  foreach (@tusers){
	    my ($tuid, $tusername) = ($_, $uidh->{$_});
	    foreach (@tboards){
	      $flag = 0	if($sid eq $_ && $tuid == $uid);
	    }
	  }
	  $tmp{$uid}{'username'} = $username if $flag;
	  $tmp{$uid}{'allowwrite'} = $allowpost if $flag;
	}
      }

      unless(keys(%tmp)){
	$ret .= "<TR><TD COLSPAN=2>$lang->{'no_members'}</TD></TR>";
      }

      foreach (keys(%tmp)){
	$ret .= qq!
<TR>
<TD>
<A HREF=$config->{'cgidir'}/user.cgi?op=userinfo&uid=$_&page=1&postsper=$postsper>$tmp{$_}{'username'}</A></TD>
<TD WIDTH=25%>$tmp{$_}{'allowwrite'}</TD>
<TD WIDTH=25%>$time</TD></TR>
  !; 
      }
    }
    else{
      if($STATE->{'prev_op'} !~ /revokegroup/){
	if($tboards && $tusers){
	  my $flag = 1;
	  foreach (@tboards){
	    if($sid eq $_){
	      foreach (@tusers){
		my ($uid, $username) = ($_, $uidh->{$_});
		my $flag1 = 1;
		foreach (@$mods){
		  my ($tuid) = @$_;
		  if($tuid == $uid){ $flag1 = 0; }
		}
		if($flag1){
		  $ret .= qq!
<TR>
  <TD>
  <A HREF=$config->{'cgidir'}/user.cgi?op=userinfo&uid=$uid&page=1&postsper=$postsper>
    $username
  </A></TD>
  <TD WIDTH=25%>$allowpost</TD>
  <TD WIDTH=25%>$time</TD></TR>
    !; $flag = 0;
		}
	      } 
	    }
	  }
	  if($flag){ 
	    $ret .= "<TR><TD COLSPAN=3>$lang->{'no_members'}</TD></TR>";
	  }
	}
	else{ $ret .= "<TR><TD COLSPAN=3>$lang->{'no_members'}</TD></TR>"; }
      }
      else{
	$ret .= "<TR><TD COLSPAN=3>$lang->{'no_members'}</TD></TR>";
      }
    }
  }

  $self->{'content'} = $ret;
  $ret = $self->SUPER::get();

  return $ret;
}

sub get_modlist{
  my ($self, $STATE) = @_;
  my $spdb = $self->{'spdb'};
  my $DBH = $spdb->{'dbh'};
  my $theme = $STATE->{'theme'};

  $lang = $STATE->{'langptr'};

  my $ret;
  my ($tboards, $tusers, $postsper) = 
    map { $STATE->{$_} } qw(boards users postsper);

  my (@tboards, @tusers);
  my ($sidh, $uidh) = ({},{});
  if($tboards && $tusers) {
    @tboards = split("#", $tboards); 
    @tusers = split("#", $tusers);
    
    my $where;
    foreach (@tusers){ $where .= "uid=$_ OR "; } 
    $where =~ s/(.*) OR $/$1/g;
    $where = "($where) AND active=1 ";
    my ($tusers_name) = $spdb->db_select_many(1,
					   "uid, username", 
					   "Users",
					   $where);
    foreach (@$tusers_name){
      my ($uid, $username) = @$_;
      $uidh->{$uid} = $username;
    }
  }
  
  my ($boards) = $spdb->db_select_many(1, "sid, title, level", 
				       "Boards");

  $ret .= qq!
<TR BGCOLOR=$theme->{'dhdrcolor'} CELLPADDING=2>
<TD CLASS=bheader2>$lang->{'moderators'}</TD>
<TD WIDTH=25% CLASS=bheader2>$lang->{'assigned_on'}</TD>
</TR>
  !;
  foreach (@$boards){
    my ($sid, $title, $level) = @$_;
    my $sidq = $DBH->quote($sid);
    my $bstatus = Templates::Admin::SmallPig::get_board_status($level);

    $ret .= "<TR BGCOLOR=$theme->{'lhdrcolor'}>
<TD CLASS=lbheader2 COLSPAN=2 ALIGN=center><B>$title ($bstatus)</B>
</TD></TR>";
    
    my ($mods) = $spdb->db_select_many(1,
				    "M.sid, assigned, username, 
                                     M.uid", 
				    "Moderators AS M,Users AS U", 
				    "M.sid=$sidq AND
                                     M.uid=U.uid AND U.active=1 ");
    my $time = $spdb->db_date($config->{'date_format'});

    if($mods){
	my %tmp = ();
	if($STATE->{'prev_op'} !~ /revokemod/){
	    foreach (@$mods){
		my ($sid, $assigned, $username, $uid) = @$_;
		$tmp{$uid} = $username;
	    }
	    foreach (@tusers){
		my ($uid, $username) = ($_, $uidh->{$_});
		foreach (@tboards){
		    $tmp{$uid} = $username if($sid eq $_);
		}
	    }
	}
	else{
	    foreach (@$mods){
		my $flag = 1;
		my ($sid, $assigned, $username, $uid) = @$_;
		foreach (@tusers){
		    my ($tuid, $tusername) = ($_, $uidh->{$_});
		    foreach (@tboards){
			$flag = 0	if($sid eq $_ && $tuid == $uid);
		    }
		}
		$tmp{$uid} = $username if $flag;
	    }
	}
	
	unless(keys(%tmp)){
	    $ret .= "<TR><TD COLSPAN=2>$lang->{'no_moderators'}</TD></TR>";
	}

	foreach (keys(%tmp)){
	    $ret .= qq!
<TR>
<TD>
<A HREF=$config->{'cgidir'}/user.cgi?op=userinfo&uid=$_&page=1&postsper=$postsper>$tmp{$_}</A></TD>
<TD WIDTH=25%>$time</TD></TR>
  !; 
	}
    }
    elsif($STATE->{'prev_op'} =~ /revokemod/){
	$ret .= "<TR><TD COLSPAN=2>$lang->{'no_moderators'}</TD></TR>";
    }
    else{
	if($tboards && $tusers){
	    my $flag = 1;
	    foreach (@tboards){
		if($sid eq $_){
		    foreach (@tusers){
			$ret .= qq!
<TR>
  <TD>
  <A HREF=$config->{'cgidir'}/user.cgi?op=userinfo&uid=$_&page=1&postsper=$postsper>$uidh->{$_}</A></TD>
  <TD WIDTH=25%>$time</TD></TR>
    !; $flag = 0;
		    } 
		}
	    }
	    if($flag){ 
		$ret .= "<TR><TD COLSPAN=2>$lang->{'no_moderators'}</TD></TR>";
	    }
	}
	else{ $ret .= "<TR><TD COLSPAN=2>$lang->{'no_moderators'}</TD></TR>"; }
    }
    
  }

  $self->{'content'} = $ret;
  $ret = $self->SUPER::get();
  
  return $ret;
}

return 1;
