package Templates::Admin::GAOMU;

use SmallPigVars qw($config);
use SPDB;
use CGI qw(:standard :cgi-lib);
use Templates::Admin::Block;
use Templates::Admin::OptBlock;

use strict;

my @ISA = qw(Templates::Admin::Block);

my $lang;

sub new{
  my ($class) = @_;
  my $self = Templates::Admin::Block->new();
  $self->{'spdb'} = SPDB->new;
  
  return bless $self, $class;
}

sub DESTROY{
    my $self = shift;
    my $spdb = $self->{'spdb'};
    $spdb->db_disconnect($spdb->{'dbh'});
}

sub display{
  my ($self, $STATE) = @_;
  my $op = "";
  $op = $STATE->{'op'};
  my $theme = $STATE->{'theme'};

  $lang = $STATE->{'langptr'};

  my $standardindex = Templates::Admin::StandardIndex->new($STATE);

  my $content = $self->_get_usersindex($STATE);
  my $classvars = {('content' => $content)};
  my $usersindex = Templates::Admin::OptBlock->new($classvars, $theme);
  my $pageindex;
  ($content, $pageindex) = $self->_get_userslist($STATE);
  $classvars = {('content' => $content, 'space' => "<P>")};
  my $userslist = Templates::Admin::OptBlock->new($classvars, $theme);
  
  my $ret;
  $ret = start_form(-method=>"post", -action=>"$config->{'cgidir'}/admin.cgi");
  $ret .= $standardindex->get();
  $ret .= $usersindex->get();
  $ret .= $userslist->get();
  $ret .= $pageindex if $pageindex;
  $ret .= hidden('prev_op', 'modifyuser');
  if($op eq "grantadmin"){
    $ret .= "<FONT SIZE=1>";
    $ret .= submit(-name=>"op", -value=>$lang->{'GrantAdmin'});
    $ret .= "</FONT>";
  }
  else{
    $ret .= "<FONT SIZE=1>";
    $ret .= submit(-name=>"op", -value=>$lang->{'ModifyProfile'});
    $ret .= submit(-name=>"op", -value=>$lang->{'ModifyPreferences'});
    $ret .= submit(-name=>"op", -value=>$lang->{'DeleteUser'});
    $ret .= "</FONT>";
  }
  $ret .= end_form()."</TD>";

  return $ret;
}

sub _get_usersindex{
  my ($self, $STATE, $pageindex) = @_;
  my $spdb = $self->{'spdb'};
  my $DBH = $spdb->{'dbh'};

  my ($op, $page, $postsper, $uid) = ("","","","");
  ($op, $page, $postsper, $uid) = 
    map{ $STATE->{$_} } qw(op page postsper uid);
  my $letter = "";
  $letter = $STATE->{'letter'};
  my ($ret, $page_index);
  $ret = "<TR><TD ALIGN=center>";
  my ($i, $j) = ("a", "A");
  my $where;
  if($op eq "grantadmin"){ $where = "AND active=1 "; }
  else{ 
      # --- <time> Wed Sep  1 14:42:29 PDT 1999
      # --- select user is active or not yet activated
      $where .= "AND (active=1 OR active=0) "; 
  }
  
  # --- 0-9
  my $tmp;
  for(my $i=0; $i<10; $i++){
      my $tmp1 = $DBH->quote("$i%");
      $tmp .= "username LIKE $tmp1 OR ";
  }
  $tmp =~ s/OR $//;
  if($spdb->db_count("Users", "($tmp) AND isadmin=0 $where ") <= 0){
      $ret .= " 0-9 |";
  }
  elsif($letter eq "0-9"){
      $ret .= " <B>0-9</B> |";
  }
  else{
      $ret .= " <A HREF=$config->{'cgidir'}/admin.cgi?op=$op&letter=0-9&page=1&postsper=$postsper>0-9</A> |";
  }

  for(;($i ne "z"); ++$i, ++$j){
    my $tmp = $DBH->quote("$i%");
    if($spdb->db_count("Users", "username LIKE $tmp AND isadmin=0 $where ") <= 0){
      $ret .= " $i$j |";
    }
    elsif($letter eq $i){
      $ret .= " <B>$i$j</B> |";
    }
    else{
      $ret .= 
 " <A HREF=$config->{'cgidir'}/admin.cgi?op=$op&letter=$i&page=1&postsper=$postsper>$i$j</A> |";
    }
  }  
  
  if($spdb->db_count("Users", "username LIKE 'z%' AND isadmin=0 $where ") <= 0){
      $ret .= " zZ";
  }
  elsif($letter eq $i){
      $ret .= " <B>zZ</B> |";
  }
  else{
      $ret .= " <A HREF=$config->{'cgidir'}/admin.cgi?op=$op&letter=z>zZ</A>";
  }
  $ret .= "</TD></TR>";

  return $ret;
}

sub _get_userslist{
  my ($self, $STATE) = @_;
  my $spdb = $self->{'spdb'};
  my $DBH = $spdb->{'dbh'};
  my $theme = $STATE->{'theme'};
  
  my ($op, $letter, $postsper, $page) = ("","","","");
  ($op, $letter, $postsper, $page) = 
    map{ $STATE->{$_} } qw(op letter postsper page);
  my $letterq = $DBH->quote("$letter%");
  my ($ret, $pageindex);

  my $select = "uid, username,
                date_format(registered, \"$config->{date_format}\")";

  my $tmp;
  if($letter eq "0-9"){
      for(my $i=0; $i<10; $i++){
	  my $tmp1 = $DBH->quote("$i%");
	  $tmp .= "username LIKE $tmp1 OR ";
      }
      $tmp =~ s/OR $//;
  }
  else{
      $tmp = "username LIKE $letterq";
  }

  my $where = my $where1 = "($tmp) AND uid>1 ";
  if($op eq "grantadmin"){ $where .= "AND active=1 "; }
  else{ 
      # --- select user is active or not yet activated
      $where .= "AND (active=1 OR active=0) "; 
  }
  my $tmplimit = $postsper;
  if($page == 1){
    $where .= "LIMIT $tmplimit";
  }
  else{ 
    my $tmpstart;
    $tmpstart = ($page-1)*$tmplimit; 
    $where .= "LIMIT $tmpstart, $tmplimit";
  }
  
  my ($users) = $spdb->db_select_many(1, $select, "Users", 
				     $where);
  
  $ret .= qq!
<TR BGCOLOR=$theme->{'dhdrcolor'} CELLPADDING=2>
<TD WIDTH=10% CLASS=bheader2>$lang->{'select'}</TD>
<TD CLASS=bheader2>$lang->{'loginusername'}</TD>
<TD WIDTH=25% CLASS=bheader2>$lang->{'reg_on'}</TD>
</TR>
  !;

 
  my $flag=1;
  foreach (@$users){
    my ($uid, $username, $registered) = @$_;

 $registered =~ s/(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/$lang->{$1}/ig;

    $ret .= qq!
<TR>
  <TD WIDTH=10%><font size=1><INPUT TYPE=radio NAME=selecteduid VALUE=$uid></font></TD>
  <TD><A HREF=$config->{'cgidir'}/user.cgi?op=userinfo&uid=$uid&page=1&postsper=$postsper>$username</A></TD>
  <TD WIDTH=25%>$registered</TD>
</TR>
  !; $flag=0;
  }
  
  if($flag){
    $ret .= "<TR><TD COLSPAN=3>$lang->{'no_user1'} '$letter' 
$lang->{'no_user2'}</TD></TR>";
  }

  my $totalnums = $spdb->db_count("Users", $where1);
  if($totalnums > 0){
    use Templates::Admin::PageIndex;
    my $obj = Templates::Admin::PageIndex->new($totalnums, $postsper, $page,
					       "", $theme);
    my $url = "&letter=$letter&postsper=$postsper";
    $pageindex .= $obj->get($op, $url);
  }
  
  return ($ret, $pageindex);
}

return 1;
