package Templates::Admin::Caution;

use SmallPigVars qw($config);
use SmallPig;

use CGI qw(:standard *table :cgi-lib);

use strict;
use vars qw(@ISA $DBH);

@ISA = qw(Templates::Admin::OptBlock);

my %CACHE;

sub new{
  my ($class, $theme, $header, $cellpadding, $btitle, 
      $bdrcolor, $bgcolor) = @_;
  $bdrcolor ||= $theme->{'inbgcolor'};
  $bgcolor ||=  $theme->{'inbgcolor'};
  
  my $classvars = {('title' => $btitle,
		    'bdrcolor' => $bdrcolor,
		    'bgcolor' => $bgcolor)};

  my $self = Templates::Admin::OptBlock->new($classvars, $theme);
  $self->{'cellpadding'} = $cellpadding || 10;
  $self->{'header'} = $header;

  my $id = join '', sort values %$self, "caution";
  return $CACHE{$id} if $CACHE{$id};
  return $CACHE{$id} = bless $self, $class;
}

sub set_header{
  my ($self, $header) = @_;
  $self->{'header'} = $header;
}

sub get{
  my ($self, $content) = @_;
  my $cp = $self->{'cellpadding'};
  my $hdr = $self->{'header'};
  $self->{'content'} = 
    CGI::Tr({},
    [CGI::td({},
    [table({-border=>0, -cellpadding=>$cp},
     CGI::Tr({},
    [CGI::td({-class=>$hdr}, [$content])]))])]); 
  $self->SUPER::get();
}
 
return 1;




