package SPDB;

use SmallPigVars qw($config);

use strict;
use DBD::mysql;
use DBI;

sub new{
  my ($class) = @_;
  my $self = {};
  $self->{'dbh'} ||= db_connect();
  $self->{'connect'}++;
  $self->{'dbcalls'} = 0;

  return bless $self, $class;
}

sub DESTROY{
    my $self = shift;
    db_disconnect($self->{'dbh'}) if $self->{'dbh'} && $self->{'connect'};
}

sub _db_handler{
  my ($self, $query) = @_;
  my $DBH = $self->{'dbh'};

  my $sth = $DBH->prepare($query) or
    die "Cant prepare: $query.";
  $sth->execute() or
    die "Cant execute: $query.";
  
  return $sth;
}

sub _db_handler_done{
    shift->finish();
}

sub _db_get_query{
  my($select, $from, $where, $other) = @_;

  my $query = "SELECT $select ";

  $from =~ s/(Cats|Boards|BoardBelongToCat|Posts|ParentAndChild|MostParents|FileAttach|AnonPosts)/$config->{'rest_tbl'}$1/g if $config->{'rest_tbl'};
  $from =~ s/(Users|BoardPrefs|Moderators|GroupMems|SubscribeBoards)/$config->{'user_tbl'}$1/g if $config->{'user_tbl'};

  $query   .= "FROM $from " if $from;
  $query   .= "WHERE $where " if $where;
  $query   .= "$other" if $other;
  return $query;
}

sub db_select_cols{
  my $self = shift;
#  $self->{'dbcalls'}++;
  my $ret = $self->db_select_cols_ref(@_);
  return $ret?@$ret:undef;
}

sub db_select_cols_ref{
  my $self = shift;
  my $sth = $self->_db_handler(_db_get_query(@_));
  return undef unless $sth->rows();
  my $ret = $sth->fetch();
  _db_handler_done($sth);
  
  return $ret;
}

sub db_select_hash{
  my $self = shift;
  my $ret = $self->db_select_hash_ref(@_);
  return $ret?@$ret:();
}

sub db_select_hash_ref{
  my $self = shift;
  my $sth = $self->_db_handler(_db_get_query(@_));
  return undef unless $sth->rows();
  my $ret = $sth->fetchrow_hashref();
  _db_handler_done($sth);
  
  return $ret;
}

sub db_select_many_new{
    my $self = shift;
    my $flag = shift;
    my $sth = $self->_db_handler(_db_get_query(@_));
    return undef unless $sth->rows();
    
    my $nums = $sth->rows;

    return ($sth, $nums);
}

sub db_handler_done{
    my ($self, $sth) = @_;
    _db_handler_done($sth) if $sth;
}

sub db_select_many{
  my $self = shift;
  my $flag = shift;
  my $sth = $self->_db_handler(_db_get_query(@_));
  return undef unless $sth->rows();

  my $nums = $sth->rows;
  my @ret;
  unless($flag){
    while(my $row = $sth->fetchrow_hashref()){
      push @ret, [%$row];
    }
  }
  else{
    while(my $row = $sth->fetch()){
      push @ret, [@$row];
    }
  }
  _db_handler_done($sth);

#  $self->{'dbcalls'}++;
  return (\@ret, $nums);
}

sub db_insert{
  my ($self, $table, $data) = @_;
  my $DBH = $self->{'dbh'};
  
  $table =~ s/(Cats|Boards|BoardBelongToCat|Posts|ParentAndChild|MostParents|FileAttach|AnonPosts)/$config->{'rest_tbl'}$1/g if $config->{'rest_tbl'};
  $table =~ s/(Users|BoardPrefs|Moderators|GroupMems|SubscribeBoards)/$config->{'user_tbl'}$1/g if $config->{'user_tbl'};

  my ($cnames, $values);
  foreach (keys(%$data)){
    $cnames .= "$_, ";
    $values .= $DBH->quote($data->{$_}).", ";
  }
  $cnames =~ s?(.*), *$?$1?g;
  $values =~ s?(.*), *$?$1?g;
  my $query = "INSERT INTO $table ($cnames) VALUES ($values)";
  $DBH->do($query) ||
    return (0, "Cant insert to sql server. Reason: $DBI::errstr");
  return (1);
}

sub db_update{
  my ($self, $table, $data, $where) = @_;
  my $DBH = $self->{'dbh'};

  $table =~ s/(Cats|Boards|BoardBelongToCat|Posts|ParentAndChild|MostParents|FileAttach|AnonPosts)/$config->{'rest_tbl'}$1/g if $config->{'rest_tbl'};
  $table =~ s/(Users|BoardPrefs|Moderators|GroupMems|SubscribeBoards)/$config->{'user_tbl'}$1/g if $config->{'user_tbl'};

  my $query   = "UPDATE $table ";
  my $pairs = "";
  foreach (keys(%$data)){
    $pairs .= " $_=$data->{$_}, ";
  }
  $pairs =~ s/(.*), $/$1/gi;
  $query  .= "SET $pairs ";
  $query  .= "WHERE $where";

  $DBH->do($query) ||
    return (0, "Cant update to sql server. $query Reason: $DBI::errstr");
  return (1);
}

sub db_delete{
  my ($self, $table, $where) = @_;
  my $DBH = $self->{'dbh'};

  $table =~ s/(Cats|Boards|BoardBelongToCat|Posts|ParentAndChild|MostParents|FileAttach|AnonPosts)/$config->{'rest_tbl'}$1/g if $config->{'rest_tbl'};
  $table =~ s/(Users|BoardPrefs|Moderators|GroupMems|SubscribeBoards)/$config->{'user_tbl'}$1/g if $config->{'user_tbl'};

  $where = "WHERE $where" if $where;

  my $query = "DELETE FROM $table $where";
  $DBH->do($query) ||
    die "Cant delete rows. query: $query Reason: $DBI::errstr";
}

sub db_do_query{
  my ($self, $query) = @_;
  my $DBH = $self->{'dbh'};
  
  $DBH->do($query) || print "Cant execute. Reason: $DBI::errstr\n";
}

sub db_drop_table{
  my ($self, $table) = @_;
  my $DBH = $self->{'dbh'};
  
  my $query = "DROP TABLE $table";
  $DBH->do($query) ||
    die "Cant drop table. Reason: $DBI::errstr";
}

sub db_connect{
  return DBI->connect("dbi:$config->{'dbdriver'}:$config->{'dbname'}:$config->{'dbhost'}:$config->{'dbport'}", 
		      $config->{'dbuser'}, $config->{'dbpass'}, {PrintError => 0});
}

sub db_disconnect{
  my($DBH) = @_;
  
  if($DBH){  
      $DBH->disconnect();
      #or  die "Cant disconnect from database. Reason: $DBI::errstr"; 
  }
}

sub db_lock{
  my ($self, @wtable, @rtable) = @_;
  my $DBH = $self->{'dbh'};
  
  my $locks;
  foreach (@wtable){ 

      s/(Cats|Boards|BoardBelongToCat|Posts|ParentAndChild|MostParents|FileAttach|AnonPosts)/$config->{'rest_tbl'}$1/g if $config->{'rest_tbl'};
      s/(Users|BoardPrefs|Moderators|GroupMems|SubscribeBoards)/$config->{'user_tbl'}$1/g if $config->{'user_tbl'};

      $locks .= "$_ WRITE, "; 

  }
  foreach (@rtable){ 
      
      s/(Cats|Boards|BoardBelongToCat|Posts|ParentAndChild|MostParents|FileAttach|AnonPosts)/$config->{'rest_tbl'}$1/g if $config->{'rest_tbl'};
      s/(Users|BoardPrefs|Moderators|GroupMems|SubscribeBoards)/$config->{'user_tbl'}$1/g if $config->{'user_tbl'};
      
      $locks .= "$_ READ, "; 

  }
  $locks =~ s/, $//;

  $DBH->do("LOCK TABLES $locks") ||
      return (0, "Cant lock tables @wtable @rtable. Reason: $DBI::errstr");
  return (1);
}

sub db_unlock{
  my ($self) = @_;
  my $DBH = $self->{'dbh'};

  $DBH->do("UNLOCK TABLES") ||
      return (0, "Cant unlock tables. Reason: $DBI::errstr");
  return (1);
}

sub db_date{
  my ($self, $format) = @_;
  my $select = "NOW()";
  $select = "date_format($select, '$format')" if $format;
  my ($time) = $self->db_select_cols($select);
  return $time;
}

sub db_count{
  my ($self, $from, $where) = @_;
  my @query = ("COUNT(*)", $from, $where);
  my $sth = $self->_db_handler(_db_get_query(@query));
  my ($ret) =  $sth->fetchrow();
  _db_handler_done($sth);
  
  return $ret;
}

sub db_sum{
  my ($self, $select, $from, $where) = @_;
  my @query = ("SUM($select)", $from, $where);
  my $sth = $self->_db_handler(_db_get_query(@query));
  my ($ret) =  $sth->fetchrow();
  _db_handler_done($sth);
  
  return $ret;
}

sub db_max{
  my ($self, $select, $from, $where) = @_;
  my @query = ("MAX($select)", $from, $where);
  my $sth = $self->_db_handler(_db_get_query(@query));
  my ($ret) =  $sth->fetchrow();
  _db_handler_done($sth);
  
  return $ret;
}

sub db_min{
  my ($self, $select, $from, $where) = @_;
  my @query = ("MIN($select)", $from, $where);
  my $sth = $self->_db_handler(_db_get_query(@query));
  my ($ret) =  $sth->fetchrow();
  _db_handler_done($sth);
  
  return $ret;
}

return 1;
