package Ops::FileAttach;

use SmallPigVars qw($config);
use SmallPig;
use strict;
use vars qw(@ISA);

my $lang;

sub new{
  my ($class, $fid, $spdb, $STATE) = @_;
  
  my $classvars = {('title' => $lang->{'file_attach1'})};  
  my $self = {};
  $self->{'fid'} = $fid;
  $self->{'spdb'} = $spdb || SPDB->new();
  $self->{'STATE'} = $STATE;

  $lang = SmallPig::get_lang_ptr($STATE->{lang}, "LComments");
  
  return bless $self, $class;
}

sub get_info{
  my ($self, $fids, $cid, $del) = @_;
  my ($fid, $ret, $select, $where, $img, @fids, $spdb);
  $fid = $self->{'fid'};
  $spdb = $self->{'spdb'};

  if($fids){
      @fids = split(/\#/, $fids);
      unshift @fids, $fid if $fid;
      foreach (@fids){
	  $where .= "fid=$_ OR ";
      }
      $where =~ s/(.+) OR $/$1/;
  }
  elsif($cid){
      $where = "cid=$cid";
  }
  else{return}
  $select = "fid, fname, fdesc, fsize, date"; 
  my ($files) = $spdb->db_select_many_new(1, $select, "FileAttach", $where);
  
  if($files){
      
      while (my ($fid, $fname, $fdesc, $fsize, $date) = $files->fetchrow_array){
	  $date =~ s/\s+/-/g;
	  my $fnameurl;
	  ($fnameurl = $fname) =~ s/(\s+|\\)/-/g;
	  my $fnameurl = "<A HREF=\"$config->{'file_url'}/$date-$fnameurl\">$fname</A>";
	  if($del){
	      $img = qq|<INPUT TYPE="image" name="DeleteFile $fname($fid)" border=0 src="$config->{'imagesdir'}/delete_file.gif">|;
	  }
	  $ret .= "$img $fnameurl $fsize bytes $fdesc<BR>";    
      }
   
      $spdb->db_handler_done($files);
  }

  return $ret;
}

sub save_file_attachment{
  my ($self) = @_;
  
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};

  my ($fids) = map{ $STATE->{$_} } qw(fids);

  # --- error checking
  my $error_msg;
  if(split(/\#/, $fids) >= $config->{'file_max'}){
      $error_msg = 
"$lang->{'allow_attach'} $config->{'file_max'} $lang->{'files'}."
  }
  
  # --- if error msg, print it out
  if($error_msg){
      return (0, $error_msg);
  }

  require CGI;
  my $cgi = new CGI;

  my ($fid, $date, $fname, $fsize, $ftype);
  my ($file_hdl, $file_desc) = 
      map { $cgi->param($_) } qw(file_hdl file_desc);

  # --- if there is no file handler
  if(!$file_hdl){
      return (0);
  }
  
  $ftype = $STATE->{'ftype'};
  $fid = $self->{'fid'};
  $date = $spdb->db_date();
  $fname ="$date-$file_hdl";
  $fname =~ s/(\s+|\\)/-/g;

  # --- save the file to disk
  $fsize = $self->_save_file($file_hdl, $fname);

  my @fids = split(/\#/, $fids);
  my $where;
  foreach (@fids){
      $where .= "fid=$_ OR ";
  }
  $where =~ s/OR $//;

  my $fsize1 = $spdb->db_sum("fsize", "FileAttach", $where) if $where;

  if(!$error_msg && $fsize1+$fsize > $config->{'file_size'}){
      my $tmp = $self->_comp_byte($config->{'file_size'});
      $error_msg = "$lang->{'allow_size'} $tmp."
  }
  # --- if error msg, print it out
  if($error_msg){
      return (0, $error_msg);
  }

  if($fsize == -1){
      return (0, $fname);
  }

  #######################################################################
  # --- insert to database
  # ---
  $spdb->db_lock(("FileAttach"));

  my ($fid) = $spdb->db_max("fid", "FileAttach");
  $fid = 0 if !$fid; $fid++;

  my $data = {('fid'=>$fid, 'fname'=>$file_hdl, 'fdesc'=>$file_desc,
	       'fsize'=>$fsize, 'date'=>$date, 'fcontenttype'=>$ftype)};

  $spdb->db_insert("FileAttach", $data);  

  $spdb->db_unlock();
  #######################################################################

  return ($fid);
}

sub set_fid{
    my ($self, $fid) = @_;
    my $spdb = $self->{'spdb'};
    
    # --- fid is not null
    if($fid){
	$self->{'fid'} = $fid; 
    }
    # --- probably it is a new post
    else{
	my $fid = $spdb->db_max("fid", "FileAttach") || 0;
	$self->{'fid'} = ++$fid; 
    }
}

sub update_files{
  my ($self, $data, $fids) = @_;
  my $spdb = $self->{'spdb'};
  my $where;
  foreach (@$fids){
    $where .= "fid=$_ OR ";
  }
  $where =~ s/(.+) OR $/$1/;
  $spdb->db_update("FileAttach", $data, $where);
}

sub delete_files{
  my ($self, $where, $fid) = @_;
  my $spdb = $self->{'spdb'};
  my $STATE = $self->{'STATE'};
  
  # --- set the fids
  my $fids = $STATE->{'fids'};
  $fids =~ s/^$fid$//;
  $fids =~ s/^fid#//;
  $fids =~ s/([^\#]+)\#$fid(\#.+)/$1$2/;
  $fids =~ s/\#$fid$//;
  $STATE->{'fids'} = $fids;

  # --- unlink each file attachment
  $self->_unlink_files($where);
  # --- delete the entries in SPFileAttach
  $spdb->db_delete("FileAttach", $where);
}

sub _unlink_files{
  my ($self, $where) = @_;
  my $spdb = $self->{'spdb'};
  # --- unlink each file attachment
  my ($fnames) = 
    $spdb->db_select_many_new(1, "fname, date", "FileAttach", $where);

  if($fnames){

      while (my ($fname, $date) = $fnames->fetchrow_array){
	  $date =~ s/\s+/-/g;
	  unlink("$config->{'file_path'}/$date-$fname");
      }

      $spdb->db_handler_done($fnames);

  }
}

sub _save_file{
    my ($self, $file_hdr, $file_name) = @_;
    my ($ret, $bytesread, $buffer);
    open FILE, ">$config->{'file_path'}/$file_name" ||
	return -1;
    binmode(FILE);
    while ($bytesread=read($file_hdr,$buffer,1024)) {
	print FILE $buffer;
    }
    close FILE;
    $ret = -s "$config->{'file_path'}/$file_name";
    return $ret;
}

sub _comp_byte{
  my ($self, $size) = @_;
  if($size){
      $size = $size / 1000;
      if($size =~ /^((\d{2}|\d{1}|\d{3})\.\d).+/ || $size =~ /^(\d{2})\.0+$/){
	  $size = $1."k";
      }
      else{
	  $size = $size / 1000;
	  $size =~ s/(\d+\.\d).+/$1/;
	  $size .= "M";
      }
  }
  return $size;
}

return 1;
