package Ops::Admin;

use SmallPigVars qw($config);

use CGI qw(:standard :cgi-lib);
use CGI::Cookie ();

use strict;

my $lang;

# --- Admin constructor
sub new{
  my ($class, $STATE, $spdb) = @_;
  my $self = {};
  if($spdb){ $self->{'spdb'} = $spdb; }
  else{  require SPDB; $self->{'spdb'} = SPDB->new; }
  $self->{'STATE'}   = $STATE;
  
  $lang = SmallPig::get_lang_ptr($STATE->{lang}, "LAdmin");

  my $id = join '', sort values %$self, "admin";
  return bless $self, $class;
}

sub DESTROY{
    my $self = shift;
    my $spdb = $self->{'spdb'};
    $spdb->db_disconnect($spdb->{'dbh'});
}

# --- save moderator or group 
sub save_mod_or_group{
  my ($self) = @_;
  # --- get the caution obj
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};

  my ($tboards, $tusers, $op, $prev_op, $allowwrite) = 
    map { $STATE->{$_} } qw(boards users op prev_op allowwrite);

  $allowwrite = ($allowwrite eq "yes")?1:0;

  my (@tboards, @tusers);
  if($tboards && $tusers) {
    @tboards = split("#", $tboards); 
    @tusers = split("#", $tusers);

    my ($bau) = $spdb->db_select_many(1, "sid, uid", "Moderators");
    
    foreach (@tboards){
      my $sid = $_;
    
      foreach (@tusers){
	  my $uid = $_; my $cnt = 0; my $flag = 1;
	  
	  if($prev_op !~ /revokemod/ && $prev_op !~ /revokegroup/){
	      # --- filter mod
	      foreach (@$bau){
		  my ($tsid, $tuid) = @$_; 
		  if($uid == $tuid && $sid eq $tsid){
		      $flag = 0; splice @$bau, $cnt, 1; $cnt++;
		  }
	      }
	      my $status;
	      my $time = $spdb->db_date();
	      if($op eq $lang->{'SaveGroup'}){
		  if($flag){
		      
		      my $sidq = $DBH->quote($sid);
		      my ($tuid) = $spdb->db_select_cols("uid, allowwrite", 
							 "GroupMems",
							 "uid=$uid AND sid=$sidq");
		      
		      if($tuid){
			  my ($succ, $errmsg) = 
			      $spdb->db_update("GroupMems", {('allowwrite'=>$allowwrite)},
					       "uid=$uid AND sid=$sidq");
		      }
		      else{
			  $spdb->db_insert("GroupMems", 
					   {('sid'=>$sid, 'uid'=>$uid,
					     'assigned'=>$time, 
					     'allowwrite'=>$allowwrite)}); 
		      }
		  }
	      }
	      else{
		  if($flag){
		      $spdb->db_insert("Moderators", 
				       {('sid'=>$sid, 'uid'=>$uid,
					 'assigned'=>$time)}); 
		      # --- delete the user in GroupMems
		      my $sidq = $DBH->quote($sid);
		      $spdb->db_delete("GroupMems", "uid=$uid AND sid=$sidq");
		  }
	      }
	  }
	  else{
	      my $sidq = $DBH->quote($sid);
	      my $where = "uid=$uid AND sid=$sidq";
	      if($prev_op =~ "revokemod"){
		  $spdb->db_delete("Moderators", $where);
	      }
	      else{
		  $spdb->db_delete("GroupMems", $where);
	      }
	      # --- erase rows from SubscribeBoard
	      $spdb->db_delete("SubscribeBoard", $where);
	  }
      }
    }
  }
  
  my $tmp = $lang->{'save_moderators'};
  my $msg = $lang->{'save_mod'};
  if($op eq $lang->{'SaveGroup'}){
    $tmp = $lang->{'save_group1'};
    $msg = $lang->{'save_group2'};
  };
 
  return (1, $msg, $tmp);
}

# --- remove category
sub remove_category{
  my ($self) = @_;
  # --- get the caution obj
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};

  my $catid = $STATE->{'selectedcategory'};
  my $catidq = $DBH->quote($catid);

  # --- make sure at least one item is selected
  if(!$catid){
    return (0, $lang->{'at_least_one'});
  }

  # --- make sure the category dont have any board
  if($spdb->db_count("BoardBelongToCat", "catid=$catidq") > 0){
    return (0, $lang->{'has_boards'});
  }

  # --- find the catorder
  my ($catorder) = $spdb->db_select_cols("catorder", "Cats",
					"catid=$catidq");
  my $cnt = $spdb->db_count("Cats");
  for(my $i=$catorder+1; $i<=$cnt; $i++){
    $spdb->db_update("Cats", {('catorder'=>'catorder-1')},
		    "catorder=$i");
  }

  $spdb->db_delete("Cats", "catid=$catidq") if $catid;

  return (1, $lang->{'category_deleted2'}, $lang->{'category_deleted1'});
				       
}

sub create_cat{
  my ($self) = @_;
  # --- get the caution obj
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};

  my ($catid, $cattitle, $catorder, $prev_catorder, $prev_catid, $uid, 
      $prev_op) = 
	  map { $STATE->{$_} } 
  qw(categoryid categorytitle categoryorder prev_catorder prev_catid uid
     prev_op);

  if($catid =~ /\W/g){
      return (0, $lang->{'non_word_cat'}, "");
  }

  # --- if the keyword is too long
  if(length($catid) > 20){
    return (0, $lang->{'keyword_too_long'});
  }
  
  my ($catidq, $cattitleq, $prev_catidq) = 
      map{ $DBH->quote($_) } 
  ($catid, $cattitle, $prev_catid);

  my ($succ, $errmsg) = $spdb->db_lock(("Cats"));

  if($spdb->db_count("Cats", "catid=$catidq OR cattitle=$cattitleq") &&
     !$prev_catid){
      return (0, $lang->{'dup_cat'});
  }

  my $tmpq = $DBH->quote($prev_catid);
  ($prev_catorder) = $spdb->db_select_cols("catorder", "Cats",
					   "catid=$tmpq");
					   
  my ($cats, $cnt) = $spdb->db_select_many(1, "catid, catorder", "Cats", "",
					   "ORDER BY catorder DESC");
  
  my (%cats, $plus, $iscreate);
  my ($catidq, $cattitleq, $prev_catidq) = 
      map{ $DBH->quote($_) } 
  ($catid, $cattitle, $prev_catid);

  if($cnt == 0){
      my $data = {('catid'=>$catid, 
		   'cattitle'=>$cattitle,
		   'catorder'=>$catorder)};
      my ($succ, $errmsg) = $spdb->db_insert("Cats", $data);    
      goto RET;
  }
  
  $plus = 0;
  push @$cats, [$catid, $catorder];
  foreach (sort { $a->[1] <=> $b->[1] } @$cats){
      my ($ocatid, $ocatorder) = @$_;
      
      if($catorder == $ocatorder){
	  $plus = 1;
	  $cats{$ocatid} = $ocatorder+1;
	  $cats{$catid} = $catorder;
      }
      elsif($plus){
	  $cats{$ocatid} = $ocatorder+1;
      }
      else{
	  $cats{$ocatid} = $ocatorder;
      }
  }

  foreach (keys(%cats)){
      my $catidq = $DBH->quote($_);
      if($_ ne $catid){
	  $spdb->db_update("Cats", {('catorder'=>$cats{$_})},
			   "catid=$catidq");
      }
      else{
	  my $data = {('catid'=>$catid, 
		       'cattitle'=>$cattitle,
		       'catorder'=>$catorder)};
	  my ($succ, $errmsg) = $spdb->db_insert("Cats", $data);
      }
  }

 RET:  
  $spdb->db_unlock();

  return (1, $lang->{'cat_created2'}, $lang->{'cat_created1'});
}

sub save_category{
  my ($self) = @_;
  # --- get the caution obj
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};

  my ($catid, $cattitle, $catorder, $prev_catorder, $prev_catid, $uid, 
      $prev_op) = 
    map { $STATE->{$_} } 
  qw(categoryid categorytitle categoryorder prev_catorder prev_catid uid
     prev_op);

  if($catid =~ /\W/g){
      return (0, $lang->{'non_word_cat'}, "");
  }
  
  # --- if there is no catid or cattitle, return error
  if(length($catid)==0 || length($cattitle)==0){
    return (0, $lang->{'form_not_fill_out'});
  }

  # --- if the keyword is too long
  if(length($catid) > 20){
    return (0, $lang->{'keyword_too_long'});
  }

  my ($catidq, $cattitleq, $prev_catidq) = 
      map{ $DBH->quote($_) } 
  ($catid, $cattitle, $prev_catid);

  my ($succ, $errmsg) = $spdb->db_lock(("Cats", "BoardBelongToCat"));

  if($spdb->db_count("Cats", "catid=$catidq OR cattitle=$cattitleq") &&
     !$prev_catid){
      return (0, $lang->{'dup_cat'});
  }

  if($prev_catid ne $catid && $prev_op eq "modifycategory" &&
     $spdb->db_count("Cats", "catid=$catidq")){
      return (0, $lang->{'dup_cat'});
  }

  my $time = $spdb->db_date();
  my ($succ, $errmsg) = (1);
  # --- create a new category
  # --- first we need to know the category is needed to 
  # --- reorder or not. If so, we need to update the order
  # --- of others before changet the catorder.
  # --- find the number of categories
 
  my $tmpq = $DBH->quote($prev_catid);
  ($prev_catorder) = $spdb->db_select_cols("catorder", "Cats",
					   "catid=$tmpq");
					   
  my ($cats, $cnt) = $spdb->db_select_many(1, "catid, catorder", "Cats");
  
  my (%cats, $plus, $iscreate);
  my ($catidq, $cattitleq, $prev_catidq) = 
      map{ $DBH->quote($_) } 
  ($catid, $cattitle, $prev_catid);

  $iscreate = 1 
  if($STATE->{'prev_op'} ne "modifycategory" &&
     $spdb->db_count("Cats", "catid=$catidq")<=0);

  if($cnt == 0){
      my $data = {('catid'=>$catid, 
		   'cattitle'=>$cattitle,
		   'catorder'=>$catorder)};
      my ($succ, $errmsg) = $spdb->db_insert("Cats", $data);    
  }
  
  foreach (@$cats){
      my ($ocatid, $ocatorder) = @$_;
  
      if($iscreate){
	  if($catorder == $ocatorder){
	      $plus = 1;
	      $cats{$ocatid} = $ocatorder+1;
	      $cats{$catid} = $catorder;
	  }
	  elsif($plus){
	      $cats{$ocatid} = $ocatorder+1;
	  }
	  else{
	      $cats{$ocatid} = $ocatorder;
	  }
      }
      else{
	  if($prev_catorder == $catorder){ last; }
	  elsif($prev_catid eq $ocatid){ 
	      $cats{$ocatid} = $catorder;
	  }
	  elsif($catorder >= $ocatorder && $prev_catorder < $ocatorder){
	      $cats{$ocatid} = $ocatorder-1;
	  }
	  elsif($catorder <= $ocatorder && $prev_catorder > $ocatorder){
	      $cats{$ocatid} = $ocatorder+1;
	  }
	  else{
	      $cats{$ocatid} = $ocatorder;
	  }
	  
      }
      
  }

  if(!%cats){
      $cats{$prev_catid} = $prev_catorder;
  }

  foreach (keys(%cats)){
      my $catidq = $DBH->quote($_);
      if(!$iscreate){
	  if($_ ne $prev_catid){
	      my ($succ, $errmsg) = 
		  $spdb->db_update("Cats", {('catorder'=>$cats{$_})},
				   "catid=$catidq");
	  }
	  else{
	      my $data = {('catid'=>$DBH->quote($catid), 
			   'cattitle'=>$cattitleq,
			   'catorder'=>$catorder)};
	      my ($succ, $errmsg) = $spdb->db_update("Cats", $data, 
						     "catid=$prev_catidq");

	      # --- if the catid is not same as the old one
	      if($prev_catid ne $catid){
		  $data = {('catid'=>$DBH->quote($catid))};
		  ($succ, $errmsg) = 
		      $spdb->db_update("BoardBelongToCat", 
				       $data, "catid=$prev_catidq");
		  print $errmsg;
	      }
	  }
      }
      else{
	  if($_ ne $catid){
	      $spdb->db_update("Cats", {('catorder'=>$cats{$_})},
			       "catid=$catidq");
	  }
	  else{
	      my $data = {('catid'=>$catid, 
			   'cattitle'=>$cattitle,
			   'catorder'=>$catorder)};
	      my ($succ, $errmsg) = $spdb->db_insert("Cats", $data);
	  }	  
      }
  }
  
  $spdb->db_unlock();
  
  if($iscreate){
      return (1, $lang->{'cat_created2'},$lang->{'cat_created1'});
  }
  else{
      return (1, $lang->{'category_updated2'},
	      $lang->{'category_updated1'});
  }
}

# --- save board
sub save_board{
  my ($self) = @_;
  # --- get the caution obj
  my ($STATE, $spdb) =  map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};

  my ($succ, $errmsg) = (1);
  
  my ($boardsid, $boardtitle, $boardintrotext, $boardhtml, 
      $boardlevel, $boardactive, $boardexpire, $catasorder,
      $boardapproved, $boardfa, $boardsub, $boardmarkup, $prev_sid) = 
    map { $STATE->{$_} } 
  qw(boardsid boardtitle boardintrotext 
     boardhtml boardlevel boardactive boardexpire category
     boardapproved boardfa boardsub boardmarkup prev_sid);
  
  if($boardsid =~ /\W/g){
      return (0, $lang->{'non_word_board'}, "");
  }

  # --- if there is no title or sid, return error
  if(length($boardtitle)==0 || length($boardsid)==0){
    return (0, $lang->{'form_not_fill_out'});
  }

  if(length($boardsid) > 20){
    return (0, $lang->{'keyword_too_long'});
  }

  my $tsidq = $DBH->quote($boardsid);
  if($spdb->db_count("Boards", "sid=$tsidq") && !$prev_sid){
      return (0, $lang->{'dup_sid'});
  }

  if($prev_sid && $prev_sid ne $boardsid && 
     $spdb->db_count("Boards", "sid=$tsidq")){
      return (0, $lang->{'dup_sid'});
  }  

  my $time = $spdb->db_date();

  $boardexpire =~ s/(\d+)M$/$1*30/e;
  $boardexpire =~ s/(\d+)y$/$1*365/e;
  my $expire = $boardexpire;

  my ($catid, $boardorder) = split(/\|/, $catasorder);

  # --- create a new board
  if($STATE->{'prev_op'} ne $lang->{'ChooseBoard'}){
    
    # --- first we need to know the board is needed to 
    # --- reorder or not. If so, we need to update the order
    # --- of others before changet the catorder.
    # --- find the number of categories
    my $catidq = $DBH->quote($catid);
    my $cnt = $spdb->db_count("BoardBelongToCat", "catid=$catidq");
    if($boardorder == $cnt+1){}
    elsif($boardorder == 1){
      for(my $i=$cnt; $i>=1; $i--){
	($succ, $errmsg) = 
	  $spdb->db_update("BoardBelongToCat", {('sorder'=>'sorder+1')}, 
			  "sorder=$i AND catid=$catidq");
      }
    }
    else{
      for(my $i=$cnt; $i>=$boardorder; $i--){
	($succ, $errmsg) = 
	  $spdb->db_update("BoardBelongToCat", {('sorder'=>'sorder+1')}, 
			  "sorder=$i AND catid=$catidq");
      }
    }
    
    # --- insert the new board to the db
    my $data = {('sid'=>$boardsid, 'title'=>$boardtitle, 
		 'introtext'=>$boardintrotext, 'html'=>$boardhtml,
		 'level'=>$boardlevel, 'active'=>$boardactive,
		 'expire'=>$expire, 'approved'=>$boardapproved, 
		 'fileattach'=>$boardfa, 'subscription'=>$boardsub,
		 'markup'=>$boardmarkup)};
    ($succ, $errmsg) = $spdb->db_insert("Boards", $data);
    # --- if insertion fails 
    if(!$succ){
	return (0, $errmsg);      
    }  

    # --- deal with BoardBelongToCat
    $data = {('catid'=>$catid, 
	      'sid'=>$boardsid, 
	      'sorder'=>$boardorder,
	      'date'=>$time)};
    ($succ, $errmsg) = $spdb->db_insert("BoardBelongToCat", $data);
    # --- if insertion fails 
    if(!$succ){
	return (0, $errmsg);      
    }  

    # --- done!
    return (1, $lang->{'board_created2'}, $lang->{'board_created1'});
  }
  # --- update the existing board
  else{
    my ($sidq, $titleq, $introq, $catidq) = map{ $DBH->quote($_) } 
    ($boardsid, $boardtitle, $boardintrotext, $catid);

    my $prev_sorder = $STATE->{'prev_sorder'};
    my $prev_catid = $STATE->{'prev_catid'};
    my $prev_sid = $STATE->{'prev_sid'};

    my $prev_sidq = $DBH->quote($prev_sid);
    
    my ($tmp_sorder, $tmp_catid) = 
      $spdb->db_select_cols("sorder, catid", 
			   "BoardBelongToCat",
			   "sid=$prev_sidq");
    
    if($tmp_sorder ne $prev_sorder || 
       $tmp_catid ne $prev_catid){
      goto RETURN;
    }

    # --- first we need to know the board is needed to 
    # --- reorder or not. If so, we need to update the order
    # --- of others before changet the catorder.
    my $catidq = $DBH->quote($catid);
    $spdb->db_update("BoardBelongToCat", {('sorder'=>0)}, "sid=$prev_sidq");
    if($prev_catid eq $catid){
      if($prev_sorder == $boardorder){} 
      elsif($prev_sorder < $boardorder){
	for(my $i=$prev_sorder+1; $i<=$boardorder; $i++){
	  ($succ, $errmsg) = $spdb->db_update("BoardBelongToCat", 
					     {('sorder'=>'sorder-1')}, 
					     "sorder=$i AND catid=$catidq");
	}  
      }
      else{
	for(my $i=$prev_sorder-1; $i>=$boardorder; $i--){
	  ($succ, $errmsg) = $spdb->db_update("BoardBelongToCat", 
					     {('sorder'=>'sorder+1')}, 
					     "sorder=$i AND catid=$catidq");
	}
      }
    }
    else{
      my $prev_catidq = $DBH->quote($prev_catid);
      my $cnt1 = $spdb->db_count("BoardBelongToCat", "catid=$prev_catidq");
      for(my $i=$prev_sorder+1; $i<=$cnt1; $i++){
	($succ, $errmsg) = $spdb->db_update("BoardBelongToCat", 
					   {('sorder'=>'sorder-1')},
					   "sorder=$i AND catid=$prev_catidq");
	return (0, $errmsg) if !$succ;
      }
    
      my $cnt = $spdb->db_count("BoardBelongToCat", "catid=$catidq");
      if($boardorder == $cnt+1){}
      else{
	for(my $i=$cnt; $i>=$boardorder; $i--){
	  ($succ, $errmsg) = $spdb->db_update("BoardBelongToCat", 
					   {('sorder'=>'sorder+1')}, 
					     "sorder=$i AND catid=$catidq");
	}
      }
    }
    return (0, $errmsg) if !$succ;
    
    # --- update the existing board
    my $data = {('sid'=>$sidq, 'title'=>$titleq, 
		 'introtext'=>$introq, 'html'=>$boardhtml,
		 'level'=>$boardlevel, 'active'=>$boardactive,
		 'expire'=>$expire, 'approved'=>$boardapproved,
		 'fileattach'=>$boardfa, 'subscription'=>$boardsub,
		 'markup'=>$boardmarkup)};
    ($succ, $errmsg) = $spdb->db_update("Boards", $data, "sid=$prev_sidq");
    return (0, $errmsg) if !$succ;

    # --- deal with BoardBelongToCat
    $data = {('catid'=>$catidq, 'sid'=>$sidq,'sorder'=>$boardorder)};
    ($succ, $errmsg) = $spdb->db_update("BoardBelongToCat", $data, "sid=$prev_sidq");
    return (0, $errmsg) if !$succ;
    # --- deal with Posts
    $data = {('sid'=>$sidq)};
    ($succ, $errmsg) = $spdb->db_update("Posts", $data, "sid=$prev_sidq");
    return (0, $errmsg) if !$succ;
    # --- deal with Moderators
    ($succ, $errmsg) = $spdb->db_update("Moderators", $data, "sid=$prev_sidq");
    return (0, $errmsg) if !$succ;
    # --- deal with GroupMems
    ($succ, $errmsg) = $spdb->db_update("GroupMems", $data, "sid=$prev_sidq");
    return (0, $errmsg) if !$succ;

    # --- if boardsub is false
    $spdb->db_delete("SubscribeBoard", "sid=$prev_sidq");
  }
  
 RETURN:
  return (1, $lang->{'board_updated2'}, $lang->{'board_updated1'});				       
}

sub _remove_board{
  my ($self, $sid) = @_;
  my $spdb =  $self->{'spdb'};
  my $DBH = $spdb->{'dbh'};
  
  my ($succ, $errmsg) = (1);
  my $sidq = $DBH->quote($sid);

  my ($sorder, $catid) = 
    $spdb->db_select_cols("sorder, catid", 
			 "BoardBelongToCat", 
			 "sid=$sidq");

  my $catidq = $DBH->quote($catid);
  my $cnt = $spdb->db_count("BoardBelongToCat", 
			   "catid=$catidq");

  # --- delete rows in BoardBelongToCat
  $spdb->db_delete("BoardBelongToCat", "sid=$sidq") if $sid;

  for(my $i=$sorder+1; $i<=$cnt; $i++){
    ($succ, $errmsg) =  
      $spdb->db_update("BoardBelongToCat", 
		      {('sorder'=>'sorder-1')},
		      "sorder=$i AND catid=$catidq");
  }

  # --- delete this board in table Boards
  $spdb->db_delete("Boards", "sid=$sidq") if $sid;
  
  # --- delete rows in Moderators
  $spdb->db_delete("Moderators", "sid=$sidq") if $sid;
  
  # --- delete rows in GroupMems
  $spdb->db_delete("GroupMems", "sid=$sidq") if $sid;

  # --- Sat Jan 15 10:46:11 PST 2000
  # --- delete parentandchild
  my ($cids) = $spdb->db_select_many(1, "cid", "Posts", "sid=$sidq");
  my $where;
  
  if($cids){
      foreach (@$cids){
	  my ($cid) = @$_;
	  $where .= "parentid=$cid OR ";
      }
      $where =~ s/OR $//;
      $spdb->db_delete("ParentAndChild", $where);
  }

  # --- delete all the messages
  $spdb->db_delete("Posts", "sid=$sidq") if $sid;

  # --- delete all the anon info
  $spdb->db_delete("AnonPosts", "sid=$sidq") if $sid;
  # ---------------------------

  require Ops::FileAttach;
  my $obj = Ops::FileAttach->new();
  # --- delete files attachment
  $obj->delete_files("sid=$sidq") if $sid;

  # --- delete rows in SubscribeBoard
  $spdb->db_delete("SubscribeBoard", "sid=$sidq") if $sid;
  
  return ($succ, $errmsg);
}

sub remove_board{
  my ($self) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $sid = $STATE->{'selectedboard'};
  
  # --- make sure at least one item is selected
  if(!$sid){
   return (0, $lang->{'at_least_one'});
  }

  # --- remove the board
  my ($succ, $errmsg) = $self->_remove_board($sid);
  # --- if update fails 
  if(!$succ){
    return (0, $errmsg);      
  }  
  
  return (1, $lang->{'drop_table2'}, $lang->{'drop_table1'});
}

# --- grant administration privileges
sub grant_admin{
  my ($self) = @_;
  my ($STATE, $spdb) =  map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};

  my ($uid, $op) = map{ $STATE->{$_} } qw(selecteduid op);
  
  # --- make sure at least one item is selected
  if(!$uid){
    return (0, $lang->{'at_least_one'});
  }

  if($op eq "GrantAdmin"){
    my $time = $spdb->db_date();
    $spdb->db_delete("Moderators", "uid=$uid") if $uid;
    $spdb->db_delete("GroupMems", "uid=$uid") if $uid;
    my $data = {('isadmin'=>1)};
    my ($succ, $errmsg) = $spdb->db_update("Users", $data,
					  "uid=$uid") if $uid;
    # --- if update fails 
    if(!$succ){
      return (0, $errmsg);      
    }  
  }

  # --- done!
  return (1, $lang->{'save_admin2'}, $lang->{'save_admin1'});
}

# --- revoke administration privileges
sub revoke_admin{
  my ($self) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};

  my $uid = $STATE->{'selectedadmin'};

  # --- make sure at least one item is selected
  unless($uid){
    return (0, $lang->{'at_least_one'});
  }
  
  my $data = {('isadmin'=>0)};
  my ($succ, $errmsg) = $spdb->db_update("Users", $data, "uid=$uid");
  # --- if update fails 
  if(!$succ){
    return (0, $errmsg);      
  }

  # --- erase rows in SubscribeBoard
  my ($boards) = $spdb->db_select_many(1, 
				      "sid", "Boards", 
				      "level>=56");
  my $where;
  foreach (@$boards){
    my ($sid) = @$_;
    my $sidq = $DBH->quote($sid);
    $where .= "sid=$sidq OR "
  }
  $where =~ s/(.+) OR $/$1/;
  $where = "AND ($where)" if $where;

  $spdb->db_delete("SubscribeBoard", "uid=$uid $where");
  #------------------------------#
		  
  return (1, $lang->{'revoke_admin2'}, $lang->{'revoke_admin1'});
}

sub delete_user{
  my ($self) = @_;
  # --- get the caution obj
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  
  my $uid = $STATE->{'selecteduid'};

  # --- make sure at least one item is selected
  unless($uid){
    return (0, $lang->{'at_least_one'});
  }

  # --- delete the user from Users 
  if($uid){
      # --- we cannot delete user in Users at this time as 
      # --- there are posts written by them in Posts
      $spdb->db_update("Users", {('active'=>2)}, "uid=$uid");
      $spdb->db_delete("Moderators", "uid=$uid");
      $spdb->db_delete("GroupMems", "uid=$uid");
      $spdb->db_delete("SubscribeBoard", "uid=$uid");

      $spdb->db_delete("BoardPrefs", "uid=$uid");
  }

  # --- done!
  return (1, $lang->{'del_user2'}, $lang->{'del_user1'});
}

sub _expire_threads{
    my ($self, $retnothing, $selectedthreads, $sid, $op) = @_;
    my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
    my $DBH = $spdb->{'dbh'};
    
    my ($where, $where1, $where2, $where3, $cnt1);

    if(!$selectedthreads){
	return (1) if $retnothing;
	return (0, $lang->{'cant_found_page'});
    }

    foreach (@$selectedthreads){
	my $cid;
	if(ref($_) ne "ARRAY"){
	    $cid = $_;
	}
	else{
	    ($cid) = @$_;
	}    
	$where .= "cid=$cid OR "; 
	$where1 .= "parentid=$cid OR ";
	$where2 .= "childid=$cid OR ";
	my $mpid = $self->_select_the_most_parent($cid);
	$where3 .= "cid=$mpid OR ";
    }
    $where =~ s/(.+) OR $/$1/g;
    $where1 =~ s/(.+) OR $/$1/g;
    $where2 =~ s/(.+) OR $/$1/g;
    $where3 =~ s/(.+) OR $/$1/g; 

    # --- lookup child
    my ($childids) = 
	$spdb->db_select_many(1, "childid","ParentAndChild", "$where1");
    foreach (@$childids){
	my ($childid) = @$_;
	# --- find out the least child
	my ($lchildid, $replies, $lastmod) = 
	  $self->_select_the_least_child($childid);
	my $data = {('cid'=>$childid, 'sid'=>$sid, 
		     'lastmod'=>$lastmod, 'replies'=>$replies)};
	$spdb->db_insert("MostParents", $data);
    }

    if($op ne $lang->{'MoveThreads'} && $op ne "CopyThreads"){
	# --- delete from Posts
	$spdb->db_delete("Posts", $where) if $where;    
	# --- delete from MostParents
	$spdb->db_delete("MostParents", $where) if $where;

	# --- delete all the anon info
	$spdb->db_delete("AnonPosts", $where) if $where;
    }

    $where1 = "$where1 OR $where2" if $where1;
    # --- delete from ParentAndChild
    $spdb->db_delete("ParentAndChild", $where1) if $where1;

    # --- update the replies field for the most parent
    my ($mpids) = $spdb->db_select_many(1, "cid", "MostParents", $where3);
    foreach (@$mpids){
	my ($mpid) = @$_;
	my ($lcid, $cnt, $date) = $self->_select_the_least_child($mpid);
	my $dateq = $DBH->quote($date);
	my ($succ, $errmsg) = 
	    $spdb->db_update("MostParents", 
			     {('replies'=>$cnt, 'lastmod'=>$dateq)}, 
			     "cid=$mpid");
	return (1) if $retnothing && !$succ;
	return (0, $errmsg) if !$succ;
    }

    # --- update commentcount in Boards
    my $sidq = $DBH->quote($sid);
    $cnt1 = $spdb->db_count("Posts", "approved=1 AND sid=$sidq");
    my ($succ, $errmsg) =
      $spdb->db_update("Boards", 
		      {('commentcount'=>$cnt1)},
		      "sid=$sidq");
    return (1) if $retnothing && !$succ;
    return (0, $errmsg) if !$succ;
    
    if($op ne $lang->{'MoveThreads'} && $op ne $lang->{'CopyThreads'}){
	require Ops::FileAttach;
	my $obj = Ops::FileAttach->new();
	# --- delete files attachment
	$obj->delete_files($where) if $where;
    }

    return (1);
}

sub _expire_whole_threads{
    my ($self, $retnothing, $selectedthreads, $sid) = @_;
    my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
    my $DBH = $spdb->{'dbh'};
    
    my ($where, $where1, $where2, $where3, $cnt1);

    if(!$selectedthreads){
	return (0, $lang->{'cant_found_page'});
    }

    foreach (@$selectedthreads){
	my $cid = $_; my $children = [];
	$self->_select_children($cid, $children);
	$where .= "cid=$cid OR ";
	foreach (@$children){
	    $where .= "cid=$_ OR ";
	    $where1 .= "parentid=$cid OR ";
	    $where2 .= "childid=$cid OR ";
	}
    }
    $where =~ s/(.*) OR $/$1/g;
    $where1 =~ s/(.+) OR $/$1/g;
    $where2 =~ s/(.+) OR $/$1/g;

    # --- delete from Posts
    $spdb->db_delete("Posts", $where) if $where;    
    # --- delete from MostParents
    $spdb->db_delete("MostParents", $where) if $where;
    
    # --- delete all the anon info
    $spdb->db_delete("AnonPosts", $where) if $where;

    $where1 = "$where1 OR $where2" if $where1;
    # --- delete from ParentAndChild
    $spdb->db_delete("ParentAndChild", $where1) if $where1;

    # --- update commentcount in Boards
    my $sidq = $DBH->quote($sid);
    $cnt1 = $spdb->db_count("Posts", "approved=1 AND sid=$sidq");
    my ($succ, $errmsg) =
      $spdb->db_update("Boards", 
		      {('commentcount'=>$cnt1)},
		      "sid=$sidq");
    return (0, $errmsg) if !$succ;
    
    require Ops::FileAttach;
    my $obj = Ops::FileAttach->new();
    # --- delete files attachment
    $obj->delete_files($where) if $where;

    return (1);
}

sub expire_threads_by_date{
  my ($self, $sid, $expire) = @_;
  my $spdb = $self->{'spdb'};
  my $DBH = $spdb->{'dbh'};

  my $sidq = $DBH->quote($sid);
  my $where = "TO_DAYS(NOW()) - TO_DAYS(date) >= $expire 
               AND sid=$sidq";
  
  my ($selectedthreads) =
    $spdb->db_select_many(1, "cid", "Posts", $where);
  
  my ($ctype, $tmpmsg) = $self->_expire_threads(1, $selectedthreads, $sid);
  return (0, $tmpmsg) if $ctype ==0;
  return 1;
}

sub expire_threads_by_selection{
  my ($self) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $sid = $STATE->{'sid'};
  my $mostparent = $STATE->{'mostparent'};

  my $ret;
  my $selectedthreads = $STATE->{'selectedthreads'};

  # --- make sure at least one item is selected
  unless($selectedthreads){
    return (0, $lang->{'at_least_one'});
  }

  my @selectedthreads = split("#", $selectedthreads);
  if($mostparent){
      my ($ctype, $tmpmsg) = $self->_expire_whole_threads(0, \@selectedthreads, $sid);
      return (0, $tmpmsg) if $ctype == 0;
  }
  else{
      my ($ctype, $tmpmsg) = $self->_expire_threads(0, \@selectedthreads, $sid);
      return (0, $tmpmsg) if $ctype == 0;
  }
  
  # --- done!
  return (1, $lang->{'expire_threads4'}, $lang->{'expire_threads3'});
}

sub approve_open_close_threads{
  my ($self) = @_;
  my ($STATE, $spdb) =  map{ $self->{$_} } qw(STATE spdb); 
  my $DBH = $spdb->{'dbh'};

  my $ret;
  my ($op, $selectedthreads, $sid) = 
    map{ $STATE->{$_} } qw(op selectedthreads sid);
  
  # --- make sure at least one item is selected
  unless($selectedthreads){
      return (0, $lang->{'at_least_one'});
  }

  my @selectedthreads = split("#", $selectedthreads);
    
  if($op && $op ne $lang->{'ApproveThreads'}){
    my $where;
    foreach (@selectedthreads){
      my $cid = $_; my $children = [];
      $self->_select_children($cid, $children);
      $where .= "cid=$cid OR ";
      foreach (@$children){
 	$where .= "cid=$_ OR ";
      }
    }
    $where =~ s/(.*) OR $/$1/g;

    my $val = ($op eq $lang->{'CloseThreads'})?1:0;
    my ($succ, $errmsg) =
      $spdb->db_update("Posts", {('closed'=>$val)}, $where);
    if(!$succ){
      return (0, $errmsg);      
    }  
  }
  # --- approve threads
  else{
    # --- update each thread
    my ($where, $cnt);
    my $time = $spdb->db_date();
    foreach (@selectedthreads){
      my $cid = $_;
      $where .= "cid=$cid OR "; 
      ++$cnt;
      
      # --- update the most parent of each thread
      my $mpid = $self->_select_the_most_parent($cid);
      if($mpid != $cid){
	  $spdb->db_update("MostParents", 
			   {('replies'=>'replies+1',
			     'lastmod'=>$DBH->quote($time))}, 
			   "cid=$mpid");
      }

      # --- send msg to user who subscribe this board
      require Ops::Subscribe;
    Ops::Subscribe->new($STATE)->send_individual_msg($cid);
    }
    $where =~ s/(.*) OR $/$1/g;
    
    $spdb->db_update("Posts", {('approved'=>1)}, $where);
    
    # --- update board
    my $sidq = $DBH->quote($sid);
    my $cnt1 = $spdb->db_count("Posts", "approved=1 AND sid=$sidq");
    my $data = {('commentcount'=>$cnt1,
		 'lastmod'=>$DBH->quote($time))};
    my ($succ, $errmsg) =
      $spdb->db_update("Boards", $data, "sid=$sidq");
    if(!$succ){
      return (0, $errmsg);      
    }  
  }
  
  my ($words, $msg, $btitle);
  # --- done!
  if($op eq $lang->{'CloseThreads'}){
    $words = $lang->{'close_threads3'};
    $msg = $lang->{'close_threads4'}; 
  }
  elsif($op eq $lang->{'OpenThreads'}){
    $words = $lang->{'open_threads3'};
    $msg = $lang->{'open_threads4'}; 
  }
  else{
    $words = $lang->{'approve_threads3'};
    $msg = $lang->{'approve_threads4'}; 
  }

  return (1, $msg, $words);
}

sub move_copy_threads{
  my ($self, $STATE) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb); 
  my $DBH = $spdb->{'dbh'};

  my $ret;
  my ($selectedthreads, $catandboard, $sid, $op) = 
      map{ $STATE->{$_} } qw(selectedthreads catandboard sid op);

  # --- make sure at least one item is selected
  unless($selectedthreads){
      return (0, $lang->{'at_least_one'});
  }

  my $cabq = $DBH->quote($catandboard);
  if($spdb->db_count("Boards", "sid=$cabq") <= 0){
      return (0, $lang->{'choose_board'});
  }
  
  my @selectedthreads = split("#", $selectedthreads);

  if($op eq $lang->{'MoveThreads'}){
      my ($ctype, $tmpmsg) = $self->_expire_threads(0, \@selectedthreads, $sid, $op);
      return (0, $tmpmsg) if $ctype == 0;

      my ($where, $where1);
      foreach (@selectedthreads){
	  my $cid = $_; 
	  $where .= "cid=$cid OR ";
      }
      $where =~ s/(.*) OR $/$1/g;

      my $data = {('sid'=>$cabq)};
      $spdb->db_update("Posts", $data, $where);
      $spdb->db_update("FileAttach", $data, $where);
      $spdb->db_update("MostParents", $data, $where);   

      my ($pids) = $spdb->db_select_many(1, "cid, pid", "Posts", $where);
      foreach (@$pids){
	  my ($cid, $pid) = @$_;
	  if($spdb->db_count("Posts", "sid=$cabq AND cid=$pid") <= 0){
	      my $data = {('sid'=>$catandboard, 'cid'=>$cid)};
	      $spdb->db_insert("MostParents", $data);
	  }
	  else{
	      $spdb->db_delete("MostParents", "sid=$cabq AND cid=$cid");
	      $spdb->db_insert("ParentAndChild", {('parentid'=>$pid,
						   'childid'=>$cid)});
	  }
      }

      # --- update the ParentAndChild
      foreach (@selectedthreads){
	  my $cid = $_;
      	  if($spdb->db_count("Posts", "sid=$cabq AND pid=$cid AND pid<>0") > 0){
	      # --- need to recover the branch
	      my ($ctype, $tmpmsg) = 
		   $self->_recover_thread($cid, $catandboard);
	      return (0, $tmpmsg) if $ctype == 0;
	  }

	  my $mpid = $self->_select_the_most_parent($cid);
	  $where1 .= "cid=$mpid OR ";
      }
      $where1 =~ s/(.*) OR $/$1/g;

      # --- update the replies field for the most parent
      my ($mpids) = $spdb->db_select_many(1, "cid", "MostParents", $where1);
      foreach (@$mpids){
	  my ($mpid) = @$_;
	  my ($lcid, $cnt, $date) = $self->_select_the_least_child($mpid);
	  my $dateq = $DBH->quote($date);
	  my ($succ, $errmsg) = 
	      $spdb->db_update("MostParents", 
			       {('replies'=>$cnt, 'lastmod'=>$dateq)}, 
			       "cid=$mpid");
	  return (0, $errmsg) if !$succ;
      }
      
      # --- update commentcount in Boards
      my $sidq = $DBH->quote($catandboard);
      my $cnt1 = $spdb->db_count("Posts", "approved=1 AND sid=$sidq");
      my ($succ, $errmsg) =
	  $spdb->db_update("Boards", 
			   {('commentcount'=>$cnt1)},
			   "sid=$sidq");
      $sidq = $DBH->quote($sid);
      $cnt1 = $spdb->db_count("Posts", "approved=1 AND sid=$sidq");
      my ($succ, $errmsg) =
	  $spdb->db_update("Boards", 
			   {('commentcount'=>$cnt1)},
			   "sid=$sidq");
      return (0, $errmsg) if !$succ;

      return (1, $lang->{'move_threads4'}, $lang->{'move_threads3'});
  }
  else{
      my ($where, $where1);
      foreach (@selectedthreads){
	  my $cid = $_; 
	  $where .= "cid=$cid OR ";
	  my $mpid = $self->_select_the_most_parent($cid);
	  $where1 .= "cid=$mpid OR ";
      }
      $where =~ s/(.*) OR $/$1/g;
      $where1 =~ s/(.*) OR $/$1/g;

      # --- lock the table Posts
      $spdb->db_lock(("Posts"));

      my $select = "cid, sid, uid, pid, subject, bodytext, hits, ip, closed, 
                    approved, emailreply, date";
      my ($threads) = $spdb->db_select_many(1, $select, "Posts", $where);
      foreach (@$threads){
	  my ($cid, $sid, $uid, $pid, $subject, $bodytext, 
	      $hits, $ip, $closed, $approved, $emailreply, $date) = @$_;
      
	  my $mcid = $spdb->db_max("cid", "Posts");
	  $mcid = 0 unless $mcid; $mcid++;

	  my $data = {('cid'=>$mcid, 'sid'=>$catandboard, 'uid'=>$uid, 'pid'=>$pid,
		       'subject'=>$subject, 'bodytext'=>$bodytext, 
		       'hits'=>$hits, 'ip'=>$ip, 'closed'=>$closed, 
		       'approved'=>$approved, 'emailreply'=>$emailreply,
		       'date'=>$date)};
	  $spdb->db_insert("Posts", $data);
	  
	  $data = {('sid'=>$catandboard, 'cid'=>$mcid, 'lastmod'=>$date)};
	  $spdb->db_insert("MostParents", $data);  

	  $select = "fid, sid, cid, fname, fdesc, fsize, date";
	  my ($fid, $sid, $fname, $fdesc, $fsize, $date) = 
	      $spdb->db_select_cols($select, "FileAttach", "cid=$cid");
	  $data = {('cid'=>$mcid, 'fid'=>$fid, 'sid'=>$catandboard,
		    'fname'=>$fname, 'fdesc'=>$fdesc, 'fsize'=>$fsize,
		    'date'=>$date)};
	  $spdb->db_insert("FileAttach", $data);
      }

      $spdb->db_unlock();
      
     # --- update commentcount in Boards

      # -------------------------------------------------------------- #

      my $sidq = $DBH->quote($catandboard);
      my $cnt1 = $spdb->db_count("Posts", "approved=1 AND sid=$sidq");
      my $tlastmod = $spdb->db_max("date", "Posts", "approved=1 AND sid=$sidq");
      my ($succ, $errmsg) =
	  $spdb->db_update("Boards", 
			   {('commentcount'=>$cnt1,
			     'lastmod'=>$DBH->quote($tlastmod))},
			   "sid=$sidq");

      # -------------------------------------------------------------- #

      $sidq = $DBH->quote($sid);
      $cnt1 = $spdb->db_count("Posts", "approved=1 AND sid=$sidq");
      $tlastmod = $spdb->db_max("date", "Posts", "approved=1 AND sid=$sidq");
      my ($succ, $errmsg) =
	  $spdb->db_update("Boards", 
			   {('commentcount'=>$cnt1,
			     'lastmod'=>$DBH->quote($tlastmod))},
			   "sid=$sidq");

      # -------------------------------------------------------------- #

      return (0, $errmsg) if !$succ;

      return (1, $lang->{'copy_threads4'}, $lang->{'copy_threads3'});
  }
}

sub _recover_thread{
    my ($self, $cid, $sid) = @_;
    my $spdb = $self->{'spdb'};
    my $DBH = $spdb->{'dbh'};

    my $sidq = $DBH->quote($sid);

    my ($childids) = $spdb->db_select_many(1, "cid", "Posts", 
					   "sid=$sidq AND pid=$cid");    
    my $where;
    foreach (@$childids){
	my ($childid) = @$_;
	$where .= "cid=$childid OR "; 

	my $data = {('parentid'=>$cid, 'childid'=>$childid)};
	$spdb->db_insert("ParentAndChild", $data);
    }
    $where =~ s/(.+) OR $/$1/g;

    $spdb->db_delete("MostParents", $where) if $where;
    return (1);
}

sub _select_the_most_parent{
  my ($template, $cid) = @_;
  my $spdb = $template->{'spdb'};
  
  # --- find out its parentid
  my ($pid) = $spdb->db_select_cols("parentid", "ParentAndChild",
                                   "childid=$cid");
  if(!$pid){
    return $cid;
  }
  else{
      $template->_select_the_most_parent($pid);
  }
}

sub _select_the_least_child{
    my ($self, $cid, $cnt, $date) = @_;
    my $spdb = $self->{'spdb'};

    my ($childids) = $spdb->db_select_many(1, "childid", "ParentAndChild",
					   "parentid=$cid");
    
    if(!$childids){
	($date) = $spdb->db_select_cols("date", "Posts", "cid=$cid") if !$date;
	$cnt = 0 if !$cnt;
	return ($cid, $cnt, $date);
    }

    my ($scid, $scnt, $cnt, $where, $date);
    my $scnt = 0;
    foreach (@$childids){
	my ($childid) = @$_; $scnt++;
	($scid, $cnt) = $self->_select_the_least_child($childid, 0, $date);
	$scnt += $cnt;
	$where .= "cid=$scid OR ";
	
    }
    $where =~ s/(.+) OR $/$1/;
    
    ($scid, $date) = $spdb->db_select_cols("cid, MAX(date)", 
					   "Posts", $where, 
					   "GROUP BY sid");
 
    return ($scid, $scnt, $date);
}

sub _select_children{
  my ($self, $cid, $children) = @_;
  my $spdb = $self->{'spdb'};

  my ($tmp) = $spdb->db_select_many(1, "childid", "ParentAndChild", 
				   "parentid=$cid");
  if(!$tmp){
    return $children;
  }
  else{
    foreach (@$tmp){
      my ($childid) = @$_;
      unshift @$children, $childid;
      $self->_select_children($childid, $children);
    }
  }
}

return 1;





