# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: modules shared by the different db types, dbi, postgresql,
    sqlite

=end
module SiSU_DB_columns
  require "#{SiSU_lib}/sysenv"                            # sysenv.rb
  require "#{SiSU_lib}/db_sqltxt"                         # db_sqltxt.rb
  class Columns < SiSU_DB_text::Prepare
    def initialize(md=nil)
      @md=md
      @db=SiSU_Env::Info_db.new #watch
      if defined? md.mod \
      and md.mod.inspect=~/import|update/ \
      and FileTest.exist?(md.fns)
        txt_arr=IO.readlines(md.fns,'')
        src=txt_arr.join("\n")
        if @db.share_source?
          @sisutxt=special_character_escape(src)
        else @sisutxt=''
        end
        @fulltext=clean_searchable_text(txt_arr)
       else @sisutxt,@fulltext='',''
      end
    end
#% structures
    #def column_define
    #  def varchar(name,size)
    #    "#{name}                VARCHAR(#{size}) NULL,"
    #  end
    #end
=begin
#% title
@title:
 :subtitle:
 :short:
 :edition:
 :language:
 :note:
=end
    def column
      def title                          # DublinCore 1 - title
        def name
          'title'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_title]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
            IS 'metadata full document title [DC1]';}
        end
        def tuple
          t=if defined? @md.title.full \
          and @md.title.full=~/\S+/
            txt=@md.title.full
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def title_main
        def name
          'title_main'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_title_part]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
            IS 'metadata main document title';}
        end
        def tuple
          t=if defined? @md.title.main \
          and @md.title.main=~/\S+/
            txt=@md.title.main
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def title_sub
        def name
          'title_sub'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_title_part]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
            IS 'metadata document subtitle';}
        end
        def tuple
          t=if defined? @md.title.sub \
          and @md.title.sub=~/\S+/
            txt=@md.title.sub
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def title_short
        def name
          'title_short'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_title_part]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
            IS 'metadata document short title if any';}
        end
        def tuple
          t=if defined? @md.title.short \
          and @md.title.short=~/\S+/
            txt=@md.title.short
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def title_edition
        def name
          'title_edition'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_title_edition]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
            IS 'metadata document edition (version)';}
        end
        def tuple
          t=if defined? @md.title.edition \
          and @md.title.edition=~/\S+/
            txt=@md.title.edition
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def title_note
        def name
          'title_note'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_info_note]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
            IS 'metadata document notes associated with title';}
        end
        def tuple
          t=if defined? @md.title.note \
          and @md.title.note=~/\S+/
            txt=@md.title.note
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def title_language
        def name
          'title_language'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_language]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
            IS 'metadata document language [DC12]';}
        end
        def tuple
          t=if defined? @md.title.language \
          and @md.title.language=~/\S+/
            txt=@md.title.language
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def title_language_char            # consider
        def name
          'title_language_char'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_language_char]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
            IS 'metadata document language iso code';}
        end
        def tuple
          t=if defined? @md.title.language_char \
          and @md.title.language_char=~/\S+/
            txt=@md.title.language_char
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
=begin
#% creator
@creator:
 :author:
 :contributor:
 :illustrator:
 :photographer:
 :translator:
 :prepared_by:
 :digitized_by:
 :audio:
 :video:
=end
      def creator_author                 # DublinCore 2 - creator/author (author)
        def name
          'creator_author'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_name]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document author (creator) [DC2]';}
        end
        def tuple
          t=if defined? @md.creator.author_detail \
          and @md.creator.author_detail.class==Array \
          and @md.creator.author_detail.length > 0
            txt=''
            @md.creator.author_detail.each do |h|
              txt=txt + %{#{h[:the]}, #{h[:others]}; }
            end
            txt.gsub!(/[;, ]+\s*$/,'')
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def creator_author_honorific       # consider
        def name
          'creator_author_hon'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_creator_misc_short]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document author honorific (title e.g, Ms. Dr. Prof.)';}
        end
        def tuple
          t=if defined? @md.creator.author_hon \
          and @md.creator.author_hon=~/\S+/
            txt=@md.creator.author_hon
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def creator_author_nationality     # consider
        def name
          'creator_author_nationality'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_creator_misc_short]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata nationality of document author (creator)';}
        end
        def tuple
          t=if defined? @md.creator.author_nationality_detail \
          and @md.creator.author_nationality=~/\S+/
            txt=@md.creator.author_nationality_detail
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def creator_contributor            # DublinCore 6 - contributor
        def name
          'creator_contributor'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_name]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document contributor name(s) [DC6]';}
        end
        def tuple
          t=if defined? @md.creator.contributor_detail \
          and @md.creator.contributor_detail.class==Array \
          and @md.creator.contributor_detail.length > 0
            txt=@md.creator.contributor_detail #dc
            txt=''
            @md.creator.contributor_detail.each do |h|
              txt=txt + %{#{h[:the]}, #{h[:others]}; }
            end
            txt.gsub!(/[;, ]+\s*$/,'')
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def creator_illustrator
        def name
          'creator_illustrator'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_name]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document illustrator name(s)';}
        end
        def tuple
          t=if defined? @md.creator.illustrator_detail \
          and @md.creator.illustrator_detail.class==Array \
          and @md.creator.illustrator_detail.length > 0
            txt=@md.creator.illustrator_detail
            txt=''
            @md.creator.illustrator_detail.each do |h|
              txt=txt + %{#{h[:the]}, #{h[:others]}; }
            end
            txt.gsub!(/[;, ]+\s*$/,'')
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def creator_photographer
        def name
          'creator_photographer'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_name]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document photographer name(s)';}
        end
        def tuple
          t=if defined? @md.creator.photographer_detail \
          and @md.creator.photographer_detail.class==Array \
          and @md.creator.photographer_detail.length > 0
            txt=@md.creator.photographer_detail
            txt=''
            @md.creator.photographer_detail.each do |h|
              txt=txt + %{#{h[:the]}, #{h[:others]}; }
            end
            txt.gsub!(/[;, ]+\s*$/,'')
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def creator_translator
        def name
          'creator_translator'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_name]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document translator name(s)';}
        end
        def tuple
          t=if defined? @md.creator.translator_detail \
          and @md.creator.translator_detail.class==Array \
          and @md.creator.translator_detail.length > 0
            txt=''
            @md.creator.translator_detail.each do |h|
              txt=txt + %{#{h[:the]}, #{h[:others]}; }
            end
            txt.gsub!(/[;, ]+\s*$/,'')
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def creator_prepared_by
        def name
          'creator_prepared_by'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_name]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document prepared by name(s)';}
        end
        def tuple
          t=if defined? @md.creator.prepared_by_detail \
          and @md.creator.prepared_by_detail.class==Array \
          and @md.creator.prepared_by_detail.length > 0
            txt=@md.creator.prepared_by_detail
            txt=''
            @md.creator.prepared_by_detail.each do |h|
              txt=txt + %{#{h[:the]}, #{h[:others]}; }
            end
            txt.gsub!(/[;, ]+\s*$/,'')
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def creator_digitized_by
        def name
          'creator_digitized_by'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_name]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document digitized by name(s)';}
        end
        def tuple
          t=if defined? @md.creator.digitized_by_detail \
          and @md.creator.digitized_by_detail.class==Array \
          and @md.creator.digitized_by_detail.length > 0
            txt=@md.creator.digitized_by_detail
            txt=''
            @md.creator.digitized_by_detail.each do |h|
              txt=txt + %{#{h[:the]}, #{h[:others]}; }
            end
            txt.gsub!(/[;, ]+\s*$/,'')
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def creator_audio
        def name
          'creator_audio'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_name]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document audio by name(s)';}
        end
        def tuple
          t=if defined? @md.creator.audio_detail \
          and @md.creator.audio_detail.class==Array \
          and @md.creator.audio_detail.length > 0
            txt=@md.creator.audio_detail
            txt=''
            @md.creator.audio_detail.each do |h|
              txt=txt + %{#{h[:the]}, #{h[:others]}; }
            end
            txt.gsub!(/[;, ]+\s*$/,'')
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def creator_video
        def name
          'creator_video'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_name]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document video by name(s)';}
        end
        def tuple
          t=if defined? @md.creator.video_detail \
          and @md.creator.video_detail.class==Array \
          and @md.creator.video_detail.length > 0
            txt=''
            @md.creator.video_detail.each do |h|
              txt=txt + %{#{h[:the]}, #{h[:others]}; }
            end
            txt.gsub!(/[;, ]+\s*$/,'')
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
=begin
#% language
#taken from other fields
@title:
 :language:
@original:
 :language:
#not available -->
#@language:
# :document:
# :original:
=end
      def language_document
        def name
          'language_document'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_language]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document language';}
        end
        def tuple
          t=if defined? @md.language.document \
          and @md.language.document=~/\S+/
            txt=@md.language.document
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def language_document_char
        def name
          'language_document_char'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_language_char]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document language';}
        end
        def tuple
          t=if defined? @md.language.document_char \
          and @md.language.document_char=~/\S+/
            txt=@md.language.document_char
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def language_original
        def name
          'language_original'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_language]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata original document/text language';}
        end
        def tuple
          t=if defined? @md.language.original \
          and @md.language.original=~/\S+/
            txt=@md.language.original
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def language_original_char
        def name
          'language_original_char'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_language_char]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document language';}
        end
        def tuple
          t=if defined? @md.language.original_char \
          and @md.language.original_char=~/\S+/
            txt=@md.language.original_char
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
=begin
#% date
@date:
 :added_to_site:
 :available:
 :created:
 :issued:
 :modified:
 :published:
 :valid:
 :translated:
 :original_publication:
=end
      def date_added_to_site
        def name
          'date_added_to_site'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_date_text]}) NULL,"
          #"#{name}                DATE,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata date added to site';}
        end
        def tuple
          t=if defined? @md.date.added_to_site \
          and @md.date.added_to_site=~/\S+/
            txt=@md.date.added_to_site
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def date_available
        def name
          'date_available'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_date_text]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata date added to site [DC]';}
        end
        def tuple
          t=if defined? @md.date.available \
          and @md.date.available=~/\S+/
            txt=@md.date.available
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def date_created
        def name
          'date_created'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_date_text]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata date created [DC]';}
        end
        def tuple
          t=if defined? @md.date.created \
          and @md.date.created=~/\S+/
            txt=@md.date.created
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def date_issued
        def name
          'date_issued'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_date_text]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata date issued [DC]';}
        end
        def tuple
          t=if defined? @md.date.issued \
          and @md.date.issued=~/\S+/
            txt=@md.date.issued
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def date_modified
        def name
          'date_modified'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_date_text]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata date modified [DC]';}
        end
        def tuple
          t=if defined? @md.date.modified \
          and @md.date.modified=~/\S+/
            txt=@md.date.modified
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def date_published
        def name
          'date_published'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_date_text]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata date published [DC7]';}
        end
        def tuple
          t=if defined? @md.date.published \
          and @md.date.published=~/\S+/
            txt=@md.date.published
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def date_valid
        def name
          'date_valid'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_date_text]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata date valid [DC]';}
        end
        def tuple
          t=if defined? @md.date.valid \
          and @md.date.valid=~/\S+/
            txt=@md.date.valid
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def date_translated
        def name
          'date_translated'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_date_text]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata date translated';}
        end
        def tuple
          t=if defined? @md.date.translated \
          and @md.date.translated=~/\S+/
            txt=@md.date.translated
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def date_original_publication
        def name
          'date_original_publication'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_date_text]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata date of original publication';}
        end
        def tuple
          t=if defined? @md.date.original_publication \
          and @md.date.original_publication=~/\S+/
            txt=@md.date.original_publication
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def date_generated
        def name
          'date_generated'
        end
        def create_column              #choose other representation of time
          "#{name}                VARCHAR(30) NULL,"
          #"#{name}                VARCHAR(10) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata date of sisu generation of document, automatically populated';}
        end
        def tuple                      #choose other representation of time
          t=if defined? @md.generated \
          and @md.generated.to_s=~/\S+/
            txt=@md.generated.to_s
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
=begin
#% publisher
@publisher:
=end
      def publisher
        def name
          'publisher'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_name]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document publisher [DC5]';}
        end
        def tuple
          t=if defined? @md.publisher \
          and @md.publisher=~/\S+/
            txt=@md.publisher
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
##% current
#    def current_publisher
#      def name
#        'current_publisher'
#      end
#      def size
#        10
#      end
#      def create_column
#        "#{name}                VARCHAR(#{current_publisher.size}) NULL,"
#      end
#      def tuple
#        t=if defined? @md.current.publisher \
#        and @md.current.publisher=~/\S+/
#          txt=@md.current.publisher
#          special_character_escape(txt)
#          "'#{txt}', "
#        end
#      end
#      self
#    end
=begin
#% original
@original:
 :publisher:
 #:date:                                #repeated under date
 :language:
 :institution:
 :nationality:
 :source:
=end
      def original_publisher
        def name
          'original_publisher'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_name]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document original publisher [DC5]';}
        end
        def tuple
          t=if defined? @md.original.publisher \
          and @md.original.publisher=~/\S+/
            txt=@md.original.publisher
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def original_language
        def name
          'original_language'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_language]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document original language';}
        end
        def tuple
          t=if defined? @md.original.language \
          and @md.original.language=~/\S+/
            txt=@md.original.language
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def original_language_char         # consider
        def name
          'original_language_char'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_language_char]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document original language iso character';}
        end
        def tuple
          t=if defined? @md.original.language_char \
          and @md.original.language_char=~/\S+/
            txt=@md.original.language_char
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def original_source
        def name
          'original_source'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_name]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document original source [DC11]';}
        end
        def tuple
          t=if defined? @md.original.source \
          and @md.original.source=~/\S+/
            txt=@md.original.source
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def original_institution
        def name
          'original_institution'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_name]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document original institution';}
        end
        def tuple
          t=if defined? @md.original.institution \
          and @md.original.institution=~/\S+/
            txt=@md.original.institution
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def original_nationality
        def name
          'original_nationality'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_language]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document original nationality';}
        end
        def tuple
          t=if defined? @md.original.nationality \
          and @md.original.nationality=~/\S+/
            txt=@md.original.nationality
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
=begin
#% rights
@rights:
 #:copyright:                          #mapped to :text: used where no other copyrights and included in :all:
 :text:
 :translation:
 :illustrations:
 :photographs:
 :preparation:
 :digitization:
 :audio:
 :video:
 :license:
 :all:
=end
      def rights_all
        def name
          'rights'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_info_note]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata rights associated with document (composite) [DC15]';}
        end
        def tuple
          t=if defined? @md.rights.all \
          and @md.rights.all=~/\S+/
            txt=@md.rights.all
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def rights_copyright_text
        def name
          'rights_copyright_text'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_info_note]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata copyright associated for document text';}
        end
        def tuple
          t=if defined? @md.rights.copyright_text \
          and @md.rights.copyright_text=~/\S+/
            txt=@md.rights.copyright_text
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def rights_copyright_translation
        def name
          'rights_copyright_translation'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_info_note]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata copyright associated for document text translation (if any)';}
        end
        def tuple
          t=if defined? @md.rights.copyright_translation \
          and @md.rights.copyright_translation=~/\S+/
            txt=@md.rights.copyright_translation
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def rights_copyright_illustrations
        def name
          'rights_copyright_illustrations'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_info_note]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata copyright associated for document text illustrations (if any)';}
        end
        def tuple
          t=if defined? @md.rights.copyright_illustrations \
          and @md.rights.copyright_illustrations=~/\S+/
            txt=@md.rights.copyright_illustrations
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def rights_copyright_photographs
        def name
          'rights_copyright_photographs'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_info_note]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata copyright associated for document text photographs (if any)';}
        end
        def tuple
          t=if defined? @md.rights.copyright_photographs \
          and @md.rights.copyright_photographs=~/\S+/
            txt=@md.rights.copyright_photographs
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def rights_copyright_preparation
        def name
          'rights_copyright_preparation'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_info_note]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata copyright associated for document text preparation (if any)';}
        end
        def tuple
          t=if defined? @md.rights.copyright_preparation \
          and @md.rights.copyright_preparation=~/\S+/
            txt=@md.rights.copyright_preparation
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def rights_copyright_digitization
        def name
          'rights_copyright_digitization'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_info_note]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata copyright associated for document text digitization (if any)';}
        end
        def tuple
          t=if defined? @md.rights.copyright_digitization \
          and @md.rights.copyright_digitization=~/\S+/
            txt=@md.rights.copyright_digitization
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def rights_copyright_audio
        def name
          'rights_copyright_audio'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_info_note]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata copyright associated for document text audio (if any)';}
        end
        def tuple
          t=if defined? @md.rights.copyright_audio \
          and @md.rights.copyright_audio=~/\S+/
            txt=@md.rights.copyright_audio
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def rights_copyright_video
        def name
          'rights_copyright_video'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_info_note]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata copyright associated for document text video (if any)';}
        end
        def tuple
          t=if defined? @md.rights.copyright_video \
          and @md.rights.copyright_video=~/\S+/
            txt=@md.rights.copyright_video
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def rights_license
        def name
          'rights_license'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_info_note]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata license granted for use of document if any)';}
        end
        def tuple
          t=if defined? @md.rights.license \
          and @md.rights.license=~/\S+/
            txt=@md.rights.license
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
=begin
#% classify
@classify:
 :topic_register:
 :coverage:
 :format:
 :identifier:
 :keywords:
 :relation:
 :subject:
 :type:
 :loc:
 :dewey:
 :pg:
 :isbn:
=end
      def classify_topic_register
        def name
          'classify_topic_register'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_info_note]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata classify document topic register (semi-structured document subject information)';}
        end
        def tuple
          t=if defined? @md.classify.topic_register \
          and @md.classify.topic_register=~/\S+/
            txt=@md.classify.topic_register
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def classify_subject
        def name
          'classify_subject'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_classify_txt_short]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata classify document subject matter [DC3]';}
        end
        def tuple
          t=if defined? @md.classify.subject \
          and @md.classify.subject=~/\S+/
            txt=@md.classify.subject
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def classify_type #check
        def name
          'classify_type'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_classify_txt_short]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata classify document type [DC8]';}
        end
        def tuple
          t=if defined? @md.classify.type \
          and @md.classify.type=~/\S+/
            txt=@md.classify.type
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def classify_loc
        def name
          'classify_loc'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_classify_library]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata classify document Library of Congress';}
        end
        def tuple
          t=if defined? @md.classify.loc \
          and @md.classify.loc=~/\S+/
            txt=@md.classify.loc
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def classify_dewey
        def name
          'classify_dewey'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_classify_library]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata classify document Dewey';}
        end
        def tuple
          t=if defined? @md.classify.dewey \
          and @md.classify.dewey=~/\S+/
            txt=@md.classify.dewey
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def classify_oclc
        def name
          'classify_oclc'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_classify_library]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata classify document Online Computer Library Center number';}
        end
        def tuple
          t=if defined? @md.classify.oclc \
          and @md.classify.oclc=~/\S+/
            txt=@md.classify.oclc
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def classify_pg
        def name
          'classify_pg'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_classify_small]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata classify document project gutenberg (if any)';}
        end
        def tuple
          t=if defined? @md.classify.pg \
          and @md.classify.pg=~/\S+/
            txt=@md.classify.pg
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def classify_isbn
        def name
          'classify_isbn'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_classify_small]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata classify document isbn (if any)';}
        end
        def tuple
          t=if defined? @md.classify.isbn \
          and @md.classify.isbn=~/\S+/
            txt=@md.classify.isbn
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def classify_format
        def name
          'classify_format'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_classify_txt_short]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata classify document format [DC9]';}
        end
        def tuple
          t=if defined? @md.classify.format \
          and @md.classify.format=~/\S+/
            txt=@md.classify.format
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def classify_identifier
        def name
          'classify_identifier'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_classify_identify]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata classify document identifier [DC10]';}
        end
        def tuple
          t=if defined? @md.classify.identifier \
          and @md.classify.identifier=~/\S+/
            txt=@md.classify.identifier
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def classify_relation
        def name
          'classify_relation'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_classify_short]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata classify document relation [DC13]';}
        end
        def tuple
          t=if defined? @md.classify.relation \
          and @md.classify.relation=~/\S+/
            txt=@md.classify.relation
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def classify_coverage
        def name
          'classify_coverage'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_classify_short]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata classify document coverage [DC14]';}
        end
        def tuple
          t=if defined? @md.classify.coverage \
          and @md.classify.coverage=~/\S+/
            txt=@md.classify.coverage
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def classify_keywords
        def name
          'classify_keywords'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_classify_txt_short]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata classify document keywords';}
        end
        def tuple
          t=if defined? @md.classify.keywords \
          and @md.classify.keywords=~/\S+/
            txt=@md.classify.keywords
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
=begin
#% notes
@notes:
 :abstract:
 :comment:
 :description:
 :history:
 :prefix:
 :prefix_a:
 :prefix_b:
 :suffix:
=end
      def notes_abstract
        def name
          'notes_abstract'
        end
        def create_column
          "#{name}                     TEXT NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document notes abstract';}
        end
        def tuple
          t=if defined? @md.notes.abstract \
          and @md.notes.abstract=~/\S+/
            txt=@md.notes.abstract
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def notes_comment
        def name
          'notes_comment'
        end
        def create_column
          "#{name}                       TEXT NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document notes comment';}
        end
        def tuple
          t=if defined? @md.notes.comment \
          and @md.notes.comment=~/\S+/
            txt=@md.notes.comment
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def notes_description
        def name
          'notes_description'
        end
        def create_column
          "#{name}                    TEXT NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document notes description [DC4]';}
        end
        def tuple
          t=if defined? @md.notes.description \
          and @md.notes.description=~/\S+/
            txt=@md.notes.description
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def notes_history   #check, consider removal
        def name
          'notes_history'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_classify_txt_short]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document notes history';}
        end
        def tuple
          t=if defined? @md.notes.history \
          and @md.notes.history=~/\S+/
            txt=@md.notes.history
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def notes_prefix
        def name
          'notes_prefix'
        end
        def create_column
          "#{name}                TEXT NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document notes prefix';}
        end
        def tuple
          t=if defined? @md.notes.prefix \
          and @md.notes.prefix=~/\S+/
            txt=@md.notes.prefix
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def notes_prefix_a
        def name
          'notes_prefix_a'
        end
        def create_column
          "#{name}                TEXT NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document notes prefix_a';}
        end
        def tuple
          t=if defined? @md.notes.prefix_a \
          and @md.notes.prefix_a=~/\S+/
            txt=@md.notes.prefix_a
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def notes_prefix_b
        def name
          'notes_prefix_b'
        end
        def create_column
          "#{name}                TEXT NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document notes prefix_b';}
        end
        def tuple
          t=if defined? @md.notes.prefix_b \
          and @md.notes.prefix_b=~/\S+/
            txt=@md.notes.prefix_b
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def notes_suffix
        def name
          'notes_suffix'
        end
        def create_column                # keep text
          "#{name}                TEXT NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document notes suffix';}
        end
        def tuple
          t=if defined? @md.notes.suffix \
          and @md.notes.suffix=~/\S+/
            txt=@md.notes.suffix
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
=begin
#% src
=end
      def src_filename
        def name
          'src_filename'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_filename]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'sisu markup source text filename';}
        end
        def tuple
          t=if defined? @md.fns \
          and @md.fns=~/\S+/
            txt=@md.fns
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def src_fingerprint
        def name
          'src_fingerprint' #hash/digest, sha256 or md5
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_digest]}) NULL,"
          #"#{name}                TEXT NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
            IS 'sisu markup source text fingerprint, hash digest sha256 (or md5)';}
        end
        def tuple
          t=if defined? @md.dgst \
          and @md.dgst.class==Array \
          and @md.dgst[1]=~/\S+/
            txt=@md.dgst[1]
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def src_filesize
        def name
          'src_filesize'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_filesize]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
            IS 'sisu markup source text file size';}
        end
        def tuple
         t=if defined? @md.filesize \
         and @md.filesize=~/\S+/
           txt=@md.filesize
           special_character_escape(txt)
           ["#{name}, ","'#{txt}', "]
         else ['','']
         end
        end
        self
      end
      def src_word_count
        def name
          'src_word_count'
        end
        def create_column
          "#{name}                TEXT NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
            IS 'sisu markup source text word count';}
        end
        def tuple
          t=if defined? @md.wc_words \
          and @md.wc_words=~/\S+/
            txt=@md.wc_words
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def src_txt                      # consider naming sisusrc
        def name
          'src_text'
        end
        def create_column
          "#{name}                TEXT NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'sisu markup source text (if shared)';}
        end
        def tuple
          t=if @md.mod.inspect=~/import|update/ \
          and FileTest.exist?(@md.fns)
            ["#{name}, ","'#{@sisutxt}', "]
          else ['','']
          end
        end
        self
      end
=begin
#% misc
@make:
 :skin:
@links:
=end
      def fulltext
        def name
          'fulltext'
        end
        def create_column
          "#{name}                TEXT NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
            IS 'document full text clean, searchable';}
        end
        def tuple
          t=if @md.mod.inspect=~/import|update/ \
          and  FileTest.exist?(@md.fns)
            ["#{name}, ","'#{@fulltext}', "]
          else ['','']
          end
        end
        self
      end
      def skin_name                      #check
        def name
          'skin_name'
        end
        def create_column
          "#{name}                 VARCHAR(#{Db[:col_filename]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'source text skin name';}
        end
        def tuple
          t=if defined? @md.skin_name \
          and @md.skin_name=~/\S+/
            txt=@md.skin_name
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def skin_fingerprint                      #check
        def name
          'skin_fingerprint'
        end
        def create_column
          "#{name}                VARCHAR(#{Db[:col_digest]}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'source text skin fingerprint';}
        end
        def tuple
          t=if defined? @md.dgst_skin \
          and @md.dgst_skin.class==Array \
          and @md.dgst_skin[1]=~/\S+/
            txt=@md.dgst_skin[1]
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def skin # you likely want a separate table for skins
        def name
          'skin'
        end
        def create_column
          "#{name}                TEXT NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'source text skin';}
        end
        def tuple
          t=if defined? @md.skin \
          and @md.skin=~/\S+/
            txt=@md.skin
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      def links
        def name
          'links'
        end
        def create_column
          "#{name}                TEXT NULL,"
          #"#{name}                 VARCHAR(#{links.size}) NULL,"
        end
        def column_comment
          %{COMMENT ON COLUMN metadata_and_text.#{name}
           IS 'metadata document links';}
        end
        def tuple
          t=if defined? @md.links \
          and @md.links=~/\S+/
            txt=@md.links
            special_character_escape(txt)
            ["#{name}, ","'#{txt}', "]
          else ['','']
          end
        end
        self
      end
      self
    end
  end
  class Column_size
    def document_clean # restriction not necessary
      60000
    end
    def document_body
      16000
    end
    def document_seg
      120
    end
    def document_seg_full
      120
    end
    def endnote_clean # restriction not necessary
      60000
    end
    def endnote_body
      16000
    end
  end
end
__END__
