#include "reformdoc.h"
#include "reformdoc.moc"
extern QPixmap loadIcon(QString nam);

ReformDoc::ReformDoc( QWidget* parent, float t, float l, float r, float b, bool fp, bool fpe, int Einh)
    : QDialog( parent, "r", true, 0 )
{
    QString ein;
    if (Einh == 0)
    	{
    	Umrech = 1.0;
    	ein = " pt";
    	}
    else
    	{
			Umrech = 0.3527777;
    	ein = " mm";
    	}
    setCaption( tr( "Document Setup" ) );
  	setIcon(loadIcon("AppIcon.xpm"));
    ReformDocLayout = new QVBoxLayout( this );
    ReformDocLayout->setSpacing( 6 );
    ReformDocLayout->setMargin( 10 );
    GroupBox7 = new QGroupBox( this, "GroupBox7" );
    GroupBox7->setTitle( tr( "Margin Guides" ) );
    GroupBox7->setColumnLayout(0, Qt::Vertical );
    GroupBox7->layout()->setSpacing( 0 );
    GroupBox7->layout()->setMargin( 0 );
    GroupBox7Layout = new QHBoxLayout( GroupBox7->layout() );
    GroupBox7Layout->setAlignment( Qt::AlignTop );
    GroupBox7Layout->setSpacing( 0 );
    GroupBox7Layout->setMargin( 10 );
    Layout4 = new QGridLayout;
    Layout4->setSpacing( 6 );
    Layout4->setMargin( 0 );
    TextLabel5 = new QLabel( GroupBox7, "TextLabel5" );
    TextLabel5->setText( tr( "Top:" ) );
    Layout4->addWidget( TextLabel5, 0, 0 );
    TopR = new QSpinBox( GroupBox7, "TopR" );
    TopR->setSuffix( ein );
    TopR->setMaxValue( 1000 );
    TopR->setValue( qRound(t * Umrech) );
    Layout4->addWidget( TopR, 0, 1 );
    Links = new QLabel( GroupBox7, "Links" );
    Links->setText( tr( "Left:" ) );
    Layout4->addWidget( Links, 0, 2 );
    LeftR = new QSpinBox( GroupBox7, "LeftR" );
    LeftR->setSuffix( ein );
    LeftR->setMaxValue( 1000 );
    LeftR->setValue( qRound(l * Umrech) );
    Layout4->addWidget( LeftR, 0, 3 );
    TextLabel7 = new QLabel( GroupBox7, "TextLabel7" );
    TextLabel7->setText( tr( "Bottom:" ) );
    Layout4->addWidget( TextLabel7, 1, 0 );
    BottomR = new QSpinBox( GroupBox7, "BottomR" );
    BottomR->setSuffix( ein );
    BottomR->setMaxValue( 1000 );
    BottomR->setValue( qRound(b * Umrech) );
    Layout4->addWidget( BottomR, 1, 1 );
    Rechts = new QLabel( GroupBox7, "Rechts" );
    Rechts->setText( tr( "Right:" ) );
    Layout4->addWidget( Rechts, 1, 2 );
    RightR = new QSpinBox( GroupBox7, "RightR" );
    RightR->setSuffix( ein );
    RightR->setMaxValue( 1000 );
    RightR->setValue( qRound(r * Umrech) );
    Layout4->addWidget( RightR, 1, 3 );
    Doppelseiten = new QCheckBox( GroupBox7, "Doppelseiten" );
    Doppelseiten->setText( tr( "Facing Pages" ) );
    Doppelseiten->setChecked( fp );
    Layout4->addMultiCellWidget( Doppelseiten, 2, 2, 0, 1 );
    ErsteSeite = new QCheckBox( GroupBox7, "n" );
    ErsteSeite->setText( tr( "Left Page first" ) );
    ErsteSeite->setChecked( fpe );
    Layout4->addMultiCellWidget( ErsteSeite, 2, 2, 2, 3 );
    if (!fp)
    	ErsteSeite->setEnabled(false);
    setDS();
    GroupBox7Layout->addLayout( Layout4 );
    ReformDocLayout->addWidget( GroupBox7 );
    Layout3 = new QHBoxLayout;
    Layout3->setSpacing( 6 );
    Layout3->setMargin( 0 );
    CancelB = new QPushButton( this, "CancelB" );
    CancelB->setMinimumSize( QSize( 86, 25 ) );
    CancelB->setText( tr( "Cancel" ) );
    CancelB->setAutoDefault( FALSE );
    Layout3->addWidget( CancelB );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout3->addItem( spacer );
    OKButton = new QPushButton( this, "OKButton" );
    OKButton->setMinimumSize( QSize( 86, 29 ) );
    OKButton->setText( tr( "OK" ) );
    OKButton->setDefault( TRUE );
    Layout3->addWidget( OKButton );
    ReformDocLayout->addLayout( Layout3 );


    // signals and slots connections
    connect( Doppelseiten, SIGNAL( clicked() ), this, SLOT( setDS() ) );
    connect( OKButton, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( CancelB, SIGNAL( clicked() ), this, SLOT( reject() ) );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
ReformDoc::~ReformDoc()
{
    // no need to delete child widgets, Qt does it all for us
}

void ReformDoc::setDS()
{
    if (Doppelseiten->isChecked())
    	{
    	Links->setText( tr( "Inside:" ) );
    	Rechts->setText( tr( "Outside:" ) );
    	ErsteSeite->setEnabled(true);    	
    	}
    else
    	{
    	Links->setText( tr( "Left:" ) );
    	Rechts->setText( tr( "Right:" ) );
    	ErsteSeite->setEnabled(false);
    	}
}

