/***************************************************************************
                          bookmwin.cpp  -  description
                             -------------------
    begin                : Mon Feb 11 2002
    copyright            : (C) 2002 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "bookmwin.h"
#include "bookmwin.moc"
#include <qpixmap.h>
#include <qdragobject.h>
#include <qpopupmenu.h>
#include <qcursor.h>
#include "pageitem.h"
extern QPixmap loadIcon(QString nam);

BookMItem::BookMItem(QListView* parent, int nr, int s, int el) : QListViewItem(parent)
{
	ItemNr = nr;
	Seite = s;
	Element = el;
	PdfObj = 0;
	Action = "";
	First = 0;
	Last = 0;
	Prev = 0;
	Next = 0;
	Pare = 0;
}

QString BookMItem::key(int, bool) const
{
	QString tmp;
	tmp.sprintf("%5d", ItemNr);
	return tmp;
}

BookMItem::~BookMItem()
{
}

BookMView::BookMView(QWidget* parent, ScribusView *vie) : QListView(parent)
{
	PageItem *ite;
	NrItems = 0;
	Mpressed = false;
	DraggedI = 0;
	First = 1;
	Last = 0;
	setAcceptDrops(true);
	viewport()->setAcceptDrops(true);
	View = vie;
	for (uint a = 0; a < View->Pages.count(); a++)
		{
		for (uint b = 0; b < View->Pages.at(a)->Items.count(); b++)
			{
			ite = View->Pages.at(a)->Items.at(b);
			if ((ite->PType == 4) && (ite->isBookmark))
				{
				QString bm = "";
				QString bm2 = "";
				QString cc;
				for (uint d = 0; d < ite->Ptext.count(); d++)
					{
					cc = ite->Ptext.at(d)->ch;
					if ((cc == QChar(13)) || (cc == QChar(10)))
						break;
					if ((cc == "(") || (cc == ")") || (cc == "\\"))
						bm2 += "\\";
					bm += cc;
					bm2 += cc;
					}
				AddItem(bm, bm2, a, b);
				ite->BMnr = NrItems;
				Last = NrItems;
				}
			}
		}
}

void BookMView::contentsMouseReleaseEvent(QMouseEvent *)
{
	Mpressed = false;
}

void BookMView::contentsMousePressEvent(QMouseEvent* e)
{
	QListView::contentsMousePressEvent(e);
	QListViewItem *i = itemAt(contentsToViewport(e->pos()));
	if (i)
		{
		Mpos = e->pos();
		Mpressed = true;
		}
}

void BookMView::contentsMouseMoveEvent(QMouseEvent* e)
{
	if ((Mpressed) && ((Mpos - e->pos()).manhattanLength() > 4))
		{
		Mpressed = false;
		QListViewItem *i = itemAt(contentsToViewport(Mpos));
		if (i)
			{
			DraggedI = (BookMItem*)i;
			QDragObject *dr = new QTextDrag(i->text(0), this, "BMD");
			dr->drag();
			}
		}
}

void BookMView::contentsDropEvent(QDropEvent *e)
{
	QString text;
	int ins, mov, mret;
	QListViewItem *pp;
	QListViewItem *lv;
	BookMItem *ip;
	BookMItem *ip2;
	BookMItem *ite;
	if (!QTextDrag::decode(e, text))
		{
		e->ignore();
		return;
    }
	QListViewItem *item = itemAt(contentsToViewport(e->pos()));
	BookMItem *Bite = (BookMItem*)item;
  if ((item) && (DraggedI != 0))
  	{
  	if ((BookMItem*)item != DraggedI)
  		{
  		pp = item->parent();
  		while (pp)
  			{
  			if (pp == DraggedI)
  				return;
  			pp = pp->parent();
  			}
			QPopupMenu *pmenu = new QPopupMenu();
			mov = pmenu->insertItem(tr("Move Bookmark"));
			ins = pmenu->insertItem(tr("Insert Bookmark"));
			pmenu->insertItem(tr("Cancel"));
			mret = pmenu->exec(QCursor::pos());
			if (mret == ins)
				{
				lv = DraggedI->parent();
				if (lv)
					lv = lv->firstChild();
				else
					lv = firstChild();
				if (!DraggedI->Prev == 0)
					{
					while (lv)
						{
						ip = (BookMItem*)lv;
						if (ip->ItemNr == DraggedI->Prev)
							break;
						lv = lv->nextSibling();
						}
					ip = (BookMItem*)lv;
					lv = DraggedI->nextSibling();
					if (lv)
						{
						ip2 = (BookMItem*)lv;
						ip2->Prev = ip->ItemNr;
						ip->Next = ip2->ItemNr;
						}
					else
						ip->Next = 0;
					}
				lv = DraggedI->parent();
  			item->insertItem(DraggedI);
				if (lv)
					lv = lv->firstChild();
				else
					lv = firstChild();
				if (DraggedI->Prev == 0)
					{
					ip = (BookMItem*)lv;
					ip->Prev = 0;
					}
				QListViewItemIterator it(this);
				for ( ; it.current(); ++it)
					{
					ite = (BookMItem*)it.current();
					if (ite->ItemNr == DraggedI->ItemNr)
						DraggedI = ite;
					}
  			DraggedI->Pare = Bite->ItemNr;
  			ip = (BookMItem*)item->firstChild();
  			Bite->First = ip->ItemNr;
  			lv = item->firstChild();
  			while (lv)
  				{
  				if (!lv->nextSibling())
  					{
  					ip = (BookMItem*)lv;
  					Bite->Last = ip->ItemNr;
  					break;
  					}
  				lv = lv->nextSibling();
  				}
  			if (DraggedI->nextSibling())
  				{
  				ip = (BookMItem*)DraggedI->nextSibling();
  				DraggedI->Next = ip->ItemNr;
  				ip->Prev = DraggedI->ItemNr;
  				}
  			else
  				DraggedI->Next = 0;
  			if (DraggedI != item->firstChild())
  				{
  				ip = (BookMItem*)DraggedI->itemAbove();
  				DraggedI->Prev = ip->ItemNr;
  				ip->Next = DraggedI->ItemNr;
  				}
  			else
  				DraggedI->Prev = 0;
  			}
			if (mret == mov)
				{
				lv = DraggedI->parent();
				if (lv)
					lv = lv->firstChild();
				else
					lv = firstChild();
				if (DraggedI->Prev == 0)
					{
					ip = (BookMItem*)lv;
					ip->Prev = 0;
					}
				else
					{
					while (lv)
						{
						ip = (BookMItem*)lv;
						if (ip->ItemNr == DraggedI->Prev)
							break;
						lv = lv->nextSibling();
						}
					}
				ip = (BookMItem*)lv;
				lv = DraggedI->nextSibling();
				if (lv)
					{
					ip2 = (BookMItem*)lv;
					ip2->Prev = ip->ItemNr;
					ip->Next = ip2->ItemNr;
					}
				else
					ip->Next = 0;
  			DraggedI->moveItem(item);
				QListViewItemIterator it2(this);
				for ( ; it2.current(); ++it2)
					{
					ite = (BookMItem*)it2.current();
					if (ite->ItemNr == DraggedI->ItemNr)
						DraggedI = ite;
					}
  			ip = (BookMItem*)item;
  			DraggedI->Pare = ip->Pare;
  			DraggedI->Prev = ip->ItemNr;
  			ip->Next = DraggedI->ItemNr;
  			if (DraggedI->nextSibling())
  				{
  				ip = (BookMItem*)DraggedI->nextSibling();
  				DraggedI->Next = ip->ItemNr;
  				ip->Prev = DraggedI->ItemNr;
  				}
  			else
  				DraggedI->Next = 0;  	
  			lv = item->parent();
				if (lv)
					{
					ip = (BookMItem*)lv->firstChild();
					ip2 = (BookMItem*)lv;
					ip2->First = ip->ItemNr;
  				lv = lv->firstChild();
  				while (lv)
  					{
  					if (!lv->nextSibling())
  						{
  						ip = (BookMItem*)lv;
  						ip2->Last = ip->ItemNr;
  						break;
  						}
  					lv = lv->nextSibling();
  					}
					}		
  			}
			delete pmenu;	
  		DraggedI = 0;
  		}
  	}
}

void BookMView::contentsDragMoveEvent(QDragMoveEvent *e)
{
	QString text;
	if (!QTextDrag::decode(e, text))
		{
		e->ignore();
		return;
    }
	QListViewItem *item = itemAt(contentsToViewport(e->pos()));
  if (item)
  	{
		setSelected(item, true);
		e->accept();
  	}
  else
		e->ignore();
}

void BookMView::AddItem(QString text, QString Tit, int s, int el)
{
  QListViewItem *lv = firstChild();
  while (lv)
  	{
  	if (!lv->nextSibling())
  		break;
  	lv = lv->nextSibling();
  	}
  BookMItem *ip;
	BookMItem *ite = new BookMItem(this, NrItems+1, s, el);
	ite->setText(0, text);
	ite->Titel = Tit;
	ite->Next = 0;
  if (lv)
  	{
  	ip = (BookMItem*)lv;
  	ip->Next = ite->ItemNr;
  	ite->Prev = ip->ItemNr;
  	}
	NrItems++;
}

void BookMView::DeleteItem(int nr)
{
	BookMItem *ite;
	QListViewItemIterator it(this);
	for ( ; it.current(); ++it)
		{
		ite = (BookMItem*)it.current();
		if (ite->ItemNr == nr)
			{
			QListViewItem *pp = ite->firstChild();
			while (pp)
				{
				if (ite->parent())
					ite->parent()->insertItem(pp);
				else
					pp->moveItem(ite);
				pp = ite->firstChild();
				}
			delete ite;
			}
		}
}

void BookMView::SetAction(int nr, QString Act)
{
	BookMItem *ite;
	QListViewItemIterator it(this);
	for ( ; it.current(); ++it)
		{
		ite = (BookMItem*)it.current();
		if (ite->ItemNr == nr)
			{
			ite->Action = Act;
			}
		}
}

BookMView::~BookMView()
{
}
