/*
 * Decompiled with CFR 0.152.
 */
package molikin.gui;

import driftwood.data.UberSet;
import driftwood.gui.AttentiveTextField;
import driftwood.gui.FatJList;
import driftwood.gui.TablePane2;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.Residue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import molikin.ResRanger;

public class SelectorPane
extends TablePane2
implements ListSelectionListener,
ActionListener {
    JList modelList;
    JList chainList;
    JList resNumList;
    JList resTypeList;
    JTextField resRangeField;
    ResRanger resRanger;

    public SelectorPane(CoordinateFile coordinateFile) {
        this.buildGUI1();
        this.populateLists(coordinateFile);
        this.buildGUI2();
    }

    private void buildGUI1() {
        this.modelList = new FatJList(0, 4);
        this.modelList.setVisibleRowCount(6);
        this.chainList = new FatJList(0, 4);
        this.chainList.setVisibleRowCount(6);
        this.resNumList = new FatJList(0, 4);
        this.resNumList.addListSelectionListener(this);
        this.resNumList.setVisibleRowCount(6);
        this.resTypeList = new FatJList(0, 4);
        this.resTypeList.setVisibleRowCount(6);
        this.resRangeField = new AttentiveTextField();
        this.resRangeField.addActionListener(this);
    }

    private void buildGUI2() {
        boolean bl = this.modelList.getModel().getSize() > 1;
        boolean bl2 = this.chainList.getModel().getSize() > 1;
        int n = 2;
        if (bl) {
            ++n;
        }
        if (bl2) {
            ++n;
        }
        this.insets(2, 8, 2, 8).memorize();
        this.weights(1.0, 0.0).memorize();
        if (bl) {
            this.addCell(new JLabel("Models"));
        }
        if (bl2) {
            this.addCell(new JLabel("Chains"));
        }
        this.addCell(new JLabel("Numbers"));
        this.addCell(new JLabel("Types"));
        this.newRow();
        this.weights(1.0, 1.0).memorize();
        if (bl) {
            this.hfill(true).vfill(true).addCell(new JScrollPane(this.modelList));
        }
        if (bl2) {
            this.hfill(true).vfill(true).addCell(new JScrollPane(this.chainList));
        }
        this.hfill(true).vfill(true).addCell(new JScrollPane(this.resNumList));
        this.hfill(true).vfill(true).addCell(new JScrollPane(this.resTypeList));
        this.newRow();
        this.weights(1.0, 0.0).memorize();
        this.startSubtable(n, 1);
        this.insets(2, 8, 2, 8).memorize();
        this.weights(0.0, 1.0).addCell(new JLabel("Numbers"));
        this.hfill(true).addCell(this.resRangeField);
        this.newRow();
        this.addCell(new JLabel("e.g. 5, 34, 77-100, 120a-120f, 200"), 2, 1);
        this.endSubtable();
    }

    private void populateLists(CoordinateFile coordinateFile) {
        Object[] objectArray2;
        Collection collection = coordinateFile.getModels();
        this.modelList.setListData(collection.toArray());
        this.modelList.setSelectionInterval(0, collection.size() - 1);
        ArrayList arrayList = new ArrayList();
        UberSet uberSet = new UberSet();
        HashSet<String> hashSet = new HashSet<String>();
        for (Object[] objectArray2 : collection) {
            arrayList.addAll(objectArray2.getResidues());
            uberSet.addAll(objectArray2.getChainIDs());
            for (Residue residue : objectArray2.getResidues()) {
                hashSet.add(residue.getName());
            }
        }
        this.chainList.setListData(uberSet.toArray());
        this.chainList.setSelectionInterval(0, uberSet.size() - 1);
        this.resRanger = new ResRanger(arrayList);
        Collection collection2 = this.resRanger.getAllNumbers();
        this.resNumList.setListData(collection2.toArray());
        this.resNumList.setSelectionInterval(0, collection2.size() - 1);
        objectArray2 = hashSet.toArray();
        Arrays.sort(objectArray2);
        this.resTypeList.setListData(objectArray2);
        this.resTypeList.setSelectionInterval(0, hashSet.size() - 1);
    }

    public Collection getSelectedModels() {
        return Arrays.asList(this.modelList.getSelectedValues());
    }

    public Collection getSelectedChains() {
        return Arrays.asList(this.chainList.getSelectedValues());
    }

    public Set getSelectedResidues(Model model) {
        return this.getSelectedResidues(model.getResidues());
    }

    public Set getSelectedResidues(Collection collection) {
        HashSet<Object> hashSet = new HashSet<Object>(Arrays.asList(this.chainList.getSelectedValues()));
        HashSet<Object> hashSet2 = new HashSet<Object>(Arrays.asList(this.resTypeList.getSelectedValues()));
        Set set = this.resRanger.getSelectedNumbers();
        UberSet uberSet = new UberSet();
        for (Residue residue : collection) {
            String string;
            if (!hashSet2.contains(residue.getName()) || !hashSet.contains(residue.getChain()) || !set.contains(string = residue.getSequenceNumber().trim() + residue.getInsertionCode().trim())) continue;
            uberSet.add(residue);
        }
        return uberSet;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.resNumList.getValueIsAdjusting()) {
            return;
        }
        if (this.resRanger != null) {
            this.resRanger.select(this.resNumList.getSelectedIndices());
            this.resRangeField.setText(this.resRanger.getSelectionString());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.resRanger.select(this.resRangeField.getText().toUpperCase());
        BitSet bitSet = this.resRanger.getSelectionMask();
        int[] nArray = new int[bitSet.cardinality()];
        int n = 0;
        int n2 = 0;
        for (n = 0; n < bitSet.length(); ++n) {
            if (!bitSet.get(n)) continue;
            nArray[n2++] = n;
        }
        this.resNumList.setSelectedIndices(nArray);
    }
}

