/*
 * Decompiled with CFR 0.152.
 */
package king.tool.draw;

import driftwood.data.CheapSet;
import driftwood.data.IdentityHashFunction;
import driftwood.gui.FoldingBox;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane;
import driftwood.gui.TablePane2;
import driftwood.r3.Builder;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import king.BasicTool;
import king.GroupEditor;
import king.PointEditor;
import king.ToolBox;
import king.core.Engine2D;
import king.core.KGroup;
import king.core.KIterator;
import king.core.KList;
import king.core.KPaint;
import king.core.KPalette;
import king.core.KPoint;
import king.core.KView;
import king.core.Kinemage;
import king.core.Painter;
import king.points.AbstractPoint;
import king.points.BallPoint;
import king.points.DotPoint;
import king.points.LabelPoint;
import king.points.SpherePoint;
import king.points.TrianglePoint;
import king.points.VectorPoint;

public class DrawingTool
extends BasicTool {
    static final int AUGER_RADIUS = 40;
    static final String PAINT_CYLINDER = "circle";
    static final String PAINT_SPHERE = "sphere";
    static final String PAINT_POINT = "one point";
    TablePane2 ui;
    JRadioButton rbDoNothing;
    JRadioButton rbRevealList;
    JRadioButton rbEditGroup;
    JRadioButton rbEditSubgroup;
    JRadioButton rbEditList;
    JRadioButton rbEditPoint;
    JRadioButton rbPaintPoints;
    JRadioButton rbMovePoint;
    JRadioButton rbLineSegment;
    JRadioButton rbDottedLine;
    JRadioButton rbArcSegment;
    JRadioButton rbBalls;
    JRadioButton rbLabels;
    JRadioButton rbDots;
    JRadioButton rbTriangle;
    JRadioButton rbPunch;
    JRadioButton rbPrune;
    JRadioButton rbAuger;
    JRadioButton rbSphereCrop;
    Builder builder = new Builder();
    KPoint lineseg1 = null;
    KPoint lineseg2 = null;
    KPoint triang1 = null;
    KPoint triang2 = null;
    KPoint triang3 = null;
    KPoint arcseg1 = null;
    KPoint arcseg2 = null;
    KPoint arcseg3 = null;
    GroupEditor grEditor = new GroupEditor(this.kMain, this.kMain.getTopWindow());
    PointEditor ptEditor = new PointEditor(this.kMain);
    KPoint draggedPoint = null;
    KPoint[] allPoints = null;
    JComboBox cmPaintMode;
    JComboBox cmPointPaint;
    JTextField tfShortenLine;
    JCheckBox cbLabelIsID;
    JTextField tfNumDots;
    JTextField tfArcDegrees;
    JTextField tfArcShorten;
    JCheckBox cbArcArrowhead;
    JTextField tfTriangleSize;
    JTextField tfCropRadius;
    LinkedList undoStack = new LinkedList();
    int subgroupCounter = 0;
    int lastAugerX;
    int lastAugerY;

    public DrawingTool(ToolBox toolBox) {
        super(toolBox);
        this.buildGUI();
    }

    private void buildGUI() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rbDoNothing = new JRadioButton("Do nothing (navigate)");
        buttonGroup.add(this.rbDoNothing);
        this.rbRevealList = new JRadioButton("Reveal in hierarchy");
        buttonGroup.add(this.rbRevealList);
        this.rbEditGroup = new JRadioButton("Edit group props");
        buttonGroup.add(this.rbEditGroup);
        this.rbEditSubgroup = new JRadioButton("Edit subgroup props");
        buttonGroup.add(this.rbEditSubgroup);
        this.rbEditList = new JRadioButton("Edit list props");
        buttonGroup.add(this.rbEditList);
        this.rbEditPoint = new JRadioButton("Edit point props");
        buttonGroup.add(this.rbEditPoint);
        this.rbPaintPoints = new JRadioButton("Paint points");
        buttonGroup.add(this.rbPaintPoints);
        this.rbMovePoint = new JRadioButton("Move points");
        buttonGroup.add(this.rbMovePoint);
        this.rbLineSegment = new JRadioButton("Draw line segments");
        buttonGroup.add(this.rbLineSegment);
        this.rbDottedLine = new JRadioButton("Draw dotted lines");
        buttonGroup.add(this.rbDottedLine);
        this.rbArcSegment = new JRadioButton("Draw curved arc");
        buttonGroup.add(this.rbArcSegment);
        this.rbBalls = new JRadioButton("Draw balls");
        buttonGroup.add(this.rbBalls);
        this.rbLabels = new JRadioButton("Draw labels");
        buttonGroup.add(this.rbLabels);
        this.rbDots = new JRadioButton("Draw dots");
        buttonGroup.add(this.rbDots);
        this.rbTriangle = new JRadioButton("Draw triangles");
        buttonGroup.add(this.rbTriangle);
        this.rbPunch = new JRadioButton("Punch one point");
        buttonGroup.add(this.rbPunch);
        this.rbPrune = new JRadioButton("Prune a polyline");
        buttonGroup.add(this.rbPrune);
        this.rbAuger = new JRadioButton("Auger a region");
        buttonGroup.add(this.rbAuger);
        this.rbSphereCrop = new JRadioButton("Spherical crop");
        buttonGroup.add(this.rbSphereCrop);
        this.cmPaintMode = new JComboBox<String>(new String[]{PAINT_CYLINDER, PAINT_SPHERE, PAINT_POINT});
        this.cmPaintMode.setSelectedItem(PAINT_CYLINDER);
        this.cmPointPaint = new JComboBox<Object>(KPalette.getStandardMap().values().toArray());
        this.cmPointPaint.setSelectedItem(KPalette.green);
        TablePane2 tablePane2 = new TablePane2();
        tablePane2.addCell(new JLabel("Use color:"));
        tablePane2.hfill(true).addCell(this.cmPointPaint);
        tablePane2.newRow();
        tablePane2.addCell(new JLabel("Selection:"));
        tablePane2.hfill(true).addCell(this.cmPaintMode);
        FoldingBox foldingBox = new FoldingBox(this.rbPaintPoints, (Component)tablePane2);
        foldingBox.setAutoPack(true);
        foldingBox.setIndent(10);
        this.tfShortenLine = new JTextField("0.0", 6);
        TablePane tablePane = new TablePane();
        tablePane.addCell(new JLabel("Shorten lines by:"));
        tablePane.addCell(this.tfShortenLine);
        FoldingBox foldingBox2 = new FoldingBox(this.rbLineSegment, (Component)tablePane);
        foldingBox2.setAutoPack(true);
        foldingBox2.setIndent(10);
        this.tfNumDots = new JTextField("10", 6);
        TablePane tablePane3 = new TablePane();
        tablePane3.addCell(new JLabel("Number of dots:"));
        tablePane3.addCell(this.tfNumDots);
        FoldingBox foldingBox3 = new FoldingBox(this.rbDottedLine, (Component)tablePane3);
        foldingBox3.setAutoPack(true);
        foldingBox3.setIndent(10);
        this.tfArcDegrees = new JTextField("120", 6);
        this.tfArcShorten = new JTextField("0", 6);
        this.cbArcArrowhead = new JCheckBox("Arrowhead", false);
        TablePane tablePane4 = new TablePane();
        tablePane4.addCell(new JLabel("Curvature (degrees):"));
        tablePane4.addCell(this.tfArcDegrees);
        tablePane4.newRow();
        tablePane4.addCell(new JLabel("Shorten by (degrees):"));
        tablePane4.addCell(this.tfArcShorten);
        tablePane4.newRow();
        tablePane4.addCell(this.cbArcArrowhead);
        FoldingBox foldingBox4 = new FoldingBox(this.rbArcSegment, (Component)tablePane4);
        foldingBox4.setAutoPack(true);
        foldingBox4.setIndent(10);
        this.cbLabelIsID = new JCheckBox("Use ID of picked point for label", false);
        TablePane tablePane5 = new TablePane();
        tablePane5.addCell(this.cbLabelIsID);
        FoldingBox foldingBox5 = new FoldingBox(this.rbLabels, (Component)tablePane5);
        foldingBox5.setAutoPack(true);
        foldingBox5.setIndent(10);
        this.tfTriangleSize = new JTextField("1.0", 6);
        TablePane tablePane6 = new TablePane();
        tablePane6.addCell(new JLabel("Fractional size:"));
        tablePane6.addCell(this.tfTriangleSize);
        FoldingBox foldingBox6 = new FoldingBox(this.rbTriangle, (Component)tablePane6);
        foldingBox6.setAutoPack(true);
        foldingBox6.setIndent(10);
        this.tfCropRadius = new JTextField("10", 6);
        TablePane tablePane7 = new TablePane();
        tablePane7.addCell(new JLabel("Crop radius:"));
        tablePane7.addCell(this.tfCropRadius);
        FoldingBox foldingBox7 = new FoldingBox(this.rbSphereCrop, (Component)tablePane7);
        foldingBox7.setAutoPack(true);
        foldingBox7.setIndent(10);
        this.rbEditList.setSelected(true);
        JButton jButton = new JButton(new ReflectiveAction("Undo drawing", null, this, "onUndo"));
        JButton jButton2 = new JButton(new ReflectiveAction("New subgroup", null, this, "onNewSubgroup"));
        this.ui = new TablePane2();
        this.ui.hfill(true).vfill(true).insets(0, 1, 0, 1).memorize();
        this.ui.addCell(this.rbDoNothing).newRow();
        this.ui.addCell(this.rbRevealList).newRow();
        this.ui.addCell(this.rbEditGroup).newRow();
        this.ui.addCell(this.rbEditSubgroup).newRow();
        this.ui.addCell(this.rbEditList).newRow();
        this.ui.addCell(this.rbEditPoint).newRow();
        this.ui.addCell(this.rbPaintPoints).newRow();
        this.ui.addCell(foldingBox).newRow();
        this.ui.addCell(this.rbMovePoint).newRow();
        this.ui.addCell(TablePane2.strut(0, 6)).newRow();
        this.ui.addCell(this.rbLineSegment).newRow();
        this.ui.addCell(foldingBox2).newRow();
        this.ui.addCell(this.rbDottedLine).newRow();
        this.ui.addCell(foldingBox3).newRow();
        this.ui.addCell(this.rbArcSegment).newRow();
        this.ui.addCell(foldingBox4).newRow();
        this.ui.addCell(this.rbBalls).newRow();
        this.ui.addCell(this.rbLabels).newRow();
        this.ui.addCell(foldingBox5).newRow();
        this.ui.addCell(this.rbDots).newRow();
        this.ui.addCell(this.rbTriangle).newRow();
        this.ui.addCell(foldingBox6).newRow();
        this.ui.addCell(TablePane2.strut(0, 6)).newRow();
        this.ui.addCell(this.rbPunch).newRow();
        this.ui.addCell(this.rbPrune).newRow();
        this.ui.addCell(this.rbAuger).newRow();
        this.ui.addCell(this.rbSphereCrop).newRow();
        this.ui.addCell(foldingBox7).newRow();
        this.ui.addCell(jButton2).newRow();
        this.ui.addCell(jButton).newRow();
    }

    public void click(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        super.click(n, n2, kPoint, mouseEvent);
        if (this.rbDoNothing.isSelected()) {
            return;
        }
        if (this.rbRevealList.isSelected()) {
            this.doRevealList(n, n2, kPoint, mouseEvent);
        } else if (this.rbEditGroup.isSelected()) {
            this.doEditGroup(n, n2, kPoint, mouseEvent);
        } else if (this.rbEditSubgroup.isSelected()) {
            this.doEditSubgroup(n, n2, kPoint, mouseEvent);
        } else if (this.rbEditList.isSelected()) {
            this.doEditList(n, n2, kPoint, mouseEvent);
        } else if (this.rbEditPoint.isSelected()) {
            this.doEditPoint(n, n2, kPoint, mouseEvent);
        } else if (this.rbPaintPoints.isSelected()) {
            this.doPaintPoints(n, n2, kPoint, mouseEvent);
        } else {
            if (this.rbMovePoint.isSelected()) {
                return;
            }
            if (this.rbLineSegment.isSelected()) {
                this.doLineSegment(n, n2, kPoint, mouseEvent);
            } else if (this.rbDottedLine.isSelected()) {
                this.doDottedLine(n, n2, kPoint, mouseEvent);
            } else if (this.rbArcSegment.isSelected()) {
                this.doArcSegment(n, n2, kPoint, mouseEvent);
            } else if (this.rbBalls.isSelected()) {
                this.doBalls(n, n2, kPoint, mouseEvent);
            } else if (this.rbLabels.isSelected()) {
                this.doLabels(n, n2, kPoint, mouseEvent);
            } else if (this.rbDots.isSelected()) {
                this.doDots(n, n2, kPoint, mouseEvent);
            } else if (this.rbTriangle.isSelected()) {
                this.doTriangle(n, n2, kPoint, mouseEvent);
            } else if (this.rbPunch.isSelected()) {
                this.doPunch(n, n2, kPoint, mouseEvent);
            } else if (this.rbPrune.isSelected()) {
                this.doPrune(n, n2, kPoint, mouseEvent);
            } else if (this.rbAuger.isSelected()) {
                this.doAuger(n, n2, kPoint, mouseEvent);
            } else if (this.rbSphereCrop.isSelected()) {
                this.doSphereCrop(n, n2, kPoint, mouseEvent);
            }
        }
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null) {
            kinemage.setModified(true);
        }
    }

    public void c_click(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        super.click(n, n2, kPoint, mouseEvent);
    }

    public void onUndo(ActionEvent actionEvent) {
        if (this.undoStack.size() < 1) {
            return;
        }
        SoftReference softReference = (SoftReference)this.undoStack.removeLast();
        UndoStep undoStep = (UndoStep)softReference.get();
        if (undoStep == null) {
            this.undoStack.clear();
        } else {
            undoStep.undo();
        }
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
    }

    public void onNewSubgroup(ActionEvent actionEvent) {
        this.getDrawingSubgroup(true);
    }

    protected KGroup getDrawingGroup() {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return null;
        }
        KGroup kGroup = (KGroup)kinemage.metadata.get(this.getClass().getName() + ".drawNewGroup");
        if (kGroup == null || kGroup.getKinemage() == null) {
            kGroup = new KGroup("Drawn objs");
            kinemage.add(kGroup);
            kinemage.metadata.put(this.getClass().getName() + ".drawNewGroup", kGroup);
        }
        return kGroup;
    }

    protected KGroup getDrawingSubgroup(boolean bl) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return null;
        }
        KGroup kGroup = this.getDrawingGroup();
        KGroup kGroup2 = (KGroup)kinemage.metadata.get(this.getClass().getName() + ".drawNewSubgroup");
        if (kGroup2 == null || bl || kGroup2.getKinemage() == null) {
            ++this.subgroupCounter;
            kGroup2 = new KGroup("Drawn objs " + this.subgroupCounter);
            kGroup2.setDominant(true);
            kGroup.add(kGroup2);
            kinemage.metadata.put(this.getClass().getName() + ".drawNewSubgroup", kGroup2);
        }
        return kGroup2;
    }

    protected KList getDrawingList(String string, String string2) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return null;
        }
        KGroup kGroup = this.getDrawingSubgroup(false);
        String string3 = this.getClass().getName() + ".drawNewList." + string + "." + string2 + "." + this.subgroupCounter;
        KList kList = (KList)kinemage.metadata.get(string3);
        if (kList == null || kList.getKinemage() == null) {
            kList = new KList(string, "Drawn " + string + "s");
            KPaint[] kPaintArray = new KPaint[]{KPalette.magenta, KPalette.green, KPalette.gold};
            kList.setColor(kPaintArray[this.subgroupCounter % kPaintArray.length]);
            kGroup.add(kList);
            kinemage.metadata.put(string3, kList);
        }
        return kList;
    }

    public void doRevealList(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint == null) {
            return;
        }
        KList kList = (KList)kPoint.getParent();
        if (kList == null) {
            return;
        }
        this.kMain.getKinTree().reveal(kList);
        this.kMain.getKinTree().show();
    }

    public void doEditGroup(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint == null) {
            return;
        }
        KList kList = (KList)kPoint.getParent();
        if (kList == null) {
            return;
        }
        KGroup kGroup = (KGroup)kList.getParent();
        if (kGroup == null) {
            return;
        }
        KGroup kGroup2 = (KGroup)kGroup.getParent();
        if (kGroup2 == null) {
            return;
        }
        this.grEditor.editGroup(kGroup2);
    }

    public void doEditSubgroup(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint == null) {
            return;
        }
        KList kList = (KList)kPoint.getParent();
        if (kList == null) {
            return;
        }
        KGroup kGroup = (KGroup)kList.getParent();
        if (kGroup == null) {
            return;
        }
        this.grEditor.editSubgroup(kGroup);
    }

    public void doEditList(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint == null) {
            return;
        }
        KList kList = (KList)kPoint.getParent();
        if (kList == null) {
            return;
        }
        this.grEditor.editList(kList);
    }

    public void doEditPoint(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint != null) {
            this.ptEditor.editPoint(kPoint);
        }
    }

    protected void doPaintPoints(int n, int n2, KPoint kPoint2, MouseEvent mouseEvent) {
        Engine2D engine2D = this.kCanvas.getEngine();
        Collection<Object> collection = Collections.emptySet();
        String string = (String)this.cmPaintMode.getSelectedItem();
        if (string == PAINT_CYLINDER) {
            collection = engine2D.pickAll2D(n, n2, this.services.doSuperpick.isSelected(), 40.0);
        } else if (string == PAINT_SPHERE && kPoint2 != null) {
            collection = engine2D.pickAll3D(kPoint2.getX(), kPoint2.getY(), kPoint2.getZ(), this.services.doSuperpick.isSelected(), 40.0 / engine2D.zoom3D);
        } else if (string == PAINT_POINT && kPoint2 != null) {
            collection = Collections.singleton(kPoint2);
        }
        KPaint kPaint = (KPaint)this.cmPointPaint.getSelectedItem();
        for (KPoint kPoint : collection) {
            kPoint.setColor(kPaint);
        }
    }

    protected void doLineSegment(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint == null) {
            return;
        }
        if (this.lineseg1 == null) {
            this.lineseg1 = kPoint;
        } else if (!this.lineseg1.equals(kPoint)) {
            this.lineseg2 = kPoint;
            KList kList = this.getDrawingList("vector", "lineSegment");
            if (kList == null) {
                return;
            }
            this.undoStack.addLast(new SoftReference<ListChildrenUndo>(new ListChildrenUndo(kList)));
            double d = 0.0;
            try {
                d = Double.parseDouble(this.tfShortenLine.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double d2 = this.lineseg1.getX() - this.lineseg2.getX();
            double d3 = this.lineseg1.getY() - this.lineseg2.getY();
            double d4 = this.lineseg1.getZ() - this.lineseg2.getZ();
            double d5 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
            double d6 = 1.0 - d / d5;
            VectorPoint vectorPoint = new VectorPoint("drawn", null);
            vectorPoint.setX(d6 * this.lineseg1.getX() + (1.0 - d6) * this.lineseg2.getX());
            vectorPoint.setY(d6 * this.lineseg1.getY() + (1.0 - d6) * this.lineseg2.getY());
            vectorPoint.setZ(d6 * this.lineseg1.getZ() + (1.0 - d6) * this.lineseg2.getZ());
            kList.add(vectorPoint);
            VectorPoint vectorPoint2 = new VectorPoint("drawn", vectorPoint);
            vectorPoint2.setX(d6 * this.lineseg2.getX() + (1.0 - d6) * this.lineseg1.getX());
            vectorPoint2.setY(d6 * this.lineseg2.getY() + (1.0 - d6) * this.lineseg1.getY());
            vectorPoint2.setZ(d6 * this.lineseg2.getZ() + (1.0 - d6) * this.lineseg1.getZ());
            kList.add(vectorPoint2);
            this.lineseg2 = null;
            this.lineseg1 = null;
            Kinemage kinemage = this.kMain.getKinemage();
            if (kinemage == null) {
                return;
            }
        }
    }

    protected void doBalls(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint == null) {
            return;
        }
        KList kList = this.getDrawingList("ball", "balls");
        if (kList == null) {
            return;
        }
        this.undoStack.addLast(new SoftReference<ListChildrenUndo>(new ListChildrenUndo(kList)));
        BallPoint ballPoint = new BallPoint("drawn");
        ballPoint.setX(kPoint.getX());
        ballPoint.setY(kPoint.getY());
        ballPoint.setZ(kPoint.getZ());
        kList.add(ballPoint);
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
    }

    protected void doLabels(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint == null) {
            return;
        }
        KList kList = this.getDrawingList("label", "labels");
        if (kList == null) {
            return;
        }
        Object object = kPoint.getName();
        if (!this.cbLabelIsID.isSelected() && (object = JOptionPane.showInputDialog(this.kMain.getTopWindow(), "Enter label text", "Enter label text", 3, null, null, object)) == null) {
            return;
        }
        this.undoStack.addLast(new SoftReference<ListChildrenUndo>(new ListChildrenUndo(kList)));
        LabelPoint labelPoint = new LabelPoint(object.toString());
        labelPoint.setX(kPoint.getX());
        labelPoint.setY(kPoint.getY());
        labelPoint.setZ(kPoint.getZ());
        kList.add(labelPoint);
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
    }

    protected void doDots(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint == null) {
            return;
        }
        KList kList = this.getDrawingList("dot", "dots");
        if (kList == null) {
            return;
        }
        this.undoStack.addLast(new SoftReference<ListChildrenUndo>(new ListChildrenUndo(kList)));
        DotPoint dotPoint = new DotPoint("drawn");
        dotPoint.setX(kPoint.getX());
        dotPoint.setY(kPoint.getY());
        dotPoint.setZ(kPoint.getZ());
        kList.add(dotPoint);
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
    }

    protected void doDottedLine(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint == null) {
            return;
        }
        if (this.lineseg1 == null) {
            this.lineseg1 = kPoint;
        } else {
            this.lineseg2 = kPoint;
            KList kList = this.getDrawingList("dot", "dottedLine");
            if (kList == null) {
                return;
            }
            this.undoStack.addLast(new SoftReference<ListChildrenUndo>(new ListChildrenUndo(kList)));
            Triple triple = new Triple(this.lineseg1.getX(), this.lineseg1.getY(), this.lineseg1.getZ());
            Triple triple2 = new Triple(this.lineseg2.getX(), this.lineseg2.getY(), this.lineseg2.getZ());
            Triple triple3 = new Triple();
            Triple triple4 = new Triple();
            int n3 = 10;
            try {
                n3 = Math.max(1, Integer.parseInt(this.tfNumDots.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            for (double d = 1.0; d <= (double)n3; d += 1.0) {
                triple3.likeProd(1.0 - d / ((double)n3 + 1.0), triple);
                triple4.likeProd(d / ((double)n3 + 1.0), triple2);
                triple3.add(triple4);
                DotPoint dotPoint = new DotPoint("drawn");
                dotPoint.setX(triple3.getX());
                dotPoint.setY(triple3.getY());
                dotPoint.setZ(triple3.getZ());
                kList.add(dotPoint);
            }
            this.lineseg2 = null;
            this.lineseg1 = null;
            Kinemage kinemage = this.kMain.getKinemage();
            if (kinemage == null) {
                return;
            }
        }
    }

    protected void doArcSegment(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint == null) {
            return;
        }
        if (this.arcseg1 == null) {
            this.arcseg1 = kPoint;
        } else if (this.arcseg2 == null) {
            this.arcseg2 = kPoint;
        } else {
            this.arcseg3 = kPoint;
            KList kList = this.getDrawingList("vector", "arcSegment");
            if (kList == null) {
                return;
            }
            this.undoStack.addLast(new SoftReference<ListChildrenUndo>(new ListChildrenUndo(kList)));
            Triple triple = new Triple(this.arcseg1.getX(), this.arcseg1.getY(), this.arcseg1.getZ());
            Triple triple2 = new Triple(this.arcseg2.getX(), this.arcseg2.getY(), this.arcseg2.getZ());
            Triple triple3 = new Triple(this.arcseg3.getX(), this.arcseg3.getY(), this.arcseg3.getZ());
            Triple triple4 = new Triple().likeMidpoint(triple2, triple3);
            double d = 90.0;
            try {
                d = Double.parseDouble(this.tfArcDegrees.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (d < 1.0) {
                d = 1.0;
            }
            if (d > 360.0) {
                d = 360.0;
            }
            double d2 = d < 180.0 ? d : 360.0 - d;
            double d3 = triple2.distance(triple3);
            double d4 = d3 / 2.0;
            double d5 = d4 / Math.tan(Math.toRadians(d2 / 2.0));
            Triple triple5 = this.builder.construct4(triple, triple3, triple4, d5, 90.0, d < 180.0 ? 180 : 0);
            Triple triple6 = new Triple().likeNormal(triple2, triple, triple3).add(triple5);
            double d6 = 0.0;
            try {
                d6 = Double.parseDouble(this.tfArcShorten.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Triple triple7 = new Triple();
            Transform transform = new Transform();
            AbstractPoint abstractPoint = null;
            AbstractPoint abstractPoint2 = null;
            for (double d7 = d6 / 2.0; d7 <= d - d6 / 2.0; d7 += 1.0) {
                transform.likeRotation(triple5, triple6, d7);
                transform.transform(triple2, triple7);
                abstractPoint2 = abstractPoint;
                abstractPoint = new VectorPoint("drawn", (VectorPoint)abstractPoint2);
                abstractPoint.setX(triple7.getX());
                abstractPoint.setY(triple7.getY());
                abstractPoint.setZ(triple7.getZ());
                kList.add(abstractPoint);
            }
            if (this.cbArcArrowhead.isSelected()) {
                Triple triple8 = new Triple(abstractPoint2.getX(), abstractPoint2.getY(), abstractPoint2.getZ());
                Triple triple9 = new Triple(abstractPoint.getX(), abstractPoint.getY(), abstractPoint.getZ());
                this.makeArrowhead(triple, triple8, triple9, 0.12 * d3, 30.0, 4, kList);
            }
            this.arcseg3 = null;
            this.arcseg2 = null;
            this.arcseg1 = null;
            Kinemage kinemage = this.kMain.getKinemage();
            if (kinemage == null) {
                return;
            }
        }
    }

    void makeArrowhead(Tuple3 tuple3, Tuple3 tuple32, Tuple3 tuple33, double d, double d2, int n, KList kList) {
        for (int i = 0; i < n; ++i) {
            Triple triple = this.builder.construct4(tuple3, tuple32, tuple33, d, d2, 360.0 * (double)i / (double)n);
            VectorPoint vectorPoint = new VectorPoint("drawn", null);
            vectorPoint.setXYZ(tuple33.getX(), tuple33.getY(), tuple33.getZ());
            kList.add(vectorPoint);
            VectorPoint vectorPoint2 = new VectorPoint("drawn", vectorPoint);
            vectorPoint2.setXYZ(triple.getX(), triple.getY(), triple.getZ());
            kList.add(vectorPoint2);
        }
    }

    protected void doTriangle(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint == null) {
            return;
        }
        if (this.triang1 == null) {
            this.triang1 = kPoint;
        } else if (this.triang2 == null) {
            this.triang2 = kPoint;
        } else {
            this.triang3 = kPoint;
            KList kList = this.getDrawingList("triangle", "triangle");
            if (kList == null) {
                return;
            }
            this.undoStack.addLast(new SoftReference<ListChildrenUndo>(new ListChildrenUndo(kList)));
            Triple triple = new Triple(this.triang1.getX(), this.triang1.getY(), this.triang1.getZ());
            Triple triple2 = new Triple(this.triang2.getX(), this.triang2.getY(), this.triang2.getZ());
            Triple triple3 = new Triple(this.triang3.getX(), this.triang3.getY(), this.triang3.getZ());
            Triple triple4 = new Triple().add(triple).add(triple2).add(triple3).mult(0.3333333333333333);
            double d = 1.0;
            try {
                d = Math.abs(Double.parseDouble(this.tfTriangleSize.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            TrianglePoint trianglePoint = new TrianglePoint("drawn", null);
            trianglePoint.setX(d * triple.getX() + (1.0 - d) * triple4.getX());
            trianglePoint.setY(d * triple.getY() + (1.0 - d) * triple4.getY());
            trianglePoint.setZ(d * triple.getZ() + (1.0 - d) * triple4.getZ());
            kList.add(trianglePoint);
            TrianglePoint trianglePoint2 = new TrianglePoint("drawn", trianglePoint);
            trianglePoint2.setX(d * triple2.getX() + (1.0 - d) * triple4.getX());
            trianglePoint2.setY(d * triple2.getY() + (1.0 - d) * triple4.getY());
            trianglePoint2.setZ(d * triple2.getZ() + (1.0 - d) * triple4.getZ());
            kList.add(trianglePoint2);
            TrianglePoint trianglePoint3 = new TrianglePoint("drawn", trianglePoint2);
            trianglePoint3.setX(d * triple3.getX() + (1.0 - d) * triple4.getX());
            trianglePoint3.setY(d * triple3.getY() + (1.0 - d) * triple4.getY());
            trianglePoint3.setZ(d * triple3.getZ() + (1.0 - d) * triple4.getZ());
            kList.add(trianglePoint3);
            this.triang3 = null;
            this.triang2 = null;
            this.triang1 = null;
            Kinemage kinemage = this.kMain.getKinemage();
            if (kinemage == null) {
                return;
            }
        }
    }

    protected void doPunch(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint == null) {
            return;
        }
        KList kList = (KList)kPoint.getParent();
        if (kList == null) {
            return;
        }
        ListChildrenUndo listChildrenUndo = new ListChildrenUndo(kList);
        this.undoStack.addLast(new SoftReference<ListChildrenUndo>(listChildrenUndo));
        this.excisePoint(kPoint, listChildrenUndo);
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
    }

    private void excisePoint(KPoint kPoint, ListChildrenUndo listChildrenUndo) {
        if (kPoint == null) {
            return;
        }
        KList kList = (KList)kPoint.getParent();
        if (kList == null) {
            return;
        }
        ListIterator listIterator = kList.getChildren().listIterator();
        while (listIterator.hasNext()) {
            KPoint kPoint2 = (KPoint)listIterator.next();
            if (kPoint2 != kPoint) continue;
            listIterator.remove();
            if (!listIterator.hasNext()) break;
            kPoint2 = (KPoint)listIterator.next();
            if (listChildrenUndo != null) {
                listChildrenUndo.savePoint(kPoint2);
            }
            kPoint2.setPrev(null);
            break;
        }
    }

    protected void doPrune(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint == null) {
            return;
        }
        KList kList = (KList)kPoint.getParent();
        if (kList == null) {
            return;
        }
        ListChildrenUndo listChildrenUndo = new ListChildrenUndo(kList);
        this.undoStack.addLast(new SoftReference<ListChildrenUndo>(listChildrenUndo));
        Object object = kList.getChildren().listIterator();
        while (object.hasNext()) {
            KPoint kPoint2 = (KPoint)object.next();
            if (kPoint2 != kPoint) continue;
            object.remove();
            if (kPoint2.getPrev() != null) {
                while (object.hasPrevious()) {
                    kPoint2 = (KPoint)object.previous();
                    object.remove();
                    if (kPoint2.getPrev() != null) continue;
                }
            }
            while (object.hasNext() && (kPoint2 = (KPoint)object.next()).getPrev() != null) {
                object.remove();
            }
            break block0;
        }
        if ((object = this.kMain.getKinemage()) == null) {
            return;
        }
    }

    protected void doAuger(int n, int n2, KPoint kPoint2, MouseEvent mouseEvent) {
        Engine2D engine2D = this.kCanvas.getEngine();
        Collection<KPoint> collection = engine2D.pickAll2D(n, n2, this.services.doSuperpick.isSelected(), 40.0);
        for (KPoint kPoint2 : collection) {
            this.excisePoint(kPoint2, null);
        }
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
    }

    protected void doSphereCrop(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint == null) {
            return;
        }
        Kinemage kinemage = kPoint.getKinemage();
        if (kinemage == null) {
            return;
        }
        double d = 10.0;
        try {
            d = Double.parseDouble(this.tfCropRadius.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        double d2 = d * d;
        Engine2D engine2D = this.kCanvas.getEngine();
        CheapSet cheapSet = new CheapSet(new IdentityHashFunction());
        cheapSet.addAll(engine2D.pickAll3D(kPoint.getX(), kPoint.getY(), kPoint.getZ(), true, d));
        ArrayList<KPoint> arrayList = new ArrayList<KPoint>();
        for (KPoint kPoint2 : KIterator.visiblePoints(kinemage)) {
            if (cheapSet.contains(kPoint2)) continue;
            arrayList.add(kPoint2);
        }
        for (KPoint kPoint2 : arrayList) {
            this.excisePoint(kPoint2, null);
        }
    }

    public void drag(int n, int n2, MouseEvent mouseEvent) {
        KView kView = this.kMain.getView();
        if (this.rbMovePoint.isSelected() && kView != null && this.allPoints != null) {
            Dimension dimension = this.kCanvas.getCanvasSize();
            for (int i = 0; i < this.allPoints.length; ++i) {
                float[] fArray = kView.translateRotated(n, -n2, 0, Math.min(dimension.width, dimension.height));
                if (this.allPoints[i] instanceof SpherePoint.DiskProxyPoint) continue;
                this.allPoints[i].setX(this.allPoints[i].getX() + (double)fArray[0]);
                this.allPoints[i].setY(this.allPoints[i].getY() + (double)fArray[1]);
                this.allPoints[i].setZ(this.allPoints[i].getZ() + (double)fArray[2]);
            }
            Kinemage kinemage = this.kMain.getKinemage();
            if (kinemage != null) {
                kinemage.setModified(true);
            }
            this.kCanvas.repaint();
        } else {
            super.drag(n, n2, mouseEvent);
        }
    }

    public void c_drag(int n, int n2, MouseEvent mouseEvent) {
        KView kView = this.kMain.getView();
        if (this.rbMovePoint.isSelected() && kView != null && this.draggedPoint != null) {
            Dimension dimension = this.kCanvas.getCanvasSize();
            float[] fArray = kView.translateRotated(n, -n2, 0, Math.min(dimension.width, dimension.height));
            this.draggedPoint.setX(this.draggedPoint.getX() + (double)fArray[0]);
            this.draggedPoint.setY(this.draggedPoint.getY() + (double)fArray[1]);
            this.draggedPoint.setZ(this.draggedPoint.getZ() + (double)fArray[2]);
            Kinemage kinemage = this.kMain.getKinemage();
            if (kinemage != null) {
                kinemage.setModified(true);
            }
            this.kCanvas.repaint();
        } else {
            super.c_drag(n, n2, mouseEvent);
        }
    }

    public void wheel(int n, MouseEvent mouseEvent) {
        KView kView = this.kMain.getView();
        if (this.rbMovePoint.isSelected() && kView != null && this.draggedPoint != null) {
            Dimension dimension = this.kCanvas.getCanvasSize();
            for (int i = 0; i < this.allPoints.length; ++i) {
                float[] fArray = kView.translateRotated(0, 0, 6 * n, Math.min(dimension.width, dimension.height));
                this.allPoints[i].setX(this.allPoints[i].getX() + (double)fArray[0]);
                this.allPoints[i].setY(this.allPoints[i].getY() + (double)fArray[1]);
                this.allPoints[i].setZ(this.allPoints[i].getZ() + (double)fArray[2]);
            }
            Kinemage kinemage = this.kMain.getKinemage();
            if (kinemage != null) {
                kinemage.setModified(true);
            }
            this.kCanvas.repaint();
        } else {
            super.wheel(n, mouseEvent);
        }
    }

    public void c_wheel(int n, MouseEvent mouseEvent) {
        KView kView = this.kMain.getView();
        if (this.rbMovePoint.isSelected() && kView != null && this.draggedPoint != null) {
            Dimension dimension = this.kCanvas.getCanvasSize();
            float[] fArray = kView.translateRotated(0, 0, 6 * n, Math.min(dimension.width, dimension.height));
            this.draggedPoint.setX(this.draggedPoint.getX() + (double)fArray[0]);
            this.draggedPoint.setY(this.draggedPoint.getY() + (double)fArray[1]);
            this.draggedPoint.setZ(this.draggedPoint.getZ() + (double)fArray[2]);
            Kinemage kinemage = this.kMain.getKinemage();
            if (kinemage != null) {
                kinemage.setModified(true);
            }
            this.kCanvas.repaint();
        } else {
            super.c_wheel(n, mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.draggedPoint = this.kMain.getKinemage() != null ? this.kCanvas.getEngine().pickPoint(mouseEvent.getX(), mouseEvent.getY(), this.services.doSuperpick.isSelected()) : null;
        if (this.draggedPoint == null) {
            this.allPoints = null;
        } else if (this.draggedPoint instanceof LabelPoint) {
            this.allPoints = new KPoint[]{this.draggedPoint};
        } else {
            Engine2D engine2D = this.kCanvas.getEngine();
            Collection collection = engine2D.pickAll3D(this.draggedPoint.getX(), this.draggedPoint.getY(), this.draggedPoint.getZ(), this.services.doSuperpick.isSelected(), engine2D.zoom3D * 0.5);
            this.allPoints = collection.toArray(new KPoint[collection.size()]);
        }
        if (this.allPoints != null && this.rbMovePoint.isSelected()) {
            this.undoStack.addLast(new SoftReference<PointCoordsUndo>(new PointCoordsUndo(this.allPoints)));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        this.lastAugerX = mouseEvent.getX();
        this.lastAugerY = mouseEvent.getY();
        if (this.needAugerCircle()) {
            this.kCanvas.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        this.lastAugerX = mouseEvent.getX();
        this.lastAugerY = mouseEvent.getY();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        super.mouseExited(mouseEvent);
        this.lastAugerY = -1;
        this.lastAugerX = -1;
        if (this.needAugerCircle()) {
            this.kCanvas.repaint();
        }
    }

    boolean needAugerCircle() {
        return this.rbAuger.isSelected() || this.rbPaintPoints.isSelected() && this.cmPaintMode.getSelectedItem() != PAINT_POINT;
    }

    public void overpaintCanvas(Painter painter) {
        if (this.lastAugerX < 0 || this.lastAugerY < 0) {
            return;
        }
        if (this.needAugerCircle()) {
            double d = 80.0;
            painter.drawOval(new Color(0xCC0000), this.lastAugerX, this.lastAugerY, 0.0, d, d);
        }
    }

    protected Container getToolPanel() {
        return this.ui;
    }

    public String getHelpAnchor() {
        return "#drawnew-tool";
    }

    public String toString() {
        return "Edit / draw / delete";
    }

    static class PointCoordsUndo
    implements UndoStep {
        KPoint[] points;
        Triple[] coords;

        public PointCoordsUndo(KPoint[] kPointArray) {
            this.points = (KPoint[])kPointArray.clone();
            this.coords = new Triple[this.points.length];
            for (int i = 0; i < this.points.length; ++i) {
                this.coords[i] = new Triple(this.points[i]);
            }
        }

        public void undo() {
            for (int i = 0; i < this.points.length; ++i) {
                this.points[i].setXYZ(this.coords[i].getX(), this.coords[i].getY(), this.coords[i].getZ());
            }
        }
    }

    static class ListChildrenUndo
    implements UndoStep {
        KList list;
        ArrayList<KPoint> children;
        KPoint modPoint = null;
        KPoint modPrev = null;

        public ListChildrenUndo(KList kList) {
            this.list = kList;
            this.children = new ArrayList(kList.getChildren());
        }

        public void savePoint(KPoint kPoint) {
            this.modPoint = kPoint;
            this.modPrev = kPoint.getPrev();
        }

        public void undo() {
            this.list.setChildren(this.children);
            if (this.modPoint != null) {
                this.modPoint.setPrev(this.modPrev);
            }
        }
    }

    static interface UndoStep {
        public void undo();
    }
}

