/*
 * Decompiled with CFR 0.152.
 */
package king.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import king.core.Engine;
import king.core.KList;
import king.core.KPaint;
import king.core.KPoint;
import king.core.KView;
import king.core.Painter;
import king.core.Transformable;

public class Engine2D
extends Engine {
    public Painter painter = null;
    public boolean useStereo = false;
    public float stereoRotation = 0.0f;
    public Font bigFont;
    public Font smallFont;
    Rectangle canvasRect = new Rectangle();
    boolean transparentBackground = false;

    public Engine2D() {
        this.stereoRotation = (float)Math.toRadians(6.0);
        this.bigFont = new Font("SansSerif", 0, 24);
        this.smallFont = new Font("SansSerif", 0, 12);
    }

    public void render(Transformable transformable, KView kView, Rectangle rectangle, Painter painter) {
        Color color;
        this.painter = painter;
        this.canvasRect.setBounds(rectangle);
        painter.setViewport(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.whiteBackground) {
            this.backgroundMode = this.monochrome ? 3 : 1;
            color = KPaint.white;
        } else {
            this.backgroundMode = this.monochrome ? 2 : 0;
            color = KPaint.black;
        }
        if (this.transparentBackground) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
            this.transparentBackground = false;
        }
        painter.clearCanvas(color);
        this.markerSize = this.bigMarkers ? 2 : 1;
        this.labelFont = this.bigLabels ? this.bigFont : this.smallFont;
        painter.setFont(this.labelFont);
        if (this.useStereo) {
            int n = Math.max(0, rectangle.width / 2 - 10);
            KView kView2 = kView.clone();
            KView kView3 = kView.clone();
            if (this.stereoRotation < 0.0f) {
                kView2.rotateY(this.stereoRotation);
            } else {
                kView3.rotateY(-this.stereoRotation);
            }
            Rectangle rectangle2 = new Rectangle();
            rectangle2.setBounds(rectangle.x, rectangle.y, n, rectangle.height);
            painter.setViewport(rectangle.x, rectangle.y, n, rectangle.height);
            this.renderLoop(transformable, kView2, rectangle2);
            rectangle2.setBounds(rectangle.x + rectangle.width - n, rectangle.y, n, rectangle.height);
            painter.setViewport(rectangle.x + rectangle.width - n, rectangle.y, n, rectangle.height);
            this.renderLoop(transformable, kView3, rectangle2);
            painter.setViewport(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.renderLoop(transformable, kView, rectangle);
        }
    }

    void renderLoop(Transformable transformable, KView kView, Rectangle rectangle) {
        this.transform(transformable, kView, rectangle);
        for (int i = 0; i <= this.TOP_LAYER; ++i) {
            this.colorCue = this.cueIntensity ? 16 * i / (this.TOP_LAYER + 1) : 15;
            this.widthCue = this.cueThickness ? 16 * i / (this.TOP_LAYER + 1) : 7;
            ArrayList arrayList = this.zbuffer[i];
            ArrayList arrayList2 = this.parents[i];
            int n = arrayList.size();
            for (int j = 0; j < n; ++j) {
                KPoint kPoint = (KPoint)arrayList.get(j);
                KList kList = (KList)arrayList2.get(j);
                if (kList == null) {
                    kPoint.paint2D(this);
                    continue;
                }
                KList kList2 = (KList)kPoint.getParent();
                kPoint.setParent(kList);
                kPoint.paint2D(this);
                kPoint.setParent(kList2);
            }
        }
    }

    public Dimension getCanvasSize() {
        return new Dimension(this.canvasRect.width, this.canvasRect.height);
    }

    public void setTransparentBackground() {
        this.transparentBackground = true;
    }
}

