/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.data.UberSet;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane2;
import driftwood.util.SoftLog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import king.KMessage;
import king.KingMain;
import king.KingPrefs;
import king.Plugin;
import king.ToolBox;

public class PrefsEditor {
    KingMain kMain;
    JDialog dialog;
    JTabbedPane tabPane;
    JTextField fontMagnification;
    JTextField fontSizeSmall;
    JTextField fontSizeBig;
    JTextField stereoAngle;
    JCheckBox joglByDefault;
    JCheckBox textOpenOnStart;
    JCheckBox textAllowEdits;
    JCheckBox treeConfirmDelete;
    JCheckBox treeConfirmMerge;
    JCheckBox checkNewVersion;
    Map pluginMenuMap;
    JButton btnDone;
    JButton btnDefaults;
    JButton btnSave;

    public PrefsEditor(KingMain kingMain) {
        this.kMain = kingMain;
        this.buildGUI();
    }

    private void buildGUI() {
        this.btnDone = new JButton(new ReflectiveAction("Close", null, this, "onDone"));
        this.btnDefaults = new JButton(new ReflectiveAction("Reset to defaults", null, this, "onDefaults"));
        this.btnSave = new JButton(new ReflectiveAction("Save to disk", null, this, "onSave"));
        if (!this.kMain.isTrusted()) {
            this.btnSave.setEnabled(false);
        }
        Component component = this.buildGeneralPane();
        Component component2 = this.buildPluginsPane();
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab("General", component);
        this.tabPane.addTab("Plugins", component2);
        TablePane2 tablePane2 = new TablePane2();
        tablePane2.hfill(true).vfill(true).addCell(this.tabPane, 2, 1);
        tablePane2.newRow();
        tablePane2.center().memorize();
        tablePane2.addCell(this.btnDefaults).addCell(this.btnSave);
        tablePane2.newRow();
        tablePane2.addCell(this.btnDone, 2, 1);
        this.dialog = new JDialog(this.kMain.getTopWindow(), "Configure KiNG", true);
        this.dialog.setDefaultCloseOperation(1);
        this.dialog.setContentPane(tablePane2);
    }

    private Component buildGeneralPane() {
        this.fontMagnification = new JTextField(4);
        this.fontSizeSmall = new JTextField(4);
        this.fontSizeBig = new JTextField(4);
        this.stereoAngle = new JTextField(4);
        this.joglByDefault = new JCheckBox("Start in OpenGL mode");
        this.textOpenOnStart = new JCheckBox("Open text window on startup");
        this.textAllowEdits = new JCheckBox("Text window starts off editable");
        this.treeConfirmDelete = new JCheckBox("Ask before deleting groups");
        this.treeConfirmMerge = new JCheckBox("Ask before merging groups");
        this.checkNewVersion = new JCheckBox("Check for new version online");
        TablePane2 tablePane2 = new TablePane2();
        tablePane2.addCell(new JLabel("Menu font magnification (requires restart)")).addCell(this.fontMagnification).newRow();
        tablePane2.addCell(new JLabel("Font size (normal)")).addCell(this.fontSizeSmall).newRow();
        tablePane2.addCell(new JLabel("Font size (large)")).addCell(this.fontSizeBig).newRow();
        tablePane2.addCell(new JLabel("Stereo angle (- cross, + wall)")).addCell(this.stereoAngle).newRow();
        tablePane2.addCell(this.joglByDefault, 2, 1).newRow();
        tablePane2.addCell(this.textOpenOnStart, 2, 1).newRow();
        tablePane2.addCell(this.textAllowEdits, 2, 1).newRow();
        tablePane2.addCell(this.treeConfirmDelete, 2, 1).newRow();
        tablePane2.addCell(this.treeConfirmMerge, 2, 1).newRow();
        tablePane2.addCell(this.checkNewVersion, 2, 1).newRow();
        return tablePane2;
    }

    private Component buildPluginsPane() {
        Object object2;
        ToolBox toolBox = this.kMain.getCanvas().getToolBox();
        List list = toolBox.getPluginList();
        UberSet uberSet = new UberSet();
        uberSet.add("<not shown>");
        uberSet.add("<main menu>");
        uberSet.add("<import>");
        uberSet.add("<export>");
        Object[] objectArray = list.iterator();
        while (objectArray.hasNext()) {
            uberSet.add(toolBox.getPluginMenuName((Plugin)objectArray.next()));
        }
        objectArray = uberSet.toArray();
        this.pluginMenuMap = new HashMap();
        TablePane2 tablePane2 = new TablePane2();
        tablePane2.addCell(new JLabel("Choose a menu for each tool, or type in a new menu name."), 3, 1).newRow();
        for (Object object2 : list) {
            JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
            jComboBox.setSelectedItem(toolBox.getPluginMenuName((Plugin)object2));
            jComboBox.setEditable(true);
            tablePane2.addCell(new JLabel(object2.toString()));
            tablePane2.addCell(TablePane2.strut(10, 0));
            tablePane2.hfill(true).addCell(jComboBox);
            tablePane2.newRow();
            this.pluginMenuMap.put(object2.getClass().getName(), jComboBox);
        }
        JScrollPane jScrollPane = new JScrollPane(tablePane2);
        jScrollPane.setVerticalScrollBarPolicy(22);
        object2 = jScrollPane.getPreferredSize();
        ((Dimension)object2).height = 100;
        jScrollPane.setPreferredSize((Dimension)object2);
        return jScrollPane;
    }

    public void edit() {
        this.toGUI();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.kMain.getTopWindow());
        this.dialog.setVisible(true);
    }

    public void editPlugins() {
        int n = this.tabPane.indexOfTab("Plugins");
        if (n != -1) {
            this.tabPane.setSelectedIndex(n);
        }
        this.edit();
    }

    private void toGUI() {
        KingPrefs kingPrefs = this.kMain.prefs;
        if (kingPrefs == null) {
            return;
        }
        this.fontMagnification.setText(kingPrefs.getString("fontMagnification"));
        this.fontSizeSmall.setText(kingPrefs.getString("fontSizeSmall"));
        this.fontSizeBig.setText(kingPrefs.getString("fontSizeBig"));
        this.stereoAngle.setText(kingPrefs.getString("stereoAngle"));
        this.joglByDefault.setSelected(kingPrefs.getBoolean("joglByDefault"));
        this.textOpenOnStart.setSelected(kingPrefs.getBoolean("textOpenOnStart"));
        this.textAllowEdits.setSelected(kingPrefs.getBoolean("textDefaultAllowEdits"));
        this.treeConfirmDelete.setSelected(kingPrefs.getBoolean("treeConfirmDelete"));
        this.treeConfirmMerge.setSelected(kingPrefs.getBoolean("treeConfirmMerge"));
        this.checkNewVersion.setSelected(kingPrefs.getBoolean("checkNewVersion"));
    }

    private void fromGUI() {
        Object object;
        KingPrefs kingPrefs = this.kMain.prefs;
        if (kingPrefs == null) {
            return;
        }
        try {
            object = new Float(this.fontMagnification.getText().trim());
            kingPrefs.setProperty("fontMagnification", ((Float)object).toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            object = new Integer(this.fontSizeSmall.getText().trim());
            kingPrefs.setProperty("fontSizeSmall", ((Integer)object).toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            object = new Integer(this.fontSizeBig.getText().trim());
            kingPrefs.setProperty("fontSizeBig", ((Integer)object).toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            object = new Float(this.stereoAngle.getText().trim());
            kingPrefs.setProperty("stereoAngle", ((Float)object).toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        kingPrefs.setProperty("joglByDefault", new Boolean(this.joglByDefault.isSelected()).toString());
        kingPrefs.setProperty("textOpenOnStart", new Boolean(this.textOpenOnStart.isSelected()).toString());
        kingPrefs.setProperty("textDefaultAllowEdits", new Boolean(this.textAllowEdits.isSelected()).toString());
        kingPrefs.setProperty("treeConfirmDelete", new Boolean(this.treeConfirmDelete.isSelected()).toString());
        kingPrefs.setProperty("treeConfirmMerge", new Boolean(this.treeConfirmMerge.isSelected()).toString());
        kingPrefs.setProperty("checkNewVersion", new Boolean(this.checkNewVersion.isSelected()).toString());
        for (String string : this.pluginMenuMap.keySet()) {
            JComboBox jComboBox = (JComboBox)this.pluginMenuMap.get(string);
            String string2 = (String)jComboBox.getSelectedItem();
            kingPrefs.setProperty(string + ".menuName", string2);
        }
    }

    public void onDone(ActionEvent actionEvent) {
        this.fromGUI();
        this.dialog.setVisible(false);
        this.kMain.publish(new KMessage(this, 64L));
    }

    public void onSave(ActionEvent actionEvent) {
        this.fromGUI();
        try {
            this.kMain.prefs.storeToFile();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace(SoftLog.err);
        }
        this.toGUI();
    }

    public void onDefaults(ActionEvent actionEvent) {
        KingPrefs kingPrefs = this.kMain.getPrefs();
        kingPrefs.clear();
        this.toGUI();
    }
}

