/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2.selection;

import driftwood.moldb2.AtomState;
import driftwood.moldb2.Selection;
import java.util.HashMap;
import java.util.Map;

public class KeywordTerm {
    static Map map = null;

    private KeywordTerm() {
    }

    public static Selection get(String string) {
        if (map == null) {
            map = new HashMap();
            map.put("all", new NamedTerm("all"){

                protected boolean selectImpl(AtomState atomState) {
                    return true;
                }
            });
            map.put("*", map.get("all"));
            map.put("none", new NamedTerm("none"){

                protected boolean selectImpl(AtomState atomState) {
                    return false;
                }
            });
            map.put("het", new NamedTerm("het"){

                protected boolean selectImpl(AtomState atomState) {
                    return atomState.isHet();
                }
            });
            map.put("carbon", new NamedTerm("carbon"){

                protected boolean selectImpl(AtomState atomState) {
                    return "C".equals(atomState.getElement());
                }
            });
            map.put("hydrogen", new NamedTerm("hydrogen"){

                protected boolean selectImpl(AtomState atomState) {
                    return "H".equals(atomState.getElement());
                }
            });
            map.put("nitrogen", new NamedTerm("nitrogen"){

                protected boolean selectImpl(AtomState atomState) {
                    return "N".equals(atomState.getElement());
                }
            });
            map.put("oxygen", new NamedTerm("oxygen"){

                protected boolean selectImpl(AtomState atomState) {
                    return "O".equals(atomState.getElement());
                }
            });
            map.put("phosphorus", new NamedTerm("phosphorus"){

                protected boolean selectImpl(AtomState atomState) {
                    return "P".equals(atomState.getElement());
                }
            });
            map.put("sulfur", new NamedTerm("sulfur"){

                protected boolean selectImpl(AtomState atomState) {
                    return "S".equals(atomState.getElement());
                }
            });
        }
        return (Selection)map.get(string);
    }

    static abstract class NamedTerm
    extends Selection {
        String name;

        public NamedTerm(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

