/***************************************************************************
 *                                                                         *
 *                         Powersave Daemon                                *
 *                                                                         *
 *          Copyright (C) 2004,2005 SUSE Linux Products GmbH               *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at you   *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA                  *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <getopt.h>
#include <string.h>

#include "powerlib.h"

int quiet = 0;

void usage()
{
	fprintf(stderr, "Usage: on_ac_power [-q]\n\n\
              returns 0 if on AC power or unable to determine ac state\n\
              returns 1 if on battery power\n\
              -q: quiet mode\n");
}

void get_args(int argc, char **argv)
{

	int option_index = 0;

	struct option opts[] = {
		{"quiet", 0, 0, 'q'},
		{"help", 0, 0, 'h'},
		{NULL, 0, 0, 0},
	};
	while (1) {
		int i = getopt_long(argc, argv, "hq", opts, &option_index);
		if (i == -1) {
			break;
		}
		switch (i) {
		case 'h':
			usage();
			exit(0);
			break;
		case 'q':
			quiet = 1;
			break;
		default:
			break;
		}
	}
}

int main(int argc, char **argv)
{
	int status;

	get_args(argc, argv);

	status = getACAdapterStatus();
	if (status == AC_OFFLINE) {
		if (!quiet)
			fprintf(stdout, "OFFLINE\n");
		return 1;
	} else {
		if (!quiet)
			fprintf(stdout, "ONLINE\n");
		return 0;
	}
}
