/***************************************************************************
 *                                                                         *
 *                         Powersave Daemon                                *
 *                                                                         *
 *          Copyright (C) 2004,2005 SUSE Linux Products GmbH               *
 *                                                                         *
 *               Author(s): Holger Macht <hmacht@suse.de>                  *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at you   *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA                  *
 *                                                                         *
 ***************************************************************************/

#ifndef POWERSAVE_APM_H
#define POWERSAVE_APM_H

#define APM_BIOS_DEV	"/dev/apm_bios"
#define MAX_EVENTS 8

#include "pm_interface.h"

class APM_Interface : public PM_Interface {
public:
	/** @brief default initialisation */
	APM_Interface();

	/** @brief destructor */
	virtual ~ APM_Interface();

	/** @brief opens the apm event file
	 *
	 * @return the filedescriptor or -1 on error
	 * @retval < 0 on error
	 * @retval the filedesctiptor on success
	 */
	virtual int openHWEventFD();

	/** @brief dummy implementation */
	virtual int openAcpidSocket();

	/** @brief Handles an event on the socket
	 *
	 * @return < 0 on error
	 */
	virtual int handleHWEventRequest(int fd = -1);

	/** @brief triggers suspend_to_ram for apm
	 *
	 * @return true on success, false if not supported
	 */
	virtual int suspend_to_ram();

	/** @brief triggers standby for apm
	 *
	 * @return true on success, false if not supported
	 */
	virtual int standby();

	/** @brief activates settings for specific scheme 
	 *
	 * only calls activateSettings from parent class for now
	 */
	virtual void activateSettings();

private:
	/** @brief the event fd */
	int _hwEvent_fd;
};

#endif // POWERSAVE_APM_H
