/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef OSCLISTENER_H
#define OSCLISTENER_H

#include <cstdlib>
#include <lo/lo.h>
#include "ClientHooks.h"


namespace LibOmClient {

class NodeModel;
class PresetModel;


/** Callbacks for "notification band" OSC messages.
 *
 * Receives all notification of engine state, but not replies on the "control
 * band".  See OSC namespace documentation for details.
 *
 * Right now this class and Comm share the same lo_server_thread and the barrier
 * between them is a bit odd, but eventually this class will be able to listen
 * on a completely different port (ie have it's own lo_server_thread) to allow
 * things like listening to the notification band over TCP while sending commands
 * on the control band over UDP.
 *
 * \ingroup libomclient
 */
class OSCListener
{
public:
	OSCListener(lo_server_thread st, ClientHooks* client_hooks);
	~OSCListener();
	
	void setup_callbacks();
	
	const string& listen_url() { return m_listen_url; }

private:
	// Prevent copies
	OSCListener(const OSCListener& copy)            { exit(EXIT_FAILURE); }
	OSCListener& operator=(const OSCListener& copy) { exit(EXIT_FAILURE); }
	
	ClientHooks* m_client_hooks;
	bool         m_dummy_client_hooks;

	string           m_listen_url;
	lo_server_thread m_st;

	// Used for receiving nodes - multiple messages are received before
	// sending an event to the client (via ClientHooks)
	bool       m_receiving_node;
	NodeModel* m_receiving_node_model;
	
	inline static int om_error_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_om_error_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int plugin_list_begin_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_plugin_list_begin_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int plugin_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_plugin_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int plugin_list_end_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_plugin_list_end_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int engine_enabled_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_engine_enabled_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int engine_disabled_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_engine_disabled_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int new_patch_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_new_patch_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int patch_destruction_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_patch_destruction_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int patch_enabled_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_patch_enabled_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int patch_disabled_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_patch_disabled_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int object_renamed_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_object_renamed_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int connection_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_connection_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int disconnection_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_disconnection_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int node_removal_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_node_removal_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int new_node_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_new_node_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int new_node_end_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_new_node_end_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int new_port_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_new_port_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int port_removal_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_port_removal_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int metadata_update_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_metadata_update_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
	inline static int control_change_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm);
	int             m_control_change_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data);
};


inline int
OSCListener::om_error_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_om_error_cb(path, types, argv, argc, data);
}

inline int
OSCListener::plugin_list_begin_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_plugin_list_begin_cb(path, types, argv, argc, data);
}

inline int
OSCListener::plugin_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_plugin_cb(path, types, argv, argc, data);
}

inline int
OSCListener::plugin_list_end_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_plugin_list_end_cb(path, types, argv, argc, data);
}

inline int
OSCListener::engine_enabled_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_engine_enabled_cb(path, types, argv, argc, data);
}

inline int
OSCListener::engine_disabled_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_engine_disabled_cb(path, types, argv, argc, data);
}

inline int
OSCListener::new_patch_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_new_patch_cb(path, types, argv, argc, data);
}

inline int
OSCListener::patch_destruction_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_patch_destruction_cb(path, types, argv, argc, data);
}

inline int
OSCListener::patch_enabled_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_patch_enabled_cb(path, types, argv, argc, data);
}

inline int
OSCListener::patch_disabled_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_patch_disabled_cb(path, types, argv, argc, data);
}

inline int
OSCListener::object_renamed_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_object_renamed_cb(path, types, argv, argc, data);
}

inline int
OSCListener::connection_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_connection_cb(path, types, argv, argc, data);
}

inline int
OSCListener::disconnection_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_disconnection_cb(path, types, argv, argc, data);
}

inline int
OSCListener::node_removal_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_node_removal_cb(path, types, argv, argc, data);
}

inline int
OSCListener::new_node_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_new_node_cb(path, types, argv, argc, data);
}

inline int
OSCListener::new_node_end_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_new_node_end_cb(path, types, argv, argc, data);
}

inline int
OSCListener::new_port_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_new_port_cb(path, types, argv, argc, data);
}

inline int
OSCListener::port_removal_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_port_removal_cb(path, types, argv, argc, data);
}

inline int
OSCListener::metadata_update_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_metadata_update_cb(path, types, argv, argc, data);
}

inline int
OSCListener::control_change_cb(const char* path, const char* types, lo_arg** argv, int argc, void* data, void* comm) {
	return ((OSCListener*)comm)->m_control_change_cb(path, types, argv, argc, data);
}


} // namespace LibOmClient

#endif // OSCLISTENER_H
