// -*- C++ -*-

// Copyright 2006 Deutsches Forschungszentrum fuer Kuenstliche Intelligenz
// or its licensors, as applicable.
//
// You may not use this file except under the terms of the accompanying license.
//
// Licensed under the Apache License, Version 2.0 (the "License"); you
// may not use this file except in compliance with the License. You may
// obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Project: bpnet -- bpnet network classifier
// File: confusion-matrix.h
// Purpose: class for a confusion matrix
// Responsible: Hagen Kaprykowsky (kapry@iupr.net)
// Reviewer: Yves Rangoni (rangoni@iupr.dfki.de)
// Primary Repository:
// Web Sites: www.iupr.org, www.dfki.de

#ifndef h_confusionmatrix__
#define h_confusionmatrix__

#include <stdlib.h>

#include "classmap.h"
#include "nustring.h"
#include "colib.h"
#include "narray-io.h"

using namespace ocropus;
using namespace colib;

namespace iupr_bpnet {

    struct ConfusionMatrix {
        ConfusionMatrix(unsigned int nRows, unsigned int nCols);
        ConfusionMatrix(colib::intarray &matrix);
        ~ConfusionMatrix();
        void clear();
        void increment(int actual,int predicted);
        void set(intarray &matrix);
        void set(ConfusionMatrix &matrix);
        void get(intarray &matrix);
        void confusion_to_list(intarray &out);
        void print(FILE *stream);
        void printReduced(FILE *stream);
        void printMatrix(FILE* stream,int size=3,bool norm=false);
        void printMatrix(FILE* stream,ClassMap &map,int size=3,bool norm=false);
        void printReduced(FILE* stream,ClassMap &map);
        
        colib::intarray confusion;
        void print_one_confusion(   
            FILE* stream,ClassMap &map,int i,
            int j,int v, const char* prefix);
    };
    
    ConfusionMatrix *make_ConfusionMatrix(int ncls);

    ConfusionMatrix *make_ConfusionMatrix(colib::intarray &c);
}
#endif

