/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef BoolLine_H
#include "BoolLine.h"
#endif

#ifndef XMString_H
#include "XMString.h"
#endif

#ifndef XMText_H
#include "XMText.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#ifndef RequestPanel_H
#include "RequestPanel.h"
#endif

#ifndef LineFactory_H
#include "LineFactory.h"
#endif

#include <Xm/ToggleB.h>

#include <mars.h>

BoolLine::BoolLine(RequestPanel& owner,const Parameter& param):
	XRequestPanelLine<UIBoolLine_c>(owner,param)
{
}

BoolLine::~BoolLine()
{
}

void BoolLine::init(Widget w)
{
	XRequestPanelLine<UIBoolLine_c>::init(w);
}

void BoolLine::refresh(const vector<string>& values)
{
	if(values.size() == 0) return;

	char c = values[0][1];
	XmToggleButtonSetState(on_, c == 'N' || c == 'n',False);
	XmToggleButtonSetState(off_,c != 'N' && c != 'n',False);
}

void BoolLine::activateCB(Widget,XtPointer data)
{
	decache();
	XmRowColumnCallbackStruct *cb =(XmRowColumnCallbackStruct *) data;
	owner_.set(param_.name(),XtName(cb->widget));
}

static LineMaker<BoolLine> maker("on_off");
