/*
 * libsysactivity
 * http://sourceforge.net/projects/libsysactivity/
 * Copyright (c) 2010 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef LIBSYSACTIVITY_H_
#define LIBSYSACTIVITY_H_

#include <net/if.h>
#include <sys/devicestat.h>
#include <sys/user.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SA_OPEN_CPU
#define SA_CLOSE_CPU
#define SA_SMP_CAPABLE
#define SA_CPU_ID
#define SA_CPU_USER
#define SA_CPU_NICE
#define SA_CPU_SYSTEM
#define SA_CPU_IDLE
#undef SA_CPU_WAITING_FOR_IO
#undef SA_CPU_HARDWARE_IRQ
#undef SA_CPU_SOFTWARE_IRQ
#undef SA_CPU_STOLEN
#define SA_CPU_INTR

#define SA_OPEN_DISK
#define SA_CLOSE_DISK
#define SA_DISK_NAME DEVSTAT_NAME_LEN
#define SA_DISK_READS
#undef SA_DISK_READS_MERGED
#undef SA_DISK_SECTORS_READ
#if DEVSTAT_VERSION == 4
	#undef SA_DISK_TIME_SPENT_READING
#elif DEVSTAT_VERSION == 6
	#define SA_DISK_TIME_SPENT_READING
#endif
#define SA_DISK_WRITES
#undef SA_DISK_SECTORS_WRITTEN
#if DEVSTAT_VERSION == 4
	#undef SA_DISK_TIME_SPENT_WRITING
#elif DEVSTAT_VERSION == 6
	#define SA_DISK_TIME_SPENT_WRITING
#endif
#define SA_DISK_BYTES_READ
#define SA_DISK_BYTES_WRITTEN

#undef SA_OPEN_MEMORY
#undef SA_CLOSE_MEMORY
#define SA_MEMORY_TOTAL
#define SA_MEMORY_FREE
#define SA_MEMORY_ACTIVE
#define SA_MEMORY_INACTIVE
#define SA_MEMORY_BUFFERS
#define SA_MEMORY_SWAP_TOTAL
#define SA_MEMORY_SWAP_FREE
#undef SA_MEMORY_SWAP_CACHED
#define SA_MEMORY_WIRED
#define SA_MEMORY_CACHED
#undef SA_MEMORY_DIRTY
#undef SA_MEMORY_EXECUTABLE
#undef SA_MEMORY_FILES
#undef SA_MEMORY_LOCKED

#undef SA_OPEN_NET
#undef SA_CLOSE_NET
#define SA_NET_INTERFACE_NAME IFNAMSIZ
#define SA_NET_INTERFACE_RECEIVED_BYTES
#define SA_NET_INTERFACE_RECEIVED_PACKETS
#define SA_NET_INTERFACE_RECEIVED_ERRORS
#define SA_NET_INTERFACE_RECEIVED_DROP
#undef SA_NET_INTERFACE_RECEIVED_FIFO
#undef SA_NET_INTERFACE_RECEIVED_COMPRESSED
#define SA_NET_INTERFACE_RECEIVED_MULTICAST
#define SA_NET_INTERFACE_SENT_BYTES
#define SA_NET_INTERFACE_SENT_PACKETS
#define SA_NET_INTERFACE_SENT_ERRORS
#undef SA_NET_INTERFACE_SENT_DROP
#undef SA_NET_INTERFACE_SENT_FIFO
#undef SA_NET_INTERFACE_SENT_COMPRESSED
#define SA_NET_INTERFACE_SENT_MULTICAST

#undef SA_OPEN_PROCESS
#define SA_CLOSE_PROCESS
#define SA_PROCESS_PID
#define SA_PROCESS_UID
#define SA_PROCESS_GID
#define SA_PROCESS_FILENAME MAXCOMLEN+1
#define SA_PROCESS_CMDLINE 256
#define SA_PROCESS_PARENT_PID
#define SA_PROCESS_PGRP
#define SA_PROCESS_SID
#define SA_PROCESS_TTY
#define SA_PROCESS_NICE
#undef SA_PROCESS_START_TIME

#define SA_PROCESS_STATE
#define SA_PROCESS_USER_TIME
#define SA_PROCESS_SYS_TIME
#define SA_PROCESS_THREADS
#define SA_PROCESS_VM_SIZE
#define SA_PROCESS_RSS

#undef SA_OPEN_SWAP
#define SA_CLOSE_SWAP
#define SA_SWAP_NAME 32
#define SA_SWAP_TOTAL
#define SA_SWAP_FREE
#undef SA_SWAP_TYPE

#include "global.h"

#ifdef __cplusplus
}
#endif

#endif /* LIBSYSACTIVITY_H_ */
