/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_TRANSPORT_INTERNALS_H_
#define _SML_TRANSPORT_INTERNALS_H_

#include "sml_queue_internals.h"

typedef void *(* SmlTransportInitializeFn) (SmlTransport *tsp, const void *data, SmlError **error);
typedef SmlBool (* SmlTransportFinalizeFn) (void *data, SmlError **error);

typedef void (* SmlTransportConnectFn) (void *data);
typedef void (* SmlTransportDisconnectFn) (void *data, void *link);
typedef void (* SmlTransportSendFn) (void *userdata, void *link, SmlTransportData *data, SmlError *error);

typedef struct SmlTransportFunctions {
	SmlTransportInitializeFn initialize;
	SmlTransportFinalizeFn finalize;
	SmlTransportConnectFn connect;
	SmlTransportDisconnectFn disconnect;
	SmlTransportSendFn send;
} SmlTransportFunctions;

typedef enum SmlTransportState {
	SML_TRANSPORT_UNINITIALIZED,
	SML_TRANSPORT_INITIALIZED,
	SML_TRANSPORT_CONNECTED,
	SML_TRANSPORT_ERROR
} SmlTransportState;

struct SmlTransport {
	GMainContext *context;
	SmlThread *thread;
	
	SmlTransportState state;
	
	SmlTransportType type;
	SmlTransportFunctions functions;
	void *transport_data;
	
	SmlQueue *command_queue;
	SmlTransportEventCb event_callback;
	void *event_callback_userdata;
	
	GList *links;
};

struct SmlLink {
	SmlQueue *event_queue;
	SmlTransport *tsp;
	void *link_data;
	gint32 refCount;
};

typedef enum SmlTransportCommandType {
	SML_TRANSPORT_CMD_SEND,
	SML_TRANSPORT_CMD_CONNECT,
	SML_TRANSPORT_CMD_DISCONNECT
} SmlTransportCommandType;

typedef struct SmlTransportCommand {
	SmlTransportCommandType type;
	SmlTransportData *data;
	const void *config;
	SmlLink *link;
	SmlError *error;
} SmlTransportCommand;

struct SmlTransportData {
	char *data;
	unsigned long size;
	SmlMimeType type;
	SmlBool ownsData;
	gint32 refCount;
	/** This field specifies if the data transported
	 * here needs an reply from the other side. If it does not
	 * need one, the transports might take special precautions */
	SmlBool needsAnswer;
};

void smlTransportWorkerHandler(void *message, void *userdata);
SmlBool smlTransportReceiveEvent(SmlTransport *tsp, SmlLink *link, SmlTransportEventType type, SmlTransportData *data, SmlError *error);

#endif //_SML_TRANSPORT_INTERNALS_H_
