package tests::MockAggregate;

use base qw/Lire::Aggregate/;

sub new {
    my $self  = bless { 'parent_groups' => [], }, shift;

    $self->init( @_, 'op' => "mock" );

    return $self;
}

sub build_query {
    my ( $self, $query ) = @_;

    $query->add_aggr_field( $self->name(), 'count()' );
}

sub create_numerical_info {
    my ( $self, $info ) = @_;

    $info->create_column_info( $self->name(), 'numerical', 'int',
                               $self->label() );
}

sub create_value {
    my ( $self, $parent_group, $row ) = @_;

    push @{$self->{'parent_groups'}}, $parent_group;
    return { 'content' => $row->{$self->name()} };
}

1;
