#% -*- mode: textmac; mode: fold -*-
#% text-macro definitions #%{{{
#i linuxdoc.tm
#d documentstyle article
#d sect1 \section
#d sect2 \subsection
#d sect3 \subsubsection
#d sect4 \subsubsection
#d url#1 <htmlurl url="$1" name="$1">
#d newsurl#1 \url{news:$1}
#d davisemail davis@space.mit.edu
#d jed_home_page http://space.mit.edu/%7Edavis/jed.html
#d slangorg http://www.s-lang.org
#d jedlist http://www.onelist.com/subscribe/jed-users
#d file#1 <file>$1</file>

#%}}}

\linuxdoc
\begin{\documentstyle}

\title Jed Quick Reference
\author Guido Gonzato
\date 4 May 2000

\begin{abstract}
This document (which is \em{not finished}) outlines the most important
features of the editor Jed, providing a quick description. Please refer to
the documentation for more thorough explanations.
\end{abstract}

\toc

\sect1{Introduction} #%{{{

Jed is a powerful, fast, and light editor that runs on Unix, VMS, OS/2, and
DOS/Windows. It provides emulation of Emacs, EDT, WordStar, Brief, and
Borland IDE, and has scores of useful features that make it a good choice
for programmers and advanced users. Moreover, Jed is highly customizable via
an extension language similar to C, called Slang. Jed embeds a Slang
interpreter, and most of its features are implemented as \em{functions} in
external files (the so-called .sl files) written in Slang.

Jed was written by John E. Davis. Email comments or suggestions to
\url{davisemail}. 
Jed Home Page: \url{jed_home_page}, \url{slangorg}.
Newsgroups: \newsurl{alt.lang.s-lang}, \newsurl{comp.editors}
Mailing lists: \url{jedlist}.

#%+
  there are translated wrong!
#%-


\sect2{Starting Up Jed} #%{{{

There are several executable files, depending on the OS you're using:
\tt{JED.EXE} for VMS; \tt{JED.EXE}, \tt{JED386.EXE} and \tt{WJED.EXE} for
DOS/Windows; \tt{jed} and \tt{xjed} for Unix console + X11.

Assuming that Jed is properly installed, there will be a directory (referred
to as JED_ROOT) under which Slang files are kept; for example,
\file{/usr/lib/jed} on Red Hat Linux systems, or
\file{C:\\jedb09910} on DOS/Windows. This is the (simplified) start-up
sequence: first, Jed loads an initialization file called \tt{site.sl}; then,
if it exists, \tt{defaults.sl}; then it tries to load your personal
initialization file, \tt{.jedrc}; failing that, it will load a system-wide
file, \tt{jed.rc}. You can customize Jed copying \tt{jed.rc} to
\tt{.jedrc}, and modifying it to suit your needs. Read it carefully; there
are many features you can customize.

To start with, you'll choose the editor emulation you prefer by editing
\tt{.jedrc}. \tt{emacs} emulation is the default; DOS/Windows users may want
to use WordStar or IDE mode, which are compatible with DOS' \tt{edit}.
Several colour schemes are also available; look at the menu Windows/Color
Schemes, choose your favourite, and make it the default in \tt{.jedrc}.

#%}}}


\sect2{Getting Help} #%{{{

Jed offers several ways to get help: 

\begin{itemize}

\item via the Help menu: there are several options, try them all;

\item typing \tt{M-X help}, you access the help screen pertinent to the
emulation you're using;

\item browse the off-line documentation that Jed ships with.

\end{itemize}

As the author of Jed states, the version number is still below 1.0 ``because
of the lack of adequate documentation''. We're working on it; this document
is an attempt...

#%}}}


\sect2{Basic Editing} #%{{{

\tt{M-Key} stands for \tt{ESC-Key} or, equivalently, \tt{ALT-Key}; 
\tt{^Key} stands for \tt{Ctrl-Key}. These are the very basic
commands to get you started:

#v+
Operation               Emacs               IDE mode
----------------------------------------------------

quit jed                ^X^C                ^KX
quit the cmd. line      ^G                  ^G
                                            ESC ESC ESC

        File Operations

open file               ^X^F                ^Ke
insert file             ^Xi                 ^Ki
save                    ^X^S                ^Kd
save as                 ^X^W                ^Ks
close file              ^Xk                 ^Kq
change buffer           ^Xb                 ^Kp
suspend                 ^Z                  ^Kz
exit                    ^X^C                ^Kx

        Movement

word left               M-b                 ^A
word right              M-f                 ^F
beginning of line       ^A                  ^Qf
end of line             ^E                  ^Qd
page up                 M-v                 ^R
page down               ^V                  ^C
beginning of file       M-<                 ^Qr
end of file             M->                 ^Qc
line no.                M-x goto_line_cmd   ^Qi

        Deleting

character left          ^H                  ^H
character right         ^D                  M-G
word left               M-DEL               M-BS
word right              M-D                 ^T
line                    ^A^K                ^Y
undo                    ^Xu                 ^U
redo                    ^G^Xu               ^G^U

        Search and Replace

search                  ^S                  ^Qf
replace                 M-%                 ^Qa
repeat search           (n/a)               ^L

        Regions (a.k.a. Blocks)

begin                   ^@                  ^Kb
                        Ctrl-SPACE
copy                    ^W                  ^Kh
paste                   ^Y                  ^Kc
---------------------------------------------------
#v-

You should also be aware of these basic features:

\begin{itemize}

\item the command line, a.k.a. \em{minibuffer}, supports completion and
history: press TAB and/or SPACE when opening a file to see what this means.
Another interesting way to get acquainted with this feature is to type
\tt{M-X b}, then cycle between all functions that begin in `b' typing
\tt{SPACE} repeatedly;

\item Jed acts in different ways, according to the type of text you're
writing; that is, it supports \em{modes} (see Section <ref id="Modes"
name="Modes">). Some characters are not always typed in as you'd expect;

\item the inverted quote character \tt{`} (ASCII 96) means ``insert the
next character literally''. Example: \tt{` ESC} will insert a real ESC
character (ASCII 27) in the text. To get an inverted quote, type \tt{`}
twice;

\item double quotes may be inserted literally, like \tt{"foo"}, or as
``smart quotes'': \tt{``foo''}. If you get smart quotes but want
\tt{"}, type \tt{`} then \tt{"}.

\end{itemize}

#%}}}

#%}}}


\sect1{Main Features} #%{{{

So many things to list here! Many of these features are accessible via
menus, others via key bindings, others still via minibuffer typing the name
of the relevant function. For some of them, a brief explanation is provided
below. There you are, in no particular order:

pull-down menus; mouse support; multiple windows/buffers; minibuffer
completion and history; directory/buffer manager; ``modes'' for editing
program sources or markup languages like LaTeX or HTML; folding support;
8-bit characters and mute-key support; abbreviations and completion; shell,
compiler, and gdb interface; numbered backups; RCS support; bookmarks;
calendar; matching parenthesis highlighting/moving to; filtering of regions
of text; editing of binary files; info and man page reader; incremental
search; ispell word or automatic on the whole buffer; macros; mail and
rmail; ``occur'' search; plain and regular expression search and replace;
replace across several buffers; registers (multiple clipboard); block
sorting; rectangular cut and paste; editable tab positions; tab-space
conversion; Windows-like cut and paste; reformat of paragraphs; CR/LF
independence; key codes; VMS help; mime filtering.

In the following sections, only the names of the functions will be reported;
find out the key bindings, if any, via Help/Where Is Command.


\sect2{Menus and Mouse} #%{{{

Pull-down menus are supported in all terminals; mouse support is available
for DOS/Windows, Linux console, and xterms. Menus are accessed via the F10,
arrows and Enter keys, or directly via \tt{M-key} or the mouse. If
\tt{Alt-Key} doesn't work, try \tt{ESC-Key}.

You can roll your own menus by customizing \tt{popups.sl}.

Tips for using the mouse:

#%+
  normal mouse support and mousex are different. Why?
#%-


\begin{itemize}

\item Click the \em{left} mouse button to move the cursor to another location.

\item To copy a region for subsequent pasting, press the \em{left} mouse
button and drag the mouse to the end of the region.

\item To paste a previously copied region, press the \em{right} 
(Linux console) or the \em{middle} (Xjed) button; for DOS/Windows, press
\tt{Alt} and the \em{middle} button.

\item To cut a region and put it in the paste buffer, define a region by
dragging with the \em{right} (console, Xjed) mouse button. Now release the
\em{right} button and press it again.

\item To paste from another window/application into Jed, press the
\em{Alt} key while pressing the \em{right} (console) or the \em{middle}
(X11) button. This works with Linux; the details of this operation depend on
the operating system.

\end{itemize}

If you're using Jed in rxvt, xterm or other terminal emulator, the above
operations are obtained thus:

\begin{itemize}

\item To copy a region, click the \em{left} mouse button at the beginning
of the region, move the mouse to the end of the region and click the
\em{right} mouse button. The region should now be marked.

\item Click the \em{middle} button to copy the region to the pastebuffer.

\item To paste from the pastebuffer, move the cursor to where you want to
paste and press the \em{middle} button.

\end{itemize}

Slang files: \tt{mouse.sl}, \tt{mousex.sl}, \tt{mswmouse.sl}

#%}}}


\sect2{Reformatting Paragraphs} #%{{{

The command \tt{M-X format_paragraph} reformats the current paragraph - that
is, all the text until the following blank line. If you want the paragraph
to be indented by, say, 5 positions, make the first line begin with 5
spaces, move the cursor to the first character, then issue the command.

If you'd like narrower paragraphs, set the variable \tt{WRAP} in your
\tt{.jedrc}, or type \tt{^X ESC} and enter \tt{WRAP=nn}, where \tt{nn} is
the column where you want the text to wrap.

To get the right margin aligned too, type \tt{ESC 1 M-X format_paragraph}.

#%}}}


\sect2{End-Of-Line Issues} #%{{{

Under DOS and Windows, lines of text end with the two characters \tt{^M^J}
(ASCII 13 + ASCII 10), while under Unix lines end with \tt{^J} alone. This
difference makes notoriously irksome reading UNIX text files under DOS, and
possibly vice versa. Jed solves this problem with the command
\tt{M-X toggle_crmode}. Under Unix, a `C' in the status line indicates
that DOS-stile end-of-line is enabled; under DOS/Windows, an `L' denotes
Unix-style end-of-line.

#%}}}


\sect2{Macros} #%{{{

If you need to perform a repetitive action on several lines of text, you'll
want to define a \em{macro}. Use \tt{M-X begin_macro}, \tt{M-X end_macro},
and \tt{M-X execute_macro} to define and run a macro. \tt{M-X
macro_assign_macro_to_key} does what it says.

If you wish to reuse a macro you have defined, the routines
\tt{macro_save_macro} and \tt{macro_to_function} can be handy.

Slang files: \tt{macro.sl}

#%}}}


\sect2{Rectangles} #%{{{

In addition to regions of text, you can also define \em{rectangles} to
operate on ``columns'' of text. Begin by selecting a region as usual, then
use the functions \tt{kill_rect} to cut the rectangle,
\tt{open_rect} to insert a blank rectangle, \tt{copy_rect} to copy,
\tt{insert_rect} to paste, and \tt{blank_rect} to blank-fill the
rectangle.

#%}}}


\sect2{8-bit Characters and Mutekey} #%{{{

People whose language includes accented characters will benefit from
\tt{M-X digraph_cmd}, which lets the user compose such characters. To type
special characters as you go, include a line like this in your
\tt{.jedrc}:

#v+
mute_set_mute_keys ("'`~^");
#v-

pressing a quote, or a tilde, or a caret, followed by the character to
accent, will insert an accented character in the buffer. Beware: this could
make inserting quotes cumbersome in some situations, and doesn't work in all
modes. If you get unexpected behaviour, type \tt{no_mode}, insert the
problem characters, then revert to the mode you were using.

Slang files: \tt{mutekeys.sl}

#%}}}


\sect2{Abbreviations and Completion} #%{{{

\em{Abbreviations} are mode-dependent and work like this: you define
that, say, ``PS'' stands for ``PostScript'' in all text-mode files; then
toggle abbreviation mode; hence, each time you type `PS', it will be
expanded to ``PostScript''. Abbreviations are saved in a file, usually
\tt{.abbrevs.sl}.

To define your own abbreviations, you'll edit that file by hand or type
\tt{M-X define_abbreviation}. You'll be prompted for the word(s)
you want to define an abbreviation for, and the abbreviation itself. Then
type \tt{M-X save_abbrevs} to save the abbreviations to the file, and
\tt{M-X abbrev_mode} to enable them.

\em{Completion} works like this: you have already written long words you
don't like to retype; so you press a key that is bound to the ``completion''
function: all possible completion for that word will appear. For example, I
don't actually type ``abbreviation''; I just type `abb', then I press
\tt{^V} (IDE mode binding) or \tt{M-/}, and the whole word appears.

Slang files: \tt{abbrev.sl}, \tt{dabbrev.sl}

#%}}}


\sect2{Ispell} #%{{{

Jed uses \tt{ispell} for spelling check. If you're in doubt whether you
misspelt a word, move the cursor over it and press \tt{M-$}. If the word is
wrong, you'll be prompted for alternatives.

You may want to enable spell checking ``as you type''; the command is
\tt{M-X auto_ispell}. There are still bugs to fix in this routine, though.

Slang files: \tt{ispell.sl}

#%}}}


\sect2{Block Sorting} #%{{{

<p>

Let's suppose you want to sort a set of lines. All you have to do is select
a region, whose beginning and end define the column of text containing the
words you want to sort; then type \tt{M-X sort}.

Slang files: \tt{sort.sl}

#%}}}


\sect2{Multiple Versions} #%{{{

In addition to the backup copy of the working file (which can be disabled:
look for the variable \tt{No_Backups} in \tt{.jedrc}), you can have numbered
copies that are created each time you save the buffer. Just put this line in
\tt{.jedrc}:

#v+
  backups_on ();
#v-

To disable this feature, type \tt{M-X backups_off}.

Slang files: \tt{backups.sl}

#%}}}


\sect2{Registers} #%{{{

\em{Registers} are 128 additional ``clipboards''. Select a region of
text, then copy it to a register with \tt{M-X reg_copy_to_register}. You'll
be prompted for the register number. To paste from a register, type \tt{M-X
reg_insert_register}.

Slang files: \tt{register.sl}

#%}}}


\sect2{Folding} #%{{{

\em{Folding} is a technique for hiding parts of a document, and is 
activated via the function \tt{folding_mode}.  The
following functions/key bindings will be made available by this mode:

#v+
Function                  Bound to key
--------------------------------------

fold_whole_buffer         ^C^W
fold_enter_fold           ^C>
fold_exit_fold            ^C<
fold_open_buffer          ^C^O
fold_fold_region          ^C^F
fold_open_fold            ^C^S
fold_close_fold           ^C^X
fold_search_forward       ^Cf
fold_search_backward      ^Cb

--------------------------------------
#v-

Slang files: \tt{folding.sl}

#%}}}


\sect2{Compiling} #%{{{

Let's suppose that you're writing C or Fortran code. Once the program is
finished, you don't have to quit Jed to compile it. Type \tt{M-X compile}
and provide a suitable command (e.g., \tt{gcc -o foo foo.c}). If the source
contains errors, they will be highlighted in the \tt{*compile*} buffer;
\tt{compile_parse_errors} (\tt{^X '}) and \tt{compile_previous_error} will
move the cursor to the location of the next/previous error in the source
buffer.

Slang files: \tt{compile.sl}, \tt{acompile.sl}

#%}}}

#%}}}


\sect2{GDB Interface} #%{{{

In addition to the compiler interface, there is also an experimental
\tt{gdb} interface. Type \tt{M-X gdb_mode} and type in the name of the
executable you want to debug. You can then use the following
routines:

#v+
Function                Bound to key
----------------------------------------

gdb_attach                        a
gdb_set_args                      A
gdb_break                         b
gdb_break_with_condition          B
gdb_continue                      c
gdb_detach                        d
gdb_finish                        f
gdb_jump                          j
gdb_kill                          k
gdb_next                          Space
gdb_run                           r
gdb_step                          \
gdb_other                         o
gdb_quit                          q
gdb_up                            ^
gdb_output_identifier_at_cursor   ?
gdb_watch_identifier_at_cursor    w
gdb_delete_watch                  W
gdb_show_output_buffer            1
gdb_show_data_buffer              2
gdb_show_watch_buffer             3
gdb_show_source_buffer_only       0
gdb_toggle_data_display_mode      t
gdb_edit_source                   e
gdb_load_source                   l
gdb_run_to_current_line           z

----------------------------------------
#v-

It is assumed that \tt{gdb} is installed, and you know how to use it.

Slang files: \tt{gdb.sl}

#%}}}


\sect2{Directory Editor} #%{{{

Mode designed for maintaining and editing a directory and the files
contained therein; type \tt{M-X dired}. You'll be promted for a directory
name, and a new buffer called \tt{*dired*} will be created. Type `h' to get
help.

Slang files: \tt{dired.sl}

#%}}}


\sect2{Buffer Editor} #%{{{

Mode designed for maintaining and editing open buffers; type \tt{M-X bufed}.
A new buffer called \tt{*BufferList*} will be created. Type `h' or `?' to
get help.

Slang files: \tt{bufed.sl}

#%}}}


\sect2{Mail/Rmail}

*** Not written yet. ***


\sect2{Tab Issues}


*** Not written yet. ***


\sect2{Regular Expressions}  #%{{{

You may perform search and replace operations with regular expression
support. To replace a regular expression with another, use the special r.e.
\tt{\\1}; for example, to replace ``some text'' with `some text' (notice:
from double quotes to simple quotes), you'll search for
\tt{"\\([a-zA-Z]*\\)"} and replace it with \tt{`\\1'}. For a good
introduction to regular expressions, \tt{man grep}.

Slang files: \tt{regexp.sl}

#%}}}


\sect2{Occur Search}  #%{{{

\tt{M-X occur} finds occurrences of regular expressions in the current
buffer. A new buffer, called \tt{*occur*}, is created; it contains the lines
where the regexp was found. Move to the \tt{*occur*} buffer, then move the
cursor to a line and press `g'. In the other buffer, the cursor will be
placed on the corresponding line.

Slang files: \tt{occur.sl}

#%}}}


\sect2{Man and Info Reader}  #%{{{

Unix users will like the built-in \tt{man} and \tt{info} readers; \tt{M-X
unix_man} and \tt{M-X info_mode} to activate them. The pages will be loaded
in most mode; see Section <ref id="Most Mode" name="Most Mode">.

Slang files: \tt{man.sl}, \tt{info.sl}

#%}}}


#%}}}


\sect1{Quick Tips} #%{{{

\begin{itemize}

\item \tt{M-X do_shell_cmd} executes a shell command and puts the resulting 
output in a buffer (\tt{shell.sl}).

\item place the cursor on a parenthesis of any kind and type \tt{^-\\} to go
to the matching one.

\item \tt{M-X cal} displays a calendar in a buffer (\tt{cal.sl}).

\item \tt{M-X isearch_forward} and \tt{M-X isearch_backward} perform
incremental search operations (\tt{isearch.sl}).

\item \tt{M-X replace_across_buffer_files} does a replace across all open
buffers (\tt{replace.sl}).

\item \tt{M-X untab} operates on a region and converts tabs to spaces;
\tt{ESC 1 M-X untab} converts spaces to tabs (\tt{untab.sl})

\end{itemize}

#%}}}


\sect1{Modes \label{Modes}} #%{{{

Jed implements \em{modes} to facilitate the editing of program sources or
markup languages like LaTeX or HTML. Typically, modes define a \em{syntax
highlighting} scheme, provide \em{automatic indentation} and
\em{functions} whose behaviour depends on \em{variables}, in some
cases provide a Mode menu entry, and often also provide a \em{hook} for
customization purposes. You can change the default key binding and variables
default values in your \tt{.jedrc}.

For example, let's consider C mode. When you edit a file with extension
\tt{.c}, Jed understands it's a C language file and turns on C
mode. As you type your program, the syntax elements are highlighted. Some
mode-specific functions are now available from the Mode menu, along with new
key bindings; you can change these by writing a function called
\tt{c_mode_hook} in your \tt{.jedrc}.

Usually, Jed recognises a file's associated mode by its extension. You can
force Jed to edit a file using a particular mode by putting this on its
first line:

#v+
-*- your_mode -*-
#v-

For example, if you save your LaTeX files without the \tt{.tex} extension,
but want to edit them in LaTeX mode, you'll write \tt{% -*- LaTeX -*-} as
the first line.

You may notice that modes are not very consistent with each other; that is,
similar actions are often bound to very different key bindings. This will
change in the future.

As of Jed B0.99.10, the following modes are available: bibtex, c, c++, dcl,
fortran 77, fortran 90, html, idl, java, latex, tex, lisp, maple, matlab,
nroff, perl, postscript, python, sgml, slang, spice, tcl, tiasm, pascal,
verilog, vhdl. Only the most commonly used will be described below. This
table summarises their features:

#%+
  I'd love to use tables, but these are poorly supported in sgml-tools 
  1.0.9. I'll make it a verbatim environment.
#%-

#v+
Mode          Syntax Hi.   Indent   Font     (Un)Comment   Hook   Other
----------------------------------------------------------------------

bibtex        y            y        y        n             y      n
c             y            y        n/a      y             y      y
c++           y            y        n/a      y             n      y
dcl           n            n        n/a      n             n      y
fortran 77    y            y        n/a      y             y      y
fortran 90    y            y        n/a      y             y      y
html          y            n        y        y             y      y
idl           y            y        n/a      n             y      y
java          y            y        n/a      y             y      y
latex         y            y        y        y             y      y
tex           y            n        n        n             y      y
lisp          y            y        n/a      n             y      n
maple         ?            ?        n/a      ?             y      y
matlab        y            y        n/a      y             y      y
nroff         y            n        n        n             y      n
perl          y            n        n/a      n             y      n
postscript    y            n        n/a      n             y      n
python        y            y        n/a      y             y      y
sgml          y            n        y        y             y      y
slang         y            y        n/a      y             y      y
spice         y            n        n/a      n             y      n
tcl           y            y        n/a      n             y      y
tiasm         y            n        n/a      n             y      n
pascal        y            y        n/a      n             y      y
verilog       y            n        n/a      n             y      n
vhdl          y            n        n/a      n             y      n 

--------------------------------------------------------------------
#v-


\sect2{C mode} #%{{{

This is a mode designed for editing C language files. After the mode is
loaded, the hook \tt{c_mode_hook} is called if it exists. Functions that
affect this mode include:

#v+
Function             Default binding
------------------------------------

c_insert_bra                  {
c_insert_ket                  }
newline_and_indent          RETURN
indent_line                  TAB
goto_match                  Ctrl-\
c_make_comment              ESC ;
c_format_paragraph          ESC q
c_top_of_function         ESC Ctrl-A
c_end_of_function         ESC Ctrl-E
c_mark_function           ESC Ctrl-H

------------------------------------
#v-

Variables affecting indentation include:

\begin{itemize}
\item \tt{C_INDENT}
\item \tt{C_BRACE}
\item \tt{C_BRA_NEWLINE}
\item \tt{C_CONTINUED_OFFSET}
\item \tt{C_Comment_Column}
\end{itemize}

Slang files: \tt{cmisc.sl}

#%}}}


\sect2{Fortran Mode} #%{{{

This is a mode designed for editing Fortran language files. After the mode
is loaded, the hook \tt{fortran_hook} is called if it exists. Useful
functions include:

#v+
Function                      Default binding
---------------------------------------------

fortran_continue_newline           ESC RETURN
fortran_comment                       ESC ;
fortran_uncomment                     ESC :
fortran_electric_label                0-9
fortran_next_statement                ^C^N
fortran_previous_statement            ^C^P
fortran_ruler                         ^C^R
fortran_beg_of_subprogram            ESC ^A
fortran_end_of_subprogram            ESC ^E
fortran_mark_subprogram              ESC ^H

---------------------------------------------
#v-

Variables include:

\begin{itemize}
\item \tt{Fortran_Continue_Char}
\item \tt{Fortran_Comment_String}
\item \tt{Fortran_Indent_Amount}
\end{itemize}

Slang files: \tt{fortran.sl}

#%}}}


\sect2{LaTeX Mode} #%{{{

This is a mode designed for editing LaTeX files. After the mode is loaded,
the hook \tt{latex_mode_hook} is called if it exists. In addition, if
the abbreviation table \tt{TeX} is defined, that table is used. Useful
functions include:

#v+
Function                      Default binding
---------------------------------------------

tex_insert_braces                      ^C{
tex_font                               ^C^F
latex_environment                      ^C^E
latex_section                          ^C^S
latex_close_environment                ^C]
latex_insert_item                      ^C^J
tex_comment_region                     ^C;
tex_uncomment_region                   ^C:
tex_comment_paragraph                  ^C%
tex_mark_environment                   ^C.
tex_mark_section                       ^C*
latex_toggle_math_mode                 ^C~
tex_insert_macro                       ^C^M
tex_complete_symbol                   ESC TAB
latex_help                             ^Ci
latex_indent_next_line                 ^J
latex_indent_region                   ^C^Q^R
latex_indent_section                  ^C^Q^S
latex_indent_environment              ^C^Q^E

---------------------------------------------
#v-

Slang files: \tt{texcom.sl}, \tt{latex.sl}, \tt{latex209.sl}

#%}}}


\sect2{TeX Mode} #%{{{

This is a mode designed for editing TeX and LaTeX files. When tex mode is
loaded, \tt{tex_mode_hook} is called if it exists. Useful bindings:

#v+
Function               Default binding
--------------------------------------

tex_insert_quote             "
tex_insert_quote             '
tex_blink_dollar             $
tex_ldots                    .

--------------------------------------
#v-

Slang files: \tt{texcom.sl}

#%}}}


\sect2{HTML Mode} #%{{{

This is a mode designed for editing HTML files. The hook \tt{html_mode_hook}
is called if it exists.

If a region is defined (i.e., if a mark is set), many HTML tags will insert
around the region, e.g. '<B>' and '</B>'.

If the variable 'HTMLModeWraps' is set to 1, this mode will wrap (like
\tt{text_mode} does); otherwise, this mode won't wrap (like \tt{no_mode}).

Keybindings begin with \tt{^C} and are grouped according to function:

#v+
Key         Function
-----------------------------------------

^CA...      Anchors
^CD...      Definition lists
^CF...      Forms
^CH...      Headings, document type, etc.
^CI...      Images
^CL...      Lists
^CP...      Paragraph styles, etc.
^CS...      Character styles

-----------------------------------------
#v-

Additionally, some special movement commands and miscellaneous characters
are defined:

#v+
Key         Action
----------------------------------------------------------

^C^B        skip to beginning of prior HTML tag
^C^F        skip to end of next HTML tag
^C^N        mark next HTML tag from '<' to '>'
^C^P        mark prior HTML tag from '<' to '>'
^C&         insert HTML text for '&'
^C>         insert HTML text for '>'
^C<         insert HMTL text for '<'
^CC         insert HTML comment (around region, if marked)

----------------------------------------------------------
#v-

Slang files: \tt{html.sl}

#%}}}


\sect2{Most Mode \label{Most Mode}} #%{{{

This is a simple mode used for browsing text files, which will be opened
read-only. Press Space to advance a page, BS to go back, `/' to search
forward, `?' to search backwards. Press `h' to get a short help message.

Slang files: \tt{most.sl}

#%}}}

#%}}}


\end{\documentstyle}
