.\"
.\" $Id: ispell.1X,v 1.80 1995/01/08 23:23:31 geoff Exp $
.\"
.\" Copyright 1992, 1993, Geoff Kuenning, Granada Hills, CA
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\"
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. All modifications to the source code must be clearly marked as
.\"    such.  Binary redistributions based on modified source code
.\"    must be clearly marked as modified versions in the documentation
.\"    and/or other materials provided with the distribution.
.\" 4. All advertising materials mentioning features or use of this software
.\"    must display the following acknowledgment:
.\"      This product includes software developed by Geoff Kuenning and
.\"      other unpaid contributors.
.\" 5. The name of Geoff Kuenning may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY GEOFF KUENNING AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL GEOFF KUENNING OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.\" $Id: ispell.1X,v 1.80 1999/11/10 kolar Exp $
.\" $Log: ispell.1X,v $
.\" Translation into Czech 1999/11/10  kolar
.\" <Petr.Kolar@vslib.cz>
.\"
.\" Revision 1.80  1995/01/08  23:23:31  geoff
.\" Document the new personal-dictionary behavior (dictionary named after
.\" the hash file is preferred).
.\"
.\" Revision 1.79  1994/10/25  05:46:02  geoff
.\" Document the new DICTIONARY variable, and improve the documentation of
.\" the -d flag.
.\"
.\" Revision 1.78  1994/09/16  05:06:58  geoff
.\" Make it clear that the + command doesn't change the string-character
.\" type.
.\"
.\" Revision 1.77  1994/04/27  01:50:35  geoff
.\" Remove the bug about the tex parser getting confused by \endxxx.
.\"
.\" Revision 1.76  1994/03/21  01:54:08  geoff
.\" Document the '&' command in -a mode.
.\"
.\" Revision 1.75  1994/03/15  06:24:26  geoff
.\" Document the changes to the +/-/~ commands and the -T switch.
.\"
.\" Revision 1.74  1994/01/25  07:11:39  geoff
.\" Get rid of all old RCS log lines in preparation for the 3.1 release.
.\"
.\"
.TH ISPELL 1 local
.SH JMNO
ispell, buildhash, munchlist, findaffix, tryaffix, icombine, ijoin \-
Interaktivn korektor peklep
.SH POUIT
.B ispell
.RI [ spolen-volby ]
.RB [ \-M | \-N ]
.RB [ \-L
\fIdk\fP]
.RB [ \-V ]
soubory
.br
.B ispell
.RI [ spolen-volby ]
.B \-l
.br
.B ispell
.RI [ spolen-volby ]
.RB [ \-f
soubor]
.RB [ \-s ]
.RB { \-| \-}
.br
.B ispell
.RB [ \-d
.IR soubor ]
.RB [ \-w
.IR znaky ]
.B \-c
.br
.B ispell
.RB [ \-d
.IR soubor ]
.RB [ \-w
.IR znaky ]
.BR \-e [ rove ]
.br
.B ispell
.RB [ \-d
.IR soubor ]
.B \-D
.br
.B ispell
.BR \-v [ v ]
.IP \fIspolen-volby\fP:
.RB [ \-t ]
.RB [ \-n ]
.RB [ \-b ]
.RB [ \-x ]
.RB [ \-B ]
.RB [ \-C ]
.RB [ \-P ]
.RB [ \-m ]
.RB [ \-S ]
.RB [ \-d
.IR soubor ]
.RB [ \-p
.IR soubor ]
.RB [ \-w
.IR znaky ]
.RB [ \-W
.IR n ]
.RB [ \-T
.IR typ ]
.PP
.B buildhash
.RB [ \-s ]
.I
dict-soubor afix-soubor hash-soubor
.br
.B buildhash
.B \-s
.I
poet afix-soubor
.if n .TP 10
.if t .PP
.B munchlist
.RB [ \-l
.IR aff-soubor ]
.RB [ \-c
.IR conv-soubor ]
.RB [ \-T
.IR sufix ]
.if n .br
.RB [ \-s
.IR hash-soubor ]
.RB [ \-D ]
.RB [ \-v ]
.RB [ \-w
.IR znaky ]
.RI [ soubory ]
.if n .TP 10
.if t .PP
.B findaffix
.RB [ \-p | \-s ]
.RB [ \-f ]
.RB [ \-c ]
.RB [ \-m
.IR min ]
.RB [ \-M
.IR max ]
.RB [ \-e
.IR elim ]
.if n .br
.RB [ \-t
.IR tabchar ]
.RB [ \-l
.IR min-poet ]
.RI [ soubory ]
.PP
.B tryaffix
.RB [ \-p | \-s]
.RB [ \-c ]
.I expandovan-soubor
.IR afix [ +pdavek ]
...
.PP
.B icombine
.RB [ \-T
.IR typ ]
.RI [ aff-soubor ]
.PP
.B ijoin
.RB [ \-s | \-u ]
.I volby-pro-join
.I soubor1
.I soubor2
.SH POPIS
.PP
Korektor peklep
.I ispell
vychz z programu
.I spell
pro ITS, kter byl pejmenovn na
.I ispell
v systmu Twenex. Jeho nejobvyklejm pouitm je kontrola obsahu
souboru pkazem "ispell jmno_souboru".
Pi n
.I ispell
peskakuje vechna jemu znm slova; slovo, kter nem ve slovnku,
povauje za peklep, zobraz je v horn sti obrazovky, a umon
uivateli jeho opravu.
Na obrazovce se zobrazuje i st kontrolovanho souboru - dek
obsahujc neznm slovo a dek pedchoz. Je-li pouit terminl
schopen zvrazovat text inverznm zobrazenm, bude neznm slovo
zvraznno.
Jsou-li ve slovnku "podobn slova" (takov, kter se od neznmho
slova odliuj zmnou jedinho psmene, vyputnm nebo pidnm
jednoho psmene, pehozenm dvojice psmen, anebo lze-li vloenm
mezery, pomlky i spojovnku rozdlit neznm slovo na dv slova
uveden ve slovnku), budou tyto monosti zobrazeny na nsledujcch
dcch jako navrhovan opravy. Krom nich
.I ispell
zobrazuje i takzvan odhady. Odhad je zpsob, jak zskat neznm slovo
z nkterho zkladnho tvaru uvedenho ve slovnku pouitm libovolnch
odvozovacch pravidel ze souboru afix (za bezchybn jsou povaovna
slova zskan vhradn pouitm pravidel povolench pro dan zkladn
tvar). Navrhovan opravy jsou oslovny, odhady jsou oznaeny otaznky.
Pokud je neznm slovo chybn, me jej uivatel opravit vybrnm jedn
z navrhovanch oprav nebo napsnm sprvnho slova. Slovo, kter nen
chybn, me uivatel zaadit do svho osobnho slovnku. Poadovan
innost se vybere jednm z nsledujcch jednopsmennch pkaz
(mohou bt zadny velkmi i malmi psmeny):
.PP
.RS
.IP mezera
Tento vskyt neznmho slova neopravovat.
.IP 0-\fIn\fR
Slovo nahradit navrhovanou opravou se zadanm slem.
.IP R
Replace - run zadat opravu chybnho slova.
.IP A
Accept - povaovat slovo za sprvn do konce tohoto sputn programu
.IR ispell .
.IP I
Insert - slovo povaovat za sprvn a vloit jej (pesn v uvedenm tvaru,
vetn pouit velkch psmen) do osobnho slovnku.
.IP U
Uncapitalized - slovo povaovat za sprvn a peveden na mal psmena
jej vloit do osobnho slovnku.
.IP L
Look up - zkontrolovat, zda se slovo vyskytuje v systmovm slovnku
(urenm pi pekladu programu
.I ispell
volbou WORDS).
.IP X
eXit - zapsat aktuln stav opravovanho souboru na disk a zahjit
zpracovn ppadnho dalho souboru.
.IP Q
Quit - ukonit program
.I ispell
a opravovan soubor ponechat beze zmn.
.IP !
Vyvolat interpret pkaz (nvrat pkazem exit).
.IP ^L
Pekreslit obrazovku.
.IP ^Z
Suspendovat ispell (pokraovat pkazem fg).
.IP ?
Zobrazit npovdu.
.RE
.PP
Podle hodnoty volby MINIMENU zadan pi pekladu programu
.I ispell
me bt ve spodn sti obrazovky zobrazen dek se seznamem
ve uvedench pkaz. Jeho zobrazen lze vynutit volbou
.BR \-M .
Naopak volbou
.B \-N
se zobrazen tto npovdy potla.
.PP
Volbou
.B \-L
lze stanovit, kolik dk kontrolovanho souboru se m pi opravovn
zobrazovat. Implicitn hodnota je vypotna jako urit st
velikosti obrazovky. Poet dk je omezen systmov zvislm limitem.
.PP
Pi pouit volby
.B \-V
budou jin ne tisknuteln ASCII znaky zobrazovny ve stylu
pkazu "cat -v", a to i v ppad, e
.I ispell
na vaem systmu tyto znaky povauje za zobraziteln ISO Latin-n znaky.
Tato volba me poslouit na starch terminlech. Bez n bude
.I ispell
osmibitov znaky povolen pro pslun formt souboru zobrazovat "jak
jsou".
.PP
V "normlnm" reimu nebo pi pouit voleb
.BR \-l ,
.B \-a
i
.B \-A
(viz ne) lze pout nsledujc "spolen" volby zadan
v pkazovm dku:
.RS
.IP \fB\-t\fR
Vstupn soubor je ve formtu TeX nebo LaTeX.
.IP \fB\-n\fR
Vstupn soubor je ve formtu nroff/troff.
.IP \fB\-b\fR
Bude vytvoen zlon soubor se jmnem vzniklm pidnm ppony ".bak"
ke jmnu vstupnho souboru.
.IP \fB\-x\fR
Zlon soubor bude smazn.
.IP \fB\-B\fR
Spojen slova budou povaovna za povolen sloeniny.
.IP \fB\-C\fR
Spojen slova budou povaovna za peklep (chybjc mezeru).
.IP \fB\-P\fR
Nebudou se generovat zvltn kombinace koen/afix.
.IP \fB\-m\fR
Budou se generovat kombinace koen/afix neuveden ve slovnku.
.IP \fB\-S\fR
Seznam odhad bude tdn podle pravdpodobn sprvnosti.
.IP "\fB\-d\fR soubor"
Uruje jmno alternativnho haovanho souboru se slovnkem
(pponu .hash nen teba uvdt). Napklad pomoc
.B "\-d czech"
lze v esk instalaci vybrat esk slovnk.
.IP "\fB\-p\fR soubor"
Uruje jmno souboru s alternativnm osobnm slovnkem.
.IP "\fB\-w\fR znaky"
Udv, kter dal znaky mohou bt st slova.
.IP "\fB\-W\fR n"
Udv maximln dlku slov, kter jsou automaticky povaovna za sprvn.
.IP "\fB-T\fR typ"
Pedpokld, e vechny soubory jsou zadanho typu.
.RE
.PP
Volby
.B \-n
a
.B \-t
uruj, zda
.I ispell
b v reimu nroff/troff
.RB ( \-n )
nebo TeX/LaTeX
.RB ( \-t ).
(Implicitn hodnota je urena volbou DEFTEXFLAG pi instalaci.)
M-li vstupn soubor pponu .tex", a nen-li pouita volba
.BR \-n ,
bude automaticky vybrn reim pro TeX/LaTeX.
V reimu pro TeX/LaTeX
.I ispell
peskakuje znaky za zptnmi lomtky ("\e"), dokud nenalezne mezeru
nebo oddlova TeXu/LaTeXu. Jist pkazy obsahuj argumenty, kter
nemaj bt kontrolovny (napklad nvt a jmna referenc v pkazu
\ecite), protoe mohou obsahovat libovoln neslovn argumenty. Kontrola
peklep je tak potlaena v matematickm reimu.
Napklad v textu
.PP
.RS
\echapter {Tato kpitola}
\ecite{SCH86}
.RE
.PP
.I ispell
ozna za chybn slovo "kpitola" ale nikoli "SCH".
Volba
.B \-t
nerozpoznv komentov znaky "%" TeXu, take jsou kontrolovny
i komente. Nen-li dodrena sprvn syntaxe, mohou bt omylem
kontrolovny i pkazy LaTeXu. Tak argumenty dce pouvanch
pkaz a nkter voliteln argumenty mohou bt nkdy kontrolovny
omylem. Bibliografie nebude kontrolovna, jestlie byl
.I ispell
byl peloen s definovanou volbou
.BR IGNOREBIB .
Nikdy nebudou kontrolovny jmna referenc.
.PP
Reference pro bibliografick systm
.I tib
tvoen textem mezi ``[.'' nebo ``<.'' a ``.]'' nebo ``.>'',
budou v reimu TeX/LaTeX ignorovny vdy.
.PP
Volby
.B \-b
a
.B \-x
uruj, zda bude
.I ispell
pro kad vstupn soubor vytvet zlon (.bak) soubor, kter
obsahuje text ped kontrolou peklep. Pokud vak dojde k chyb
pi otevrn nebo zpisu do souboru, bude .bak soubor existovat
pro ely zotaven dokonce pi pouit volby
.BR \-x .
Implicitn nastaven tto vlastnosti je ureno instalan volbou
DEFNOBACKUPFLAG.
.PP
Volby
.B \-B
a
.B \-C
uruj, jak bude
.I ispell
zpracovvat spojen slova, jako "aletak" msto "ale tak".
Jestlie je zadna volba
.BR \-C ,
budou takov slova povaovna za chybn, a
.I ispell
bude vypisovat jejich variace s vloenmi mezerami nebo pomlkami
jako mon opravy.
Je-li zadna volba
.BR \-B ,
budou spojen slova povaovna za povolen sloeniny, pokud jsou
ob komponenty ve slovnku, a kad komponenta je pinejmenm tak
dlouh jako jazykov zvisl minimum (implicitn 3 znaky). Volba je
uiten pro jazyky jako je nmina a nortina, kde se mnoho sloench
slov vytv prostm zetzenm. (Pamatujte, e sloeniny ze t nebo
vce koenovch slov budou stle povaovny za chybn). Implicitn
hodnota pro tuto volbu je jazykov zvisl; ve vcejazynch
instalacch me zviset na zvolenm slovnku.
.PP
Volby
.B \-P
a
.B \-m
uruj chovn programu
.I ispell
pi automatickm generovn odhadovanch kombinac koen/afix pro mon
pdavky do vaeho osobnho slovnku. (To jsou poloky oznaen v seznamu
odhad otaznky.)
Jestlie je zadna volba
.BR \-P ,
budou tyto odhady zobrazovny pouze kdy
.I ispell
neme vygenerovat dnou opravu, kter vyhovuje aktulnmu slovnku.
Je-li zadna volba
.BR \-m ,
budou tyto odhady zobrazovny vdy. To me bt uiten, pokud slovnk
obsahuje omezen seznam slov, nebo pokud slovm v seznamu nejsou piazeny
vechny sprvn afixy. Pi pouvn tto volby muste bt opatrn,
protoe mohou bt generovna nesprvn slova.  Implicitn hodnota tto volby
je urena pouvanm slovnkem.
.PP
Volba
.B \-S
potlauje implicitn tdn seznamu oprav slova. Tm se me
ponkud zvit pravdpodobnost, e sprvn slovo bude mt nzk slo.
.PP
Volba
.B \-d
umouje vbr alternativnho haovanho slovnku. Volba lze pout
pro vbr jinho jazyka. Jestlie jmno souboru neobsahuje znak "/",
bude soubor hledn v knihovnm adresi, ve kterm je soubor s implicitnm
slovnkem. Pro pouit slovnku umstnho v aktulnm adresi je nutn
zadat "-d ./slovnik.hash". Na rozdl od pedchoz verze programu
.I ispell
nelze jako slovnk pout
.IR /dev/null ,
protoe slovnk mus obsahovat tabulku afix. Jestlie potebujete
efektivn przdn slovnk, vytvote seznam obsahujc jedinou poloku
s nepravdpodobnm etzcem (nap. "qqqqq").
.PP
Volba
.B \-p
se pouv pro zadn alternativnho osobnho slovnku. Jestlie
jmno souboru nezan znakem "/", pedad se mu $HOME. Stejnm
zpsobem definuje jmno osobnho slovnku promnn prosted WORDLIST.
Volba z pkazovho dku m pednost ped nastavenm pomoc
WORDLIST.
Jestlie nen pouita ani volba
.BR \-p ,
ani nen nastavena promnn prosted WORDLIST, bude
.I ispell
hledat osobn slovnk v aktulnm adresi a pot v $HOME; pokud
ani jeden nebude nalezen, vytvo slovnk v $HOME. Jmno souboru
s uivatelskm slovnkem je implicitn vytvoeno pedazenm
etzce ".ispell_" ped jmno zkladnho slovnku. Napklad
pokud pouvte anglick slovnk, bude v osobn slovnk
pojmenovn ".ispell_english". Pokud ovem existuje
soubor ".ispell_words", bude pouvn jako osobn slovnk bez
ohledu na zvolen hlavn slovnk. Toto chovn slou k dosaen
zptn kompatibility.
.PP
Jestlie
.I nen
zadna volba
.BR \-p ,
bude
.I ispell
hledat osobn slovnky jak v aktulnm adresi tak v domovskm
adresi. Existuj-li slovnky v obou tchto adresch, bude pouito
spojen obou. Jsou-li do osobnho slovnku pidvna dal slova,
budou pidvna do slovnku v aktulnm adresi, pokud existuje;
neexistuje-li, budou pidvna do slovnku v domovskm adresi.
.PP
Volba
.B \-w
slou pro zadn nepsmennch znak, kter maj bt povaovny
za povolen znaky ve slovech. Napklad
.B \-w
"&" umon, aby "AT&T" bylo povaovno za jedno slovo. V mnoha
technickch dokumentech mohou bt uiten podtrtka. Tato volba
tak umouje velmi primitivn podporu pro 8-bitov mezinrodn
znaky. Netisknuteln znaky mohou bt zadny obvyklm zpsobem
pomoc zptnho lomtka nsledovanho osmikovm kdem znaku;
nap. "\e014" pro nov dek. Dal monost jak zadat kd znaku
je pout v etzci "n" nsledovan nejve temi slicemi,
udvajcm destkov kd znaku 0 - 255.
Pokud byste napklad chtli zahrnout ASCII znaky BEL (zvonek)
a FF (nov strnka) do vaich slov (to je samozejm naprosto
nesmysln, ale poslou to jako ilustran pklad), bylo by
mon pout
.PP
.RS
n007n012
.RE
.PP
Jin slice ne ti nsledujc znak "n" jsou obyejnmi slicemi.
Ani pouit psmene "n" pro tento el nezpsobuje dn problmy,
protoe psmena bez diakritiky jsou vdy povaovna za znaky, kter
mohou bt pouity ve slov. Program
.I ispell
se obvykle pouv pro zpracovn obsahu souboru, take implicitn
zpracovvn 8-bitovch znak je v podku. Pi zpracovn seznamu
slov s pouitm volby
.B -l
a natnm slov z terminlu mohou bt problmy, pokud je stty
nastaveno tak, e osm bit je skuten paritn.
.PP
Volba
.B \-W
stanovuje maximln dlku slov, kter
.I ispell
bude povaovat vdy povaovat za sprvn.
.I ispell
implicitn pijm vechna jednoznakov slova jako sprvn, co je
ekvivalentem nastaven "\fB\-W 1\fR."
(Implicitn hodnota tto volby je ve skutenosti urena
instalan volbou MINWORD, take ve va instalaci me bt jin.)
Jestlie chcete, aby byla kontrolovna vechna slova bez ohledu na
dlku, muste pout "\fB\-W 0\fR." Pokud v dokument obsahuje velk
mnostv tpsmennch zkratek, pouijte "\fB\-W 3\fR", aby vechna
slova s dlkou nejve ti znaky byla automaticky povaovna za sprvn.
Bez ohledu na nastaven tto volby bude
.I ispell
jako doporuovan nhrady generovat pouze slova, kter jsou ve slovnku.
Jinak by byl seznam doporuovanch nhrad byl pli dlouh. Tato volba
me bt samozejm velmi nebezpen, protoe chyby v krtkch slovech
nebudou odhaleny. Pokud ji pouvte, je vhodn udlat posledn kontrolu
dokumentu bez n, aby byly odhaleny i chyby v krtkch slovech.
.PP
Volba
.B \-T
se pouv pro zadn implicitnho typu etzcovch znak. Tato volba m
pednost ped implicitnm typem odvozenm ze jmna souboru. Argument
.I typ
me bt bu jedno z uniktnch jmen definovanch v souboru afix
(nap.
.BR nroff )
nebo ppona souboru vetn teky (nap.
.BR .tex ).
Nen-li pouita volba
.B \-T
a typ nelze urit ze jmna souboru, bude pouit implicitn typ
etzcovch znak podle souboru afix.
.PP
Volba
.B \-l
(list) slou pro vypsn seznamu neznmch slov z textu tenho ze
standardnho vstupu.
.PP
Volba
.B \-a
slou pro komunikaci jinch program s programem
.I ispell
pomoc roury. V tomto reimu
.I ispell
vype jednodkovou zprvu o sv verzi, a pak zahj ten dk ze
vstupu. Pro kad vstupn slovo bude na standardn vstup vypsn jeden
dek. Pokud se jedn o tvar slova, kter je pmo uveden v hlavnm
nebo v osobnm slovnku, bude dek obsahovat pouze znak '*'. Pokud lze
slovo odvodit pomoc pravidel ze souboru afix (tj. slovo by v normlnm
reimu bylo povaovno za bezchybn), bude dek obsahovat znak '+',
mezeru a zkladn tvar slova. Pokud bylo slovo odvozeno zetzenm dvou
slov (povolenho volbou
.BR \-C ),
pak dek bude obsahovat pouze znak '\-'.
.PP
Jestlie slovo ve slovnku nen, ale jsou tam podobn slova, pak dek
bude obsahovat znak '&', mezeru, patn napsan slovo, mezeru, poet
podobnch slov, pozici slova na dku (0 znamen, e slovo bylo na
zatku dku), dvojteku, dal mezeru a seznam podobnch sprvnch
slov oddlench vdy rkou a mezerou. Za podobnmi slovy nsleduj
odhady (kter lze rozpoznat od podobnch slov pouze tm, e skuten
poet slov je vt ne kolik bylo udno), tj. zpsoby, jak by mohlo
bt slovo vytvoeno pidnm (ve slovnku pro dan koen nepovolench)
afix ke znmmu koeni. Jednotliv odhady jsou tak oddleny rkou
a mezerou. Jestlie jsou v seznamu pouze odhady a dn podobn slova,
bude formt dku stejn, ale msto vodnho znaku '&' bude pouit
znak '?' (a poet podobnch slov bude vdy nula). Doporuovan odvozen
v odhadech maj nsledujc tvar:
.PP
.RS
[prefix+] koen [-prefix] [-sufix] [+sufix]
.RE
.PP
(nap. "re+fry-y+ies" dv "refries"); kad nepovinn
.I prefix
a
.I sufix
je etzec.
V kadm podobnm slov nebo odhadu jsou pouita velk psmena stejnm
zpsobem jako ve vstupnm slov, pokud nen takov pouit velkch psmen
zakzno; jinak jsou v podobnch slovech pouita velk psmena podle
slovnku.
.PP
Jestlie se slovo ve slovnku nevyskytuje, ani v nm nejsou podobn
slova, pak dek bude obsahovat znak '#', mezeru, patn napsan slovo,
mezeru a pozici slova na dku (0 znamen, e slovo bylo na zatku dku).
.PP
Za poslednm vypsanm zznamem bude jeden przdn dek, kter oznauje, e
.I ispell
dokonil zpracovn vstupnho dku.
.PP
Formt vstupnch dk lze shrnout takto:
.PP
.RS
.IP Slovo:
.IP Sprvn:
*
.IP Koen:
+ <koen>
.IP Sloenina:
\-
.IP patn:
& <pvodn> <poet> <posunut>: <podobn>, <podobn>, ..., <odhad>, ...
.IP Odhad:
? <pvodn> 0 <posunut>: <odhad>, <odhad>, ...
.IP Nenalezeno:
# <pvodn> <posunut>
.RE
.PP
Pokud by anglick slovnk napklad obsahoval pouze slova "fray", "Frey",
"fry" a "refried", na pkaz
"echo 'frqy refries' | ispell -a -C -d ./fray.hash" by
.I ispell
odpovdl
.RS
.nf
@(#) International Ispell Version 3.1.20 10/10/95
& frqy 3 0: fray, Frey, fry
& refries 1 5: refried, re+fry-y+ies
.fi
.RE
.PP
Reim s volbou \-a je vhodn i pro interaktivn pouit, pokud
chcete zjistit, jak se m pst jedno konkrtn slovo.
.PP
Volba
.B \-A
funguje stejn jako volba
.BR \-a ,
ale pokud dek zan etzcem "&Include_File&", zbytek
dku je povaovn za jmno souboru, jeho obsah m bt zpracovn.
Po zpracovn vloenho souboru bude
.I ispell
pokraovat ve zpracovn pvodnho souboru. Maximln hloubka vnoen
vloench soubor je 5. etzec pouit pro vloen souboru me bt
zmnn pomoc promnn prosted
.B INCLUDE_STRING
(znaky '&' mus bt obsaeny).
.PP
V reimu
.B \-a
pijm
.I ispell
dky obsahujc jedin slovo s pedazenm nkterm z nsledujcch
znak: '*', '&', '@', '+', '-', '~', '#', '!', '%' nebo '^'.
dek zanajc znakem '*' pikazuje programu
.IR ispell ,
aby vloil slovo do uivatelskho slovnku (jako interaktivn pkaz I);
dek zanajc znakem '&' pikazuje
vloit slovo peveden na mal psmena do uivatelskho slovnku
(jako interaktivn pkaz U);
dek zanajc znakem '@' zpsob, e program
.I ispell
bude toto slovo pt pijmat (jako pkaz A);
dek zanajc znakem '+' nsledovanm (bez mezery) etzcem
.B tex
nebo
.B nroff
zpsob, e
.I ispell
bude dal vstup zpracovvat podle syntaxe zadanho formtu;
dek obsahujc pouze znak '+' pepne
.I ispell
do reimu TeX/LaTeX (jako volba
.BR \-t )
a znak '-' pepne
.I ispell
zpt do reimu nroff/troff (posledn dva pkazy jsou zastaral).
Nicmn typ etzcovch znak
.I nen
tmito pkazy zmnn; pro jeho zmnu je teba pout pkaz '~'.
dek zanajc znakem '~' zpsob, e
.I ispell
nastav intern parametr urujc implicitn typ etzcovch
znak podle jmna souboru zadanho ve zbytku dku. (Postauje
ppona souboru s tekou na zatku. Msto jmna souboru nebo
ppony me bt pouito uniktn jmno uveden v souboru afix.)
Pkaz '~'
.I nemn
nastaven zpsob zpracovn (formt) zpracovvanho souboru;
pro jeho zmnu mus bt pouit pkaz '+'.
dek zanajc znakem '#' zpsob, e bude uloen osobn slovnk.
dek zanajc znakem '!' zapne
.I strun
reim (viz dle); dek zanajc znakem '%' pepne
.I ispell
do normlnho (nestrunho) reimu.
Jakkoli znaky na dku obsahujcm pkaz '+', '-', '#', '!'
nebo '%' jsou ignorovny, stejn jako libovoln vstup nsledujc
jmno_souboru na dku '~'. Aby bylo mon kontrolovat dky, kter
zanaj nkterm z tchto znak, je nutn na zatek takovch
dk pidat znak '^'. Program
.I ispell
odstran tento znak a zbytek dku ped kdu na kontrolu peklep.
Doporuuje se, aby programy, kter komunikuj tmto zpsobem s programem
.IR ispell ,
pidvaly znak '^' na kad dek, kter m bt kontrolovn, aby
byly chrnny ped budoucmi zmnami chovn programu
.IR ispell .
.PP
Souhrn ve uvedench pkaz:
.PP
.RS
.IP *
Pidat slovo do osobnho slovnku
.IP @
Slovo pijmout, ale nevloit jej do slovnku
.IP #
Uloit aktuln osobn slovnk
.IP ~
Nastavit parametry podle jmna_souboru
.IP +
Zapnout reim TeX
.IP -
Ukonit reim TeX
.IP !
Zapnout strun reim
.IP %
Ukonit strun reim
.IP ^
Kontrolovat zbytek dku
.fi
.RE
.PP
Ve 
.I strunm
reimu nebude
.I ispell
tisknout dky zanajc znaky '*', '+' nebo '\-', kter indikuj
sprvn slova. To vznamn zvyuje rychlost bhu pokud dc program
tato sprvn slova ignoruje.
.PP
Volba
.B \-s
je povolena pouze na systmech odvozench od BSD a pouze ve spojen
s volbami
.B \-a
nebo
.BR \-A .
S touto volbou program
.I ispell
sm sebe zastav signlem
.B SIGTSTP
po kadm vstupnm dku.
Pokraovat bude a po pchodu signlu
.BR SIGCONT .
Tato vlastnost slou pro handshaking s uritmi textovmi editory.
.PP
Volba
.B \-f
je povolena pouze ve spojen s volbami
.B \-a
nebo
.BR \-A .
S touto volbou bude
.I ispell
zapisovat vsledky do zadanho souboru msto standardnho vstupu.
.PP
Volba
.B \-v
zpsob, e
.I ispell
vype identifikaci sv aktuln verzi na standardn vstup a skon.
Pokud se tato volba zdvoj, vype
.I ispell
tak volby, se ktermi byl peloen.
.PP
Volby
.BR \-c ,
.BR \-e [ 1-4 ]
a
.B \-D
programu
.I ispell
jsou primrn ureny pro pouit shellovm skriptem
.IR munchlist .
Volba
.B \-c
zpsob, e seznam slov bude ten ze standardnho vstupu, a pro kad
slovo bude vypsn na standardn vstup seznam vech monch kombinac
koene a afixu, pomoc kterch lze dan slovo vygenerovat. Nkter
koeny mohou bt patn a mus bt odfiltrovny z vstupu jinmi
prostedky; to dl napklad skript
.IR munchlist .
Napklad pkaz
.PP
.RS
echo BOTHER | ispell -c
.RE
.PP
produkuje:
.PP
.RS
.nf
BOTHER BOTHE/R BOTH/R
.fi
.RE
.PP
Volba
.B \-e
je opakem volby
.B \-c
a expanduje pznaky na seznam slov.
Napklad pkaz:
.PP
.RS
echo BOTH/R | ispell -e
.RE
.PP
produkuje:
.PP
.RS
.nf
BOTH BOTHER
.fi
.RE
.PP
Voliteln me bt tak zadna rove expanze. Volba
.B \-e
je tot co
.BR \-e1 .
Pi rovni 2 bude kadmu dku pedazena pvodn
dvojice koen/afix:
.PP
.RS
.nf
BOTH/R BOTH BOTHER
.fi
.RE
.PP
Pi rovni 3 bude kad vygenerovan slovo na zvltnm dku a
budou mu pedazeny dvojicemi koen/afix jako v rovni 2:
.PP
.RS
.nf
BOTH/R BOTH
BOTH/R BOTHER
.fi
.RE
.PP
Pi rovni 4 budou vypisovny dky jako v rovni 3, ale na konci
kadho dku bude navc reln slo udvajc pomr mezi dlkou
koene a celkovou dlkou vech vygenerovanch slov vetn koen:
.PP
.RS
.nf
BOTH/R BOTH 2.500000
BOTH/R BOTHER 2.500000
.fi
.RE
.PP
Volba
.B \-D
zpsob, e tabulky afix ze slovnkovho souboru budou vypsny
na standardn vstup.
.PP
Pokud v sprvce systmu nezapnul volbu pro eten mstem,
.I ispell
bude dbt na sprvn pouit velkch psmen ve slovech ze zkladnho
i vaeho osobnho slovnku. Krom rozpoznvn slov, kter mus zanat
velkch psmenem (nap. George), a slov, kter mus mt vechno psmena
velk (nap. NASA), me tak zpracovvat slova s "neobvyklm" pouitm
velkch psmen (nap. "ITCorp" nebo "TeX"). Jestlie jsou ve slov
pouita velk psmena nesprvn, seznam monost bude zahrnovat vechny
povolen pouit velkch psmen. (Me bt povoleno vce ne jedno
pouit velkch psmen me bt acceptable; slovnk napklad me
obsahovat jak "ITCorp" tak "ITcorp".)
.PP
Normln tato vlastnost nepsob dn pekvapen, ale existuje jeden
ppad, na kter muste dvat pozor. Jestlie pouvte interaktivn
pkaz "I" pro pidn slova, kter je na zatku vty (nap. prvn
slovo tohoto odstavce, kdyby slovo "normln" nebylo ve slovnku),
do vaeho slovnku, bude oznaeno jako "pouit velkch psmen podle
poadavku". Dal vskyt tohoto slovo bez pouit velkch psmen
(nap. slovo uveden v uvozovkch v pedchoz vt) bude programem
.I ispell
povaovno za chybu, a jako oprava bude nabdnuto slovo s velkm
psmenem na zatku. Potom nezbv ne zkontrolovat, zda se jedn
o sprvn slovo a stisknutm "I" pidat do slovnku i slovo psan
malmi psmeny. Tomuto problmu se mete vyhnout pouvnm pkazu
"U" msto "I" pro pidn slova do uivatelskho slovnku.
.PP
Pravidla pro porovnvn slov s velkmi psmeny jsou nsledujc:
.IP (1)
Libovoln slovo uveden ve slovnku je sprvn, i kdy je napsno
cel velkmi psmeny (napklad v nzvech kapitol).
.IP (2)
Jakkoli slovo, kter je ve slovnku uloeno se vemi psmeny malmi,
se me v textu objevit napsan malmi psmeny nebo s velkm potenm
psmenem (nap. na zatku vty).
.IP (3)
Jakkoli slovo, kter je uloeno ve slovnku s "podivnou" kombinac
velkch a malch psmen (tj. obsahuje jak velk tak mal psmena a
velk psmeno je jinde ne na zatku), mus bt v textu uvedeno pesn
stejn jako ve slovnku, krom ppadu uvedenho v pravidle (1). M-li
bt pijato slovo napsan malmi psmeny, mus bt tak uvedeno i ve
slovnku.
.SS buildhash
.PP
Program
.I buildhash
vytv haovan soubor se slovnkem pro pozdj pouit programem
.IR ispell .
Jmno souboru se seznamem slov (s afixovmi pznaky) je zadno parametrem
.IR dict-soubor ,
afixov pznaky jsou definovny v souboru
.IR afix-soubor .
Vytven haovan soubor bude mt jmno
.IR hash-soubor .
Formt vstupnch soubor je popsn v manulov strnce
.IR ispell (4).
Volba
.B \-s
(silent, tich) potla vpis obvyklch stavovch zprv na standardn
chybov vstup.
.SS munchlist
.PP
Shellov skript
.I munchlist
se pouv pro zmenen velikosti souboru se slovnkem, zejmna pro
osobn slovnky. Lze jej tak pout pro slouen dvou slovnk
pouvajcch rzn soubory afix.
Pkaz pete zadan
.I soubory
(nebo standardn vstup, jestlie nejsou zadny dn argumenty),
zredukuje je na minimln sadu koen a afix, kter budou vyhovovat
stejnmu seznamu slov, a vsledek vype na standardn vstup.
.PP
Vstup pro munchlist me obsahuje pouze slova (nap. z osobnho
slovnku) nebo kombinace koen/afix (pravdpodobn vygenerovan
pi pedchozch sputnch programu munchlist). Kad slovo a
kombinace koen/afix mus bt na zvltnm dku.
.PP
Volba
.B \-D
(debug, ladn) nesmae doasn soubory se standardnmi jmny, co
lze pout pro ladic ely. Varovn: toto volba me spotebovat
enormn mnostv diskovho prostoru.
.PP
Volba
.B \-v
(verbose) zpsob, e na standardn chybov vstup budou vypisovny
zprvy o prbhu zpracovn, aby uivatel nebyl nervzn, e
.I munchlist
havaroval.
.PP
Jestlie je pouita volba
.B \-s
(strip, odtrhnout), budou slova, kter jsou v zadanm souboru
.IR hash-soubor ,
vyputna ze seznamu slov. To me bt uiten pro osobn slovnky.
.PP
Volba
.B \-l
slou pro zadn alternativnho jmna souboru
.I afix-soubor
pro zpracovn slovnk pro jin jazyky ne je anglitina.
.PP
Volba
.B \-c
slou pro konverzi slovnk, kter byly vytvoeny s pouitm
starho souboru afix, bez rizika nezamlenho vnen nechtnch
kombinac afix do slovnku.
.PP
Volba
.B \-T
umouje konvertovat slovnky na kanonick formt etzcovch znak.
Zadan sufix je vyhledn v souboru afix (zadanm volbou
.BR \-l ), 
a pak je stanoven formt etzcovch znak pouvan pro vstupn soubor;
na vstupu budou vdy pouit kanonick formt etzcovch znak.
Napklad slovnk zskan ze zdrojovch soubor v TeXu me bt
konvertovn na kanonick formt pomoc parametru
.BR "\-T tex" .
.PP
Volba
.B \-w
je pedna programu
.IR ispell .
.SS findaffix
.PP
Shellov skript
.I findaffix
je pomcka pro vybrn afix pi vytven novch popis jazyka.
V zadanch
.I souborech
se slovnky (nebo ve standardnm vstupu, pokud nejsou zadna dn
jmna soubor) jsou vyhledny mon prefixy (s volbou
.BR \-p )
nebo sufixy (implicitn nebo s volbou
.BR \-s ).
Kad obvykle se objevujc afix bude vypsn spolu s informac,
kolikrt se objev, s odhadem potu byt, kter by byly ueteny
v haovanm slovnku, pokud by afix byl pidn do souboru afix
pro dan jazyk. Jsou vypsny pouze afixy, kter generuj povolen
koen (tj. koen, kter se nachz v pvodnm vstupu).
.PP
Jestlie nen pouita volba "-c", budou mt vstupn dky formt:
.IP
odtrhnout/pidat/poet/byt
.PP
kde
.I odtrhnout
je etzec, kter mus bt odstrann z koenovho slova ped pidnm
afixu,
.I pidat
je afix, kter m bt pidn,
.I count
udv, kolikrt se tato kombinace
.IR odtrhnout / pidat
objev, a
.I byt
je odhad potu byt, kter by mohly bt uloeny v syrovm souboru se
slovnkem, pokud by tato kombinace byla pidna do souboru afix.
Jako oddlova poloek ve vstupu bude pouit znak zadan pepnaem
.BR -t ;
implicitn lomtko ("/").
.PP
Je-li pouita volba
.B \-c
("ist vstup"), vzhled vstupu bude vizuln ist (ale obtnji
zpracovateln) ve tvaru:
.IP
-odtrhnout+pidat<tab>poet<tab>byt
.PP
kde
.IR odtrhnout ,
.IR pidat ,
.IR poet ,
a
.I byt
maj stejn vznam jako v pedelm ppad, a
.I "<tab>"
je ASCII znak tabeltor.
.PP
Metoda pouvan na generovn monch afix bude tak generovat
del afixy kter maj stejn zatky nebo konce. Napklad
slova "moth" a "mother" budou generovat nejenom normln
substituce "+er", ale tak "-h+her" a "-th+ther" (ppadn
jet del, v zvislosti na hodnot argumentu
.IR min ).
Aby se zabrnilo zahlcen vstupu tmito afixy, je vypisovn vech dvojic
afix, kter zanaj (u prefix kon) stejnm etzcem delm ne
.I elim
znak (implicitn 1) zakzno. Mete nastavit "elim" na hodnotu vt
ne 1, jestlie v jazyk pouv etzcov znaky; obvykle se poteba
tohoto parameteru stane zjevnou, kdy zkontrolujete vstupy vaich
sputn programu
.IR findaffix .
.PP
Normln jsou afixy setdn podle odhadu uetench byt.
Volba
.B \-f
zpsob, e afixy budou setdny podle frekvence vskytu.
.PP
Pro zmenen velikosti vstupnho souboru budou eliminovny afixy,
kter se objev mn ne 10 krt; tento limit me bt zmnn volbou
.BR \-l .
Volba
.B \-M
uruje maximln dlku afix (implicitn 8). Del afixy nebudou vypsny.
(Tato volba et prostor, kter zabraj doasn diskov soubory,
a urychluje bh skriptu.)
.PP
Afixy kter generuj slovn kmeny krat ne 3 znaky jsou potlaeny.
(Kmen je slovo po odstrann etzce
.IR odtrhnout
a ped pidnm etzce
.IR pidat .)
Tm se zmen jak as bhu, tak velikost vstupnho souboru.
Tento limit me bt zmnn pepnaem
.BR \-m .
Nenastavujte minimln dlku kmene na 1, pokud nemte
.I spoustu
volnho asu a diskovho prostoru (v mtku mnoha dn a stovek megabyt).
.PP
Skript
.I findaffix
vyaduje pro intern pouit nemezerov znak jako separtor poloek.
Normln je tmto znakem lomtko ("/"), ale pokud se lomtko vyskytuje
jako znak ve zpracovvanm seznamu slov, me bt pomoc volby
.B \-t
zadn jin znak.
.PP
Slovnky pro ispell mus bt ped zpracovnm programem
.I findaffix 
expandovny, a znaky s diakritikou mus bt pevedeny na mal psmena.
.SS tryaffix
.PP
Shellov skript
.I tryaffix
se pouv pro odhad efektivnosti navrhovanho prefixu (s volbou
.BR \-p )
nebo sufixu (implicitn nebo s volbou
.BR \-s )
pro dan
.IR expandovan-soubor .
Pi kadm sputn programu
.I tryaffix
me bt zkouen pouze jeden afix, ale lze pout vce argument pro
popis rznch forem stejnho afixovho pznaku (nap. pznak
.B D
me v anglitin pidat koncovku
.I D
nebo
.IR ED ,
podle toho, zda slovo kon na E nebo ne).
Kad slovo v expandovanm slovnku, kter kon (nebo zan) vybranm
sufixem (nebo prefixem) m tento sufix (prefix) odstrann; ve slovnku
se pak hled koen slova, kter vyhovuje slovu po odtren tto sti.
Normln jsou na standardn vstup vypsny vechny vyhovujc koeny.
Pokud je pouita volba
.B \-c
(count), bude vypsn pouze statistick souhrn vsledk: poet slov, na
kter lze afix potenciln aplikovat a odhad potu byt slovnku, kter
by se uetily pokud by byl pouit pznak definujc zkouen afixy.
Odhad bude pli vysok, jestlie pznak generuje slova
kter jsou tak generovna jinmi afixovmi pznaky
(nap. v anglitin me bt slovo
.I bathers
vygenerovno pomoc
.I bath/X
nebo
.IR bather/S ).
.P
Soubor
.I expandovan-soubor
se slovnkem mus bt pedem expandovn (pomoc volby
.B \-e
programu
.IR ispell )
a setdn. Program obvykle bude pracovat nejlpe, jestlie budou
velk psmena pevedena na mal programem 'tr'.
.PP
Argumenty
.I afix
je etzec, kter m bt odtrhnut ze slov v souboru se slovnkem, aby
byl zskn zkuebn koen: pkladem prefixu v anglitin je
.I con
a pkladem sufixu
.IR ing .
sti argumentu oznaen
.I pdavek
jsou etzce, kter maj bt odtreeny od
koen ped pidnm afixiu.
Napklad v anglitin afix
.I ing
normln odtrhv koncov
.I e
ze slov, kter tmto znakem kon (tak se nap. ze slova
.I like
stane slovo
.IR liking ),
take je mon spustit:
.PP
.RS
.nf
tryaffix ing ing+e
.fi
.RE
.PP
pro pokryt obou ppad.
.PP
Vechny shellov skripty obsahuj dokumentaci v komentch na svm
zatku; tyto komente mohou obsahovat uiten informace, kter nejsou
uvedeny na tto manulov strnce.
.PP
Je-li to poadovno, lze program
.I ispell
nainstalovat takovm zpsobem, aby zpracovval pouze ASCII texty.
.SS icombine
.I icombine
je pomocn program pro
.IR munchlist .
Nat ze standardnho vstupu seznam slov v tomt formtu, v jakm
jsou ve slovnku (koen/pznaky), a na standardn vstup vypisuje
redukovan seznam, v nm jsou zkombinovny pznaky u koen, kter
se na vstupu vyskytly vcekrt; pokud se v nkolika po sob jdoucch
dcch objev stejn koen, bude na vstup vypsn pouze jeden dek
obsahujc tento koen se vemi pouitmi pznaky. Koeny, ve kterch
byla rzn pouita velk psmena, budou zkombinovny tak, aby informace
o pouit velkch psmen byly zachovny. Voliteln parametr
.I aff-soubor
uruje soubor afix, ve kterm jsou definovny pouvan znakov sady a
vznam jednotlivch pznak.
Volba
.B \-T
umouje vbr rznch typ etzcovch znak zadnm nastrenho
sufixu definovanho pkazem
.BR altstringtype .
.SS ijoin
Program
.I ijoin
je reimplementac programu
.IR join (1).
Program
.I ijoin
sprvn zpracovv dlouh dky a 8-bitov znaky.
Volba
.B \-s
udv, e program
.IR sort (1)
pouvan pro ppravu vstupu pro program
.I ijoin
porovnv 8-bitov znaky jako hodnoty se znamnkem. Volba
.B \-u
naopak udv, e program
.IR sort (1)
pouv porovnn bez znamnka.
Vechny dal volby a chovn programu
.IR join (1)
jsou pevzaty z jeho manulov strnky, s tou odchylkou, e
.I ijoin
nepovauje znak newline za oddlova poloek.
Dal informace naleznete v manulov strnce programu
.IR join (1).
.SH PROMNN PROSTED
.IP DICTIONARY
Jmno slovnku, kter bude pouit, pokud nen zadna volba
.BR \-d .
.IP CHARSET
Bere se v vahu pouze tehdy, je-li nastaveno
.BR DICTIONARY .
Stanovuje implicitn formt a kdovn znak, kdy nejsou pouity volby
.BR \-T ,
.B \-t
nebo
.BR \-n .
Je uiten, je-li formt definovn v souboru afix.
.IP WORDLIST
Jmno souboru s osobn slovnkem.
.IP INCLUDE_STRING
Jmno direktivy pro vloen souboru pi pouit volby
.BR \-A .
.IP TMPDIR
Adres pouvan programem munchlist pro doasn soubory.
.SH SOUBORY
.IP /usr/lib/ispell/english.hash
Haovan slovnk pro anglitinu (me bt hledn v jinm adresi podle
konkrtnho systmu).
.IP /usr/lib/ispell/english.aff
Soubor s definicemi afix pro anglitinu pro program
.I munchlist
.IP "/usr/dict/web2 nebo /usr/dict/words"
Dal soubor pro vyhledvn slov (zvis na volb WORDS pi pekladu).
.IP $HOME/.ispell_\fIhashfile\fP
Uivatelsk osobn slovnk.
.IP .ispell_\fIhashfile\fP
Slovnk pro dan adres.
.SH VIZ TAK
.IR spell (1),
.IR egrep (1),
.IR look (1),
.IR join (1),
.IR sort (1),
.IR sq (1),
.IR ispell (5),
.IR english (5).
.SH CHYBY
Naten haovanho slovnku me podle jeho velikosti trvat nkolik
sekund nebo i dle.
.sp
Jsou-li povoleny vechny volby, me generovn vech odhad pro
patn napsan slovo trvat nkolik sekund; na pomalejch strojch
to me bt nepjemn.
.sp
Haovac tabulka je uloena jako tvrtmegabytov (nebo vt) pole,
take pravdpodobn nebude nikdy existovat verze pro PDP-11 nebo
Intel 80286.
.sp
Program
.I ispell
by ml lpe rozumt syntaxi soubor pro
.IR troff ,
a inteligentnji se vypodat s kontrakcemi.
.sp
Akoli mal osobn slovnky jsou ped uloenm setdny, poad,
v jakm se vypisuj rzn varianty pouit velkch psmen v jednom
slov, je ponkud nhodn.
.sp
Pi pouit volby
.B \-x
program
.I ispell
mae soubory s pponou .bak.
.sp
Program
.I ispell
m pli mnoho voleb, a mnoh z nich nemaj mnemonick jmna.
.sp
Program
.I munchlist
nepracuje pli elegantn se slovnky, kter obsahuj
"neslovn" znaky. Takov znaky by mly bt ze slovnku smazny
a souasn by mlo bt vypsno varovn.
.sp
Pi pouit rozshlch slovnk vyaduj pkazy
.I findaffix
a
.I munchlist
velk mnostv diskovho prostoru pro doasn soubory. Tyto soubory
se vytvej v adresi zadanm promnnou prosted TMPDIR, take
lze ovlivovat jejich umstn. Podstatn st prostoru pro doasn
diskov soubory se vak vyuv pi tdn, take na systmech,
kde program
.IR sort (1)
neakceptuje nedokumentovanou volbu -T, zmna nastaven promnn
TMPDIR pli nepome.
Program
.I munchlist
te pvodn slovnk 10 a 40 krt. (Vt pomr je u slovnk, kter
pouvaj mnostv afix, jako je tomu u anglickho slovnku
distribuovanho s programem
.IR ispell .)
Tak program
.I munchlist
je velmi pomal;
zpracovn slovnku normln velikosti (15K koen, 45K vslednch slova)
trv na mal pracovn stanici okolo jedn hodiny.
(Vtina asu je spotebovna programem
.IR sort (1);
program
.I munchlist
me bet podstatn rychleji na strojch, kter maj modernj
.IR sort ,
kter lpe pouv dostupnou pam.)
Program
.I findaffix
je jet hor;
ani nejmen anglick slovnk neme bt tmto skriptem zpracovn
v 50 KB voln pamti, a s volbou pro omezen poadovanho
doasnho prostoru b skript na mal pracovn stanici vce ne
24 hodin.
.SH AUTOI
Pace Willisson (pace@mit-vax) napsal program ispell v roce 1983
podle assemblerov verze pro PDP-10 od R. E. Gorina z roku 1971,
revidovan W. E. Matsonem (1974) a W. B. Ackermanem (1978).
.P
Pro Usenet shromdil, revidoval a vylepil Walt Buehring, 1987.
.P
Autorem tabulkou zen vcejazyn verze je Geoff Kuenning, 1987-88.
.P
Velk slovnky byly poskytnuty Bobem Devinem (vianet!devine).
.P
Kompletn seznam pispvatel zde nen uveden, protoe je pli rozshl.
Je vak distribuovn se zdrojovmi texty programu ispell jako soubor
"Contributors".
.SH VERZE
Tato manulov strnka popisuje ispell verze
"International Ispell Version 3.1.00, 10/08/93".
