<?php

//    showlink.php
//    Shows the info regarding a link
//
//    Part of the ht://Check package
//
//    Copyright (c) 1999-2002 Comune di Prato - Prato - Italy
//    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
//
//    For copyright details, see the file COPYING in your distribution
//    or the GNU General Public License version 2 or later 
//    <http://www.gnu.org/copyleft/gpl.html>
//
//    $Id: showlink.php,v 1.15 2002/02/11 08:47:38 angusgb Exp $

///////
   //    Global settings
///////

include ("./include/global.inc.php");


if (!isset($dbname))
{
   // Error
   DisplayErrMsg($strErrorNoDBSelected);
   echo "<A href=\"index.php\">" . $strMainPage . "</A>";
   die;
}
else
{
   eval("\$strhome = \"$strDBHome \";");
   if (!isset($IDUrl) || !isset($TagPosition) || !isset($AttrPosition))
   {
      // Error
      DisplayErrMsg($strMissingInfo);
      echo "<A href=\"index.php?dbname=". $dbname . "\">". $strhome."</A>";
      die;
   }

   $strSQL = "Select Schedule.Url as DestUrl, SrcUrl.Url as SourceUrl," .
      " Schedule.Status, Link.IDUrlSrc, Link.IDUrlDest," .
      " Link.LinkType, LinkResult, Link.Anchor, " .
      " Url.Url, Url.StatusCode, Url.ReasonPhrase, Url.ContentType," . 
      " HtmlStatement.Statement, HtmlAttribute.Attribute, HtmlAttribute.Content" .
      " from Url AS SrcUrl, Schedule, Link, HtmlStatement, HtmlAttribute" .
      " LEFT JOIN Url ON Url.IDUrl=Link.IDUrlDest " .
      " WHERE Link.IDUrlSrc=" . $IDUrl . " AND " .
      " Link.TagPosition=" . $TagPosition . " AND " .
      " Link.AttrPosition=" . $AttrPosition . " AND " .
      " SrcUrl.IDUrl=Link.IDUrlSrc AND " .
      " HtmlStatement.IDUrl=" . $IDUrl . " AND " .
      " HtmlAttribute.IDUrl=" . $IDUrl . " AND " .
      " HtmlStatement.TagPosition=Link.TagPosition AND " .
      " HtmlAttribute.TagPosition=Link.TagPosition AND " .
      " HtmlAttribute.AttrPosition=Link.AttrPosition AND " .
      " Schedule.IDUrl=Link.IDUrlDest";

      $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if (! $num=$MyDB->NumRows())
   {
      DisplayErrMsg($strNoOccurrencies);
      die;
   }

   // Information retrieved
   $link = $MyDB->FetchArray();
   $URLName = $link["SourceUrl"];
   $DestLink = $link["DestUrl"];
   $ShowURLName = GetURL($URLName);
   $ShowDestLink = GetURL($DestLink);

   if (strlen($link["Anchor"]))
   {
      $DestLink .= "#" . $link["Anchor"];
      $ShowDestLink .= "#" . $link["Anchor"];
   }

   $pagetitle = "Database: $dbname - " . $strShowLink . ": " . $URLName;
   $linkbar = "<A href=\"index.php?dbname=". $dbname . "\">". $strhome ."</A>";
   $linkbar = $linkbar . " | " .
      "<A href=\"javascript:history.go(-1)\">" . $strBack . "</A>";

      
?>
<?php include ("./include/header.inc.php"); ?>
<?php

   // A database and a URL have been selected

?>
<H4><?php echo $strShowLink; ?>:</H4>
<BLOCKQUOTE>
 <B><?php echo $strReferencingUrl; ?></B>: <A href="showurl.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $link["IDUrlSrc"]; ?>"><?php echo $ShowURLName; ?></A><BR>
 <B><?php echo $strReferencedUrl; ?></B>: <A href="showurl.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $link["IDUrlDest"]; ?>"><?php echo $ShowDestLink; ?></A><BR>
<?php
  if ($link["Anchor"])
  {
?>
 <B><?php echo $strAnchor; ?></B>: <?php echo $link["Anchor"]; ?><BR>
<?php  
  }
?>
 <B><?php echo $strRetrievingFlag; ?></B>: <?php echo $link["Status"]; ?><BR>
 <B><?php echo $strLinkType; ?></B>: <?php echo GetTextString($link["LinkType"]) ; ?><BR>
 <B><?php echo $strLinkResult; ?></B>: <?php
   echo GetTextString($link["LinkResult"]); // Show text anyway

   if ($ShowIcons)
   {
?>
<IMG src="img/<?php echo $link["LinkResult"]; ?>.png" alt="<?php
   echo GetTextString($link["LinkResult"]); ?>"
   width="40" height="35" border=1" bordercolor="black"
   align="middle" hspace="5">
<?php
   }

?><BR>
</BLOCKQUOTE>

<H4><?php echo $strRetrievingInfo; ?></H4>
<BLOCKQUOTE>
<?php
   if ($link["StatusCode"])
   {
?>
 <B><?php echo $strStatusCode; ?></B>: <?php echo $link["StatusCode"]; ?> -
 <B><?php echo $strReasonPhrase; ?></B>: <?php echo $link["ReasonPhrase"]; ?> - 
 <B><?php echo $strContentType; ?></B>: <?php echo $link["ContentType"]; ?><BR>
<?php
   }
   else
   {
?>
<B><?php echo $strNotRetrieved; ?></B><BR>
<?php
   }
?>
</BLOCKQUOTE>

<H4><?php echo $strLinkIssued; ?></H4>
<BLOCKQUOTE>
<B><?php echo $strHTMLStatement; ?></B>: &lt;<?php echo $link["Statement"]; ?>&gt;<BR>
<B><?php echo $strHTMLAttribute; ?></B>: <?php echo $link["Attribute"]; ?>="<?php echo $link["Content"]; ?>"<BR>
</BLOCKQUOTE>

<H4><?php echo $strOperations; ?></H4>
<MENU>
<LI><A href="<?php echo $URLName; ?>" target="_blank"><?php echo $strOpenReferencingUrl; ?></A> (<?php echo $ShowURLName; ?>)</LI>
<LI><A href="<?php echo $DestLink; ?>" target="_blank"><?php echo $strOpenReferencedUrl; ?></A> (<?php echo $ShowDestLink; ?>)</LI>
</MENU>
<?php      

   $MyDB->Free();
}

?>

<BR>

<?php include ("./include/footer.inc.php"); ?>
