<?php

//    listlinks.php
//    Shows a List of Links previously set with a form
//
//    Part of the ht://Check package
//
//    Copyright (c) 1999-2002 Comune di Prato - Prato - Italy
//    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
//
//    For copyright details, see the file COPYING in your distribution
//    or the GNU General Public License version 2 or later 
//    <http://www.gnu.org/copyleft/gpl.html>
//
//    $Id: listlinks.php,v 1.15 2002/02/11 08:47:37 angusgb Exp $

///////
   //    Global settings
///////

include ("./include/global.inc.php");


if (!isset($dbname))
{
   // Error
   DisplayErrMsg($strErrorNoDBSelected);
   echo "<A href=\"index.php\">" . $strMainPage . "</A>";
   die;
}

$strSection=$strListofLinks;
$pagetitle = "Database: $dbname - " . $strSection;
eval("\$strhome = \"$strDBHome \";");
$linkbar = "<A href=\"index.php?dbname=". $dbname . "\">". $strhome."</A>";

// A database has been selected

include ("./include/header.inc.php");

if (isset ($cmd))
{

   if (!isset($initpage))
      $initpage=0;

   if (!isset($pagesize))
      $pagesize=30;

   $strwhere = "";
   $otherinfo = '&cmd=' . urlencode($cmd);
   
   if (isset($linkresult) && $linkresult!="AllLinks")
   {
      $strwhere = $strwhere . "AND Link.LinkResult $whatlinkresult '$linkresult' ";
      $otherinfo = $otherinfo . '&whatlinkresult=' . urlencode($whatlinkresult)
         . '&linkresult=' . urlencode($linkresult);
   }
   
   if (isset($linktype) && $linktype!="AllLinks")
   {
      $strwhere = $strwhere . "AND Link.LinkType $whatlinktype '$linktype' ";
      $otherinfo = $otherinfo . '&whatlinktype=' . urlencode($whatlinktype)
         . '&linktype=' . urlencode($linktype);
   }

   $num=count($src); // Count the elements

   // Set the source filter   
   for ($i=0; $i<$num; $i++)
   {
      if (isset($src[$i]) && $src[$i] && strlen($src[$i]) > 0)
      {
         if(isset($whatsrc[$i]))
         {
            $strwhere = $strwhere . "AND Url.Url " . $whatsrc[$i]
               . " '" . $src[$i] . "' ";
            $otherinfo = $otherinfo . "&whatsrc[$i]=" . urlencode($whatsrc[$i])
               . "&src[$i]=" . urlencode($src[$i]);
          }
      }
   }
   
   $num=count($dest); // Count the elements

   // Set the destination filter   
   for ($i=0; $i<$num; $i++)
   {
      if (isset($dest[$i]) && $dest[$i] && strlen($dest[$i]) > 0)
      {
         if(isset($whatdest[$i]))
         {
            $strwhere = $strwhere . "AND Schedule.Url " . $whatdest[$i]
               . " '" . $dest[$i] . "' ";
            $otherinfo = $otherinfo . "&whatdest[$i]="
               . urlencode($whatdest[$i]) . "&dest[$i]=" . urlencode($dest[$i]);
          }
      }
   }

   // Show all the URLs, retrieved ones as well as not
   $strGenSQL = "SELECT Link.*, "
      . "Url.Url as UrlSrc, "
      . "Schedule.Url as UrlDest, "
      . "HtmlStatement.Statement "
      . "FROM Url, Schedule, Link "
      . "LEFT JOIN HtmlStatement "
      . "ON HtmlStatement.IDUrl = Link.IDUrlSrc "
      . "AND HtmlStatement.TagPosition = Link.TagPosition "
      . "WHERE Schedule.IDUrl = Link.IDUrlDest "
      . "AND Url.IDUrl = Link.IDUrlSrc "
      . $strwhere
      . " LIMIT " . $initpage . ", " . $pagesize;

   if (!isset($count))
   {
      $strCountSQL="select count(*) from Schedule, Url, Link "
         . "LEFT JOIN HtmlStatement "
         . "ON HtmlStatement.IDUrl = Link.IDUrlSrc "
         . "AND HtmlStatement.TagPosition = Link.TagPosition "
         . "WHERE Schedule.IDUrl = Link.IDUrlDest "
         . "AND Url.IDUrl = Link.IDUrlSrc "
         . $strwhere;

      $count = $MyDB->CountEntries($strCountSQL,$dbname,true);
      if ($count<0)
      {
         DisplayErrMsg($MyDB->errmsg);
         return;
      }
      $MyDB->Free();
   }

?>

<!--
<?php echo $strCountSQL; ?><BR>
Records found: <?php echo $count; ?><BR>
<?php echo $strGenSQL; ?><BR>
-->


<?php

// HTTP results
   
?>
<H4><?php echo $strSection; ?></H4>
<P>
<?
if ($count) printf ($strListPageInfo, number_format($initpage+1), number_format(($initpage+$pagesize)>$count?$count:$initpage+$pagesize), number_format($count));
?>  
<BR>
<?php WritePageLink($initpage, $pagesize, $count, $dbname, $otherinfo); ?>
</P>

<?php

   $result=$MyDB->Query($dbname, $strGenSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {
      // At least one occurrence found

?>
<TABLE width="100%" border="1" cellpadding="2" cellspacing="2">
<TR>
<TH> N. </TH>
<TH> <?php echo $strReferencingUrl; ?> \ <?php echo $strReferencedUrl; ?> \ <?php echo $strHTMLStatement; ?> </TH>
<TH> <?php echo $strLinkType; ?> </TH>
<TH> <?php echo $strLinkResult; ?> </TH>
<TH><?php echo $strShow; ?></TH>
</TR>
      
<?php
      $i=0;
      while ($row = $MyDB->FetchArray())
      {
         // Get next row
         $i++;

         // If HTML statement to be shown is too large, we cut it, depending
         // on MaxTagStrLenght setting in 'global.inc'
         $htmlstat = $row["Statement"];
         
         if (empty($htmlstat))
            $htmlstat = $strRedirection;
         else if (strlen($htmlstat) > $MaxTagStrLength)
            $htmlstat = '<I>' . substr($htmlstat, 0, $MaxTagStrLength) . '...</I>';

         ($i % 2)? $trclass='odd':$trclass='even';
?>
 <TR class="<?php echo $trclass; ?>">
   <TD align="right"> <?php echo number_format($initpage+$i); ?> </TD>
   <TD class="url" align="left">
   <B><?php echo $strReferencingUrl; ?></B>: <A href="showurl.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $row["IDUrlSrc"]; ?>"><?php echo GetURL($row["UrlSrc"]); ?></A><BR>
   <B><?php echo $strReferencedUrl; ?></B>: <A href="showurl.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $row["IDUrlDest"]; ?>"><?php echo GetURL($row["UrlDest"]); ?></A><BR>
   <B><?php echo $strHTMLStatement; ?></B>: <?php echo $htmlstat; ?></TD>
   <TD align="center"><?php echo GetTextString($row["LinkType"]) ; ?></TD>
   <TD align="center" valign="middle"><?php
   // Show the image or the text
   if ($ShowIcons)
   {
?>
<IMG src="img/<?php echo $row["LinkResult"]; ?>.png" alt="<?php
   echo GetTextString($row["LinkResult"]); ?>"
   width="40" height="35" border=1" bordercolor="black">
<?php
   }
   else echo GetTextString($row["LinkResult"]); // No Icons
 ?></TD>
   <TD align="center">
<?php
   if (strcmp($row["LinkType"], "Redirection"))  // It's not a redirection
   {
?>
   <A href="showlink.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $row["IDUrlSrc"]; ?>&TagPosition=<?php echo $row["TagPosition"]; ?>&AttrPosition=<?php echo $row["AttrPosition"]; ?>"><?php echo $strShowLink; ?></A>
<?php
   }
?>
   </TD>
 </TR>
<?php         
      }

?>
</TABLE>
<?php      
      // Page management

      WritePageLink($initpage, $pagesize, $count, $dbname,$otherinfo);
   }
   else
   {
?>
<P><?php echo $strNoOccurrencies; ?></P>

<?php
   }

   $MyDB->Free();
}
else
{
?>
<P><?php echo $strFilterLinks; ?>:</P>

<FORM action="<?php echo $PHP_SELF; ?>" method="GET">
<INPUT type="hidden" name="dbname" value="<?php echo $dbname; ?>">
<TABLE border="1" cellpadding="5" cellspacing="2">

<?php

   // Retrieving all the LinkResults found
   $strSQL="SELECT count(*) as Count, LinkResult "
      . "FROM Link GROUP BY LinkResult "
      . "ORDER BY LinkResult ASC";

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {
?>
<TR>
<TD colspan="2">
<B><?php echo $strLinkResult; ?> : </B>
<SELECT name="whatlinkresult">
 <OPTION value="="><?php echo $strLike; ?></OPTION>
 <OPTION value="!="><?php echo $strNotLike; ?></OPTION>
</SELECT>
<SELECT name="linkresult">
 <OPTION value="AllLinks"><?php echo $strAllLinks; ?></OPTION>
<?php
      while ($row = $MyDB->FetchArray())
      {
?>
 <OPTION value="<?php echo $row["LinkResult"]; ?>">
   <?php echo GetTextString($row["LinkResult"]); ?> (<?php echo $row["Count"]; ?>)</OPTION>
<?php
      }
?>
</SELECT>
</TD>
</TR>

<?php

   }

   $MyDB->Free();

   // Retrieving all the LinkType found
   $strSQL="SELECT count(*) as Count, LinkType "
      . "FROM Link GROUP BY LinkType "
      . "ORDER BY LinkType ASC";

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {

?>
<TR>
<TD colspan="2">
<B><?php echo $strLinkType; ?> : </B>
<SELECT name="whatlinktype">
 <OPTION value="="><?php echo $strLike; ?></OPTION>
 <OPTION value="!="><?php echo $strNotLike; ?></OPTION>
</SELECT>
<SELECT name="linktype">
 <OPTION value="AllLinks"><?php echo $strAllLinks; ?></OPTION>
<?php
      while ($row = $MyDB->FetchArray())
      {
?>
 <OPTION value="<?php echo $row["LinkType"]; ?>">
   <?php echo GetTextString($row["LinkType"]); ?> (<?php echo $row["Count"]; ?>)</OPTION>
<?php
      }
?>
</SELECT>
</TD>
</TR>
<?php
   }

   $MyDB->Free();

?>

<TR>
<TH>
<?php echo $strReferencingUrl; ?> : 
</TH>
<TH>
<?php echo $strReferencedUrl; ?> : 
</TH>
</TR>
<?php
   for ($i=0; $i<$NumFilterRows; $i++)
   {
?>
<TR>
<TD>
<SELECT name="whatsrc[<?php echo $i; ?>]">
 <OPTION value="LIKE"><?php echo $strLike; ?></OPTION>
 <OPTION value="NOT LIKE"><?php echo $strNotLike; ?></OPTION>
 <OPTION value="REGEXP"><?php echo $strRegExp; ?></OPTION>
 <OPTION value="NOT REGEXP"><?php echo $strNotRegExp; ?></OPTION>
</SELECT>
<INPUT name="src[<?php echo $i; ?>]" type="text" value="<?php echo $src[$i]; ?>"
   size="30" maxlength="255">
</TD>
<TD>
<SELECT name="whatdest[<?php echo $i; ?>]">
 <OPTION value="LIKE"><?php echo $strLike; ?></OPTION>
 <OPTION value="NOT LIKE"><?php echo $strNotLike; ?></OPTION>
 <OPTION value="REGEXP"><?php echo $strRegExp; ?></OPTION>
 <OPTION value="NOT REGEXP"><?php echo $strNotRegExp; ?></OPTION>
</SELECT>
<INPUT name="dest[<?php echo $i; ?>]" type="text" value="<?php echo $dest[$i]; ?>"
   size="30" maxlength="255">
</TD>
</TR>
<?php
   }
?>
<TR>
<TD colspan="2" align="right">
<INPUT type="submit" name="cmd" value="<?php echo $strLinkSubmit; ?>">
</TD>
</TR>
</FORM>
</TABLE>

<P align="justify">
<?php echo $strHelpOnString; ?>
</P>
<P align="justify">
<?php echo $strHelpOnRegExp; ?>
</P>

<?php
}
?>

<BR>

<?php include ("./include/footer.inc.php"); ?>
