/******************************************************************************\
 *  Copyright (C) 2001 writen by Jewfish and Armoth                           *
 *									      *
 *  Description: this codes allows a user to view and edit the hexadecimal and*
 *		 and ascii values of a file.  The curses library is used to   *
 *		 display and manipulate the output.  See the README file      *
 *		 included for more information.				      *
 *									      *
 *  This program is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or	      *
 *  (at your option) any later version.					      *
 *									      *
 *  This program is distributed in the hope that it will be useful,	      *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of	      *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	      *
 *  GNU General Public License for more details.			      *
 *									      *
 *  You should have received a copy of the GNU General Public License	      *
 *  along with this program; if not, write to the Free Software		      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
 *									      *
\******************************************************************************/

#include "hex.h"					/* custom header      */

/*#define DEBUG_LLIST*/
/*#define DEBUG_GOTO*/

int     BASE, MAXY, resize = 0;
hexList *head;						/* linked list struct */
WINS    *windows;					/* window structure   */
char    *fpINfilename = NULL,
        *fpOUTfilename = NULL;
int     hex_win_width,
        ascii_win_width,
        hex_outline_width,
        ascii_outline_width;


int main(int argc, char *argv[])			/* main program       */
{
    bool printHex;					/* address format     */
    int  row, col, x, retval = 1, val;			/* counters, etc.     */
    long int len;					/* len need to be long*/

    windows = (WINS *) malloc(sizeof(WINS));		/* malloc windows     */
    head = llalloc();					/* malloc list space  */
    fpINfilename = (char *) malloc(81);			/* allocate in and    */
    fpOUTfilename = (char *) malloc(81);		/* out file name ptrs */
    printHex = TRUE;					/* address format     */

							/* get cmd line args  */
    len = parseArgs(windows, head, argc, argv, fpINfilename, fpOUTfilename,
		    &printHex);

    use_env(TRUE);					/* use env values     */
    slk_init(0);					/* init menu bar      */
    init_screen();					/* init visuals       */

    							/* calculate screen   */
    BASE                = (resize > 0 && resize < COLS) ? resize:((COLS-14)/4);
    MAXY                = (LINES) - 3;
    hex_win_width       = BASE * 3;
    ascii_win_width     = BASE;
    hex_outline_width   = (BASE * 3) + 11;
    ascii_outline_width = BASE + 2;

    slk_set(6, (printHex) ? "Hex Addr":"Dec Addr", 1);
    init_fkeys();					/* define menu bar    */
    init_menu(windows);					/* init windows       */


    while (retval)
    {
        head = freeList(head);				/* free & init head   */
							/* print origin loc   */
	mvwprintw(windows->hex_outline, 0, 1, "00000000");
    
	if (fpIN != NULL)				/* if no infile...    */
	{
            len = maxLoc(fpIN);				/* get last file loc  */
	    val = maxLines(len); 			/* max file lines     */
            for (x = 0; x <= MAXY && x<=val; x++)       /* output lines       */
		outline(fpIN, windows, head, x, printHex); 
	}

	wmove(windows->hex, 0, 0);			/* cursor to origin   */
	row = col = 0;					/* init row & col     */
    
	refreshall(windows);				/* refresh all wins   */
	doupdate();					/* update screen      */

	mvwaddch(windows->scrollbar, 1, 0, ACS_CKBOARD);/* clear scroller     */
							/* get user input     */
	retval = wacceptch(windows, head, len, fpINfilename, fpOUTfilename,
			   printHex); 
    }
    
    screen_exit(0);					/* end visualizations */
    return retval;					/* return             */
}

/********************************************************\
 * Description: prints out debug info to a file         *
 * Returns:     nothing                                 *
\********************************************************/
/*
void printDebug(hexList *head, long int loc)
{
    FILE *tmpofp;
    hexList *tmpHead = head;

    tmpofp = fopen("debug_llist", "a+");
    tmpHead = head;

    fprintf(tmpofp, "location undone: %08X\n", loc);
    while (tmpHead != NULL)
    {
	fprintf(tmpofp, "head->loc: %08X   head->val: %02X (%c)\n", tmpHead->loc, tmpHead->val, tmpHead->val);

	tmpHead = tmpHead->next;
    }
    fprintf(tmpofp, "\n");

    fclose(tmpofp);
}
*/

/********************************************************\
 * Description: parses command line arguments and 	*
 *		processes them.				*
 * Returns:	length of file				*
\********************************************************/
long int parseArgs(WINS *win, hexList *head, int argc, char *argv[], 
                   char *fpINfilename, char *fpOUTfilename, bool *printHex)
{
    extern char *optarg;				/* extern vars for    */
    extern int optind, opterr, optopt;			/* getopt()	      */

    int val;						/* counters, etc.     */

							/* get args           */
    while ((val = hgetopt(argc, argv, "i:o:r:a")) != -1) 
    {
	switch (val)					/* test args          */
        {
            case 'a':	*printHex = FALSE;		/* decimal addresses  */
                        break;
							/* infile             */
	    case 'i':	strncpy(fpINfilename, optarg, 80);
			break;
							/* outfile            */
	    case 'o':   strncpy(fpOUTfilename, optarg, 80);
			break;

            case 'r':   resize = atoi(optarg);		/* don't resize screen*/
                        break;
							/* help/invalid args  */
	    case '?':	print_usage();			/* output help        */
                        if ((optopt == 'h') || (optopt == '?'))
			    exit(0);			/* exit               */
			else				/* illegal option     */
			    exit(-1);
        }
    }
    argc -= optind;
    argv += optind;

    if (argv[0])
        strncpy(fpINfilename, argv[0], 80);

    if (strcmp(fpINfilename, ""))
        if ((fpIN = fopen(fpINfilename, "r")) == NULL)
            exit_err("Could not open file");

    return ((fpIN != NULL) ? maxLoc(fpIN):0);		/* return file length */
}

/********************************************************\
 * Description: in the event of a segmentation fault    *
 * 		this catches the signal and prints out  *
 *		instructions on where to send a bug     *
 * 		report.					*
 * Returns:	length of file				*
\********************************************************/
void catchSegfault(int sig)
{
    endwin();
    printf("\n\nHexcurse has encountered a segmentation fault!\n");
    printf("\tPlease submit a full bug report to devel@jewfish.net.\n");
    printf("\tInclude what you did to cause the segfault, and if possible\n");
    printf("\tinclude the core dump.  And for your troubles, we'll add you to\n");
    printf("\tthe Changelog.  Then you can brag to your friends about it!\n");

    exit(-1);
}
