package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.trafo.tag.docbook.Anchor;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.html.HtmlElement;

public class DefaultEditor extends Editor {

    @Override
    public EditorInstruction edit(EditorInstruction values) throws EditorException {

        EditorInstruction evo = super.edit(values);
        
        HtmlElement html = getHtmlElement();
        String htmlId = html.getId();
        
        if (htmlId != null) {
        
            DocBookTagFactory dbf = evo.getTagFactory();
            Anchor anchor = dbf.createAnchor();
            copyCommonAttributes(html, anchor);
            
            getParent().appendChild(anchor);
        }
        
        return evo;
    }
}
