/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

/* Now this is how /all/ programs ought to be written :). Some of the command
   routines below are just snatched out of what used to be the main funciton of
   other programs... But seriously, is this cool or what!? */

#include "../util/debug.h"
#include "../util/error.h"
#include "../util/File.h"
#include "../util/String.h"
#include "../gl/Aset.h"
#include "../gl/Animation.h"
#include "../gl/Sprite.h"
#include "../gl/Sset.h"
#include <getopt.h>
#include <string.h>
#include <unistd.h>

//--------------------------------------------------------------------------------------------------------------------------------

static Sprite *sprite = NULL;

static bool hgtLoadSpr(int argc, char** argv)
{
 if(argc != 2) { setError("%s: syntax: load-spr,<filename>", argv[0]); return false; }
 if(sprite) delete sprite;
 sprite = (Sprite*) load(argv[1], Sprite::getCreateFunc(argv[1]));
 if(!sprite) return false;
 return true;
}

static bool hgtSaveSpr(int argc, char** argv)
{
 if(argc != 2) { setError("%s: syntax: %s,<filename>", argv[0], argv[0]); return false; }
 if(!sprite) { setError("%s: no sprite data", argv[0]); return false; }
 return save(argv[1], sprite, (objectWriteFunc) &Sprite::write);
}

static bool hgtSaveSprTga(int argc, char** argv)
{
 if(argc != 2) { setError("%s: syntax: %s,<filename>", argv[0], argv[0]); return false; }
 if(!sprite) { setError("%s: no sprite data", argv[0]); return false; }
 return save(argv[1], sprite, (objectWriteFunc) &Sprite::writeTga);
}

static bool hgtDimSpr(int argc, char** argv)
{
 if(argc != 2) { setError("%s: syntax: %s,<factor>", argv[0], argv[0]); return false; }
 int factor = strtol(argv[1], NULL, 0);
 if(factor < 0 || factor > 255) { setError("%s: invalid factor %d (should be out of 255)", argv[0], factor); }
 if(!sprite) { setError("%s: no sprite data", argv[0]); return false; }
 sprite->dim(factor);
 return true;
}

//--------------------------------------------------------------------------------------------------------------------------------

static Animation* animation = NULL;

static bool hgtSaveAnim(int argc, char** argv)
{
 if(argc != 2) { setError("%s: syntax: %s,<filename>", argv[0], argv[0]); return false; }
 if(!animation) { setError("%s: no animation data", argv[0]); return false; }
 return save(argv[1], animation, (objectWriteFunc) &Animation::write);
}

static bool hgtLoadSprsAsAnim(int argc, char** argv)
{
 if(argc != 3) { setError("%s: syntax: %s,<basename>,<number>", argv[0], argv[0]); return false; }
 char* basename = argv[1];
 int number = strtol(argv[2], NULL, 0);
 if(number < 1) { setError("%s: invalid number %d (should be >= 1)", argv[0], number); }
 
 if(animation) delete animation;
 animation = new Animation;
 
 for(int i=0; i<number; i++)
  {
   String filename = String(basename) + String(".") + String(i) + String(".spr");
   Sprite* s = (Sprite*) load(filename, (objectCreateFunc) Sprite::create);
   if(s == NULL) { setError("%s: loading %s: %s", argv[0], (const char*) filename, errStr); delete animation; return false; }
   animation->add(s);
  }

 return true;
}

static bool hgtSetAnimSpeed(int argc, char** argv)
{
 if(argc != 2) { setError("%s: syntax %s,<speed>", argv[0], argv[0]); return false; }
 int speed = strtol(argv[1], NULL, 0);
 if(speed < 1) { setError("%s: invalid speed %d (should be >= 1)", argv[0], speed); }

 if(!animation) { setError("%s: no animation data", argv[0]); return false; }

 animation->speed = speed;

 return true;
}

//--------------------------------------------------------------------------------------------------------------------------------

static Aset* aset = NULL;

static bool hgtSaveAset(int argc, char** argv)
{
 if(argc != 2) { setError("%s: syntax: %s,<filename>", argv[0], argv[0]); return false; }
 if(!aset) { setError("%s: no aset data", argv[0]); return false; }
 return save(argv[1], aset, (objectWriteFunc) &Aset::write);
}

static bool hgtLoadAnimsAsAset(int argc, char** argv)
{
 if(argc != 3) { setError("%s: syntax: %s,<basename>,<number>", argv[0], argv[0]); return false; }
 char* basename = argv[1];
 int number = strtol(argv[2], NULL, 0);
 if(number < 1) { setError("%s: invalid number %d (should be >= 1)", argv[0], number); }

 if(aset) delete aset;
 aset = new Aset;

 for(int i=0; i<number; i++)
  {
   String filename = String(basename) + String(".") + String(i) + String(".anim");
   Animation* a = (Animation*) load(filename, (objectCreateFunc) Animation::create);
   if(a == NULL) { setError("%s: loading %s: %s", argv[0], (const char*) filename, errStr); delete aset; return false; }
   aset->add(a);
  }

 return true;
}

//--------------------------------------------------------------------------------------------------------------------------------

static Sset* sset = NULL;

static bool hgtSaveSset(int argc, char** argv)
{
 if(argc != 2) { setError("%s: syntax: %s,<filename>", argv[0], argv[0]); return false; }
 if(!sset) { setError("%s: no aset data", argv[0]); return false; }
 return save(argv[1], sset, (objectWriteFunc) &Sset::write);
}

static bool hgtLoadSprsAsSset(int argc, char** argv)
{
 if(argc != 3) { setError("%s: syntax: %s,<basename>,<number>", argv[0], argv[0]); return false; }
 char* basename = argv[1];
 int number = strtol(argv[2], NULL, 0);
 if(number < 1) { setError("%s: invalid number %d (should be >= 1)", argv[0], number); }

 if(sset) delete sset;
 sset = new Sset;

 for(int i=0; i<number; i++)
  {
   String filename = String(basename) + String(".") + String(i) + String(".spr");
   Sprite* s = (Sprite*) load(filename, (objectCreateFunc) Sprite::create);
   if(s == NULL) { setError("%s: loading %s: %s", argv[0], (const char*) filename, errStr); delete sset; return false; }
   sset->add(s);
  }

 return true;
}

//--------------------------------------------------------------------------------------------------------------------------------

static struct Command { bool (*func)(int, char**); const char* name; } commands[] =
{
 { hgtLoadSpr, "load-spr" },
 { hgtSaveSpr, "save-spr" },
 { hgtSaveSprTga, "save-spr-tga" },
 { hgtDimSpr, "dim-spr" },

 { hgtSaveAnim, "save-anim" },
 { hgtLoadSprsAsAnim, "load-sprs-as-anim" },
 { hgtSetAnimSpeed, "set-anim-speed" },

 { hgtSaveAset, "save-aset" },
 { hgtLoadAnimsAsAset, "load-anims-as-aset" },

 { hgtSaveSset, "save-sset" },
 { hgtLoadSprsAsSset, "load-sprs-as-sset" },

 // some aliases

 { hgtSaveSprTga, "save-spr-targa" },
 { hgtSaveSprTga, "save-tga" },
 { hgtSaveSprTga, "save-targa" },

 // and the list terminator

 { 0, 0 }
};

//--------------------------------------------------------------------------------------------------------------------------------

int main(int argc, char **argv)
{
 initError();

#ifndef NDEBUG
 const char* getoptChars = "1";
#else
 const char* getoptChars = "";
#endif

 int c;
 while((c = getopt(argc, argv, getoptChars)) != -1)
  switch(c)
   {
#ifndef NDEBUG
   case '1':
    vdebug = 1;
    break;
#endif

   case '?':
    fatal("%s: unknown option: -%c\n", argv[0], optopt);

   default:
    fatal("%s: getopt problems...\n", argv[0]);
   }

 for(int i=optind; i<argc; i++)
  {
   // parse each argument into it's own comma separated arguments list..

   int subArgc = 0;
   char *subArgv[256];
   char *s = argv[i];
   while(*s)
    {
     if(subArgc == 255) fatal("%s: bugger off\n", argv[0]);
     char *token = s;
     while(*s && *s != ',') s++;
     if(*s) *s++ = 0;
     subArgv[subArgc++] = token;
    }

   // ...then call the command specified by argv[0]

   for(Command *command = &commands[0]; command->func; command++)
    if(strcmp(command->name, subArgv[0]) == 0)
     {
      if(!command->func(subArgc, subArgv))
       fatal("%s: %s\n", argv[0], errStr);
      goto foundCommand;
     }
   fatal("%s: unknown command: %s\n", argv[0], subArgv[0]);
  foundCommand:
   (void)0; // dont ask...
  }

 if(sprite) delete sprite;
 if(animation) delete animation;
 if(aset) delete aset;
 if(sset) delete sset;

 return EXIT_SUCCESS;
}

//--------------------------------------------------------------------------------------------------------------------------------
