
#include "options.h"
#include "../util/util.h"
#include <getopt.h>
#include <stdio.h>
#include <stdlib.h>

static Options staticOptions;
Options* options = &staticOptions;

#ifndef NDEBUG
extern int vdebug;
#endif

static const char optionsHelp[] =
#ifndef NDEBUG
 " -0, --debug-parser  Enable parser trace feature\n"
 " -1, --debug-lots    Turns on reams of debugging info\n"
#endif
 " -d, --dir           Specify where to find library files\n"
 " -h, --help          This help screen\n"
 " -l, --load          Specify level/sprite to play/edit immediately\n"
#ifdef SOUND
 " -q, --nosound       Disable sound effects\n"
#endif
// " -L, --ledit         Level editor mode\n"
// " -S, --sedit         Sprite editor mode\n"
 "     --8bpp          Use 8bpp color depth\n"
 "     --16bpp         Use 16bpp color depth\n"
 "     --24bpp         Use 24bpp color depth\n"
 "     --32bpp         Use 32bpp color depth\n"
;

bool parseOptions(int argc, char* const argv[])
{
 // set default options
 options->level = NULL;
 options->libDir = newString(DATADIR);
 options->mode = Options::modePlay;
#ifndef NDEBUG
 vdebug = 0;
#endif
#ifdef SOUND
 options->sound = 1;
#endif
 options->bitdepth = 0;

 while(1)
  {
   int optionIndex;
   static struct option longOptions[] =
    {
#ifndef NDEBUG
     { "debug-parser", 0, 0, '0' },
     { "debug-lots",   0, 0, '1' },
#endif
     { "dir",          1, 0, 'd' },
     { "help",         0, 0, 'h' },
     { "load",         1, 0, 'l' },
#ifdef SOUND
     { "nosound",      0, 0, 'q' },
#endif
     { "ledit",        0, 0, 'L' },
     { "sedit",        0, 0, 'S' },
     { "8bpp",         0, &options->bitdepth, 8  },
     { "16bpp",        0, &options->bitdepth, 16 },
     { "24bpp",        0, &options->bitdepth, 24 },
     { "32bpp",        0, &options->bitdepth, 32 },
     { NULL,           0, 0, 0   }
    };
   int c;
   if((c = getopt_long(argc, argv,
#ifndef NDEBUG
                       "01"
#endif
                       "d:hl:qLS", longOptions, &optionIndex)) == -1) return true;
   switch(c)
    {
    case 0:
     // this stops flag options producing an error
     break;

#ifndef NDEBUG
    case '0':
     extern int rgdebug, tpdebug;
     rgdebug = tpdebug = 1;
     break;

    case '1':
     vdebug = true;
     break;
#endif

    case 'd':
     if(options->libDir) delete options->libDir;
     options->libDir = newString(optarg);
     break;

    case 'h':
     printf("%s", optionsHelp);
     return false;
     
    case 'l':
     if(options->level) delete options->level;
     options->level = newString(optarg);
     break;
     
#ifdef SOUND
    case 'q':
     options->sound = false;
     break;
#endif
     
    case 'L':
     if(options->mode) { fprintf(stderr, "Only one of -L, -S, --ledit, --sedit can be specified.\n"); return false; }
     options->mode = Options::modeLevel;
     break;
     
    case 'S':
     if(options->mode) { fprintf(stderr, "Only one of -L, -S, --ledit, --sedit can be specified.\n"); return false; }
     options->mode = Options::modeSprite;
     break;
     
    case '?':
    default:
     printf("Invalid option.\n");
     return false;
    }
  }
}

