/*C* $Id: background.cc,v 1.3 1997/09/28 09:21:00 james Exp james $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "Background.h"
#include "../gl/Rect.h"
#include "../gl/Sprite.h"
#include "../util/debug.h"
#include "../util/error.h"
#include "../util/File.h"
#include "../util/util.h"
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

//--------------------------------------------------------------------------------------------------------------------------------

Background::Background()
 : VgaContext()
{
 VPRINTF("<bk> init\n");
 pFilename = "";
}

Background::~Background()
{
 VPRINTF("<bk> done\n");
}

bool Background::load(const char* filename)
{
 assert(filename);
 if(pFilename == String(filename)) return true;
 Sprite* s;
 s = (Sprite*) ::load(filename, (objectCreateFunc) Sprite::getCreateFunc(filename));
 if(!s) { return false; }
 if(s->size() != screenSize)
  {
   setError("background %s is wrong size %dx%d", filename, s->size().x, s->size().y);
   delete s;
   return false;
  }
 s->draw(this, Point(0, 0));
 delete s;
 pFilename = filename;
 return true;
}

//--------------------------------------------------------------------------------------------------------------------------------

Background* bk;

//--------------------------------------------------------------------------------------------------------------------------------
