/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef Animation_h
#define Animation_h

#include "Sprite.h"
#include "../util/Collection.h"
#include <assert.h>

class Animation : public SCollection<class Sprite>
{
private:

 int currentFrame;
 int advanceCounter;
 Point pZ;

public:
 int speed; // advances to wait between updates

 Animation(int _space = 64, int _delta = 64);
 virtual ~Animation();

 void advance(int i=1);
 void reset();

 Sprite* next() { return length()? at(currentFrame) : &emptySprite; }

 static Animation* create(class File& f);
 bool read(class File& f);
 bool write(class File& f);

 void add(Sprite* object);

 int frame(int _frame)
  {
   assert(_frame >= 0 && _frame < length());
   return currentFrame = _frame;
  }
};

#endif
