//
// C++ Interface: networkdialog
//
// Description:
//
//
// Author: Lorn Potter <lorn.potter@gmail.com>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef NETWORKDIALOG_H
#define NETWORKDIALOG_H

#include "ui_NetworkDialogBase.h"
#include <QDialog>


class QFile;
class QHttp;
class QHttpResponseHeader;


/**
	@author Lorn Potter <lorn.potter@gmail.com>
*/
class NetworkDialog : public QDialog, private Ui::NetworkDialogBase
{
    Q_OBJECT

public:
    NetworkDialog(QWidget *parent=0);

    ~NetworkDialog();


    void setFileSize(const int& theValue)
    {
      fileSize = theValue;
    }
    void setFile(const QString &file);
    void setUrl(const QString &url);

signals:
    void downloadFinished();
    void downloadFailed();
    void fileNotFound();
    
protected slots:
    void downloadFile();
    void setProgress(int,int);
    void httpRequestFinished(int, bool);
    void readResponseHeader(const QHttpResponseHeader &);
    void isDone(bool);

private:
    QString filenamePath;
    QString serverPath;
   bool httpRequestAborted;
    QFile *file;
    QHttp *http;
    int httpGetId;
    
protected:
    int fileSize;
};

#endif
